/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public abstract class Handler {
    Formatter formatter;
    Filter filter;
    Level level = Level.ALL;
    ErrorManager errorManager;
    String encoding;

    protected Handler() {
    }

    public abstract void publish(LogRecord var1);

    public abstract void flush();

    public abstract void close() throws SecurityException;

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) throws SecurityException {
        LogManager.getLogManager().checkAccess();
        formatter.getClass();
        this.formatter = formatter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        LogManager.getLogManager().checkAccess();
        if (string != null) {
            new String(new byte[0], string);
        }
        this.encoding = string;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) throws SecurityException {
        LogManager.getLogManager().checkAccess();
        this.filter = filter;
    }

    public ErrorManager getErrorManager() {
        LogManager.getLogManager().checkAccess();
        if (this.errorManager == null) {
            this.errorManager = new ErrorManager();
        }
        return this.errorManager;
    }

    public void setErrorManager(ErrorManager errorManager) {
        LogManager.getLogManager().checkAccess();
        errorManager.getClass();
        this.errorManager = errorManager;
    }

    protected void reportError(String string, Exception exception, int n) {
        if (this.errorManager == null) {
            this.errorManager = new ErrorManager();
        }
        this.errorManager.error(string, exception, n);
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        LogManager.getLogManager().checkAccess();
        level.getClass();
        this.level = level;
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (logRecord.getLevel().intValue() < this.level.intValue()) {
            return false;
        }
        if (this.filter != null) {
            return this.filter.isLoggable(logRecord);
        }
        return true;
    }
}

