/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Observer;
import java.util.Set;

public class Observable {
    private boolean changed;
    private LinkedHashSet observers = new LinkedHashSet();

    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException("can't add null observer");
        }
        this.observers.add(observer);
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized int countObservers() {
        return this.observers.size();
    }

    public synchronized void deleteObserver(Observer observer) {
        this.observers.remove(observer);
    }

    public synchronized void deleteObservers() {
        this.observers.clear();
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object object) {
        if (!this.hasChanged()) {
            return;
        }
        Observable observable = this;
        synchronized (observable) {
            Set set;
            try {
                set = (Set)this.observers.clone();
            }
            finally {
                Object var4_4 = null;
            }
            int n = set.size();
            Iterator iterator = set.iterator();
            while (--n >= 0) {
                ((Observer)iterator.next()).update(this, object);
            }
            this.clearChanged();
            return;
        }
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }
}

