/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Identity;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Enumeration;

public abstract class IdentityScope
extends Identity {
    private static final long serialVersionUID = -2337346281189773310L;
    private static IdentityScope systemScope;

    protected IdentityScope() {
    }

    public IdentityScope(String string) {
        super(string);
    }

    public IdentityScope(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public static IdentityScope getSystemScope() {
        if (systemScope == null) {
            // empty if block
        }
        return systemScope;
    }

    protected static void setSystemScope(IdentityScope identityScope) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setSystemScope");
        }
        systemScope = identityScope;
    }

    public abstract int size();

    public abstract Identity getIdentity(String var1);

    public Identity getIdentity(Principal principal) {
        return this.getIdentity(principal.getName());
    }

    public abstract Identity getIdentity(PublicKey var1);

    public abstract void addIdentity(Identity var1) throws KeyManagementException;

    public abstract void removeIdentity(Identity var1) throws KeyManagementException;

    public abstract Enumeration identities();

    public String toString() {
        return super.getName() + " " + super.getScope().getName() + " " + this.size();
    }
}

