/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.VMAccessController;

public final class AccessController {
    private AccessController() {
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        AccessController.getContext().checkPermission(permission);
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction) {
        Object object;
        VMAccessController.pushContext(null);
        try {
            object = privilegedAction.run();
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return object;
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        Object object;
        VMAccessController.pushContext(accessControlContext);
        try {
            object = privilegedAction.run();
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        Object object;
        VMAccessController.pushContext(null);
        try {
            try {
                object = privilegedExceptionAction.run();
                Object var2_2 = null;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new PrivilegedActionException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        Object object;
        VMAccessController.pushContext(accessControlContext);
        try {
            try {
                object = privilegedExceptionAction.run();
                Object var3_3 = null;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new PrivilegedActionException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return object;
    }

    public static AccessControlContext getContext() {
        return VMAccessController.getContext();
    }
}

