/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import java.util.StringTokenizer;

public class SecurityManager {
    static volatile SecurityManager current;
    protected boolean inCheck;

    public SecurityManager() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("createSecurityManager"));
        }
    }

    public boolean getInCheck() {
        return this.inCheck;
    }

    protected Class[] getClassContext() {
        return VMSecurityManager.getClassContext(SecurityManager.class$("java.lang.SecurityManager"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected ClassLoader currentClassLoader() {
        return VMSecurityManager.currentClassLoader(SecurityManager.class$("java.lang.SecurityManager"));
    }

    protected Class currentLoadedClass() {
        int n = this.classLoaderDepth();
        if (n >= 0) {
            return this.getClassContext()[n];
        }
        return null;
    }

    protected int classDepth(String string) {
        Class[] classArray = this.getClassContext();
        for (int i = 0; i < classArray.length; ++i) {
            if (!string.equals(classArray[i].getName())) continue;
            return i;
        }
        return -1;
    }

    protected int classLoaderDepth() {
        try {
            this.checkPermission(new AllPermission());
        }
        catch (SecurityException securityException) {
            Class[] classArray = this.getClassContext();
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].getClassLoader() == null) continue;
                return i;
            }
        }
        return -1;
    }

    protected boolean inClass(String string) {
        return this.classDepth(string) != -1;
    }

    protected boolean inClassLoader() {
        return this.classLoaderDepth() != -1;
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    public void checkPermission(Permission permission) {
        AccessController.checkPermission(permission);
    }

    public void checkPermission(Permission permission, Object object) {
        if (!(object instanceof AccessControlContext)) {
            throw new SecurityException("Missing context");
        }
        ((AccessControlContext)object).checkPermission(permission);
    }

    public void checkCreateClassLoader() {
        this.checkPermission(new RuntimePermission("createClassLoader"));
    }

    public void checkAccess(Thread thread) {
        if (thread.getThreadGroup() != null && thread.getThreadGroup().getParent() == null) {
            this.checkPermission(new RuntimePermission("modifyThread"));
        }
    }

    public void checkAccess(ThreadGroup threadGroup) {
        if (threadGroup.getParent() == null) {
            this.checkPermission(new RuntimePermission("modifyThreadGroup"));
        }
    }

    public void checkExit(int n) {
        this.checkPermission(new RuntimePermission("exitVM"));
    }

    public void checkExec(String string) {
        if (!string.equals(new File(string).getAbsolutePath())) {
            string = "<<ALL FILES>>";
        }
        this.checkPermission(new FilePermission(string, "execute"));
    }

    public void checkLink(String string) {
        this.checkPermission(new RuntimePermission("loadLibrary." + string.toString()));
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        this.checkPermission(new RuntimePermission("readFileDescriptor"));
    }

    public void checkRead(String string) {
        this.checkPermission(new FilePermission(string, "read"));
    }

    public void checkRead(String string, Object object) {
        if (!(object instanceof AccessControlContext)) {
            throw new SecurityException("Missing context");
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        accessControlContext.checkPermission(new FilePermission(string, "read"));
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        this.checkPermission(new RuntimePermission("writeFileDescriptor"));
    }

    public void checkWrite(String string) {
        this.checkPermission(new FilePermission(string, "write"));
    }

    public void checkDelete(String string) {
        this.checkPermission(new FilePermission(string, "delete"));
    }

    public void checkConnect(String string, int n) {
        if (n == -1) {
            this.checkPermission(new SocketPermission(string, "resolve"));
        } else {
            this.checkPermission(new SocketPermission(string.toString() + ":" + n, "connect"));
        }
    }

    public void checkConnect(String string, int n, Object object) {
        if (!(object instanceof AccessControlContext)) {
            throw new SecurityException("Missing context");
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        if (n == -1) {
            accessControlContext.checkPermission(new SocketPermission(string, "resolve"));
        } else {
            accessControlContext.checkPermission(new SocketPermission(string.toString() + ":" + n, "connect"));
        }
    }

    public void checkListen(int n) {
        this.checkPermission(new SocketPermission("localhost:" + (n == 0 ? "1024-" : "" + n), "listen"));
    }

    public void checkAccept(String string, int n) {
        this.checkPermission(new SocketPermission(string.toString() + ":" + n, "accept"));
    }

    public void checkMulticast(InetAddress inetAddress) {
        this.checkPermission(new SocketPermission(inetAddress.getHostAddress(), "accept,connect"));
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        this.checkPermission(new SocketPermission(inetAddress.getHostAddress(), "accept,connect"));
    }

    public void checkPropertiesAccess() {
        this.checkPermission(new PropertyPermission("*", "read,write"));
    }

    public void checkPropertyAccess(String string) {
        this.checkPermission(new PropertyPermission(string, "read"));
    }

    public boolean checkTopLevelWindow(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        try {
            this.checkPermission(new AWTPermission("showWindowWithoutWarningBanner"));
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public void checkPrintJobAccess() {
        this.checkPermission(new RuntimePermission("queuePrintJob"));
    }

    public void checkSystemClipboardAccess() {
        this.checkPermission(new AWTPermission("accessClipboard"));
    }

    public void checkAwtEventQueueAccess() {
        this.checkPermission(new AWTPermission("accessEventQueue"));
    }

    public void checkPackageAccess(String string) {
        this.checkPackageList(string, "package.access", "accessClassInPackage.");
    }

    public void checkPackageDefinition(String string) {
        this.checkPackageList(string, "package.definition", "defineClassInPackage.");
    }

    public void checkSetFactory() {
        this.checkPermission(new RuntimePermission("setFactory"));
    }

    public void checkMemberAccess(Class clazz, int n) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (n == 0) {
            return;
        }
        this.checkPermission(new RuntimePermission("accessDeclaredMembers"));
    }

    public void checkSecurityAccess(String string) {
        this.checkPermission(new SecurityPermission(string));
    }

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    void checkPackageList(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string4 = (String)AccessController.doPrivileged(new PrivilegedAction(this, string2){
            private /* synthetic */ SecurityManager this$0;
            private /* synthetic */ String val$restriction;
            {
                this.this$0 = securityManager;
                this.finit$(string);
            }

            private /* synthetic */ void finit$(String string) {
                this.val$restriction = string;
            }

            public Object run() {
                return Security.getProperty(this.val$restriction);
            }
        });
        if (string4 == null || string4.equals("")) {
            return;
        }
        String string5 = string + ".";
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string5.startsWith(stringTokenizer.nextToken())) continue;
            RuntimePermission runtimePermission = new RuntimePermission(string3 + string);
            this.checkPermission(runtimePermission);
            return;
        }
    }
}

