/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;

public final class LineBreakMeasurer {
    private AttributedCharacterIterator text;
    private int position;
    private TextMeasurer tm;
    private int numChars;

    public LineBreakMeasurer(AttributedCharacterIterator attributedCharacterIterator, BreakIterator breakIterator, FontRenderContext fontRenderContext) {
        this(attributedCharacterIterator, fontRenderContext);
    }

    public LineBreakMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this.text = attributedCharacterIterator;
        this.position = 0;
        this.numChars = attributedCharacterIterator.getEndIndex();
        this.tm = new TextMeasurer(attributedCharacterIterator, fontRenderContext);
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.tm.deleteChar(attributedCharacterIterator, n);
        this.position = 0;
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.tm.insertChar(attributedCharacterIterator, n);
        this.position = 0;
    }

    public TextLayout nextLayout(float f) {
        return this.nextLayout(f, this.numChars, false);
    }

    public TextLayout nextLayout(float f, int n, boolean bl) {
        int n2 = this.nextOffset(f, n, bl);
        TextLayout textLayout = this.tm.getLayout(this.position, n2);
        this.position = n2;
        return textLayout;
    }

    public int nextOffset(float f) {
        return this.nextOffset(f, this.numChars, false);
    }

    public int nextOffset(float f, int n, boolean bl) {
        int n2 = this.tm.getLineBreakIndex(this.position, f);
        if (n > this.numChars) {
            n = this.numChars;
        }
        if (n2 > n) {
            this.text.setIndex(n);
            return n;
        }
        this.text.setIndex(n2);
        if (Character.isWhitespace(this.text.current())) {
            return n2;
        }
        if (!bl) {
            while (!Character.isWhitespace(this.text.previous()) && n2 > this.position) {
                --n2;
            }
        } else {
            while (!Character.isWhitespace(this.text.next()) && n2 < n) {
                ++n2;
            }
        }
        if (n2 > n) {
            this.text.setIndex(n);
            return n;
        }
        this.text.setIndex(n2);
        return n2;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }
}

