/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Polygon
implements Shape,
Serializable {
    private static final long serialVersionUID = -6460061437900069969L;
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;
    private static final double BIG_VALUE = 1.7976931348623158E307;

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(int[] nArray, int[] nArray2, int n) {
        this.xpoints = new int[n];
        this.ypoints = new int[n];
        System.arraycopy(nArray, 0, this.xpoints, 0, n);
        System.arraycopy(nArray2, 0, this.ypoints, 0, n);
        this.npoints = n;
    }

    public void reset() {
        this.npoints = 0;
        this.invalidate();
    }

    public void invalidate() {
        this.bounds = null;
    }

    public void translate(int n, int n2) {
        int n3 = this.npoints;
        while (--n3 >= 0) {
            int n4 = n3;
            this.xpoints[n4] = this.xpoints[n4] + n;
            int n5 = n3;
            this.ypoints[n5] = this.ypoints[n5] + n2;
        }
        if (this.bounds != null) {
            this.bounds.x += n;
            this.bounds.y += n2;
        }
    }

    public void addPoint(int n, int n2) {
        int[] nArray;
        if (this.npoints + 1 > this.xpoints.length) {
            nArray = new int[this.npoints + 1];
            System.arraycopy(this.xpoints, 0, nArray, 0, this.npoints);
            this.xpoints = nArray;
        }
        if (this.npoints + 1 > this.ypoints.length) {
            nArray = new int[this.npoints + 1];
            System.arraycopy(this.ypoints, 0, nArray, 0, this.npoints);
            this.ypoints = nArray;
        }
        this.xpoints[this.npoints] = n;
        this.ypoints[this.npoints] = n2;
        ++this.npoints;
        if (this.bounds != null) {
            if (this.npoints == 1) {
                this.bounds.x = n;
                this.bounds.y = n2;
            } else {
                if (n < this.bounds.x) {
                    this.bounds.width += this.bounds.x - n;
                    this.bounds.x = n;
                } else if (n > this.bounds.x + this.bounds.width) {
                    this.bounds.width = n - this.bounds.x;
                }
                if (n2 < this.bounds.y) {
                    this.bounds.height += this.bounds.y - n2;
                    this.bounds.y = n2;
                } else if (n2 > this.bounds.y + this.bounds.height) {
                    this.bounds.height = n2 - this.bounds.y;
                }
            }
        }
    }

    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    public Rectangle getBoundingBox() {
        if (this.bounds == null) {
            int n;
            int n2;
            if (this.npoints == 0) {
                this.bounds = new Rectangle();
                return this.bounds;
            }
            int n3 = this.npoints - 1;
            int n4 = n2 = this.xpoints[n3];
            int n5 = n = this.ypoints[n3];
            while (--n3 >= 0) {
                int n6 = this.xpoints[n3];
                int n7 = this.ypoints[n3];
                if (n6 < n2) {
                    n2 = n6;
                } else if (n6 > n4) {
                    n4 = n6;
                }
                if (n7 < n) {
                    n = n7;
                    continue;
                }
                if (n7 <= n5) continue;
                n5 = n7;
            }
            this.bounds = new Rectangle(n2, n, n4 - n2, n5 - n);
        }
        return this.bounds;
    }

    public boolean contains(Point point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(int n, int n2) {
        return this.contains((double)n, (double)n2);
    }

    public boolean inside(int n, int n2) {
        return this.contains((double)n, (double)n2);
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public boolean contains(double d, double d2) {
        return (this.evaluateCrossings(d, d2, false, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.evaluateCrossings(d, d2, false, d3) != 0 || this.evaluateCrossings(d, d2 + d4, false, d3) != 0 || this.evaluateCrossings(d + d3, d2, true, d4) != 0 || this.evaluateCrossings(d, d2, true, d4) != 0) {
            return true;
        }
        return (this.evaluateCrossings(d, d2, false, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        if (!this.getBounds2D().intersects(d, d2, d3, d4)) {
            return false;
        }
        if (this.evaluateCrossings(d, d2, false, d3) != 0 || this.evaluateCrossings(d, d2 + d4, false, d3) != 0 || this.evaluateCrossings(d + d3, d2, true, d4) != 0 || this.evaluateCrossings(d, d2, true, d4) != 0) {
            return false;
        }
        return (this.evaluateCrossings(d, d2, false, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PathIterator(this, affineTransform){
            private /* synthetic */ Polygon this$0;
            private /* synthetic */ AffineTransform val$transform;
            private int vertex;
            {
                this.this$0 = polygon;
                this.finit$(affineTransform);
            }

            private /* synthetic */ void finit$(AffineTransform affineTransform) {
                this.val$transform = affineTransform;
            }

            public int getWindingRule() {
                return 0;
            }

            public boolean isDone() {
                return this.vertex > this.this$0.npoints;
            }

            public void next() {
                ++this.vertex;
            }

            public int currentSegment(float[] fArray) {
                if (this.vertex >= this.this$0.npoints) {
                    return 4;
                }
                fArray[0] = this.this$0.xpoints[this.vertex];
                fArray[1] = this.this$0.ypoints[this.vertex];
                if (this.val$transform != null) {
                    this.val$transform.transform(fArray, 0, fArray, 0, 1);
                }
                if (this.vertex == 0) {
                    return 0;
                }
                return 1;
            }

            public int currentSegment(double[] dArray) {
                if (this.vertex >= this.this$0.npoints) {
                    return 4;
                }
                dArray[0] = this.this$0.xpoints[this.vertex];
                dArray[1] = this.this$0.ypoints[this.vertex];
                if (this.val$transform != null) {
                    this.val$transform.transform(dArray, 0, dArray, 0, 1);
                }
                if (this.vertex == 0) {
                    return 0;
                }
                return 1;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    private int evaluateCrossings(double d, double d2, boolean bl, double d3) {
        double d4;
        double d5;
        int[] nArray;
        int[] nArray2;
        double d6 = 0.0;
        int n = 0;
        if (bl) {
            nArray2 = this.ypoints;
            nArray = this.xpoints;
            double d7 = d2;
            d2 = d;
            d = d7;
        } else {
            nArray2 = this.xpoints;
            nArray = this.ypoints;
        }
        d6 = 1.0E-7;
        double d8 = (double)nArray2[0] - d;
        double d9 = (double)nArray[0] - d2;
        for (int i = 1; i < this.npoints; ++i) {
            d5 = (double)nArray2[i] - d;
            d4 = (double)nArray[i] - d2;
            if (d9 == 0.0) {
                d9 -= d6;
            }
            if (d4 == 0.0) {
                d4 -= d6;
            }
            if (d9 * d4 < 0.0 && Line2D.linesIntersect(d8, d9, d5, d4, d6, 0.0, d3, 0.0)) {
                ++n;
            }
            d8 = (double)nArray2[i] - d;
            d9 = (double)nArray[i] - d2;
        }
        d5 = (double)nArray2[0] - d;
        d4 = (double)nArray[0] - d2;
        if (d9 == 0.0) {
            d9 -= d6;
        }
        if (d4 == 0.0) {
            d4 -= d6;
        }
        if (d9 * d4 < 0.0 && Line2D.linesIntersect(d8, d9, d5, d4, d6, 0.0, d3, 0.0)) {
            ++n;
        }
        return n;
    }
}

