/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.ClasspathToolkit;
import java.awt.AWTPermission;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.peer.MouseInfoPeer;

public class MouseInfo {
    private static MouseInfoPeer peer;

    public static PointerInfo getPointerInfo() throws HeadlessException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("watchMousePointer"));
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (peer == null) {
            peer = Toolkit.getDefaultToolkit().getMouseInfoPeer();
        }
        Point point = new Point();
        int n = peer.fillPointWithCoords(point);
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        return new PointerInfo(graphicsDeviceArray[n], point);
    }

    public static int getNumberOfButtons() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return ((ClasspathToolkit)Toolkit.getDefaultToolkit()).getMouseNumberOfButtons();
    }
}

