/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class EntitiesType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    EntitiesType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "ENTITIES"), TypeLibrary.ENTITY);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                String string2 = stringBuffer.toString();
                if (string2.length() > 0 && !validationContext.isUnparsedEntity(string2)) {
                    throw new DatatypeException(i, "invalid ENTITIES value");
                }
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(c);
        }
        String string3 = stringBuffer.toString();
        if (string3.length() == 0 || !validationContext.isUnparsedEntity(string3)) {
            throw new DatatypeException("invalid ENTITIES value");
        }
    }

    public boolean isContextDependent() {
        return true;
    }
}

