/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Resolver
implements EntityResolver,
Cloneable {
    private Dictionary pubidMapping;

    public static void addDirectoryMapping(Dictionary dictionary, String[][] stringArray, File file) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i][1]);
            if (!file2.exists()) continue;
            String string = Resolver.fileToURL(file2);
            dictionary.put(stringArray[i][0], string);
        }
    }

    public static String fileNameToURL(String string) throws IOException {
        return Resolver.fileToURL(new File(string));
    }

    public static String fileToURL(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("no such file: " + file.getName());
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return "file:" + string;
    }

    public static String getURL(String string) {
        try {
            return Resolver.fileNameToURL(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public Resolver(Dictionary dictionary) {
        this.pubidMapping = dictionary;
    }

    public static String getEncoding(String string) {
        String string2;
        int n;
        String string3 = null;
        if (string.startsWith("text/")) {
            String string4 = string3 = string.startsWith("text/html") ? "ISO-8859-1" : "US-ASCII";
        }
        if ((n = string.indexOf("charset")) != -1) {
            if ((n = string.indexOf(61, n)) == -1) {
                return string3;
            }
            string2 = string.substring(n + 1);
            if ((n = string2.indexOf(59)) != -1) {
                string2 = string2.substring(0, n);
            }
            if ((n = string2.indexOf(40)) != -1) {
                string2 = string2.substring(0, n);
            }
            if ((string2 = string2.trim()).charAt(0) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
        } else {
            string2 = string3;
        }
        return string2;
    }

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        String string3;
        InputSource inputSource = null;
        if (string != null && (string3 = (String)this.pubidMapping.get(string)) != null) {
            inputSource = new InputSource(string3);
            inputSource.setPublicId(string);
        }
        return inputSource;
    }
}

