/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.SortKey;
import gnu.xml.xpath.Expr;
import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Node;

class XSLComparator
implements Comparator {
    final List sortKeys;

    XSLComparator(List list2) {
        this.sortKeys = list2;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof Node && object2 instanceof Node) {
            Node node2 = (Node)object;
            Node node3 = (Node)object2;
            Iterator iterator = this.sortKeys.iterator();
            while (iterator.hasNext()) {
                int n;
                SortKey sortKey = (SortKey)iterator.next();
                String string = sortKey.key(node2);
                String string2 = sortKey.key(node3);
                if ("text".equals(sortKey.dataType)) {
                    Locale locale = sortKey.lang == null ? Locale.getDefault() : new Locale(sortKey.lang);
                    Collator collator = Collator.getInstance(locale);
                    n = collator.compare(string, string2);
                    if (n == 0) continue;
                    switch (sortKey.caseOrder) {
                        case 1: {
                            break;
                        }
                    }
                    if (sortKey.descending) {
                        n = -n;
                    }
                    return n;
                }
                if (!"number".equals(sortKey.dataType)) continue;
                double d = Expr._number(node2, string);
                double d2 = Expr._number(node3, string2);
                if (Double.isNaN(d) || Double.isInfinite(d2)) {
                    n = -1;
                } else if (Double.isNaN(d2) || Double.isInfinite(d)) {
                    n = 1;
                } else {
                    int n2 = d > d2 ? 1 : (n = d < d2 ? -1 : 0);
                }
                if (sortKey.descending) {
                    return -n;
                }
                return n;
            }
        }
        return 0;
    }
}

