/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.dom;

import gnu.xml.dom.DomNodeIterator;
import gnu.xml.libxmlj.dom.GnomeDOMException;
import gnu.xml.libxmlj.dom.GnomeDOMStringList;
import gnu.xml.libxmlj.dom.GnomeElement;
import gnu.xml.libxmlj.dom.GnomeNode;
import gnu.xml.libxmlj.dom.GnomeXPathExpression;
import gnu.xml.libxmlj.dom.GnomeXPathNSResolver;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathNSResolver;

public class GnomeDocument
extends GnomeNode
implements Document,
DOMConfiguration,
XPathEvaluator,
DocumentTraversal {
    DOMImplementation dom;
    boolean strictErrorChecking;
    boolean canonicalForm;
    boolean cdataSections;
    boolean checkCharacterNormalization;
    boolean comments;
    boolean datatypeNormalization;
    boolean elementContentWhitespace;
    boolean entities;
    DOMErrorHandler errorHandler;
    boolean namespaces;
    boolean namespaceDeclarations;
    boolean normalizeCharacters;
    boolean splitCdataSections;
    boolean validate;
    boolean validateIfSchema;
    boolean wellFormed;

    private /* synthetic */ void finit$() {
        this.canonicalForm = false;
        this.cdataSections = true;
        this.checkCharacterNormalization = false;
        this.comments = true;
        this.datatypeNormalization = false;
        this.elementContentWhitespace = true;
        this.entities = true;
        this.namespaces = true;
        this.namespaceDeclarations = true;
        this.normalizeCharacters = false;
        this.splitCdataSections = true;
        this.validate = false;
        this.validateIfSchema = false;
        this.wellFormed = true;
    }

    GnomeDocument(Object object) {
        super(object);
        this.finit$();
        this.strictErrorChecking = true;
    }

    protected void finalize() {
        this.free(this.id);
    }

    private native void free(Object var1);

    public native DocumentType getDoctype();

    public DOMImplementation getImplementation() {
        return this.dom;
    }

    public native Element getDocumentElement();

    public Element createElement(String string) throws DOMException {
        return this.createElementNS(null, string);
    }

    public native DocumentType createDocumentType(String var1, String var2, String var3);

    public native DocumentFragment createDocumentFragment();

    public native Text createTextNode(String var1);

    public native Comment createComment(String var1);

    public native CDATASection createCDATASection(String var1) throws DOMException;

    public native ProcessingInstruction createProcessingInstruction(String var1, String var2) throws DOMException;

    public Attr createAttribute(String string) throws DOMException {
        return this.createAttributeNS(null, string);
    }

    public native EntityReference createEntityReference(String var1) throws DOMException;

    public native NodeList getElementsByTagName(String var1);

    public Node importNode(Node node2, boolean bl) throws DOMException {
        Node node3 = this.xmljImportNode(node2, bl);
        if (node2 instanceof GnomeNode) {
            ((GnomeNode)node2).notifyUserDataHandlers((short)2, node2, node3);
        }
        return node3;
    }

    private native Node xmljImportNode(Node var1, boolean var2) throws DOMException;

    public native Element createElementNS(String var1, String var2) throws DOMException;

    public native Attr createAttributeNS(String var1, String var2) throws DOMException;

    public native NodeList getElementsByTagNameNS(String var1, String var2);

    public Element getElementById(String string) {
        Element element = this.xmljGetElementById(string);
        if (element == null) {
            TreeWalker treeWalker = this.createTreeWalker(this, 1, null, false);
            Node node2 = treeWalker.nextNode();
            while (node2 != null) {
                GnomeElement gnomeElement = (GnomeElement)node2;
                if (gnomeElement.userIdAttrs != null) {
                    Iterator iterator = gnomeElement.userIdAttrs.iterator();
                    while (iterator.hasNext()) {
                        Attr attr = (Attr)iterator.next();
                        if (!attr.getNodeValue().equals(string)) continue;
                        return gnomeElement;
                    }
                }
                node2 = treeWalker.nextNode();
            }
        }
        return element;
    }

    private native Element xmljGetElementById(String var1);

    public native String getInputEncoding();

    public native String getXmlEncoding();

    public native boolean getXmlStandalone();

    public native void setXmlStandalone(boolean var1);

    public native String getXmlVersion();

    public native void setXmlVersion(String var1);

    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    public void setStrictErrorChecking(boolean bl) {
        this.strictErrorChecking = bl;
    }

    public native String getDocumentURI();

    public native void setDocumentURI(String var1);

    public Node adoptNode(Node node2) throws DOMException {
        if (node2 == null || !(node2 instanceof GnomeNode)) {
            return null;
        }
        Node node3 = this.xmljAdoptNode(node2);
        if (node2 instanceof GnomeNode) {
            ((GnomeNode)node2).notifyUserDataHandlers((short)5, node2, node3);
        }
        return node3;
    }

    private native Node xmljAdoptNode(Node var1) throws DOMException;

    public DOMConfiguration getDomConfig() {
        return this;
    }

    public void normalizeDocument() {
        this.normalize();
    }

    public native Node renameNode(Node var1, String var2, String var3);

    public void setParameter(String string, Object object) throws DOMException {
        if (!"canonical-form".equals(string = string.toLowerCase())) {
            if ("cdata-sections".equals(string)) {
                this.cdataSections = this.getBooleanValue(object);
            } else if (!"check-character-normalization".equals(string)) {
                if ("comments".equals(string)) {
                    this.comments = this.getBooleanValue(object);
                } else if (!"datatype-normalization".equals(string) && !"element-content-whitespace".equals(string)) {
                    if ("entities".equals(string)) {
                        this.entities = this.getBooleanValue(object);
                    } else if ("error-handler".equals(string)) {
                        this.errorHandler = (DOMErrorHandler)object;
                    } else if ("infoset".equals(string)) {
                        if (this.getBooleanValue(object)) {
                            this.validateIfSchema = false;
                            this.entities = false;
                            this.datatypeNormalization = false;
                            this.cdataSections = false;
                            this.namespaceDeclarations = true;
                            this.wellFormed = true;
                            this.elementContentWhitespace = true;
                            this.comments = true;
                            this.namespaces = true;
                        }
                    } else if (!"namespaces".equals(string)) {
                        if ("namespace-declarations".equals(string)) {
                            this.namespaceDeclarations = this.getBooleanValue(object);
                        } else if (!"normalize-characters".equals(string)) {
                            if ("split-cdata-sections".equals(string)) {
                                this.splitCdataSections = this.getBooleanValue(object);
                            } else if (!("validate".equals(string) || "validate-if-schema".equals(string) || "well-formed".equals(string))) {
                                throw new GnomeDOMException(8, string);
                            }
                        }
                    }
                }
            }
        }
    }

    public Object getParameter(String string) throws DOMException {
        if ("canonical-form".equals(string = string.toLowerCase())) {
            return this.canonicalForm;
        }
        if ("cdata-sections".equals(string)) {
            return this.cdataSections;
        }
        if ("check-character-normalization".equals(string)) {
            return this.checkCharacterNormalization;
        }
        if ("comments".equals(string)) {
            return this.comments;
        }
        if ("datatype-normalization".equals(string)) {
            return this.datatypeNormalization;
        }
        if ("element-content-whitespace".equals(string)) {
            return this.elementContentWhitespace;
        }
        if ("entities".equals(string)) {
            return this.entities;
        }
        if ("error-handler".equals(string)) {
            return this.errorHandler;
        }
        if ("infoset".equals(string)) {
            return !this.validateIfSchema && !this.entities && !this.datatypeNormalization && !this.cdataSections && this.namespaceDeclarations && this.wellFormed && this.elementContentWhitespace && this.comments && this.namespaces;
        }
        if ("namespaces".equals(string)) {
            return this.namespaces;
        }
        if ("namespace-declarations".equals(string)) {
            return this.namespaceDeclarations;
        }
        if ("normalize-characters".equals(string)) {
            return this.normalizeCharacters;
        }
        if ("split-cdata-sections".equals(string)) {
            return this.splitCdataSections;
        }
        if ("validate".equals(string)) {
            return this.validate;
        }
        if ("validate-if-schema".equals(string)) {
            return this.validateIfSchema;
        }
        if ("well-formed".equals(string)) {
            return this.wellFormed;
        }
        throw new GnomeDOMException(8, string);
    }

    public boolean canSetParameter(String string, Object object) {
        if ("error-handler".equals(string = string.toLowerCase())) {
            return object == null || object instanceof DOMErrorHandler;
        }
        return "cdata-sections".equals(string) || "comments".equals(string) || "entities".equals(string) || "namespace-declarations".equals(string) || "split-cdata-sections".equals(string);
    }

    public DOMStringList getParameterNames() {
        String[] stringArray = new String[]{"canonical-form", "cdata-sections", "check-character-normalization", "comments", "datatype-normalization", "element-content-whitespace", "entities", "error-handler", "infoset", "namespaces", "namespace-declarations", "normalize-characters", "split-cdata-sections", "validate", "validate-if-schema", "well-formed"};
        return new GnomeDOMStringList(stringArray);
    }

    private boolean getBooleanValue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return false;
    }

    public XPathExpression createExpression(String string, XPathNSResolver xPathNSResolver) throws XPathException, DOMException {
        return new GnomeXPathExpression(this, string, xPathNSResolver);
    }

    public XPathNSResolver createNSResolver(Node node2) {
        return new GnomeXPathNSResolver(node2);
    }

    public native Object evaluate(String var1, Node var2, XPathNSResolver var3, short var4, Object var5) throws XPathException, DOMException;

    public NodeIterator createNodeIterator(Node node2, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        return new DomNodeIterator(node2, n, nodeFilter, bl, false);
    }

    public TreeWalker createTreeWalker(Node node2, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        return new DomNodeIterator(node2, n, nodeFilter, bl, true);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[version=");
        stringBuffer.append(this.getXmlVersion());
        stringBuffer.append(",standalone=");
        stringBuffer.append(this.getXmlStandalone());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

