/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.SAXEventSink;
import java.util.LinkedList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSParserFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class FilteredSAXEventSink
extends SAXEventSink {
    final LSParserFilter filter;
    final int whatToShow;
    LinkedList nodes;
    LinkedList decisions;
    boolean rejecting;

    FilteredSAXEventSink(LSParserFilter lSParserFilter) {
        this.filter = lSParserFilter;
        this.whatToShow = lSParserFilter.getWhatToShow();
    }

    public void startDocument() throws SAXException {
        if (this.interrupted) {
            return;
        }
        this.nodes = new LinkedList();
        this.decisions = new LinkedList();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        if (this.interrupted) {
            return;
        }
        super.endDocument();
        if (this.getDecision(this.ctx, false) == 2) {
            this.ctx = null;
            this.doc = null;
        }
        this.nodes = null;
        this.decisions = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.rejecting || this.interrupted) {
            return;
        }
        Element element = this.createElement(string, string2, string3, attributes);
        this.ctx = element;
        short s = this.getDecision(element, true);
        this.nodes.addLast(element);
        this.decisions.addLast(new Short(s));
        switch (s) {
            case 2: {
                this.rejecting = true;
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    protected Attr createAttr(Attributes attributes, int n) {
        Attr attr = super.createAttr(attributes, n);
        short s = this.getDecision(attr, false);
        switch (s) {
            case 2: {
                return null;
            }
            case 4: {
                this.interrupted = true;
                return null;
            }
        }
        return attr;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.rejecting || this.interrupted) {
            return;
        }
        super.endElement(string, string2, string3);
        Element element = (Element)this.nodes.removeLast();
        DomDocument domDocument = this.nodes.isEmpty() ? this.doc : (Node)this.nodes.getLast();
        this.ctx = domDocument;
        short s = (Short)this.decisions.removeLast();
        switch (s) {
            case 3: {
                for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    domDocument.insertBefore(node2, element);
                }
                return;
            }
            case 2: {
                this.rejecting = false;
            }
        }
        s = this.getDecision(element, false);
        switch (s) {
            case 1: {
                domDocument.appendChild(element);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.rejecting || this.interrupted) {
            return;
        }
        Text text = this.createText(cArray, n, n2);
        short s = this.getDecision(text, false);
        switch (s) {
            case 1: {
                this.ctx.appendChild(text);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.rejecting || this.interrupted || this.inDTD) {
            return;
        }
        Node node2 = this.createProcessingInstruction(string, string2);
        short s = this.getDecision(node2, false);
        switch (s) {
            case 1: {
                this.ctx.appendChild(node2);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        Node node2;
        if (this.interrupted) {
            return;
        }
        this.ctx = node2 = this.createDocumentType(string, string2, string3);
        this.inDTD = true;
        this.nodes.addLast(node2);
        this.decisions.addLast(new Short(1));
    }

    public void endDTD() throws SAXException {
        if (this.interrupted) {
            return;
        }
        Node node2 = (Node)this.nodes.removeLast();
        this.decisions.removeLast();
        this.inDTD = false;
        this.ctx = this.doc;
        short s = this.getDecision(node2, false);
        switch (s) {
            case 1: {
                this.ctx.appendChild(node2);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.rejecting || this.interrupted || this.inDTD) {
            return;
        }
        Node node2 = this.createComment(cArray, n, n2);
        short s = this.getDecision(node2, false);
        switch (s) {
            case 1: {
                this.ctx.appendChild(node2);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    short getDecision(Node node2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.whatToShow == -1;
        if (!bl2) {
            switch (node2.getNodeType()) {
                case 2: {
                    bl2 = (this.whatToShow & 2) != 0;
                    break;
                }
                case 3: {
                    bl2 = (this.whatToShow & 4) != 0;
                    break;
                }
                case 4: {
                    bl2 = (this.whatToShow & 8) != 0;
                    break;
                }
                case 1: {
                    bl2 = (this.whatToShow & 1) != 0;
                    break;
                }
                case 8: {
                    bl2 = (this.whatToShow & 0x80) != 0;
                    break;
                }
                case 9: {
                    bl2 = (this.whatToShow & 0x100) != 0;
                    break;
                }
                case 7: {
                    bl2 = (this.whatToShow & 0x40) != 0;
                    break;
                }
                case 11: {
                    bl2 = (this.whatToShow & 0x400) != 0;
                    break;
                }
                case 10: {
                    bl2 = (this.whatToShow & 0x200) != 0;
                    break;
                }
                case 5: {
                    bl2 = (this.whatToShow & 0x10) != 0;
                    break;
                }
                case 6: {
                    bl2 = (this.whatToShow & 0x20) != 0;
                    break;
                }
                case 12: {
                    boolean bl4 = bl2 = (this.whatToShow & 0x800) != 0;
                }
            }
        }
        if (!bl2) {
            return 1;
        }
        if (bl) {
            return this.filter.startElement((Element)node2);
        }
        return this.filter.acceptNode(node2);
    }
}

