/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.java.security.util.PRNG;
import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.key.IKeyAgreementParty;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.KeyAgreementFactory;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.sasl.IllegalMechanismStateException;
import gnu.javax.crypto.sasl.InputBuffer;
import gnu.javax.crypto.sasl.IntegrityException;
import gnu.javax.crypto.sasl.OutputBuffer;
import gnu.javax.crypto.sasl.ServerMechanism;
import gnu.javax.crypto.sasl.srp.CALG;
import gnu.javax.crypto.sasl.srp.IALG;
import gnu.javax.crypto.sasl.srp.KDF;
import gnu.javax.crypto.sasl.srp.SRP;
import gnu.javax.crypto.sasl.srp.SRPRegistry;
import gnu.javax.crypto.sasl.srp.SecurityContext;
import gnu.javax.crypto.sasl.srp.ServerStore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public class SRPServer
extends ServerMechanism
implements SaslServer {
    private static final Logger log = Logger.getLogger(SRPServer.class$("gnu.javax.crypto.sasl.srp.SRPServer").getName());
    private String U;
    private BigInteger N;
    private BigInteger g;
    private BigInteger A;
    private BigInteger B;
    private byte[] s;
    private byte[] cIV;
    private byte[] sIV;
    private byte[] cn;
    private byte[] sn;
    private SRP srp;
    private byte[] sid;
    private int ttl;
    private byte[] cCB;
    private String mandatory;
    private String L;
    private String o;
    private String chosenIntegrityAlgorithm;
    private String chosenConfidentialityAlgorithm;
    private int rawSendSize;
    private byte[] K;
    private boolean replayDetection;
    private int inCounter;
    private int outCounter;
    private IALG inMac;
    private IALG outMac;
    private CALG inCipher;
    private CALG outCipher;
    private IKeyAgreementParty serverHandler;
    private PRNG prng;

    private /* synthetic */ void finit$() {
        this.U = null;
        this.ttl = 360;
        this.L = null;
        this.rawSendSize = 0x7FFFFFFB;
        this.replayDetection = true;
        this.inCounter = 0;
        this.outCounter = 0;
        this.serverHandler = KeyAgreementFactory.getPartyBInstance("srp-sasl");
        this.prng = null;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SRPServer() {
        super("SRP");
        this.finit$();
    }

    protected void initMechanism() throws SaslException {
        String string = (String)this.properties.get("gnu.crypto.sasl.srp.hash");
        this.srp = SRP.instance(string == null ? SRPRegistry.SRP_DEFAULT_DIGEST_NAME : string);
    }

    protected void resetMechanism() throws SaslException {
        this.s = null;
        this.B = null;
        this.A = null;
        this.K = null;
        this.outMac = null;
        this.inMac = null;
        this.outCipher = null;
        this.inCipher = null;
        this.sid = null;
    }

    public byte[] evaluateResponse(byte[] byArray) throws SaslException {
        switch (this.state) {
            case 0: {
                if (byArray == null) {
                    return null;
                }
                ++this.state;
                return this.sendProtocolElements(byArray);
            }
            case 1: {
                if (this.complete) break;
                ++this.state;
                return this.sendEvidence(byArray);
            }
        }
        throw new IllegalMechanismStateException("evaluateResponse()");
    }

    protected byte[] engineUnwrap(byte[] byArray, int n, int n2) throws SaslException {
        byte[] byArray2;
        if (this.inMac == null && this.inCipher == null) {
            throw new IllegalStateException("connection is not protected");
        }
        try {
            if (this.inMac != null) {
                byte[] byArray3;
                int n3 = this.inMac.length();
                int n4 = n2 - n3;
                byte[] byArray4 = new byte[n3];
                System.arraycopy(byArray, n + n4, byArray4, 0, n3);
                this.inMac.update(byArray, n, n4);
                if (this.replayDetection) {
                    ++this.inCounter;
                    this.inMac.update(new byte[]{(byte)(this.inCounter >>> 24), (byte)(this.inCounter >>> 16), (byte)(this.inCounter >>> 8), (byte)this.inCounter});
                }
                if (!Arrays.equals(byArray4, byArray3 = this.inMac.doFinal())) {
                    throw new IntegrityException("engineUnwrap()");
                }
                if (this.inCipher != null) {
                    byArray2 = this.inCipher.doFinal(byArray, n, n4);
                } else {
                    byArray2 = new byte[n4];
                    System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
                }
            } else {
                byArray2 = this.inCipher.doFinal(byArray, n, n2);
            }
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new SaslException("engineUnwrap()", iOException);
        }
        return byArray2;
    }

    protected byte[] engineWrap(byte[] byArray, int n, int n2) throws SaslException {
        byte[] byArray2;
        if (this.outMac == null && this.outCipher == null) {
            throw new IllegalStateException("connection is not protected");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (this.outCipher != null) {
                byArray2 = this.outCipher.doFinal(byArray, n, n2);
                byteArrayOutputStream.write(byArray2);
                if (this.outMac != null) {
                    this.outMac.update(byArray2);
                    if (this.replayDetection) {
                        ++this.outCounter;
                        this.outMac.update(new byte[]{(byte)(this.outCounter >>> 24), (byte)(this.outCounter >>> 16), (byte)(this.outCounter >>> 8), (byte)this.outCounter});
                    }
                    byte[] byArray3 = this.outMac.doFinal();
                    byteArrayOutputStream.write(byArray3);
                }
            } else {
                byteArrayOutputStream.write(byArray, n, n2);
                this.outMac.update(byArray, n, n2);
                if (this.replayDetection) {
                    ++this.outCounter;
                    this.outMac.update(new byte[]{(byte)(this.outCounter >>> 24), (byte)(this.outCounter >>> 16), (byte)(this.outCounter >>> 8), (byte)this.outCounter});
                }
                byte[] byArray4 = this.outMac.doFinal();
                byteArrayOutputStream.write(byArray4);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new SaslException("engineWrap()", iOException);
        }
        return byArray2;
    }

    protected String getNegotiatedQOP() {
        if (this.inMac != null) {
            if (this.inCipher != null) {
                return "auth-conf";
            }
            return "auth-int";
        }
        return "auth";
    }

    protected String getNegotiatedStrength() {
        if (this.inMac != null) {
            if (this.inCipher != null) {
                return "high";
            }
            return "medium";
        }
        return "low";
    }

    protected String getNegotiatedRawSendSize() {
        return String.valueOf(this.rawSendSize);
    }

    protected String getReuse() {
        return "true";
    }

    private byte[] sendProtocolElements(byte[] byArray) throws SaslException {
        Object object;
        Object object2;
        InputBuffer inputBuffer = new InputBuffer(byArray);
        try {
            this.U = inputBuffer.getText();
            this.authorizationID = inputBuffer.getText();
            this.sid = inputBuffer.getEOS();
            this.cn = inputBuffer.getOS();
            this.cCB = inputBuffer.getEOS();
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new AuthenticationException("sendProtocolElements()", iOException);
        }
        if (ServerStore.instance().isAlive(this.sid)) {
            SecurityContext securityContext = ServerStore.instance().restoreSession(this.sid);
            this.srp = SRP.instance(securityContext.getMdName());
            this.K = securityContext.getK();
            this.cIV = securityContext.getClientIV();
            this.sIV = securityContext.getServerIV();
            this.replayDetection = securityContext.hasReplayDetection();
            this.inCounter = securityContext.getInCounter();
            this.outCounter = securityContext.getOutCounter();
            this.inMac = securityContext.getInMac();
            this.outMac = securityContext.getOutMac();
            this.inCipher = securityContext.getInCipher();
            this.outCipher = securityContext.getOutCipher();
            if (this.sn == null || this.sn.length != 16) {
                this.sn = new byte[16];
            }
            this.getDefaultPRNG().nextBytes(this.sn);
            this.setupSecurityServices(false);
            OutputBuffer outputBuffer = new OutputBuffer();
            try {
                outputBuffer.setScalar(1, 255);
                outputBuffer.setOS(this.sn);
                outputBuffer.setEOS(this.channelBinding);
            }
            catch (IOException iOException) {
                if (iOException instanceof SaslException) {
                    throw (SaslException)iOException;
                }
                throw new AuthenticationException("sendProtocolElements()", iOException);
            }
            byte[] byArray2 = outputBuffer.encode();
            return byArray2;
        }
        this.authenticator.activate(this.properties);
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.srp6.ka.H", this.srp.getAlgorithm());
        hashMap.put("gnu.crypto.srp6.ka.password.db", this.authenticator);
        try {
            this.serverHandler.init(hashMap);
            object2 = new OutgoingMessage();
            ((OutgoingMessage)object2).writeString(this.U);
            object = new IncomingMessage(((OutgoingMessage)object2).toByteArray());
            object2 = this.serverHandler.processMessage((IncomingMessage)object);
            object = new IncomingMessage(((OutgoingMessage)object2).toByteArray());
            this.N = ((IncomingMessage)object).readMPI();
            this.g = ((IncomingMessage)object).readMPI();
            this.s = ((IncomingMessage)object).readMPI().toByteArray();
            this.B = ((IncomingMessage)object).readMPI();
        }
        catch (KeyAgreementException keyAgreementException) {
            throw new SaslException("sendProtocolElements()", keyAgreementException);
        }
        this.L = this.createL();
        object2 = new OutputBuffer();
        try {
            ((OutputBuffer)object2).setScalar(1, 0);
            ((OutputBuffer)object2).setMPI(this.N);
            ((OutputBuffer)object2).setMPI(this.g);
            ((OutputBuffer)object2).setOS(this.s);
            ((OutputBuffer)object2).setMPI(this.B);
            ((OutputBuffer)object2).setText(this.L);
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new AuthenticationException("sendProtocolElements()", iOException);
        }
        object = ((OutputBuffer)object2).encode();
        return object;
    }

    private byte[] sendEvidence(byte[] byArray) throws SaslException {
        Object object;
        Object object2;
        byte[] byArray2;
        InputBuffer inputBuffer = new InputBuffer(byArray);
        try {
            this.A = inputBuffer.getMPI();
            byArray2 = inputBuffer.getOS();
            this.o = inputBuffer.getText();
            this.cIV = inputBuffer.getOS();
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new AuthenticationException("sendEvidence()", iOException);
        }
        this.parseO(this.o);
        try {
            object2 = new OutgoingMessage();
            ((OutgoingMessage)object2).writeMPI(this.A);
            object = new IncomingMessage(((OutgoingMessage)object2).toByteArray());
            this.serverHandler.processMessage((IncomingMessage)object);
            this.K = this.serverHandler.getSharedSecret();
        }
        catch (KeyAgreementException keyAgreementException) {
            throw new SaslException("sendEvidence()", keyAgreementException);
        }
        try {
            object2 = this.srp.generateM1(this.N, this.g, this.U, this.s, this.A, this.B, this.K, this.authorizationID, this.L, this.cn, this.cCB);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationException("sendEvidence()", unsupportedEncodingException);
        }
        if (!Arrays.equals(byArray2, (byte[])object2)) {
            throw new AuthenticationException("M1 mismatch");
        }
        this.setupSecurityServices(true);
        try {
            object = this.srp.generateM2(this.A, byArray2, this.K, this.U, this.authorizationID, this.o, this.sid, this.ttl, this.cIV, this.sIV, this.channelBinding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationException("sendEvidence()", unsupportedEncodingException);
        }
        OutputBuffer outputBuffer = new OutputBuffer();
        try {
            outputBuffer.setOS((byte[])object);
            outputBuffer.setOS(this.sIV);
            outputBuffer.setEOS(this.sid);
            outputBuffer.setScalar(4, this.ttl);
            outputBuffer.setEOS(this.channelBinding);
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new AuthenticationException("sendEvidence()", iOException);
        }
        byte[] byArray3 = outputBuffer.encode();
        return byArray3;
    }

    private String createL() {
        Object object;
        int n;
        String string = (String)this.properties.get("gnu.crypto.sasl.srp.mandatory");
        if (string == null) {
            string = "replay_detection";
        }
        if (!(SRPRegistry.MANDATORY_NONE.equals(string) || SRPRegistry.OPTION_REPLAY_DETECTION.equals(string) || SRPRegistry.OPTION_INTEGRITY.equals(string) || SRPRegistry.OPTION_CONFIDENTIALITY.equals(string))) {
            string = "replay_detection";
        }
        this.mandatory = string;
        string = (String)this.properties.get("gnu.crypto.sasl.srp.confidentiality");
        boolean bl = string == null ? false : Boolean.valueOf(string);
        string = (String)this.properties.get("gnu.crypto.sasl.srp.integrity");
        boolean bl2 = string == null ? true : Boolean.valueOf(string);
        string = (String)this.properties.get("gnu.crypto.sasl.srp.replay.detection");
        boolean bl3 = string == null ? true : Boolean.valueOf(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mda").append("=").append(this.srp.getAlgorithm()).append(",");
        if (!SRPRegistry.MANDATORY_NONE.equals(this.mandatory)) {
            stringBuffer.append("mandatory").append("=").append(this.mandatory).append(",");
        }
        if (bl3) {
            stringBuffer.append("replay_detection").append(",");
            bl2 = true;
        }
        if (bl2) {
            for (n = 0; n < SRPRegistry.INTEGRITY_ALGORITHMS.length; ++n) {
                stringBuffer.append("integrity").append("=").append(SRPRegistry.INTEGRITY_ALGORITHMS[n]).append(",");
            }
        }
        if (bl) {
            for (n = 0; n < SRPRegistry.CONFIDENTIALITY_ALGORITHMS.length; ++n) {
                object = CipherFactory.getInstance(SRPRegistry.CONFIDENTIALITY_ALGORITHMS[n]);
                if (object == null) continue;
                stringBuffer.append("confidentiality").append("=").append(SRPRegistry.CONFIDENTIALITY_ALGORITHMS[n]).append(",");
            }
        }
        object = stringBuffer.append("maxbuffersize").append("=").append(0x7FFFFFFB).toString();
        return object;
    }

    private void parseO(String string) throws AuthenticationException {
        this.replayDetection = false;
        boolean bl = false;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("replay_detection")) {
                this.replayDetection = true;
                continue;
            }
            if (string2.startsWith("integrity=")) {
                if (bl) {
                    throw new AuthenticationException("Only one integrity algorithm may be chosen");
                }
                string2 = string2.substring(string2.indexOf(61) + 1);
                for (n = 0; n < SRPRegistry.INTEGRITY_ALGORITHMS.length; ++n) {
                    if (!SRPRegistry.INTEGRITY_ALGORITHMS[n].equals(string2)) continue;
                    this.chosenIntegrityAlgorithm = string2;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new AuthenticationException("Unknown integrity algorithm: " + string2);
            }
            if (string2.startsWith("confidentiality=")) {
                if (bl2) {
                    throw new AuthenticationException("Only one confidentiality algorithm may be chosen");
                }
                string2 = string2.substring(string2.indexOf(61) + 1);
                for (n = 0; n < SRPRegistry.CONFIDENTIALITY_ALGORITHMS.length; ++n) {
                    if (!SRPRegistry.CONFIDENTIALITY_ALGORITHMS[n].equals(string2)) continue;
                    this.chosenConfidentialityAlgorithm = string2;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                throw new AuthenticationException("Unknown confidentiality algorithm: " + string2);
            }
            if (!string2.startsWith("maxbuffersize=")) continue;
            String string3 = string2.substring(string2.indexOf(61) + 1);
            try {
                this.rawSendSize = Integer.parseInt(string3);
                if (this.rawSendSize <= 0x7FFFFFFB && this.rawSendSize >= 1) continue;
                throw new AuthenticationException("Illegal value for 'maxbuffersize' option");
            }
            catch (NumberFormatException numberFormatException) {
                throw new AuthenticationException("maxbuffersize=" + string3, numberFormatException);
            }
        }
        if (this.replayDetection && !bl) {
            throw new AuthenticationException("Missing integrity protection algorithm but replay detection is chosen");
        }
        if (this.mandatory.equals("replay_detection") && !this.replayDetection) {
            throw new AuthenticationException("Replay detection is mandatory but was not chosen");
        }
        if (this.mandatory.equals("integrity") && !bl) {
            throw new AuthenticationException("Integrity protection is mandatory but was not chosen");
        }
        if (this.mandatory.equals("confidentiality") && !bl2) {
            throw new AuthenticationException("Confidentiality is mandatory but was not chosen");
        }
        int n = 0;
        if (this.chosenConfidentialityAlgorithm != null) {
            IBlockCipher iBlockCipher = CipherFactory.getInstance(this.chosenConfidentialityAlgorithm);
            if (iBlockCipher != null) {
                n = iBlockCipher.defaultBlockSize();
            } else {
                throw new AuthenticationException("Confidentiality algorithm (" + this.chosenConfidentialityAlgorithm + ") not available");
            }
        }
        this.sIV = new byte[n];
        if (n > 0) {
            this.getDefaultPRNG().nextBytes(this.sIV);
        }
    }

    private void setupSecurityServices(boolean bl) throws SaslException {
        this.complete = true;
        if (bl) {
            this.inCounter = 0;
            this.outCounter = 0;
            if (this.chosenConfidentialityAlgorithm != null) {
                this.inCipher = CALG.getInstance(this.chosenConfidentialityAlgorithm);
                this.outCipher = CALG.getInstance(this.chosenConfidentialityAlgorithm);
            }
            if (this.chosenIntegrityAlgorithm != null) {
                this.inMac = IALG.getInstance(this.chosenIntegrityAlgorithm);
                this.outMac = IALG.getInstance(this.chosenIntegrityAlgorithm);
            }
            this.sid = this.inMac != null ? ServerStore.getNewSessionID() : new byte[]{};
        } else {
            this.K = this.srp.generateKn(this.K, this.cn, this.sn);
        }
        KDF kDF = KDF.getInstance(this.K);
        if (this.inCipher != null) {
            this.outCipher.init(kDF, this.sIV, Direction.FORWARD);
            this.inCipher.init(kDF, this.cIV, Direction.REVERSED);
        }
        if (this.inMac != null) {
            this.outMac.init(kDF);
            this.inMac.init(kDF);
        }
        if (this.sid != null && this.sid.length != 0) {
            ServerStore.instance().cacheSession(this.ttl, new SecurityContext(this.srp.getAlgorithm(), this.sid, this.K, this.cIV, this.sIV, this.replayDetection, this.inCounter, this.outCounter, this.inMac, this.outMac, this.inCipher, this.outCipher));
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

