/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.mac.IMac;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PBKDF2
extends BasePRNG
implements Cloneable {
    private byte[] in;
    private int iterationCount;
    private byte[] salt;
    private IMac mac;
    private long count;

    public PBKDF2(IMac iMac) {
        super("PBKDF2-" + iMac.name());
        this.mac = iMac;
        this.iterationCount = -1;
    }

    public void setup(Map map) {
        byte[] byArray;
        Object object;
        char[] cArray;
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.hmac.pkcs5", Boolean.TRUE);
        byte[] byArray2 = (byte[])map.get("gnu.crypto.pbe.salt");
        if (byArray2 == null) {
            if (this.salt == null) {
                throw new IllegalArgumentException("no salt specified");
            }
        } else {
            this.salt = byArray2;
        }
        if ((cArray = (char[])map.get("gnu.crypto.pbe.password")) != null) {
            object = (String)map.get("gnu.crypto.pbe.password.encoding");
            object = object == null || ((String)object).trim().length() == 0 ? "UTF-8" : ((String)object).trim();
            try {
                byArray = new String(cArray).getBytes((String)object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException("Unknown or unsupported encoding: " + (String)object, unsupportedEncodingException);
            }
        } else {
            byArray = (byte[])map.get("gnu.crypto.mac.key.material");
        }
        if (byArray != null) {
            hashMap.put("gnu.crypto.mac.key.material", byArray);
        } else if (!this.initialised) {
            throw new IllegalArgumentException("Neither password nor key-material were specified");
        }
        try {
            this.mac.init(hashMap);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        object = (Integer)map.get("gnu.crypto.pbe.iteration.count");
        if (object != null) {
            this.iterationCount = (Integer)object;
        }
        if (this.iterationCount <= 0) {
            throw new IllegalArgumentException("bad iteration count");
        }
        this.count = 0L;
        this.buffer = new byte[this.mac.macSize()];
        try {
            this.fillBlock();
        }
        catch (LimitReachedException limitReachedException) {
            throw new Error(limitReachedException.getMessage());
        }
    }

    public void fillBlock() throws LimitReachedException {
        if (++this.count > 0xFFFFFFFFL) {
            throw new LimitReachedException();
        }
        Arrays.fill(this.buffer, (byte)0);
        int n = this.salt.length;
        this.in = new byte[n + 4];
        System.arraycopy(this.salt, 0, this.in, 0, this.salt.length);
        this.in[n++] = (byte)(this.count >>> 24);
        this.in[n++] = (byte)(this.count >>> 16);
        this.in[n++] = (byte)(this.count >>> 8);
        this.in[n] = (byte)this.count;
        for (int i = 0; i < this.iterationCount; ++i) {
            this.mac.reset();
            this.mac.update(this.in, 0, this.in.length);
            this.in = this.mac.digest();
            for (int j = 0; j < this.buffer.length; ++j) {
                int n2 = j;
                this.buffer[n2] = this.buffer[n2] ^ this.in[j];
            }
        }
    }
}

