/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import java.util.Map;

public class ARCFour
extends BasePRNG
implements Cloneable {
    public static final String ARCFOUR_KEY_MATERIAL = "gnu.crypto.prng.arcfour.key-material";
    public static final int ARCFOUR_SBOX_SIZE = 256;
    private byte[] s;
    private byte m;
    private byte n;

    public ARCFour() {
        super("arcfour");
    }

    public void setup(Map map) {
        int n;
        int n2;
        byte[] byArray = (byte[])map.get(ARCFOUR_KEY_MATERIAL);
        if (byArray == null) {
            throw new IllegalArgumentException("ARCFOUR needs a key");
        }
        this.s = new byte[256];
        this.n = 0;
        this.m = 0;
        byte[] byArray2 = new byte[256];
        for (n2 = 0; n2 < 256; ++n2) {
            this.s[n2] = (byte)n2;
        }
        if (byArray.length > 0) {
            n2 = 0;
            for (n = 0; n < 256; ++n) {
                byArray2[n] = byArray[n2++];
                if (n2 < byArray.length) continue;
                n2 = 0;
            }
        }
        n2 = 0;
        for (n = 0; n < 256; ++n) {
            n2 = n2 + this.s[n] + byArray2[n];
            byte by = this.s[n];
            this.s[n] = this.s[n2 & 0xFF];
            this.s[n2 & 0xFF] = by;
        }
        this.buffer = new byte[256];
        try {
            this.fillBlock();
        }
        catch (LimitReachedException limitReachedException) {
            // empty catch block
        }
    }

    public void fillBlock() throws LimitReachedException {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.m = (byte)(this.m + 1);
            this.n = (byte)(this.n + this.s[this.m & 0xFF]);
            int n = this.s[this.m & 0xFF];
            this.s[this.m & 0xFF] = this.s[this.n & 0xFF];
            this.s[this.n & 0xFF] = n;
            n = this.s[this.m & 0xFF] + this.s[this.n & 0xFF];
            this.buffer[i] = this.s[n & 0xFF];
        }
    }
}

