/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.util.Map;
import java.util.logging.Logger;

public abstract class BasePad
implements IPad {
    private static final Logger log = Logger.getLogger(BasePad.class$("gnu.javax.crypto.pad.BasePad").getName());
    protected String name;
    protected int blockSize;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected BasePad(String string) {
        this.name = string;
        this.blockSize = -1;
    }

    public String name() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        if (this.blockSize != -1) {
            stringBuffer.append('-').append(String.valueOf(8 * this.blockSize));
        }
        return stringBuffer.toString();
    }

    public void init(int n) throws IllegalStateException {
        if (this.blockSize != -1) {
            throw new IllegalStateException();
        }
        this.blockSize = n;
        this.setup();
    }

    public void init(Map map) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.blockSize = -1;
    }

    public boolean selfTest() {
        byte[] byArray = new byte[1024];
        for (int i = 2; i < 256; ++i) {
            if (this.test1BlockSize(i, byArray)) continue;
            return false;
        }
        return true;
    }

    protected boolean test1BlockSize(int n, byte[] byArray) {
        int n2 = 5;
        int n3 = byArray.length;
        this.init(n);
        for (int i = 0; i < n3 - n2 - this.blockSize; ++i) {
            byte[] byArray2 = this.pad(byArray, n2, i);
            if ((i + byArray2.length) % this.blockSize != 0) {
                return false;
            }
            System.arraycopy(byArray2, 0, byArray, n2 + i, byArray2.length);
            try {
                if (byArray2.length == this.unpad(byArray, n2, i + byArray2.length)) continue;
                return false;
            }
            catch (WrongPaddingException wrongPaddingException) {
                return false;
            }
        }
        this.reset();
        return true;
    }

    public abstract void setup();

    public abstract byte[] pad(byte[] var1, int var2, int var3);

    public abstract int unpad(byte[] var1, int var2, int var3) throws WrongPaddingException;
}

