/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.util.DerUtil;
import gnu.java.security.util.Util;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;

public class DHKeyPairPKCS8Codec
implements IKeyPairCodec {
    private static final OID DH_ALG_OID = new OID("1.2.840.10046.2.1");

    public int getFormatID() {
        return 3;
    }

    public byte[] encodePublicKey(PublicKey publicKey) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public byte[] encodePrivateKey(PrivateKey privateKey) {
        byte[] byArray;
        if (!(privateKey instanceof GnuDHPrivateKey)) {
            throw new InvalidParameterException("Wrong key type");
        }
        DERValue dERValue = new DERValue(2, BigInteger.ZERO);
        DERValue dERValue2 = new DERValue(6, DH_ALG_OID);
        GnuDHPrivateKey gnuDHPrivateKey = (GnuDHPrivateKey)privateKey;
        BigInteger bigInteger = gnuDHPrivateKey.getParams().getP();
        BigInteger bigInteger2 = gnuDHPrivateKey.getParams().getG();
        BigInteger bigInteger3 = gnuDHPrivateKey.getQ();
        if (bigInteger3 == null) {
            bigInteger3 = BigInteger.ZERO;
        }
        BigInteger bigInteger4 = gnuDHPrivateKey.getX();
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(new DERValue(2, bigInteger));
        arrayList.add(new DERValue(2, bigInteger2));
        arrayList.add(new DERValue(2, bigInteger3));
        DERValue dERValue3 = new DERValue(48, arrayList);
        ArrayList arrayList2 = new ArrayList(2);
        arrayList2.add(dERValue2);
        arrayList2.add(dERValue3);
        DERValue dERValue4 = new DERValue(48, arrayList2);
        DERValue dERValue5 = new DERValue(4, Util.trim(bigInteger4));
        ArrayList arrayList3 = new ArrayList(3);
        arrayList3.add(dERValue);
        arrayList3.add(dERValue4);
        arrayList3.add(dERValue5);
        DERValue dERValue6 = new DERValue(48, arrayList3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DERWriter.write(byteArrayOutputStream, dERValue6);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return byArray;
    }

    public PublicKey decodePublicKey(byte[] byArray) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public PrivateKey decodePrivateKey(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        if (byArray == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader dERReader = new DERReader(byArray);
        try {
            DERValue dERValue = dERReader.read();
            DerUtil.checkIsConstructed(dERValue, "Wrong PrivateKeyInfo field");
            DERValue dERValue2 = dERReader.read();
            if (!(dERValue2.getValue() instanceof BigInteger)) {
                throw new InvalidParameterException("Wrong Version field");
            }
            BigInteger bigInteger5 = (BigInteger)dERValue2.getValue();
            if (bigInteger5.compareTo(BigInteger.ZERO) != 0) {
                throw new InvalidParameterException("Unexpected Version: " + bigInteger5);
            }
            DERValue dERValue3 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue3, "Wrong AlgorithmIdentifier field");
            DERValue dERValue4 = dERReader.read();
            OID oID = (OID)dERValue4.getValue();
            if (!oID.equals(DH_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + oID);
            }
            DERValue dERValue5 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue5, "Wrong DSS Parameters field");
            DERValue dERValue6 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue6, "Wrong P field");
            bigInteger4 = (BigInteger)dERValue6.getValue();
            dERValue6 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue6, "Wrong G field");
            bigInteger3 = (BigInteger)dERValue6.getValue();
            dERValue6 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue6, "Wrong Q field");
            bigInteger2 = (BigInteger)dERValue6.getValue();
            if (bigInteger2.compareTo(BigInteger.ZERO) == 0) {
                bigInteger2 = null;
            }
            dERValue6 = dERReader.read();
            byte[] byArray2 = (byte[])dERValue6.getValue();
            bigInteger = new BigInteger(1, byArray2);
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return new GnuDHPrivateKey(3, bigInteger2, bigInteger4, bigInteger3, bigInteger);
    }
}

