/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.javax.crypto.cipher.BaseCipher;
import gnu.javax.crypto.cipher.DES;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class TripleDES
extends BaseCipher {
    public static final int BLOCK_SIZE = 8;
    public static final int KEY_SIZE = 24;
    private DES des = new DES();

    public TripleDES() {
        super("tripledes", 8, 24);
    }

    public static void adjustParity(byte[] byArray, int n) {
        TripleDES.adjustParity(3, byArray, n);
    }

    public static void adjustParity(int n, byte[] byArray, int n2) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Invalid keyCount value: " + n);
        }
        DES.adjustParity(byArray, n2);
        if (n > 1) {
            DES.adjustParity(byArray, n2 + 8);
        }
        if (n > 2) {
            DES.adjustParity(byArray, n2 + 16);
        }
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) {
        return TripleDES.isParityAdjusted(3, byArray, n);
    }

    public static boolean isParityAdjusted(int n, byte[] byArray, int n2) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Invalid keyCount value: " + n);
        }
        boolean bl = DES.isParityAdjusted(byArray, n2);
        if (n > 1) {
            boolean bl2 = bl = bl && DES.isParityAdjusted(byArray, n2 + 8);
        }
        if (n > 2) {
            bl = bl && DES.isParityAdjusted(byArray, n2 + 16);
        }
        return bl;
    }

    public Object clone() {
        return new TripleDES();
    }

    public Iterator blockSizes() {
        return Collections.singleton(8).iterator();
    }

    public Iterator keySizes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(8);
        arrayList.add(16);
        arrayList.add(24);
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length != 8 && byArray.length != 16 && byArray.length != 24) {
            throw new InvalidKeyException("TripleDES key must be 8, 16 or 24 bytes: " + byArray.length);
        }
        Context context = new Context(this);
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        if (!DES.isParityAdjusted(byArray2, 0)) {
            DES.adjustParity(byArray2, 0);
        }
        context.k1 = (DES.Context)this.des.makeKey(byArray2, n);
        if (byArray.length == 8) {
            context.k2 = (DES.Context)this.des.makeKey(byArray2, n);
            context.k3 = (DES.Context)this.des.makeKey(byArray2, n);
        } else {
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray, 8, byArray3, 0, 8);
            if (!DES.isParityAdjusted(byArray3, 0)) {
                DES.adjustParity(byArray3, 0);
            }
            context.k2 = (DES.Context)this.des.makeKey(byArray3, n);
            byte[] byArray4 = new byte[8];
            if (byArray.length == 16) {
                context.k3 = (DES.Context)this.des.makeKey(byArray2, n);
            } else {
                System.arraycopy(byArray, 16, byArray4, 0, 8);
                if (!DES.isParityAdjusted(byArray4, 0)) {
                    DES.adjustParity(byArray4, 0);
                }
                context.k3 = (DES.Context)this.des.makeKey(byArray4, n);
            }
        }
        return context;
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        byte[] byArray3 = new byte[8];
        this.des.encrypt(byArray, n, byArray3, 0, ((Context)object).k1, n3);
        this.des.decrypt(byArray3, 0, byArray3, 0, ((Context)object).k2, n3);
        this.des.encrypt(byArray3, 0, byArray2, n2, ((Context)object).k3, n3);
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        byte[] byArray3 = new byte[8];
        this.des.decrypt(byArray, n, byArray3, 0, ((Context)object).k3, n3);
        this.des.encrypt(byArray3, 0, byArray3, 0, ((Context)object).k2, n3);
        this.des.decrypt(byArray3, 0, byArray2, n2, ((Context)object).k1, n3);
    }

    private final class Context {
        private /* synthetic */ TripleDES this$0;
        DES.Context k1;
        DES.Context k2;
        DES.Context k3;

        Context(TripleDES tripleDES) {
            this.this$0 = tripleDES;
        }
    }
}

