/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class BacktrackStack {
    Backtrack[] stack = new Backtrack[32];
    private int size = 0;
    private int capacity = 32;
    private static final int INITIAL_CAPACITY = 32;
    private static final int CAPACITY_INCREMENT = 16;

    BacktrackStack() {
    }

    boolean empty() {
        return this.size == 0;
    }

    Backtrack peek() {
        return this.stack[this.size - 1];
    }

    Backtrack pop() {
        Backtrack backtrack = this.stack[--this.size];
        this.stack[this.size] = null;
        return backtrack;
    }

    void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.stack[i] = null;
        }
        this.size = 0;
    }

    void push(Backtrack backtrack) {
        if (this.size >= this.capacity) {
            this.capacity += 16;
            Backtrack[] backtrackArray = new Backtrack[this.capacity];
            System.arraycopy(this.stack, 0, backtrackArray, 0, this.size);
            this.stack = backtrackArray;
        }
        this.stack[this.size++] = backtrack;
    }

    static class Backtrack {
        REToken token;
        CharIndexed input;
        REMatch match;
        Object param;

        Backtrack(REToken rEToken, CharIndexed charIndexed, REMatch rEMatch, Object object) {
            this.token = rEToken;
            this.input = charIndexed;
            this.match = (REMatch)rEMatch.clone();
            this.param = object;
        }
    }
}

