/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.math.BigInteger;

public class PolicyConstraint
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.36");
    private final int requireExplicitPolicy;
    private final int inhibitPolicyMapping;

    public PolicyConstraint(byte[] byArray) throws IOException {
        super(byArray);
        DERValue dERValue;
        int n = -1;
        int n2 = -1;
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue2 = dERReader.read();
        if (!dERValue2.isConstructed()) {
            throw new IOException("malformed PolicyConstraints");
        }
        for (int i = dERValue2.getLength(); i > 0; i -= dERValue.getEncodedLength()) {
            dERValue = dERReader.read();
            if (dERValue.getTag() == 0) {
                n = new BigInteger((byte[])dERValue.getValue()).intValue();
                continue;
            }
            if (dERValue.getTag() == 1) {
                n2 = new BigInteger((byte[])dERValue.getValue()).intValue();
                continue;
            }
            throw new IOException("invalid policy constraint");
        }
        this.requireExplicitPolicy = n;
        this.inhibitPolicyMapping = n2;
    }

    public int getRequireExplicitPolicy() {
        return this.requireExplicitPolicy;
    }

    public int getInhibitPolicyMapping() {
        return this.inhibitPolicyMapping;
    }

    public String toString() {
        return PolicyConstraint.class$("gnu.java.security.x509.ext.PolicyConstraint").getName() + " [ requireExplicitPolicy=" + this.requireExplicitPolicy + " inhibitPolicyMapping=" + this.inhibitPolicyMapping + " ]";
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

