/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.dgc;

import gnu.java.rmi.server.UnicastRef;
import java.lang.ref.WeakReference;
import java.rmi.dgc.Lease;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;

public class LeaseRenewingTask {
    public static long REQUEST_LEASE_DURATION = 60000L;
    LinkedList ref;
    Lease lease;
    static Timer timer = new Timer(true);
    static WeakHashMap existingTasks = new WeakHashMap();

    private /* synthetic */ void finit$() {
        this.ref = new LinkedList();
        this.lease = new Lease(null, REQUEST_LEASE_DURATION);
    }

    public LeaseRenewingTask(UnicastRef unicastRef) {
        this.finit$();
        this.lease = this.notifyDGC(unicastRef);
        if (this.lease != null) {
            this.schedule(this.lease);
            this.ref.add(new WeakReference(unicastRef));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void scheduleLeases(UnicastRef unicastRef) {
        if (unicastRef == null) {
            return;
        }
        try {
            WeakHashMap weakHashMap = existingTasks;
            synchronized (weakHashMap) {
                try {
                    LeaseRenewingTask leaseRenewingTask = (LeaseRenewingTask)existingTasks.get(unicastRef);
                    if (leaseRenewingTask != null) {
                        LinkedList linkedList = leaseRenewingTask.ref;
                        synchronized (linkedList) {
                            try {
                                leaseRenewingTask.ref.add(new WeakReference(unicastRef));
                                return;
                            }
                            finally {
                                Object var4_4 = null;
                            }
                        }
                    }
                    existingTasks.put(unicastRef, new LeaseRenewingTask(unicastRef));
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    throw throwable;
                }
                return;
            }
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Lease for " + unicastRef);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public void schedule(Lease lease) {
        long l = lease.getValue();
        long l2 = l * (long)90 / (long)100;
        if (l2 == 0L) {
            l2 = l;
        }
        timer.schedule((TimerTask)new LeaseTimerTask(this), l2);
    }

    public void renew() {
        Object object;
        Object object2 = null;
        LinkedList linkedList = this.ref;
        synchronized (linkedList) {
            try {
                object = this.ref.iterator();
                while (object.hasNext() && object2 == null) {
                    WeakReference weakReference = (WeakReference)object.next();
                    object2 = weakReference.get();
                    if (object2 != null) continue;
                    object.remove();
                }
                object = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
        if (object2 != null && (object = this.notifyDGC((UnicastRef)object2)) != null) {
            this.schedule((Lease)object);
        }
    }

    public Lease notifyDGC(UnicastRef unicastRef) {
        try {
            return unicastRef.notifyDGC(this.lease);
        }
        catch (Exception exception) {
            return null;
        }
    }

    class LeaseTimerTask
    extends TimerTask {
        private /* synthetic */ LeaseRenewingTask this$0;

        public void run() {
            this.this$0.renew();
        }

        LeaseTimerTask(LeaseRenewingTask leaseRenewingTask) {
            this.this$0 = leaseRenewingTask;
        }
    }
}

