/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class ChannelReader
extends Reader {
    private static final int DEFAULT_BUFFER_CAP = 8192;
    private ReadableByteChannel channel;
    private CharsetDecoder decoder;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;

    public ChannelReader(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        this.channel = readableByteChannel;
        this.decoder = charsetDecoder;
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        charsetDecoder.reset();
        int n2 = n == -1 ? 8192 : n;
        this.byteBuffer = ByteBuffer.allocate(n2);
        this.byteBuffer.flip();
        this.charBuffer = CharBuffer.allocate((int)((float)n2 * charsetDecoder.averageCharsPerByte()));
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            CoderResult coderResult;
            try {
                if (!this.channel.isOpen()) {
                    throw new IOException("Reader was already closed.");
                }
                if (this.decoder == null) {
                    int n4 = -1;
                    Object var9_7 = null;
                    return n4;
                }
                int n5 = -1;
                if (this.charBuffer.remaining() > 0) {
                    n5 = Math.min(n2, this.charBuffer.remaining());
                    this.charBuffer.get(cArray, n, n5);
                    n += n5;
                    n2 -= n5;
                }
                this.charBuffer.compact();
                int n6 = 0;
                boolean bl = false;
                while (n2 != 0) {
                    coderResult = this.decoder.decode(this.byteBuffer, this.charBuffer, bl);
                    if (coderResult.isMalformed() || coderResult.isUnmappable()) {
                        coderResult.throwException();
                    }
                    if (bl) {
                        this.decoder = null;
                    } else if (coderResult.isUnderflow()) {
                        this.byteBuffer.compact();
                        if (this.channel.read(this.byteBuffer) == -1) {
                            bl = true;
                        }
                        this.byteBuffer.flip();
                    }
                    this.charBuffer.flip();
                    n6 = Math.min(n2, this.charBuffer.remaining());
                    this.charBuffer.get(cArray, n, n6);
                    this.charBuffer.compact();
                    n += n6;
                    n2 -= n6;
                    n5 += n6;
                    if (this.decoder != null) continue;
                    break;
                }
                this.charBuffer.flip();
                n3 = n5;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                throw throwable;
            }
            coderResult = null;
            return n3;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block3: {
                try {
                    this.channel.close();
                    if (this.decoder == null) break block3;
                    this.decoder.reset();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            Object var2_2 = null;
        }
    }
}

