/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.ftp;

import gnu.java.net.protocol.ftp.DTP;
import gnu.java.net.protocol.ftp.DTPInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;

class CompressedInputStream
extends DTPInputStream {
    static final int EOF = 64;
    static final int RAW = 0;
    static final int COMPRESSED = 128;
    static final int FILLER = 192;
    int descriptor;
    int max;
    int count;
    int state;
    int rep;
    int n;

    private /* synthetic */ void finit$() {
        this.max = -1;
        this.count = -1;
        this.state = 0;
        this.n = 0;
    }

    CompressedInputStream(DTP dTP, InputStream inputStream) {
        super(dTP, inputStream);
        this.finit$();
    }

    public int read() throws IOException {
        if (this.transferComplete) {
            return -1;
        }
        if (this.count == -1) {
            this.readHeader();
        }
        if (this.max < 1) {
            this.close();
            return -1;
        }
        if (this.n > 0 && (this.state == 128 || this.state == 192)) {
            --this.n;
            return this.rep;
        }
        int n = this.in.read();
        if (n == -1) {
            this.close();
        }
        ++this.count;
        if (this.count >= this.max) {
            this.count = -1;
            if (this.descriptor == 64) {
                this.close();
            }
        }
        if (n == -1) {
            return n;
        }
        while (this.n == 0) {
            this.state = n & 0xC0;
            this.n = n & 0x3F;
            n = this.in.read();
            if (n != -1) continue;
            return -1;
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 128: 
            case 192: {
                this.rep = n;
                break;
            }
            default: {
                throw new ProtocolException("Illegal state: " + this.state);
            }
        }
        --this.n;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.transferComplete) {
            return -1;
        }
        if (this.count == -1) {
            this.readHeader();
        }
        if (this.max < 1) {
            this.close();
            return -1;
        }
        for (int i = n; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                this.close();
                return i;
            }
            byArray[i] = (byte)n3;
        }
        return n2;
    }

    void readHeader() throws IOException {
        this.descriptor = this.in.read();
        int n = this.in.read();
        int n2 = this.in.read();
        this.max = n << 8 | n2;
        this.count = 0;
    }

    void readCodeHeader() throws IOException {
        int n = this.in.read();
        this.state = n & 0xC0;
        this.n = n & 0x3F;
    }
}

