/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.local;

import gnu.java.net.local.LocalSocket;
import gnu.java.net.local.LocalSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;

public final class LocalServerSocket
extends ServerSocket {
    private LocalSocketImpl myImpl = new LocalSocketImpl();
    private boolean closed;

    public LocalServerSocket() throws IOException {
    }

    public LocalServerSocket(SocketAddress socketAddress) throws IOException {
        this();
        this.bind(socketAddress);
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 0);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        this.myImpl.doCreate();
        this.myImpl.bind(socketAddress);
        this.myImpl.listen(n);
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public int getLocalPort() {
        return -1;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.myImpl.getLocalAddress();
    }

    public Socket accept() throws IOException {
        LocalSocket localSocket = new LocalSocket(true);
        this.myImpl.accept(localSocket.getLocalImpl());
        localSocket.localConnected = true;
        return localSocket;
    }

    public void close() throws IOException {
        this.myImpl.close();
        this.myImpl.unlink();
        this.closed = true;
    }

    public boolean isBound() {
        return this.myImpl.getLocalAddress() != null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSoTimeout(int n) {
        throw new UnsupportedOperationException("local sockets do not support timeouts");
    }

    public int getSoTimeout() {
        throw new UnsupportedOperationException("local sockets do not support timeouts");
    }

    public void setReuseAddress(boolean bl) {
        throw new UnsupportedOperationException("local sockets do not support reuse address");
    }

    public boolean getReuseAddress() {
        throw new UnsupportedOperationException("local sockets do not support reuse address");
    }

    public String toString() {
        return LocalServerSocket.class$("gnu.java.net.local.LocalServerSocket").getName() + " [ address=" + this.myImpl.getLocalAddress() + " ]";
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setReceiveBufferSize(int n) {
        throw new UnsupportedOperationException("local sockets do not support buffer size");
    }

    public int getReceiveBufferSize() {
        throw new UnsupportedOperationException("local sockets do not support buffer size");
    }

    public void setSendBufferSize(int n) {
        throw new UnsupportedOperationException("local sockets do not support buffer size");
    }

    public int getSendBufferSize() {
        throw new UnsupportedOperationException("local sockets do not support buffer size");
    }
}

