/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.loader;

import gnu.java.net.IndexListParser;
import gnu.java.net.loader.JarURLResource;
import gnu.java.net.loader.Resource;
import gnu.java.net.loader.URLLoader;
import gnu.java.net.loader.URLStreamHandlerCache;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class JarURLLoader
extends URLLoader {
    boolean initialized;
    JarFile jarfile;
    final URL baseJarURL;
    ArrayList classPath;
    Set indexSet;

    private JarURLLoader(URLClassLoader uRLClassLoader, URLStreamHandlerCache uRLStreamHandlerCache, URLStreamHandlerFactory uRLStreamHandlerFactory, URL uRL, URL uRL2, Set set) {
        super(uRLClassLoader, uRLStreamHandlerCache, uRLStreamHandlerFactory, uRL, uRL2);
        URL uRL3 = null;
        try {
            String string = uRL.toExternalForm() + "!/";
            uRL3 = new URL("jar", "", -1, string, uRLStreamHandlerCache.get(uRLStreamHandlerFactory, "jar"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.baseJarURL = uRL3;
        this.classPath = null;
        this.indexSet = set;
    }

    public JarURLLoader(URLClassLoader uRLClassLoader, URLStreamHandlerCache uRLStreamHandlerCache, URLStreamHandlerFactory uRLStreamHandlerFactory, URL uRL, URL uRL2) {
        this(uRLClassLoader, uRLStreamHandlerCache, uRLStreamHandlerFactory, uRL, uRL2, null);
        this.initialize();
    }

    private void initialize() {
        JarFile jarFile = null;
        try {
            jarFile = ((JarURLConnection)this.baseJarURL.openConnection()).getJarFile();
            IndexListParser indexListParser = new IndexListParser(jarFile, this.baseJarURL, this.baseURL);
            LinkedHashMap linkedHashMap = indexListParser.getHeaders();
            if (linkedHashMap != null) {
                this.classPath = new ArrayList();
                Iterator iterator = linkedHashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    URL uRL = (URL)entry.getKey();
                    Set set = (Set)entry.getValue();
                    if (uRL.equals(this.baseURL)) {
                        this.indexSet = set;
                        continue;
                    }
                    JarURLLoader jarURLLoader = new JarURLLoader(this.classloader, this.cache, this.factory, uRL, uRL, set);
                    this.classPath.add(jarURLLoader);
                }
            } else {
                String string;
                Attributes attributes;
                Manifest manifest = jarFile.getManifest();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                    this.classPath = new ArrayList();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                    while (stringTokenizer.hasMoreElements()) {
                        String string2 = stringTokenizer.nextToken();
                        try {
                            URL uRL = new URL(this.baseURL, string2);
                            if (uRL.equals(this.baseURL)) continue;
                            JarURLLoader jarURLLoader = new JarURLLoader(this.classloader, this.cache, this.factory, uRL, uRL);
                            this.classPath.add(jarURLLoader);
                            ArrayList arrayList = jarURLLoader.getClassPath();
                            if (arrayList == null) continue;
                            this.classPath.addAll(arrayList);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.jarfile = jarFile;
        this.initialized = true;
    }

    public Resource getResource(String string) {
        Object object;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (this.indexSet != null) {
            object = string;
            int n = ((String)object).lastIndexOf(47);
            if (n != -1) {
                object = ((String)object).substring(0, n);
            }
            if (!this.indexSet.contains(object)) {
                return null;
            }
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (this.jarfile == null) {
            return null;
        }
        object = this.jarfile.getJarEntry(string);
        if (object != null) {
            return new JarURLResource(this, string, (JarEntry)object);
        }
        return null;
    }

    public Manifest getManifest() {
        try {
            if (this.jarfile == null) {
                return null;
            }
            return this.jarfile.getManifest();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ArrayList getClassPath() {
        return this.classPath;
    }
}

