/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QtScreenDevice;
import gnu.java.awt.peer.qt.QtToolkit;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Locale;

public class QtGraphicsEnvironment
extends GraphicsEnvironment {
    QtToolkit toolkit;
    GraphicsDevice[] screens;

    public QtGraphicsEnvironment(QtToolkit qtToolkit) {
        this.toolkit = qtToolkit;
        int n = this.toolkit.numScreens();
        this.screens = new GraphicsDevice[n];
        for (int i = 0; i < n; ++i) {
            this.screens[i] = new QtScreenDevice(i);
        }
    }

    public Font[] getAllFonts() {
        String[] stringArray = this.getAvailableFontFamilyNames();
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fontArray[i] = new Font(stringArray[i], 0, 12);
        }
        return fontArray;
    }

    public String[] getAvailableFontFamilyNames() {
        return this.toolkit.getFontList();
    }

    public String[] getAvailableFontFamilyNames(Locale locale) {
        return this.getAvailableFontFamilyNames();
    }

    public GraphicsDevice getDefaultScreenDevice() {
        return this.screens[this.toolkit.defaultScreen()];
    }

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        return (Graphics2D)bufferedImage.getGraphics();
    }

    public GraphicsDevice[] getScreenDevices() {
        return this.screens;
    }

    public QtToolkit getToolkit() {
        return this.toolkit;
    }
}

