/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gcj_dbtool;

import gnu.gcj.runtime.PersistentByteMap;
import gnu.gcj.tools.gcj_dbtool.Fileset;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Main {
    private static boolean verbose = false;

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        char c = ' ';
        Main.insist(stringArray.length >= 1);
        if (stringArray[0].equals("-") || stringArray[0].equals("-0")) {
            if (stringArray[0].equals("-0")) {
                c = '\u0000';
            }
            bl = true;
            object = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, object, 0, stringArray.length - 1);
            stringArray = object;
        }
        if (stringArray[0].equals("-v") || stringArray[0].equals("--version")) {
            Main.insist(stringArray.length == 1);
            System.out.println("gcj-dbtool (" + System.getProperty("java.vm.name") + ") " + System.getProperty("java.vm.version"));
            System.out.println();
            System.out.println("Copyright 2006 Free Software Foundation, Inc.");
            System.out.println("This is free software; see the source for copying conditions.  There is NO");
            System.out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
            return;
        }
        if (stringArray[0].equals("--help")) {
            Main.usage(System.out);
            return;
        }
        if (stringArray[0].equals("-n")) {
            Main.insist(stringArray.length >= 2 && stringArray.length <= 3);
            int n = 32749;
            if (stringArray.length == 3 && (n = Integer.parseInt(stringArray[2])) <= 2) {
                Main.usage(System.err);
                System.exit(1);
            }
            try {
                PersistentByteMap persistentByteMap = PersistentByteMap.emptyPersistentByteMap(new File(stringArray[1]), n, n * 32);
            }
            catch (Exception exception) {
                System.err.println("error: could not create " + stringArray[1] + ": " + exception.toString());
                System.exit(2);
            }
            return;
        }
        if (stringArray[0].equals("-a") || stringArray[0].equals("-f")) {
            try {
                Main.insist(stringArray.length == 4);
                object = new File(stringArray[1]);
                object = ((File)object).getAbsoluteFile();
                File file = new File(stringArray[2]);
                PersistentByteMap persistentByteMap = ((File)object).isFile() ? new PersistentByteMap((File)object, PersistentByteMap.AccessMode.READ_ONLY) : PersistentByteMap.emptyPersistentByteMap((File)object, 100, 3200);
                File file2 = new File(stringArray[3]);
                if (!stringArray[0].equals("-f") && !file2.isFile()) {
                    throw new IllegalArgumentException(stringArray[3] + " is not a file");
                }
                persistentByteMap = Main.addJar(file, persistentByteMap, file2);
            }
            catch (Exception exception) {
                System.err.println("error: could not update " + stringArray[1] + ": " + exception.toString());
                System.exit(2);
            }
            return;
        }
        if (stringArray[0].equals("-t")) {
            try {
                Main.insist(stringArray.length == 2);
                object = new PersistentByteMap(new File(stringArray[1]), PersistentByteMap.AccessMode.READ_ONLY);
                Iterator iterator = ((PersistentByteMap)object).iterator(2);
                while (iterator.hasNext()) {
                    PersistentByteMap.MapEntry mapEntry = (PersistentByteMap.MapEntry)iterator.next();
                    byte[] byArray = (byte[])mapEntry.getKey();
                    byte[] byArray2 = ((PersistentByteMap)object).get(byArray);
                    if (Arrays.equals(byArray2, (byte[])mapEntry.getValue())) continue;
                    String string = "Key " + Main.bytesToString(byArray) + " at bucket " + mapEntry.getBucket();
                    throw new RuntimeException(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(3);
            }
            return;
        }
        if (stringArray[0].equals("-m")) {
            Main.insist(stringArray.length >= 3 || bl && stringArray.length == 2);
            try {
                object = new File(stringArray[1]);
                object = ((File)object).getAbsoluteFile();
                File file = File.createTempFile(((File)object).getName(), "", ((File)object).getParentFile());
                int n = 0;
                int n2 = 0;
                Fileset fileset = Main.getFiles(stringArray, 2, bl, c);
                PersistentByteMap[] persistentByteMapArray = new PersistentByteMap[fileset.size()];
                Object object2 = fileset.iterator();
                int n3 = 0;
                while (object2.hasNext()) {
                    PersistentByteMap persistentByteMap = new PersistentByteMap((File)object2.next(), PersistentByteMap.AccessMode.READ_ONLY);
                    n += persistentByteMap.size();
                    n2 += persistentByteMap.stringTableSize();
                    persistentByteMapArray[n3++] = persistentByteMap;
                }
                n = (int)((double)n * 1.5);
                object2 = PersistentByteMap.emptyPersistentByteMap(file, n, n2);
                for (n3 = 0; n3 < persistentByteMapArray.length; ++n3) {
                    if (verbose) {
                        System.err.println("adding " + persistentByteMapArray[n3].size() + " elements from " + persistentByteMapArray[n3].getFile());
                    }
                    ((PersistentByteMap)object2).putAll(persistentByteMapArray[n3]);
                }
                ((PersistentByteMap)object2).close();
                file.renameTo((File)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(3);
            }
            return;
        }
        if (stringArray[0].equals("-l")) {
            Main.insist(stringArray.length == 2);
            try {
                object = new PersistentByteMap(new File(stringArray[1]), PersistentByteMap.AccessMode.READ_ONLY);
                System.out.println("Capacity: " + ((PersistentByteMap)object).capacity());
                System.out.println("Size: " + ((PersistentByteMap)object).size());
                System.out.println();
                System.out.println("Elements: ");
                Iterator iterator = ((PersistentByteMap)object).iterator(2);
                while (iterator.hasNext()) {
                    PersistentByteMap.MapEntry mapEntry = (PersistentByteMap.MapEntry)iterator.next();
                    byte[] byArray = (byte[])mapEntry.getKey();
                    System.out.print("[" + mapEntry.getBucket() + "] " + Main.bytesToString(byArray) + " -> ");
                    System.out.println(new String((byte[])mapEntry.getValue()));
                }
            }
            catch (Exception exception) {
                System.err.println("error: could not list " + stringArray[1] + ": " + exception.toString());
                System.exit(2);
            }
            return;
        }
        if (stringArray[0].equals("-d")) {
            Main.insist(stringArray.length == 2);
            try {
                object = MessageDigest.getInstance("MD5");
                PersistentByteMap persistentByteMap = new PersistentByteMap(new File(stringArray[1]), PersistentByteMap.AccessMode.READ_WRITE);
                int n = persistentByteMap.capacity();
                byte[] byArray = new byte[1];
                byte[] byArray3 = ((MessageDigest)object).digest(byArray);
                for (int i = 0; i < n; ++i) {
                    byArray3 = ((MessageDigest)object).digest(byArray3);
                    persistentByteMap.put(byArray3, byArray3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(3);
            }
            return;
        }
        if (stringArray[0].equals("-p")) {
            Main.insist(stringArray.length == 1 || stringArray.length == 2);
            object = stringArray.length == 1 ? System.getProperty("gnu.gcj.precompiled.db.path", "") : stringArray[1] + (stringArray[1].endsWith(File.separator) ? "" : File.separator) + Main.getDbPathTail();
            System.out.println((String)object);
            return;
        }
        Main.usage(System.err);
        System.exit(1);
    }

    private static native String getDbPathTail();

    private static void insist(boolean bl) {
        if (!bl) {
            Main.usage(System.err);
            System.exit(1);
        }
    }

    private static void usage(PrintStream printStream) {
        printStream.println("gcj-dbtool: Manipulate gcj map database files\n\n  Usage: \n    gcj-dbtool -n file.gcjdb [size]     - Create a new gcj map database\n    gcj-dbtool -a file.gcjdb file.jar file.so\n            - Add the contents of file.jar to a gcj map database\n    gcj-dbtool -f file.gcjdb file.jar file.so\n            - Add the contents of file.jar to a gcj map database\n    gcj-dbtool -t file.gcjdb            - Test a gcj map database\n    gcj-dbtool -l file.gcjdb            - List a gcj map database\n    gcj-dbtool [-][-0] -m dest.gcjdb [source.gcjdb]...\n            - Merge gcj map databases into dest\n              Replaces dest\n              To add to dest, include dest in the list of sources\n              If the first arg is -, read the list from stdin\n              If the first arg is -0, filenames separated by nul\n    gcj-dbtool -p [LIBDIR]              - Print default database name");
    }

    private static PersistentByteMap addJar(File file, PersistentByteMap persistentByteMap, File file2) throws Exception {
        Object object;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        JarFile jarFile = new JarFile(file);
        int n = 0;
        Enumeration enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            object = (JarEntry)enumeration.nextElement();
            if (!((ZipEntry)object).getName().endsWith(".class")) continue;
            ++n;
        }
        if (verbose) {
            System.err.println("adding " + n + " elements from " + file + " to " + persistentByteMap.getFile());
        }
        persistentByteMap = Main.resizeMap(persistentByteMap, (persistentByteMap.size() + n) * 2, true);
        enumeration = jarFile.entries();
        object = file2.getCanonicalPath().getBytes("UTF-8");
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = (JarEntry)enumeration.nextElement();
            if (!jarEntry.getName().endsWith(".class")) continue;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n2 = (int)jarEntry.getSize();
            if (n2 == -1) {
                throw new EOFException();
            }
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n2 - n3 > 0) {
                int n4 = inputStream.read(byArray, n3, n2 - n3);
                if (n4 == -1) {
                    throw new EOFException("Not enough data reading from: " + jarEntry.getName());
                }
                n3 += n4;
            }
            persistentByteMap.put(messageDigest.digest(byArray), (byte[])object);
        }
        return persistentByteMap;
    }

    static PersistentByteMap resizeMap(PersistentByteMap persistentByteMap, int n, boolean bl) throws IOException, IllegalAccessException {
        n = Math.max(persistentByteMap.capacity(), n);
        File file = persistentByteMap.getFile();
        File file2 = File.createTempFile(file.getName(), "", file.getParentFile());
        try {
            PersistentByteMap persistentByteMap2 = PersistentByteMap.emptyPersistentByteMap(file2, n, n * 32);
            persistentByteMap2.putAll(persistentByteMap);
            persistentByteMap2.force();
            if (bl) {
                persistentByteMap.close();
            }
            file2.renameTo(file);
            return persistentByteMap2;
        }
        catch (Exception exception) {
            file2.delete();
            return null;
        }
    }

    static String bytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    private static final Fileset getFiles(String[] stringArray, int n, boolean bl, char c) {
        if (bl) {
            return new Fileset(System.in, c);
        }
        return new Fileset(stringArray, n, stringArray.length);
    }
}

