/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.Jdwp;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.processor.ArrayReferenceCommandSet;
import gnu.classpath.jdwp.processor.ArrayTypeCommandSet;
import gnu.classpath.jdwp.processor.ClassLoaderReferenceCommandSet;
import gnu.classpath.jdwp.processor.ClassObjectReferenceCommandSet;
import gnu.classpath.jdwp.processor.ClassTypeCommandSet;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.processor.EventRequestCommandSet;
import gnu.classpath.jdwp.processor.FieldCommandSet;
import gnu.classpath.jdwp.processor.InterfaceTypeCommandSet;
import gnu.classpath.jdwp.processor.MethodCommandSet;
import gnu.classpath.jdwp.processor.ObjectReferenceCommandSet;
import gnu.classpath.jdwp.processor.ReferenceTypeCommandSet;
import gnu.classpath.jdwp.processor.StackFrameCommandSet;
import gnu.classpath.jdwp.processor.StringReferenceCommandSet;
import gnu.classpath.jdwp.processor.ThreadGroupReferenceCommandSet;
import gnu.classpath.jdwp.processor.ThreadReferenceCommandSet;
import gnu.classpath.jdwp.processor.VirtualMachineCommandSet;
import gnu.classpath.jdwp.transport.JdwpCommandPacket;
import gnu.classpath.jdwp.transport.JdwpConnection;
import gnu.classpath.jdwp.transport.JdwpPacket;
import gnu.classpath.jdwp.transport.JdwpReplyPacket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;

public class PacketProcessor
implements PrivilegedAction {
    private JdwpConnection _connection;
    private boolean _shutdown;
    private CommandSet[] _sets;
    private ByteArrayOutputStream _outputBytes;
    private DataOutputStream _os;

    public PacketProcessor(JdwpConnection jdwpConnection) {
        this._connection = jdwpConnection;
        this._shutdown = false;
        this._sets = new CommandSet[18];
        this._outputBytes = new ByteArrayOutputStream();
        this._os = new DataOutputStream(this._outputBytes);
        this._sets[1] = new VirtualMachineCommandSet();
        this._sets[2] = new ReferenceTypeCommandSet();
        this._sets[3] = new ClassTypeCommandSet();
        this._sets[4] = new ArrayTypeCommandSet();
        this._sets[5] = new InterfaceTypeCommandSet();
        this._sets[6] = new MethodCommandSet();
        this._sets[8] = new FieldCommandSet();
        this._sets[9] = new ObjectReferenceCommandSet();
        this._sets[10] = new StringReferenceCommandSet();
        this._sets[11] = new ThreadReferenceCommandSet();
        this._sets[12] = new ThreadGroupReferenceCommandSet();
        this._sets[13] = new ArrayReferenceCommandSet();
        this._sets[14] = new ClassLoaderReferenceCommandSet();
        this._sets[15] = new EventRequestCommandSet();
        this._sets[16] = new StackFrameCommandSet();
        this._sets[17] = new ClassObjectReferenceCommandSet();
    }

    public Object run() {
        Jdwp.getDefault().subcomponentInitialized();
        try {
            while (!this._shutdown) {
                this._processOnePacket();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Jdwp.getDefault().shutdown();
        return null;
    }

    public void shutdown() {
        this._shutdown = true;
    }

    private void _processOnePacket() throws IOException {
        JdwpPacket jdwpPacket = this._connection.getPacket();
        if (!(jdwpPacket instanceof JdwpCommandPacket)) {
            return;
        }
        if (jdwpPacket != null) {
            JdwpCommandPacket jdwpCommandPacket = (JdwpCommandPacket)jdwpPacket;
            JdwpReplyPacket jdwpReplyPacket = new JdwpReplyPacket(jdwpCommandPacket);
            this._outputBytes.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(jdwpCommandPacket.getData());
            byte by = jdwpCommandPacket.getCommand();
            byte by2 = jdwpCommandPacket.getCommandSet();
            CommandSet commandSet = null;
            try {
                if (by2 > 0 && by2 < this._sets.length) {
                    commandSet = this._sets[jdwpCommandPacket.getCommandSet()];
                }
                if (commandSet != null) {
                    this._shutdown = commandSet.runCommand(byteBuffer, this._os, by);
                    jdwpReplyPacket.setData(this._outputBytes.toByteArray());
                } else {
                    jdwpReplyPacket.setErrorCode((short)99);
                }
            }
            catch (JdwpException jdwpException) {
                jdwpReplyPacket.setErrorCode(jdwpException.getErrorCode());
            }
            this._connection.sendPacket(jdwpReplyPacket);
        }
    }
}

