'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.11.1/tcllib-1.11.1/modules/math/polynomials.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Arjen Markus <arjenmarkus@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "math::polynomials" n 1.0.1 math "Tcl Math Library"
.BS
.SH NAME
math::polynomials \- Polynomial functions
.SH SYNOPSIS
package require \fBTcl  ?8.3?\fR
.sp
package require \fBmath::polynomials  ?1.0.1?\fR
.sp
\fB::math::polynomials::polynomial\fR \fIcoeffs\fR
.sp
\fB::math::polynomials::polynCmd\fR \fIcoeffs\fR
.sp
\fB::math::polynomials::evalPolyn\fR \fIpolynomial\fR \fIx\fR
.sp
\fB::math::polynomials::addPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
.sp
\fB::math::polynomials::subPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
.sp
\fB::math::polynomials::multPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
.sp
\fB::math::polynomials::divPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
.sp
\fB::math::polynomials::remainderPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
.sp
\fB::math::polynomials::derivPolyn\fR \fIpolyn\fR
.sp
\fB::math::polynomials::primitivePolyn\fR \fIpolyn\fR
.sp
\fB::math::polynomials::degreePolyn\fR \fIpolyn\fR
.sp
\fB::math::polynomials::coeffPolyn\fR \fIpolyn\fR \fIindex\fR
.sp
\fB::math::polynomials::allCoeffsPolyn\fR \fIpolyn\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package deals with polynomial functions of one variable:
.IP \(bu
the basic arithmetic operations are extended to polynomials
.IP \(bu
computing the derivatives and primitives of these functions
.IP \(bu
evaluation through a general procedure or via specific procedures)
.PP
.SH PROCEDURES
The package defines the following public procedures:
.TP
\fB::math::polynomials::polynomial\fR \fIcoeffs\fR
Return an (encoded) list that defines the polynomial. A polynomial
.nf

   f(x) = a + b.x + c.x**2 + d.x**3

.fi
can be defined via:
.nf

   set f [::math::polynomials::polynomial [list $a $b $c $d]

.fi
.RS
.TP
list \fIcoeffs\fR
Coefficients of the polynomial (in ascending
order)
.RE
.sp
.TP
\fB::math::polynomials::polynCmd\fR \fIcoeffs\fR
Create a new procedure that evaluates the polynomial. The name of the
polynomial is automatically generated. Useful if you need to evualuate
the polynomial many times, as the procedure consists of a single
[expr] command.
.RS
.TP
list \fIcoeffs\fR
Coefficients of the polynomial (in ascending
order) or the polynomial definition returned by the \fIpolynomial\fR
command.
.RE
.sp
.TP
\fB::math::polynomials::evalPolyn\fR \fIpolynomial\fR \fIx\fR
Evaluate the polynomial at x.
.RS
.TP
list \fIpolynomial\fR
The polynomial's definition (as returned by
the polynomial command).
order)
.TP
float \fIx\fR
The coordinate at which to evaluate the polynomial
.RE
.sp
.TP
\fB::math::polynomials::addPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
Return a new polynomial which is the sum of the two others.
.RS
.TP
list \fIpolyn1\fR
The first polynomial operand
.TP
list \fIpolyn2\fR
The second polynomial operand
.RE
.sp
.TP
\fB::math::polynomials::subPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
Return a new polynomial which is the difference of the two others.
.RS
.TP
list \fIpolyn1\fR
The first polynomial operand
.TP
list \fIpolyn2\fR
The second polynomial operand
.RE
.sp
.TP
\fB::math::polynomials::multPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
Return a new polynomial which is the product of the two others. If one
of the arguments is a scalar value, the other polynomial is simply
scaled.
.RS
.TP
list \fIpolyn1\fR
The first polynomial operand or a scalar
.TP
list \fIpolyn2\fR
The second polynomial operand or a scalar
.RE
.sp
.TP
\fB::math::polynomials::divPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
Divide the first polynomial by the second polynomial and return the
result. The remainder is dropped
.RS
.TP
list \fIpolyn1\fR
The first polynomial operand
.TP
list \fIpolyn2\fR
The second polynomial operand
.RE
.sp
.TP
\fB::math::polynomials::remainderPolyn\fR \fIpolyn1\fR \fIpolyn2\fR
Divide the first polynomial by the second polynomial and return the
remainder.
.RS
.TP
list \fIpolyn1\fR
The first polynomial operand
.TP
list \fIpolyn2\fR
The second polynomial operand
.RE
.sp
.TP
\fB::math::polynomials::derivPolyn\fR \fIpolyn\fR
Differentiate the polynomial and return the result.
.RS
.TP
list \fIpolyn\fR
The polynomial to be differentiated
.RE
.sp
.TP
\fB::math::polynomials::primitivePolyn\fR \fIpolyn\fR
Integrate the polynomial and return the result. The integration
constant is set to zero.
.RS
.TP
list \fIpolyn\fR
The polynomial to be integrated
.RE
.sp
.TP
\fB::math::polynomials::degreePolyn\fR \fIpolyn\fR
Return the degree of the polynomial.
.RS
.TP
list \fIpolyn\fR
The polynomial to be examined
.RE
.sp
.TP
\fB::math::polynomials::coeffPolyn\fR \fIpolyn\fR \fIindex\fR
Return the coefficient of the term of the index'th degree of the
polynomial.
.RS
.TP
list \fIpolyn\fR
The polynomial to be examined
.TP
int \fIindex\fR
The degree of the term
.RE
.sp
.TP
\fB::math::polynomials::allCoeffsPolyn\fR \fIpolyn\fR
Return the coefficients of the polynomial (in ascending order).
.RS
.TP
list \fIpolyn\fR
The polynomial in question
.RE
.PP
.SH "REMARKS ON THE IMPLEMENTATION"
The implementation for evaluating the polynomials at some point uses
Horn's rule, which guarantees numerical stability and a minimum of
arithmetic operations.
To recognise that a polynomial definition is indeed a correct
definition, it consists of a list of two elements: the keyword
"POLYNOMIAL" and the list of coefficients in descending order. The
latter makes it easier to implement Horner's rule.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fImath :: polynomials\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
math, polynomial functions
.SH COPYRIGHT
.nf
Copyright (c) 2004 Arjen Markus <arjenmarkus@users.sourceforge.net>

.fi