/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml;

import com.microstar.xml.XmlHandler;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class XmlParser {
    private static final boolean USE_CHEATS = true;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    public static final int ATTRIBUTE_UNDECLARED = 0;
    public static final int ATTRIBUTE_CDATA = 1;
    public static final int ATTRIBUTE_ID = 2;
    public static final int ATTRIBUTE_IDREF = 3;
    public static final int ATTRIBUTE_IDREFS = 4;
    public static final int ATTRIBUTE_ENTITY = 5;
    public static final int ATTRIBUTE_ENTITIES = 6;
    public static final int ATTRIBUTE_NMTOKEN = 7;
    public static final int ATTRIBUTE_NMTOKENS = 8;
    public static final int ATTRIBUTE_ENUMERATED = 9;
    public static final int ATTRIBUTE_NOTATION = 10;
    private static Hashtable attributeTypeHash = new Hashtable();
    private static final int ENCODING_UTF_8 = 1;
    private static final int ENCODING_ISO_8859_1 = 2;
    private static final int ENCODING_UCS_2_12 = 3;
    private static final int ENCODING_UCS_2_21 = 4;
    private static final int ENCODING_UCS_4_1234 = 5;
    private static final int ENCODING_UCS_4_4321 = 6;
    private static final int ENCODING_UCS_4_2143 = 7;
    private static final int ENCODING_UCS_4_3412 = 8;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 0;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 1;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 2;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 3;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 4;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_EXTERNAL = 2;
    private static final int INPUT_STREAM = 3;
    private static final int INPUT_BUFFER = 4;
    private static final int INPUT_READER = 5;
    private static final int LIT_CHAR_REF = 1;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_PE_REF = 4;
    private static final int LIT_NORMALIZE = 8;
    private static final int CONTEXT_NONE = 0;
    private static final int CONTEXT_DTD = 1;
    private static final int CONTEXT_ENTITYVALUE = 2;
    private static final int CONTEXT_ATTRIBUTEVALUE = 3;
    XmlHandler handler;
    private Reader reader;
    private InputStream is;
    private int line;
    private int column;
    private int sourceType;
    private Stack inputStack;
    private URLConnection externalEntity;
    private int encoding;
    private int currentByteCount;
    private int errorCount;
    private static final int READ_BUFFER_MAX = 16384;
    private char[] readBuffer;
    private int readBufferPos;
    private int readBufferLength;
    private int readBufferOverflow;
    private byte[] rawReadBuffer;
    private static int DATA_BUFFER_INITIAL;
    private char[] dataBuffer;
    private int dataBufferPos;
    private static int NAME_BUFFER_INITIAL;
    private char[] nameBuffer;
    private int nameBufferPos;
    private Hashtable elementInfo;
    private Hashtable entityInfo;
    private Hashtable notationInfo;
    private String currentElement;
    private int currentElementContent;
    private String basePublicId;
    private String baseURI;
    private int baseEncoding;
    private Reader baseReader;
    private InputStream baseInputStream;
    private char[] baseInputBuffer;
    private int baseInputBufferStart;
    private int baseInputBufferLength;
    private Stack entityStack;
    private int context;
    private Object[] symbolTable;
    private static final int SYMBOL_TABLE_LENGTH = 1087;
    private String[] tagAttributes;
    private int tagAttributePos;
    private boolean sawCR;

    public void setHandler(XmlHandler xmlHandler) {
        this.handler = xmlHandler;
    }

    public void parse(String string, String string2, String string3) throws Exception {
        this.doParse(string, string2, null, null, string3);
    }

    public void parse(String string, String string2, InputStream inputStream, String string3) throws Exception {
        this.doParse(string, string2, null, inputStream, string3);
    }

    public void parse(String string, String string2, Reader reader) throws Exception {
        this.doParse(string, string2, reader, null, null);
    }

    private synchronized void doParse(String string, String string2, Reader reader, InputStream inputStream, String string3) throws Exception {
        this.basePublicId = string2;
        this.baseURI = string;
        this.baseReader = reader;
        this.baseInputStream = inputStream;
        this.initializeVariables();
        this.setInternalEntity(this.intern("amp"), "&#38;");
        this.setInternalEntity(this.intern("lt"), "&#60;");
        this.setInternalEntity(this.intern("gt"), "&#62;");
        this.setInternalEntity(this.intern("apos"), "&#39;");
        this.setInternalEntity(this.intern("quot"), "&#34;");
        if (this.handler != null) {
            this.handler.startDocument();
        }
        this.pushURL("[document]", this.basePublicId, this.baseURI, this.baseReader, this.baseInputStream, string3);
        this.parseDocument();
        if (this.handler != null) {
            this.handler.endDocument();
        }
        this.cleanupVariables();
    }

    void error(String string, String string2, String string3) throws Exception {
        ++this.errorCount;
        if (string2 != null) {
            string = string + " (found \"" + string2 + "\")";
        }
        if (string3 != null) {
            string = string + " (expected \"" + string3 + "\")";
        }
        if (this.handler != null) {
            String string4 = null;
            if (this.externalEntity != null) {
                string4 = this.externalEntity.getURL().toString();
            }
            this.handler.error(string, string4, this.line, this.column);
        }
    }

    void error(String string, char c, String string2) throws Exception {
        this.error(string, new Character(c).toString(), string2);
    }

    void parseDocument() throws Exception {
        this.parseProlog();
        this.require('<');
        this.parseElement();
        try {
            this.parseMisc();
            char c = this.readCh();
            this.error("unexpected characters after document end", c, null);
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    void parseComment() throws Exception {
        this.skipUntil("-->");
    }

    void parsePI() throws Exception {
        String string = this.readNmtoken(true);
        if (!this.tryRead("?>")) {
            this.requireWhitespace();
            this.parseUntil("?>");
        }
        if (this.handler != null) {
            this.handler.processingInstruction(string, this.dataBufferToString());
        }
    }

    void parseCDSect() throws Exception {
        this.parseUntil("]]>");
    }

    void parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
        }
    }

    void parseXMLDecl(boolean bl) throws Exception {
        String string = null;
        String string2 = null;
        this.require("version");
        this.parseEq();
        String string3 = this.readLiteral(0);
        if (!string3.equals("1.0")) {
            this.error("unsupported XML version", string3, "1.0");
        }
        this.skipWhitespace();
        if (this.tryRead("encoding")) {
            this.parseEq();
            string = this.readLiteral(0);
            this.checkEncoding(string, bl);
        }
        this.skipWhitespace();
        if (this.tryRead("standalone")) {
            this.parseEq();
            string2 = this.readLiteral(0);
        }
        this.skipWhitespace();
        this.require("?>");
    }

    void parseTextDecl(boolean bl) throws Exception {
        String string = null;
        if (this.tryRead("version")) {
            this.parseEq();
            String string2 = this.readLiteral(0);
            if (!string2.equals("1.0")) {
                this.error("unsupported XML version", string2, "1.0");
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.parseEq();
        string = this.readLiteral(0);
        this.checkEncoding(string, bl);
        this.skipWhitespace();
        this.require("?>");
    }

    void checkEncoding(String string, boolean bl) throws Exception {
        string = string.toUpperCase();
        if (bl) {
            return;
        }
        switch (this.encoding) {
            case 1: {
                if (string.equals("ISO-8859-1")) {
                    this.encoding = 2;
                    break;
                }
                if (string.equals("UTF-8")) break;
                this.error("unsupported 8-bit encoding", string, "UTF-8 or ISO-8859-1");
                break;
            }
            case 3: 
            case 4: {
                if (string.equals("ISO-10646-UCS-2") || string.equals("UTF-16")) break;
                this.error("unsupported 16-bit encoding", string, "ISO-10646-UCS-2");
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (string.equals("ISO-10646-UCS-4")) break;
                this.error("unsupported 32-bit encoding", string, "ISO-10646-UCS-4");
            }
        }
    }

    void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead("<?")) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead("<!--")) break;
            this.parseComment();
        }
    }

    void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.skipWhitespace();
        String[] stringArray = this.readExternalIds(false);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.context = 1;
                this.skipWhitespace();
                this.context = 0;
                if (this.tryRead(']')) break;
                this.context = 1;
                this.parseMarkupdecl();
                this.context = 0;
            }
        }
        if (stringArray[1] != null) {
            this.pushURL("[external subset]", stringArray[0], stringArray[1], null, null, null);
            while (true) {
                this.context = 1;
                this.skipWhitespace();
                this.context = 0;
                if (!this.tryRead('>')) {
                    this.context = 1;
                    this.parseMarkupdecl();
                    this.context = 0;
                    continue;
                }
                break;
            }
        } else {
            this.skipWhitespace();
            this.require('>');
        }
        if (this.handler != null) {
            this.handler.doctypeDecl(string, stringArray[0], stringArray[1]);
        }
    }

    void parseMarkupdecl() throws Exception {
        if (this.tryRead("<!ELEMENT")) {
            this.parseElementdecl();
        } else if (this.tryRead("<!ATTLIST")) {
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            this.parseNotationDecl();
        } else if (this.tryRead("<?")) {
            this.parsePI();
        } else if (this.tryRead("<!--")) {
            this.parseComment();
        } else if (this.tryRead("<![")) {
            this.parseConditionalSect();
        } else {
            this.error("expected markup declaration", null, null);
        }
    }

    void parseElement() throws Exception {
        String string;
        int n = this.currentElementContent;
        String string2 = this.currentElement;
        this.tagAttributePos = 0;
        this.currentElement = string = this.readNmtoken(true);
        this.currentElementContent = this.getElementContentType(string);
        if (this.currentElementContent == 0) {
            this.currentElementContent = 1;
        }
        this.skipWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            this.parseAttribute(string);
            this.skipWhitespace();
            c = this.readCh();
        }
        this.unread(c);
        Enumeration enumeration = this.declaredAttributes(string);
        if (enumeration != null) {
            block5: while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                for (int i = 0; i < this.tagAttributePos; ++i) {
                    if (this.tagAttributes[i] == string3) continue block5;
                }
                if (this.handler == null) continue;
                this.handler.attribute(string3, this.getAttributeExpandedValue(string, string3), false);
            }
        }
        c = this.readCh();
        switch (c) {
            case '>': {
                if (this.handler != null) {
                    this.handler.startElement(string);
                }
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>');
                if (this.handler == null) break;
                this.handler.startElement(string);
                this.handler.endElement(string);
            }
        }
        this.currentElement = string2;
        this.currentElementContent = n;
    }

    void parseAttribute(String string) throws Exception {
        String string2 = this.readNmtoken(true).intern();
        int n = this.getAttributeDefaultValueType(string, string2);
        this.parseEq();
        String string3 = n == 1 || n == 0 ? this.readLiteral(3) : this.readLiteral(11);
        if (this.handler != null) {
            this.handler.attribute(string2, string3, true);
        }
        this.dataBufferPos = 0;
        if (this.tagAttributePos == this.tagAttributes.length) {
            String[] stringArray = new String[this.tagAttributes.length * 2];
            System.arraycopy(this.tagAttributes, 0, stringArray, 0, this.tagAttributePos);
            this.tagAttributes = stringArray;
        }
        this.tagAttributes[this.tagAttributePos++] = string2;
    }

    void parseEq() throws Exception {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    void parseETag() throws Exception {
        String string = this.readNmtoken(true);
        if (string != this.currentElement) {
            this.error("mismatched end tag", string, this.currentElement);
        }
        this.skipWhitespace();
        this.require('>');
        if (this.handler != null) {
            this.handler.endElement(string);
        }
    }

    void parseContent() throws Exception {
        while (true) {
            switch (this.currentElementContent) {
                case 1: 
                case 3: {
                    this.parsePCData();
                    break;
                }
                case 4: {
                    this.parseWhitespace();
                }
            }
            char c = this.readCh();
            block4 : switch (c) {
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                        break;
                    }
                    this.unread(c);
                    this.parseEntityRef(true);
                    break;
                }
                case '<': {
                    c = this.readCh();
                    switch (c) {
                        case '!': {
                            c = this.readCh();
                            switch (c) {
                                case '-': {
                                    this.require('-');
                                    this.parseComment();
                                    break block4;
                                }
                                case '[': {
                                    this.require("CDATA[");
                                    this.parseCDSect();
                                    break block4;
                                }
                            }
                            this.error("expected comment or CDATA section", c, null);
                            break block4;
                        }
                        case '?': {
                            this.dataBufferFlush();
                            this.parsePI();
                            break block4;
                        }
                        case '/': {
                            this.dataBufferFlush();
                            this.parseETag();
                            return;
                        }
                    }
                    this.dataBufferFlush();
                    this.unread(c);
                    this.parseElement();
                }
            }
        }
    }

    void parseElementdecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(string);
        this.skipWhitespace();
        this.require('>');
    }

    void parseContentspec(String string) throws Exception {
        if (this.tryRead("EMPTY")) {
            this.setElement(string, 2, null, null);
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(string, 1, null, null);
            return;
        }
        this.require('(');
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed();
            this.setElement(string, 3, this.dataBufferToString(), null);
        } else {
            this.parseElements();
            this.setElement(string, 4, this.dataBufferToString(), null);
        }
    }

    void parseElements() throws Exception {
        char c;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c2 = this.readCh();
        switch (c2) {
            case ')': {
                this.dataBufferAppend(')');
                c2 = this.readCh();
                switch (c2) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c2);
                        break;
                    }
                    default: {
                        this.unread(c2);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                c = c2;
                this.dataBufferAppend(c2);
                break;
            }
            default: {
                this.error("bad separator in content model", c2, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c2 = this.readCh();
            if (c2 == ')') break;
            if (c2 != c) {
                this.error("bad separator in content model", c2, null);
                return;
            }
            this.dataBufferAppend(c2);
        }
        this.dataBufferAppend(')');
        c2 = this.readCh();
        switch (c2) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c2);
                return;
            }
        }
        this.unread(c2);
    }

    void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements();
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                }
            }
        }
    }

    void parseMixed() throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")*")) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.dataBufferAppend(")*");
    }

    void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        while (!this.tryRead('>')) {
            this.parseAttDef(string);
            this.skipWhitespace();
        }
    }

    void parseAttDef(String string) throws Exception {
        String string2 = null;
        String string3 = this.readNmtoken(true);
        this.requireWhitespace();
        int n = this.readAttType();
        if (n == 9 || n == 10) {
            string2 = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(string, string3, n, string2);
    }

    int readAttType() throws Exception {
        Integer n;
        if (this.tryRead('(')) {
            this.parseEnumeration();
            return 9;
        }
        String string = this.readNmtoken(true);
        if (string.equals("NOTATION")) {
            this.parseNotationType();
        }
        if ((n = (Integer)attributeTypeHash.get(string)) == null) {
            this.error("illegal attribute type", string, null);
            return 0;
        }
        return n;
    }

    void parseEnumeration() throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(true));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(');
        this.parseEnumeration();
    }

    void parseDefault(String string, String string2, int n, String string3) throws Exception {
        int n2 = 1;
        String string4 = null;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                n2 = 4;
                this.requireWhitespace();
                this.context = 3;
                string4 = this.readLiteral(1);
                this.context = 1;
            } else if (this.tryRead("REQUIRED")) {
                n2 = 3;
            } else if (this.tryRead("IMPLIED")) {
                n2 = 2;
            } else {
                this.error("illegal keyword for attribute default value", null, null);
            }
        } else {
            this.context = 3;
            string4 = this.readLiteral(1);
            this.context = 1;
        }
        this.setAttribute(string, string2, n, string3, string4, n2);
    }

    void parseConditionalSect() throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[');
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[');
            boolean bl = true;
            int n = 1;
            while (n > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (this.tryRead("![")) {
                            ++n;
                        }
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --n;
                    }
                }
            }
        } else {
            this.error("conditional section must begin with INCLUDE or IGNORE", null, null);
        }
    }

    void parseCharRef() throws Exception {
        int n = 0;
        if (this.tryRead('x')) {
            block8: while (true) {
                char c = this.readCh();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        n *= 16;
                        n += Integer.parseInt(new Character(c).toString(), 16);
                        continue block8;
                    }
                    case ';': {
                        break block8;
                    }
                    default: {
                        this.error("illegal character in character reference", c, null);
                        break block8;
                    }
                }
                break;
            }
        } else {
            block9: while (true) {
                char c = this.readCh();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n *= 10;
                        n += Integer.parseInt(new Character(c).toString(), 10);
                        continue block9;
                    }
                    case ';': {
                        break block9;
                    }
                    default: {
                        this.error("illegal character in character reference", c, null);
                        break block9;
                    }
                }
                break;
            }
        }
        if (n <= 65535) {
            this.dataBufferAppend((char)n);
        } else if (n <= 1048575) {
            this.dataBufferAppend((char)(0xD8 | (n & 0xFFC00) >> 10));
            this.dataBufferAppend((char)(0xDC | n & 0x3FF));
        } else {
            this.error("character reference " + n + " is too large for UTF-16", new Integer(n).toString(), null);
        }
    }

    void parseEntityRef(boolean bl) throws Exception {
        String string = this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(string)) {
            case 0: {
                this.error("reference to undeclared entity", string, null);
                break;
            }
            case 1: {
                this.pushString(string, this.getEntityValue(string));
                break;
            }
            case 3: {
                if (bl) {
                    this.pushURL(string, this.getEntityPublicId(string), this.getEntitySystemId(string), null, null, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
                break;
            }
            case 2: {
                if (bl) {
                    this.error("data entity reference in content", string, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", string, null);
            }
        }
    }

    void parsePEReference(boolean bl) throws Exception {
        String string = "%" + this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(string)) {
            case 0: {
                this.error("reference to undeclared parameter entity", string, null);
                break;
            }
            case 1: {
                if (bl) {
                    this.pushString(string, this.getEntityValue(string));
                    break;
                }
                this.pushString(string, " " + this.getEntityValue(string) + ' ');
                break;
            }
            case 3: {
                if (bl) {
                    this.pushString(null, " ");
                }
                this.pushURL(string, this.getEntityPublicId(string), this.getEntitySystemId(string), null, null, null);
                if (!bl) break;
                this.pushString(null, " ");
            }
        }
    }

    void parseEntityDecl() throws Exception {
        boolean bl = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            bl = true;
            this.requireWhitespace();
        }
        String string = this.readNmtoken(true);
        if (bl) {
            string = "%" + string;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            this.context = 2;
            String string2 = this.readLiteral(5);
            this.context = 1;
            this.setInternalEntity(string, string2);
        } else {
            String[] stringArray = this.readExternalIds(false);
            if (stringArray[1] == null) {
                this.error("system identifer missing", string, null);
            }
            this.skipWhitespace();
            if (this.tryRead("NDATA")) {
                this.requireWhitespace();
                String string3 = this.readNmtoken(true);
                this.setExternalDataEntity(string, stringArray[0], stringArray[1], string3);
            } else {
                this.setExternalTextEntity(string, stringArray[0], stringArray[1]);
            }
        }
        this.skipWhitespace();
        this.require('>');
    }

    void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.requireWhitespace();
        String[] stringArray = this.readExternalIds(true);
        if (stringArray[0] == null && stringArray[1] == null) {
            this.error("external identifer missing", string, null);
        }
        this.setNotation(string, stringArray[0], stringArray[1]);
        this.skipWhitespace();
        this.require('>');
    }

    void parsePCData() throws Exception {
        int n = 0;
        int n2 = 0;
        block7: for (int i = this.readBufferPos; i < this.readBufferLength; ++i) {
            switch (this.readBuffer[i]) {
                case '\n': {
                    ++n;
                    n2 = 0;
                    continue block7;
                }
                case '&': 
                case '<': {
                    int n3 = this.readBufferPos;
                    ++n2;
                    this.readBufferPos = i;
                    if (n > 0) {
                        this.line += n;
                        this.column = n2;
                    } else {
                        this.column += n2;
                    }
                    this.dataBufferAppend(this.readBuffer, n3, i - n3);
                    return;
                }
                default: {
                    ++n2;
                }
            }
        }
        while (true) {
            char c = this.readCh();
            switch (c) {
                case '&': 
                case '<': {
                    this.unread(c);
                    return;
                }
            }
            this.dataBufferAppend(c);
        }
    }

    void requireWhitespace() throws Exception {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.error("whitespace expected", c, null);
        }
    }

    void parseWhitespace() throws Exception {
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            this.dataBufferAppend(c);
            c = this.readCh();
        }
        this.unread(c);
    }

    void skipWhitespace() throws Exception {
        char c = '\u0000';
        int n = 0;
        block5: for (int i = this.readBufferPos; i < this.readBufferLength; ++i) {
            switch (this.readBuffer[i]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++n;
                    continue block5;
                }
                case '\n': {
                    ++c;
                    n = 0;
                    continue block5;
                }
                case '%': {
                    if (this.context == 1 || this.context == 2) break block5;
                }
                default: {
                    this.readBufferPos = i;
                    if (c > '\u0000') {
                        this.line += c;
                        this.column = n;
                    } else {
                        this.column += n;
                    }
                    return;
                }
            }
        }
        c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    String readNmtoken(boolean bl) throws Exception {
        block7: for (int i = this.readBufferPos; i < this.readBufferLength; ++i) {
            switch (this.readBuffer[i]) {
                case '%': {
                    if (this.context == 1 || this.context == 2) break block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '#': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    int n = this.readBufferPos;
                    if (i == n) {
                        this.error("name expected", this.readBuffer[i], null);
                    }
                    this.readBufferPos = i;
                    return this.intern(this.readBuffer, n, i - n);
                }
                default: {
                    continue block7;
                }
            }
        }
        this.nameBufferPos = 0;
        while (true) {
            char c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.nameBufferPos == 0) {
                        this.error("name expected", null, null);
                    }
                    String string = this.intern(this.nameBuffer, 0, this.nameBufferPos);
                    this.nameBufferPos = 0;
                    return string;
                }
            }
            this.nameBuffer = (char[])this.extendArray(this.nameBuffer, this.nameBuffer.length, this.nameBufferPos);
            this.nameBuffer[this.nameBufferPos++] = c;
        }
    }

    String readLiteral(int n) throws Exception {
        int n2 = this.line;
        char c = this.readCh();
        if (c != '\"' && c != '\'' && c != '\u0000') {
            this.error("expected '\"' or \"'\"", c, null);
            return null;
        }
        try {
            char c2 = this.readCh();
            block6: while (c2 != c) {
                switch (c2) {
                    case '\n': 
                    case '\r': {
                        c2 = ' ';
                        break;
                    }
                    case '&': {
                        if ((n & 1) <= 0) break;
                        c2 = this.readCh();
                        if (c2 == '#') {
                            this.parseCharRef();
                            c2 = this.readCh();
                            continue block6;
                        }
                        if ((n & 2) > 0) {
                            this.unread(c2);
                            this.parseEntityRef(false);
                            c2 = this.readCh();
                            continue block6;
                        }
                        this.dataBufferAppend('&');
                        break;
                    }
                }
                this.dataBufferAppend(c2);
                c2 = this.readCh();
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n2 + ')', null, new Character(c).toString());
        }
        if ((n & 8) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    String[] readExternalIds(boolean bl) throws Exception {
        String[] stringArray = new String[2];
        if (this.tryRead("PUBLIC")) {
            this.requireWhitespace();
            stringArray[0] = this.readLiteral(8);
            if (bl) {
                this.skipWhitespace();
                if (this.tryRead('\"') || this.tryRead('\'')) {
                    stringArray[1] = this.readLiteral(0);
                }
            } else {
                this.requireWhitespace();
                stringArray[1] = this.readLiteral(0);
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            stringArray[1] = this.readLiteral(0);
        }
        return stringArray;
    }

    final boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    void dataBufferAppend(char c) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos);
        this.dataBuffer[this.dataBufferPos++] = c;
    }

    void dataBufferAppend(String string) {
        this.dataBufferAppend(string.toCharArray(), 0, string.length());
    }

    void dataBufferAppend(char[] cArray, int n, int n2) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos + n2);
        System.arraycopy(cArray, n, this.dataBuffer, this.dataBufferPos, n2);
        this.dataBufferPos += n2;
    }

    void dataBufferNormalize() {
        int n;
        int n2 = 0;
        int n3 = this.dataBufferPos;
        for (n = 0; n < n3 && this.isWhitespace(this.dataBuffer[n]); ++n) {
        }
        while (n3 > n && this.isWhitespace(this.dataBuffer[n3 - 1])) {
            --n3;
        }
        while (n < n3) {
            char c;
            if (this.isWhitespace(c = this.dataBuffer[n++])) {
                while (n < n3 && this.isWhitespace(this.dataBuffer[n++])) {
                }
                this.dataBuffer[n2++] = 32;
                this.dataBuffer[n2++] = this.dataBuffer[n - 1];
                continue;
            }
            this.dataBuffer[n2++] = c;
        }
        this.dataBufferPos = n2;
    }

    String dataBufferToString() {
        String string = new String(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
        return string;
    }

    void dataBufferFlush() throws Exception {
        if (this.dataBufferPos > 0) {
            switch (this.currentElementContent) {
                case 0: 
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    if (this.handler == null) break;
                    this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
                    break;
                }
                case 4: {
                    if (this.handler == null) break;
                    this.handler.ignorableWhitespace(this.dataBuffer, 0, this.dataBufferPos);
                }
            }
            this.dataBufferPos = 0;
        }
    }

    void require(String string) throws Exception {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            this.require(cArray[i]);
        }
    }

    void require(char c) throws Exception {
        char c2 = this.readCh();
        if (c2 != c) {
            this.error("expected character", c2, new Character(c).toString());
        }
    }

    public String intern(String string) {
        char[] cArray = string.toCharArray();
        return this.intern(cArray, 0, cArray.length);
    }

    public String intern(char[] cArray, int n, int n2) {
        Object object;
        int n3;
        int n4 = 0;
        for (int i = n; i < n + n2; ++i) {
            n4 = (n4 << 1 & 0xFFFFFF) + cArray[i];
        }
        Object[] objectArray = (Object[])this.symbolTable[n4 %= 1087];
        if (objectArray == null) {
            objectArray = new Object[8];
            this.symbolTable[n4] = objectArray;
        }
        for (n3 = 0; n3 < objectArray.length && (object = (char[])objectArray[n3]) != null; n3 += 2) {
            if (((char[])object).length != n2) continue;
            for (int i = 0; i < ((char[])object).length && cArray[n + i] == object[i]; ++i) {
                if (i != n2 - 1) continue;
                return (String)objectArray[n3 + 1];
            }
        }
        objectArray = (Object[])this.extendArray(objectArray, objectArray.length, n3);
        object = new String(cArray, n, n2);
        objectArray[n3] = ((String)object).toCharArray();
        objectArray[n3 + 1] = object;
        this.symbolTable[n4] = objectArray;
        return object;
    }

    Object extendArray(Object object, int n, int n2) {
        if (n2 < n) {
            return object;
        }
        Object[] objectArray = null;
        int n3 = n * 2;
        if (n3 <= n2) {
            n3 = n2 + 1;
        }
        if (object instanceof char[]) {
            objectArray = new char[n * 2];
        } else if (object instanceof Object[]) {
            objectArray = new Object[n * 2];
        }
        System.arraycopy(object, 0, objectArray, 0, n);
        return objectArray;
    }

    public Enumeration declaredElements() {
        return this.elementInfo.keys();
    }

    public int getElementContentType(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            return 0;
        }
        return (Integer)objectArray[0];
    }

    public String getElementContentModel(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    void setElement(String string, int n, String string2, Hashtable hashtable) throws Exception {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            objectArray = new Object[]{new Integer(0), null, null};
        } else if (n != 0 && (Integer)objectArray[0] != 0) {
            this.error("multiple declarations for element type", string, null);
            return;
        }
        if (n != 0) {
            objectArray[0] = new Integer(n);
        }
        if (string2 != null) {
            objectArray[1] = string2;
        }
        if (hashtable != null) {
            objectArray[2] = hashtable;
        }
        this.elementInfo.put(string, objectArray);
    }

    Hashtable getElementAttributes(String string) {
        Object[] objectArray = (Object[])this.elementInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (Hashtable)objectArray[2];
    }

    public Enumeration declaredAttributes(String string) {
        Hashtable hashtable = this.getElementAttributes(string);
        if (hashtable == null) {
            return null;
        }
        return hashtable.keys();
    }

    public int getAttributeType(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return 0;
        }
        return (Integer)objectArray[0];
    }

    public String getAttributeEnumeration(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[3];
    }

    public String getAttributeDefaultValue(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    public String getAttributeExpandedValue(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[4] == null && objectArray[1] != null) {
            try {
                this.pushString(null, '\u0000' + (String)objectArray[1] + '\u0000');
                objectArray[4] = this.readLiteral(11);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (String)objectArray[4];
    }

    public int getAttributeDefaultValueType(String string, String string2) {
        Object[] objectArray = this.getAttribute(string, string2);
        if (objectArray == null) {
            return 0;
        }
        return (Integer)objectArray[2];
    }

    void setAttribute(String string, String string2, int n, String string3, String string4, int n2) throws Exception {
        Hashtable<String, Object[]> hashtable = this.getElementAttributes(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object[]>();
        }
        if (hashtable.get(string2) != null) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(n), string4, new Integer(n2), string3, null};
        hashtable.put(string2.intern(), objectArray);
        this.setElement(string, 0, null, hashtable);
    }

    Object[] getAttribute(String string, String string2) {
        Hashtable hashtable = this.getElementAttributes(string);
        if (hashtable == null) {
            return null;
        }
        Object[] objectArray = (Object[])hashtable.get(string2);
        return objectArray;
    }

    public Enumeration declaredEntities() {
        return this.entityInfo.keys();
    }

    public int getEntityType(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return 0;
        }
        return (Integer)objectArray[0];
    }

    public String getEntityPublicId(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    public String getEntitySystemId(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[2];
    }

    public String getEntityValue(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[3];
    }

    public String getEntityNotationName(String string) {
        Object[] objectArray = (Object[])this.entityInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[4];
    }

    void setInternalEntity(String string, String string2) {
        this.setEntity(string, 1, null, null, string2, null);
    }

    void setExternalDataEntity(String string, String string2, String string3, String string4) {
        this.setEntity(string, 2, string2, string3, null, string4);
    }

    void setExternalTextEntity(String string, String string2, String string3) {
        this.setEntity(string, 3, string2, string3, null, null);
    }

    void setEntity(String string, int n, String string2, String string3, String string4, String string5) {
        if (this.entityInfo.get(string) == null) {
            Object[] objectArray = new Object[]{new Integer(n), string2, string3, string4, string5};
            this.entityInfo.put(string, objectArray);
        }
    }

    public Enumeration declaredNotations() {
        return this.notationInfo.keys();
    }

    public String getNotationPublicId(String string) {
        Object[] objectArray = (Object[])this.notationInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[0];
    }

    public String getNotationSystemId(String string) {
        Object[] objectArray = (Object[])this.notationInfo.get(string);
        if (objectArray == null) {
            return null;
        }
        return (String)objectArray[1];
    }

    void setNotation(String string, String string2, String string3) throws Exception {
        if (this.notationInfo.get(string) == null) {
            Object[] objectArray = new Object[]{string2, string3};
            this.notationInfo.put(string, objectArray);
        } else {
            this.error("multiple declarations of notation", string, null);
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    char readCh() throws Exception {
        char c;
        block3: while (this.readBufferPos >= this.readBufferLength) {
            switch (this.sourceType) {
                case 2: 
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
            }
            this.popInput();
        }
        if ((c = this.readBuffer[this.readBufferPos++]) == '%' && (this.context == 1 || this.context == 2)) {
            char c2 = this.readCh();
            this.unread(c2);
            if (!this.isWhitespace(c2)) {
                this.parsePEReference(this.context == 2);
                return this.readCh();
            }
        }
        if (c == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        return c;
    }

    void unread(char c) throws Exception {
        if (c == '\n') {
            --this.line;
            this.column = -1;
        }
        if (this.readBufferPos > 0) {
            this.readBuffer[--this.readBufferPos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    void unread(char[] cArray, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != '\n') continue;
            --this.line;
            this.column = -1;
        }
        if (n < this.readBufferPos) {
            this.readBufferPos -= n;
        } else {
            this.pushCharArray(null, cArray, 0, n);
            this.sourceType = 4;
        }
    }

    void pushURL(String string, String string2, String string3, Reader reader, InputStream inputStream, String string4) throws Exception {
        Object object;
        boolean bl = false;
        this.pushInput(string);
        this.readBuffer = new char[16388];
        this.readBufferPos = 0;
        this.readBufferLength = 0;
        this.readBufferOverflow = -1;
        this.is = null;
        this.line = 1;
        this.currentByteCount = 0;
        this.dataBufferFlush();
        if (string3 != null && this.externalEntity != null) {
            string3 = new URL(this.externalEntity.getURL(), string3).toString();
        } else if (this.baseURI != null) {
            try {
                string3 = new URL(new URL(this.baseURI), string3).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string3 != null && this.handler != null && (object = this.handler.resolveEntity(string2, string3)) != null) {
            if (object instanceof String) {
                string3 = (String)object;
            } else if (object instanceof InputStream) {
                inputStream = (InputStream)object;
            } else if (object instanceof Reader) {
                reader = (Reader)object;
            }
        }
        if (this.handler != null) {
            if (string3 != null) {
                this.handler.startExternalEntity(string3);
            } else {
                this.handler.startExternalEntity("[external stream]");
            }
        }
        if (reader != null) {
            this.sourceType = 5;
            this.reader = reader;
            this.tryEncodingDecl(true);
            return;
        }
        if (inputStream != null) {
            this.sourceType = 3;
            this.is = inputStream;
        } else {
            this.sourceType = 2;
            URL uRL = new URL(string3);
            this.externalEntity = uRL.openConnection();
            this.externalEntity.connect();
            this.is = this.externalEntity.getInputStream();
        }
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        if (string4 == null && this.externalEntity != null) {
            string4 = this.externalEntity.getContentEncoding();
        }
        if (string4 != null) {
            this.checkEncoding(string4, false);
            bl = true;
        } else {
            this.detectEncoding();
            bl = false;
        }
        this.tryEncodingDecl(bl);
    }

    void tryEncodingDecl(boolean bl) throws Exception {
        if (this.tryRead("<?xml")) {
            if (this.tryWhitespace()) {
                if (this.inputStack.size() > 0) {
                    this.parseTextDecl(bl);
                } else {
                    this.parseXMLDecl(bl);
                }
            } else {
                this.unread("xml".toCharArray(), 3);
                this.parsePI();
            }
        }
    }

    void detectEncoding() throws Exception {
        byte[] byArray = new byte[4];
        this.is.mark(4);
        this.is.read(byArray);
        this.is.reset();
        if (this.tryEncoding(byArray, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.encoding = 5;
        } else if (this.tryEncoding(byArray, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.encoding = 6;
        } else if (this.tryEncoding(byArray, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.encoding = 7;
        } else if (this.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.encoding = 8;
        } else if (this.tryEncoding(byArray, (byte)-2, (byte)-1)) {
            this.encoding = 3;
            this.is.read();
            this.is.read();
        } else if (this.tryEncoding(byArray, (byte)-1, (byte)-2)) {
            this.encoding = 4;
            this.is.read();
            this.is.read();
        } else if (this.tryEncoding(byArray, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.encoding = 3;
            this.error("no byte-order mark for UCS-2 entity", null, null);
        } else if (this.tryEncoding(byArray, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.encoding = 4;
            this.error("no byte-order mark for UCS-2 entity", null, null);
        } else if (this.tryEncoding(byArray, (byte)60, (byte)63, (byte)120, (byte)109)) {
            this.encoding = 1;
            this.read8bitEncodingDeclaration();
        } else {
            this.encoding = 1;
        }
    }

    boolean tryEncoding(byte[] byArray, byte by, byte by2, byte by3, byte by4) {
        return byArray[0] == by && byArray[1] == by2 && byArray[2] == by3 && byArray[3] == by4;
    }

    boolean tryEncoding(byte[] byArray, byte by, byte by2) {
        return byArray[0] == by && byArray[1] == by2;
    }

    void pushString(String string, String string2) throws Exception {
        char[] cArray = string2.toCharArray();
        this.pushCharArray(string, cArray, 0, cArray.length);
    }

    void pushCharArray(String string, char[] cArray, int n, int n2) throws Exception {
        this.pushInput(string);
        this.sourceType = 1;
        this.readBuffer = cArray;
        this.readBufferPos = n;
        this.readBufferLength = n2;
        this.readBufferOverflow = -1;
    }

    void pushInput(String string) throws Exception {
        Object[] objectArray = new Object[12];
        if (string != null) {
            Enumeration enumeration = this.entityStack.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2 != string) continue;
                this.error("recursive reference to entity", string, null);
            }
        }
        this.entityStack.push(string);
        if (this.sourceType == 0) {
            return;
        }
        objectArray[0] = new Integer(this.sourceType);
        objectArray[1] = this.externalEntity;
        objectArray[2] = this.readBuffer;
        objectArray[3] = new Integer(this.readBufferPos);
        objectArray[4] = new Integer(this.readBufferLength);
        objectArray[5] = new Integer(this.line);
        objectArray[6] = new Integer(this.encoding);
        objectArray[7] = new Integer(this.readBufferOverflow);
        objectArray[8] = this.is;
        objectArray[9] = new Integer(this.currentByteCount);
        objectArray[10] = new Integer(this.column);
        objectArray[11] = this.reader;
        this.inputStack.push(objectArray);
    }

    void popInput() throws Exception {
        switch (this.sourceType) {
            case 2: {
                this.dataBufferFlush();
                if (this.handler == null || this.externalEntity == null) break;
                this.handler.endExternalEntity(this.externalEntity.getURL().toString());
                break;
            }
            case 3: {
                this.dataBufferFlush();
                if (this.baseURI == null || this.handler == null) break;
                this.handler.endExternalEntity(this.baseURI);
                break;
            }
            case 5: {
                this.dataBufferFlush();
                if (this.baseURI == null || this.handler == null) break;
                this.handler.endExternalEntity(this.baseURI);
            }
        }
        if (this.inputStack.isEmpty()) {
            throw new EOFException();
        }
        Object[] objectArray = (Object[])this.inputStack.pop();
        String string = (String)this.entityStack.pop();
        this.sourceType = (Integer)objectArray[0];
        this.externalEntity = (URLConnection)objectArray[1];
        this.readBuffer = (char[])objectArray[2];
        this.readBufferPos = (Integer)objectArray[3];
        this.readBufferLength = (Integer)objectArray[4];
        this.line = (Integer)objectArray[5];
        this.encoding = (Integer)objectArray[6];
        this.readBufferOverflow = (Integer)objectArray[7];
        this.is = (InputStream)objectArray[8];
        this.currentByteCount = (Integer)objectArray[9];
        this.column = (Integer)objectArray[10];
        this.reader = (Reader)objectArray[11];
    }

    boolean tryRead(char c) throws Exception {
        char c2 = this.readCh();
        if (c2 == c) {
            return true;
        }
        this.unread(c2);
        return false;
    }

    boolean tryRead(String string) throws Exception {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = this.readCh();
            if (c == cArray[i]) continue;
            this.unread(c);
            if (i != 0) {
                this.unread(cArray, i);
            }
            return false;
        }
        return true;
    }

    boolean tryWhitespace() throws Exception {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    void parseUntil(String string) throws Exception {
        int n = this.line;
        try {
            while (!this.tryRead(string)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n + ')', null, string);
        }
    }

    void skipUntil(String string) throws Exception {
        while (!this.tryRead(string)) {
            this.readCh();
        }
    }

    void read8bitEncodingDeclaration() throws Exception {
        this.readBufferLength = 0;
        this.readBufferPos = 0;
        while (true) {
            int n = this.is.read();
            this.readBuffer[this.readBufferLength++] = (char)n;
            switch (n) {
                case 62: {
                    return;
                }
                case -1: {
                    this.error("end of file before end of XML or encoding declaration.", null, "?>");
                    return;
                }
            }
            if (this.readBuffer.length != this.readBufferLength) continue;
            this.error("unfinished XML or encoding declaration", null, null);
        }
    }

    void readDataChunk() throws Exception {
        if (this.readBufferOverflow > -1) {
            this.readBuffer[0] = (char)this.readBufferOverflow;
            this.readBufferOverflow = -1;
            this.readBufferPos = 1;
            this.sawCR = true;
        } else {
            this.readBufferPos = 0;
            this.sawCR = false;
        }
        if (this.sourceType == 5) {
            int n = this.reader.read(this.readBuffer, this.readBufferPos, 16383);
            if (n < 0) {
                this.readBufferLength = -1;
            } else {
                this.readBufferLength = this.readBufferPos + n;
                this.filterCR();
                this.sawCR = false;
            }
            return;
        }
        int n = this.is.read(this.rawReadBuffer, 0, 16384);
        switch (this.encoding) {
            case 1: {
                this.copyUtf8ReadBuffer(n);
                break;
            }
            case 2: {
                this.copyIso8859_1ReadBuffer(n);
                break;
            }
            case 3: {
                this.copyUcs2ReadBuffer(n, 8, 0);
                break;
            }
            case 4: {
                this.copyUcs2ReadBuffer(n, 0, 8);
                break;
            }
            case 5: {
                this.copyUcs4ReadBuffer(n, 24, 16, 8, 0);
                break;
            }
            case 6: {
                this.copyUcs4ReadBuffer(n, 0, 8, 16, 24);
                break;
            }
            case 7: {
                this.copyUcs4ReadBuffer(n, 16, 24, 0, 8);
                break;
            }
            case 8: {
                this.copyUcs4ReadBuffer(n, 8, 0, 24, 16);
            }
        }
        if (this.sawCR) {
            this.filterCR();
            this.sawCR = false;
        }
        this.readBufferPos = 0;
        this.currentByteCount += n;
    }

    void filterCR() {
        this.readBufferOverflow = -1;
        int n = 0;
        block3: for (int i = 0; i < this.readBufferLength; ++i) {
            switch (this.readBuffer[i]) {
                case '\r': {
                    if (i == this.readBufferLength - 1) {
                        this.readBufferOverflow = 13;
                        --this.readBufferLength;
                        break block3;
                    }
                    if (this.readBuffer[i + 1] == '\n') {
                        ++i;
                    }
                    this.readBuffer[n] = 10;
                    break;
                }
                default: {
                    this.readBuffer[n] = this.readBuffer[i];
                }
            }
            ++n;
        }
        this.readBufferLength = n;
    }

    void copyUtf8ReadBuffer(int n) throws Exception {
        int n2 = 0;
        int n3 = this.readBufferPos;
        boolean bl = false;
        while (n2 < n) {
            byte by = this.rawReadBuffer[n2++];
            bl = false;
            if ((by & 0x80) == 0) {
                this.readBuffer[n3++] = (char)by;
            } else if ((by & 0xE0) == 192) {
                this.readBuffer[n3++] = (char)((by & 0x1F) << 6 | this.getNextUtf8Byte(n2++, n));
            } else if ((by & 0xF0) == 224) {
                this.readBuffer[n3++] = (char)((by & 0xF) << 12 | this.getNextUtf8Byte(n2++, n) << 6 | this.getNextUtf8Byte(n2++, n));
            } else if ((by & 0xF8) == 240) {
                bl = true;
                int n4 = this.getNextUtf8Byte(n2++, n);
                int n5 = this.getNextUtf8Byte(n2++, n);
                int n6 = this.getNextUtf8Byte(n2++, n);
                this.readBuffer[n3++] = (char)(0xD800 | ((by & 7) << 2 | ((n4 & 0x30) >> 4) - 1) << 6 | (n4 & 0xF) << 2 | (n5 & 0x30) >> 4);
                this.readBuffer[n3++] = (char)(0xDC | (n5 & 0xF) << 6 | n6);
            } else {
                this.encodingError("bad start for UTF-8 multi-byte sequence", by, n2);
            }
            if (this.readBuffer[n3 - 1] != '\r') continue;
            this.sawCR = true;
        }
        this.readBufferLength = n3;
    }

    int getNextUtf8Byte(int n, int n2) throws Exception {
        int n3;
        if (n < n2) {
            n3 = this.rawReadBuffer[n];
        } else {
            n3 = this.is.read();
            if (n3 == -1) {
                this.encodingError("unfinished multi-byte UTF-8 sequence at EOF", -1, n);
            }
        }
        if ((n3 & 0xC0) != 128) {
            this.encodingError("bad continuation of multi-byte UTF-8 sequence", n3, n + 1);
        }
        return n3 & 0x3F;
    }

    void copyIso8859_1ReadBuffer(int n) {
        int n2 = 0;
        int n3 = this.readBufferPos;
        while (n2 < n) {
            this.readBuffer[n3] = (char)(this.rawReadBuffer[n2] & 0xFF);
            if (this.readBuffer[n3] == '\r') {
                this.sawCR = true;
            }
            ++n2;
            ++n3;
        }
        this.readBufferLength = n3;
    }

    void copyUcs2ReadBuffer(int n, int n2, int n3) throws Exception {
        int n4 = this.readBufferPos;
        if (n > 0 && n % 2 != 0) {
            this.encodingError("odd number of bytes in UCS-2 encoding", -1, n);
        }
        for (int i = 0; i < n; i += 2) {
            this.readBuffer[n4++] = (char)((this.rawReadBuffer[i] & 0xFF) << n2 | (this.rawReadBuffer[i + 1] & 0xFF) << n3);
            if (this.readBuffer[n4 - 1] != '\r') continue;
            this.sawCR = true;
        }
        this.readBufferLength = n4;
    }

    void copyUcs4ReadBuffer(int n, int n2, int n3, int n4, int n5) throws Exception {
        int n6 = this.readBufferPos;
        if (n > 0 && n % 4 != 0) {
            this.encodingError("number of bytes in UCS-4 encoding not divisible by 4", -1, n);
        }
        for (int i = 0; i < n; i += 4) {
            int n7 = (this.rawReadBuffer[i] & 0xFF) << n2 | (this.rawReadBuffer[i + 1] & 0xFF) << n3 | (this.rawReadBuffer[i + 2] & 0xFF) << n4 | (this.rawReadBuffer[i + 3] & 0xFF) << n5;
            if (n7 < 65535) {
                this.readBuffer[n6++] = (char)n7;
                if (n7 != 13) continue;
                this.sawCR = true;
                continue;
            }
            if (n7 < 1048575) {
                this.readBuffer[n6++] = (char)(0xD8 | (n7 & 0xFFC00) >> 10);
                this.readBuffer[n6++] = (char)(0xDC | n7 & 0x3FF);
                continue;
            }
            this.encodingError("value cannot be represented in UTF-16", n7, i);
        }
        this.readBufferLength = n6;
    }

    void encodingError(String string, int n, int n2) throws Exception {
        if (n >= 0) {
            string = string + " (byte value: 0x" + Integer.toHexString(n) + ')';
        }
        String string2 = this.externalEntity != null ? this.externalEntity.getURL().toString() : this.baseURI;
        this.handler.error(string, string2, -1, n2 + this.currentByteCount);
    }

    void initializeVariables() {
        this.errorCount = 0;
        this.line = 1;
        this.column = 0;
        this.dataBufferPos = 0;
        this.dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.nameBufferPos = 0;
        this.nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.elementInfo = new Hashtable();
        this.entityInfo = new Hashtable();
        this.notationInfo = new Hashtable();
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = new Stack();
        this.entityStack = new Stack();
        this.externalEntity = null;
        this.tagAttributePos = 0;
        this.tagAttributes = new String[100];
        this.rawReadBuffer = new byte[16384];
        this.readBufferOverflow = -1;
        this.context = 0;
        this.symbolTable = new Object[1087];
    }

    void cleanupVariables() {
        this.errorCount = -1;
        this.line = -1;
        this.column = -1;
        this.dataBuffer = null;
        this.nameBuffer = null;
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = null;
        this.externalEntity = null;
        this.entityStack = null;
    }

    static {
        attributeTypeHash.put("CDATA", new Integer(1));
        attributeTypeHash.put("ID", new Integer(2));
        attributeTypeHash.put("IDREF", new Integer(3));
        attributeTypeHash.put("IDREFS", new Integer(4));
        attributeTypeHash.put("ENTITY", new Integer(5));
        attributeTypeHash.put("ENTITIES", new Integer(6));
        attributeTypeHash.put("NMTOKEN", new Integer(7));
        attributeTypeHash.put("NMTOKENS", new Integer(8));
        attributeTypeHash.put("NOTATION", new Integer(10));
        DATA_BUFFER_INITIAL = 4096;
        NAME_BUFFER_INITIAL = 1024;
    }
}

