/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef ICALMAPI_H
#define ICALMAPI_H

#include <mapix.h>
#include <mapidefs.h>
#include <string>
#include <map>
#include "recurrence.h"

using namespace std;


#define ICAL_COMPONENT_VCALENDAR	0x0001
#define ICAL_COMPONENT_VEVENT		0x0002
#define ICAL_COMPONENT_VTODO		0x0004
#define ICAL_COMPONENT_VJOURNAL		0x0008
#define ICAL_COMPONENT_VFREEBUSY	0x0010
#define ICAL_COMPONENT_VTIMEZONE	0x0020
#define ICAL_COMPONENT_VALARM		0x0040
#define ICAL_COMPONENT_MEETING		0x0080
#define ICAL_COMPONENT_ALL			0x00FF

#define ICAL_MAPI_DELETE			0x0001
#define ICAL_MAPI_NOPRIVATE			0x0002
#define ICAL_INCLUDE_METHOD			0x0004

//VEVENT, VTODO, VJOURNAL, VFREEBUSY, VALARM

/*
run "outlook /c ipm.activity" to make a new journal

IPM.Activity			VJOURNAL		text notes with a particular calendar date / logbook
IPM.Appointment			VEVENT			represents a scheduled amount of time on a calendar		
IPM.Task				VTODO			The VTODO component describes a to-do item, i.e., an action-item or assignment.
IPM.Schedule.Meeting.*	VEVENT
		IPM.Schedule.Meeting.Canceled, IPM.Schedule.Meeting.Request, IPM.Schedule.Meeting.Resp.Neg, IPM.Schedule.Meeting.Resp.Pos, IPM.Schedule.Meeting.Resp.Tent
IPM.StickyNote			VJOURNAL?
IPM.Contact				VCARD
*/

// iCalendar uses utf-8 as its standard character encoding

ZARAFA_API HRESULT HrMAPI2iCalendar(LPADRBOOK lpAdrBook, LPMESSAGE lpMessage, map<string, timezone_type*> * lpMapTimeZones, string * strICal, ULONG ulFlags = ICAL_INCLUDE_METHOD, ULONG ulComponentFlags = ICAL_COMPONENT_ALL, std::string strCharset = "utf-8");
ZARAFA_API HRESULT HrMAPI2iCalendar(LPADRBOOK lpAdrBook, IMAPIFolder * lpFolder, string * strICal, ULONG ulFlags = ICAL_INCLUDE_METHOD, ULONG ulComponentFlags = ICAL_COMPONENT_ALL, std::string strCharset = "utf-8");

//	lpParent IMAPIFolder will create messages in the folder and checks for duplicates
//	lpParent IMessage will create attached messages
ZARAFA_API HRESULT HrICalendar2MAPI(const char * szICal, IMAPIProp * lpParent, std::string strCharset = "utf-8", ULONG ulFlags = 0);


#endif //ICALMAPI_H
