<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
":" => " :",
"!" => " !",
"Jan" => "janv.",
"Feb" => "févr.",
"Mar" => "mars",
"Apr" => "avr.",
"Jun" => "juin",
"Jul" => "juill.",
"Aug" => "août",
"Sep" => "sept.",
"Oct" => "oct.",
"Nov" => "nov.",
"Dec" => "déc.",
"%A %d of %B, %Y" => "%A %d %B %Y",
"%a %d of %b, %Y" => "%e/%m/%y",
"%a %d of %b, %Y[%H:%M %Z]" => "%e/%m/%y [%Hh%M]",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d %B %Y [%Hh%M]",
"%B %e" => "%e %B",
"%H:%M:%S %Z" => "%Hh%M",
"\$tailtitle" => "\$tailtitle",
"\$title" => "\$title",
"Female" => "Femme",
"Male" => "Homme",
"OpenID" => "OpenID",
"tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
"UTC" => "UTC",
"the former Yugoslav Republic of Macedonia" => "l'Ex-République yougoslave de Macédoine",
"Republic_of_Serbia" => "République de Serbie",
"Russian Federation" => "Fédération de Russie",
"Site-wide" => "Global",
"Technical" => "Technique",
"UI enhancement" => "Améliorations UI",
"Experimental" => "Expérimentales",
"Major Features" => "Fonctionnalités Principales",
"Minor Features" => "Fonctionnalités mineures",
"Site-wide Features" => "Fonctionnalités globales au site",
"sites" => "sites",
"error" => "erreur",
"~np~{~/np~EVENTS(calendarid=>1,maxdays=>365,max=>-1,datetime=>0|1,desc=>0|1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=>1,maxdays=>365,max=>-1,datetime=>0|1,desc=>0|1)}{EVENTS} Insère la syndication RSS dans une page Wiki",
"Old vers" => "Versions passées",
"date" => "date",
"contacts" => "contacts",
"clip" => "clip",
"cc" => "cc",
"bcc" => "bcc",
"Isle_of_Man" => "Île de Man",
"Phillippines" => "Philippines",
"Can admin article topics" => "Droit d'administrer les sujets d'articles",
"Can admin article types" => "Droit d'administrer les types d'articles",
"sender" => "expéditeur",
"subject" => "sujet",
"flagged" => "avec drapeau",
"mark" => "marquer",
"find replied message" => "trouver les messages répondus",
"replied" => "répondu",
"Click" => "Cliquer",
"posted by" => "publié par",
"email this post" => "envoyer par email cet article",
"Tag name" => "Nom du marqueur",
"Forum for discussion" => "Forum pour les discussions",
"Hide page name prefix" => "Cacher le préfixe des noms de page",
"Name length" => "Longueur du nom",
"Enable wiki 3D browser" => "Permettre le navigateur Wiki 3D",
"Load page on navigation" => "Charger la page à la navigation",
"Existing page node color" => "Couleur du noeud d'une page existante ",
"Missing page node color" => "Couleur du noeud d'une page manquante ",
"Anonymous editors must input anti-bot code" => "Les éditeurs anonymes doivent saisir un code anti-bot",
"View source" => "Voir fichier source",
"MultiPrint" => "Multi-impression",
"Warn on edit conflict" => "Avertir en cas de conflit de modification",
"Edit idle timeout" => "Modifier le timeout d'inactivité",
"Pictures" => "Images",
"Use page description" => "Description d'une page",
"Show page title" => "Afficher le titre de la page",
"Show page ID" => "Montrer l'ID de la page",
"Cache wiki pages (global)" => "Antémémoire globale à toutes les pages Wiki",
"Individual cache" => "Antémémoire individuelle",
"Footnotes" => "Notes de bas de page",
"Users can lock pages (if perm)" => "Les utilisateurs (ayant les droits) peuvent verrouiller une page",
"Use WikiWords" => "Utiliser les MotWikis (NomDePage)",
"Accept dashes and underscores in WikiWords" => "Accepter les tirets et les soulignés dans les MotsWiki",
"Link plural WikiWords to their singular forms" => "Lier les pluriels des MotWikis à leur singulier",
"Use Wiki paragraph formatting" => "Utiliser le wiki pour formatter les paragraphes (insérer &lt;p&gt; pour aller à la ligne)",
"But still create line breaks within paragraphs" => "Crée cependant toujours des sauts de lignes à l'intérieur des paragraphes",
"Automonospaced text" => "Texte à espacement constant sur début de ligne blanc",
"Tables syntax" => "Syntaxe des tables",
"Open page as structure" => "Ouvrir une page en tant que structure",
"Make structure from page" => "Créer une structure avec la page",
"Categorize structure pages together" => "Catégoriser les structures de pages ensemble",
"Create webhelp from structure" => "Créer l'aide web à partir d'une structure",
"Use external link icons" => "Utiliser une icône pour un lien externe",
"User's Page" => "Mes pages",
"UserPage prefix" => "Préfixe de la page utilisateur",
"Page creators are admin of their pages" => "Les créateurs d'une page en sont administrateur",
"Import Page" => "Importer une page",
"List authors" => "Liste des auteurs",
"Protect email against spam" => "Protéger les adresses mails contre les spammeurs",
"When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page" => "Lors de l'appel d'une page, si celle-ci n'existe pas et qu'il existe une page similaire, rediriger automatiquement vers celle-ci",
"Show/hide heading icon displayed before the heading" => "Afficher/masquer l'icône d'en-tête affichée avant l'en-tête",
"Print Page" => "Impression de page",
"Show page version" => "Montrer le numéro de version de la page",
"Page navigation bar position (displayed when page break '...page...' are used)" => "Position de la barre de navigation (affichée lorsque le saut de page '...page...' est utilisé)",
"Regex search and replace" => "Recherche et remplacement avec une expression régulière",
"Edit section" => "Editer la section",
"Maximum number of versions for history" => "Nombre maximum de versions dans l'historique",
"Never delete versions younger than days" => "Ne jamais effacer des versions datant de moins de (jours)",
"IP address displayed in history" => "L'adresse IP est affichée dans l'historique",
"Diff style" => "Style de la comparaison",
"Create watch for author on page creation" => "Activer la surveillance de la page pour l'auteur automatiquement à la création de la page",
"Enable watch events when I am the editor" => "Envoyer une notification de changement même si je suis l'éditeur",
"Enable watches on comments" => "La surveillance d'une page tient compte des commentaires",
"Watch minor" => "Notification mineur",
"Add or edit event" => "Ajouter/modifier un évènement",
"merge selected notes into" => "fusionner les notes sélectionnées dans",
"Faq Stats" => "Statistiques sur les FAQs",
"Edit User Files" => "Modifier les fichiers utilisateur",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Votre message est mis en attente jusqu'à ce qu'il soit approuvé par un modérateur.",
"Webmail Doc" => "Documentation Webmail",
"Webmail Doc template" => "gabarit de la documentation Webmail",
"settings" => "configuration",
"mailbox" => "boîte à lettre",
"compose" => "composer",
"back to mailbox" => "retourner à la boîte à lettre",
"full headers" => "en-têtes complets",
"normal headers" => "en-têtes normaux",
"reply all" => "répondre à tous",
"forward" => "transférer",
"select from address book" => "sélectionner du carnet d'adresses",
" item found" => " fiche trouvée",
" items found" => " fiches trouvées",
"Please login" => "SVP, connectez-vous",
"Transparent" => "Transparent",
"Image (url)" => "Image (url)",
"Dimensions" => "Dimensions",
"You are not the owner of this page" => "Vous n'êtes pas le propriétaire de cette page",
"Name is empty" => "Le nom est vide",
"mypage type unaivalable" => "type mesPages non trouvé",
"window not found" => "fenêtre non trouvée",
"You cannot have more than one windows of this type." => "Vous ne pouvez pas avoir plus d'une fenêtre de ce type.",
"Parameter not found :" => "Paramètrenon trouvé :",
"bad type name" => "mauvais nom de type",
"type class not found" => "classe type non trouvée",
"component name is invalid" => "le nom du composant n'est pas valide",
"component class not found" => "classe du composant introuvable",
"You do not have permission to view this part of content" => "Vous n'avez pas les droits de voir cette partie de contenu",
"Tools" => "Outils",
"Color" => "Coleur",
"Mypages Types" => "Types mesPages",
"Default Dimensions" => "Dimensions par défaut",
"Default background color" => "Couleur de fond par défaut",
"Components" => "Composants",
"No templates" => "Pas de gabarit",
"delete entry" => "supprimer l'entrée",
"Modify" => "Modifier",
"Object Type" => "Type de l'objet",
"Are you sure you want to delete this entry ?" => "Êtes-vous certain de vouloir détruire cette entrée ?",
"Permission assigned to the group" => "Permission assignée au groupe",
"Permission assigned to the group through a category" => "Permission assignée au group via une catégorie",
"Current permissions" => "Permissions actives",
"Group name" => "Groupe",
"Read &amp; write" => "Lecture &amp; Ecriture",
"No specific permission" => "Pas de permission spécifique",
"Apply permissions" => "Appliquer les permissions",
"Additional permissions" => "Permissions additionnelles",
"Add Groups" => "Ajouter un groupe",
"Add Users" => "Ajouter un utilisateur",
"Add to List" => "Ajouter à la liste",
"Share Page" => "Partager une page",
"ajax and mootools features mandatory for that feature" => "les fonctionnalités ajax et mootools sont obligatoires pour cette fonctionnalité",
"can't open mypage" => "ne peut pas ouvrir mapage",
"name already exists" => "le nom existe déjà",
"Window not found" => "Fenêtre non trouvée",
"Without template" => "Sans gabarit",
"Missing parameter on page. objectId and objectType required." => "Paramètre manquant. objectId et objectType sont obligatoires.",
"Then rerun the installer using tiki_1.9to1.10." => "Ensuite, relancer l;installateur avec tiki_1.9to1.10.",
"A wildcard pattern of originating pages to be ignored.<br />" => "Une expression régulière des pages d'origine à ignorer.<br />",
"The character, by which ignored patterns are separated.<br />" => "Le caractère par lequel les patterns ignorés sont séparés.<br />",
"Whether to include external wikis in the list.<br />" => "Inclure ou pas les wikis externes dans la liste.<br />",
"Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Récupérer les pages d'origine ou voulues dans une cellule et afficher les dans une seconde colonne.<br />",
"Switch-on debug output with details about the items.<br />" => "Activer les traces détaillées sur les items.<br />",
"Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Les éléments récupérés multiples sont séparés dans des rangées distinctes, ou par virgule ou retour à la ligne dans une même cellule.<br />",
"Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filtrer la liste des pages voulues selon l'expression régulière ou le filtre local. La valeur par defaut est __current__ page_regex.<br />",
"Use context menus for actions (icons) (only in file galleries yet):" => "Utiliser les menus contextuels pour les actions (icônes) (seulement dans les galeries de fichiers pour l'heure) :",
"Use context menus for actions (text) (only in file galleries yet):" => "Utiliser les menus contextuels pour les actions (texte) (seulement dans les galeries de fichiers pour l'heure) :",
"Restart the installer" => "Redémarrer l'installateur",
"You have completed the TikiWiki installation" => "L'installation de TikiWiki est maintenant achevée",
"You have completed the TikiWiki upgrade" => "L'évolution de TikiWiki est maintenant achevée",
"Use one of these links to continue" => "Utikisez l'un de ces liens pour poursuivre",
"Disable the installation script and enter TikiWiki" => "Désactiver les scripts d'installation et entrer dans TikiWiki",
"Recommended" => "Recommandé",
"Enter TikiWiki <em>without</em> disabling the installation script" => "Entrer dans TikiWiki <em>sans</em> désactiver les scripts d'installation",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it." => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it.",
"Fast Next" => "Vite au suivant",
"First {\$params['itemname']}" => "Premier {\$params['itemname']}",
"Last {\$params['itemname']}" => "Dernier {\$params['itemname']}",
"Next {\$params['itemname']}" => "Suivant {\$params['itemname']}",
"Prev {\$params['itemname']}" => "Précédent {\$params['itemname']}",
// " 0|1|2|3|4|5 0,xsize,ysize. First record :0 for URL in file gal of MP3 only, 1 for URL of FLV in file gal video only , 2 for URL of MP3 or Video in file gal, 3 donwload MP3 only, 4 donwload FLV video only, 5 download FLV or MP3 (default is 0). Second record : X size of flash applet(default is 200) , Y size of flash applet (default is 100) " => " 0|1|2|3|4|5 0,xsize,ysize. First record :0 for URL in file gal of MP3 only, 1 for URL of FLV in file gal video only , 2 for URL of MP3 or Video in file gal, 3 donwload MP3 only, 4 donwload FLV video only, 5 download FLV or MP3 (default is 0). Second record : X size of flash applet(default is 200) , Y size of flash applet (default is 100) ",
// "Sequential auto-increment number:initial_value,prepend,append,itemId: initial_value default is 1, prepend will be displayed before the field, append will be displayed just after, itemId will use the item Id" => "Sequential auto-increment number:initial_value,prepend,append,itemId: initial_value default is 1, prepend will be displayed before the field, append will be displayed just after, itemId will use the item Id",
// "Allow registered user to subscribe to an item. They can add a number of friends." => "Allow registered user to subscribe to an item. They can add a number of friends.",
// "Save changes to annotations" => "Save changes to annotations",
// "Creates an annotation block for an image." => "Creates an annotation block for an image.",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc)}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc)}{ARTICLES}~/np~",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "blogId is mandatory" => "blogId is mandatory",
// "Includes blog posts listing into a wiki page" => "Includes blog posts listing into a wiki page",
// "~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~" => "~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~",
// "remarks text" => "remarks text",
// "Displays text in superscript." => "Displays text in superscript.",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)." => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker).",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields." => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields.",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "A wildcard pattern of originating pages to be ignored." => "A wildcard pattern of originating pages to be ignored.",
// "The character, by which ignored patterns are separated." => "The character, by which ignored patterns are separated.",
// "Whether to include external wikis in the list." => "Whether to include external wikis in the list.",
// "Collect either originating or wanted pages in a cell and display them in the second column." => "Collect either originating or wanted pages in a cell and display them in the second column.",
// "Switch-on debug output with details about the items." => "Switch-on debug output with details about the items.",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell." => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex." => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.",
// "A custom filter for wanted pages to be listed (only used when level=>custom)." => "A custom filter for wanted pages to be listed (only used when level=>custom).",
"Can use the page as a tracker template" => "Peut utiliser une page comme gabarit de formulaire",
// "Can view any mypage" => "Can view any mypage",
// "Can view/edit only one's own mypages" => "Can view/edit only one's own mypages",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}:" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}:",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "More Like This" => "More Like This",
// "List everything tagged" => "List everything tagged",
// "What is OpenID?" => "What is OpenID?",
"in:" => "dans :",
// "Up-to-date-ness" => "Up-to-date-ness",
"Better translations" => "Meilleures traductions",
// "update from it" => "update from it",
// "None match your" => "None match your",
"Set your preferred languages." => "Mettre à jour vos langues préférées.",
"preferred languages" => "langues préférées",
// "Changes that need to be reproduced are highlighted below." => "Changes that need to be reproduced are highlighted below.",
// "Note: if you want to use images please save the post first and you\n\twill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\n\tor use the image URL to include images using the WYSIWYG editor. " => "Note: if you want to use images please save the post first and you\n\twill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\n\tor use the image URL to include images using the WYSIWYG editor. ",
// "Design by" => "Design by",
// "Post level trackback pings" => "Post level trackback pings",
// "Exclude These Category IDs from Path (comma delimited)" => "Exclude These Category IDs from Path (comma delimited)",
// "Site Global Features" => "Site Global Features",
// "Additional Features" => "Additional Features",
// "Search engine friendly url" => "Search engine friendly url",
// "Swffix" => "Swffix",
// "User interface enhancement features" => "User interface enhancement features",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Search method when searching in content: Tiki search local to a forum" => "Search method when searching in content: Tiki search local to a forum",
// "Search method when searching in content: Non-Tiki search local to a forum" => "Search method when searching in content: Non-Tiki search local to a forum",
// "More Like This/Get Similar Module" => "More Like This/Get Similar Module",
// "More Like This algorithm" => "More Like This algorithm",
// "Basic algorithm - Minimum amount of tags in common" => "Basic algorithm - Minimum amount of tags in common",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Quantify change size" => "Quantify change size",
// "Generate a password option" => "Generate a password option",
// "On permission denied, display login box for anonymous:" => "On permission denied, display login box for anonymous:",
// "On permission denied, send to this url:" => "On permission denied, send to this url:",
// "Valid Affiliations (separated by commas)" => "Valid Affiliations (separated by commas)",
// "Site logo background style" => "Site logo background style",
// "Site Login Bar" => "Site Login Bar",
// "Custom code" => "Custom code",
// "Prefix breadcrumbs with 'Location : ' " => "Prefix breadcrumbs with 'Location : ' ",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Use context menus for actions (icons) (only in file galleries yet)" => "Use context menus for actions (icons) (only in file galleries yet)",
// "Use context menus for actions (text) (only in file galleries yet)" => "Use context menus for actions (text) (only in file galleries yet)",
// "Insert freetags in keyword list" => "Insert freetags in keyword list",
// "Use the thread title in Forum pages instead" => "Use the thread title in Forum pages instead",
// "Use the image title in Image gallery pages instead" => "Use the image title in Image gallery pages instead",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Lenght" => "Flash Lenght",
// "Flash Heigth" => "Flash Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Profile repositories" => "Profile repositories",
// "Profiles can be installed from multiple repositories. Enter one repository URL per line." => "Profiles can be installed from multiple repositories. Enter one repository URL per line.",
// "Profile repository status" => "Profile repository status",
// "Profile list" => "Profile list",
// "Repository" => "Repository",
// "Profile" => "Profile",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS modules</strong> menu option, or",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Individual image galleries" => "Individual image galleries",
// "Individual file galleries" => "Individual file galleries",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Refresh files search index now" => "Refresh files search index now",
// "No records" => "No records",
// "Tag name:" => "Tag name:",
// "Default number of comments per page:" => "Default number of comments per page:",
// "Wiki attachments:" => "Wiki attachments:",
// "Use database to store files:" => "Use database to store files:",
// "Use a directory to store files:" => "Use a directory to store files:",
// "Path:" => "Path:",
// "Forum for discussion:" => "Forum for discussion:",
// "Page name display stripper: choose a character that will be used as a delimiter to strip a final part of the page name (only concerns display)" => "Page name display stripper: choose a character that will be used as a delimiter to strip a final part of the page name (only concerns display)",
// "Wiki Page Staging and Approval" => "Wiki Page Staging and Approval",
// "Use wiki page staging and approval:" => "Use wiki page staging and approval:",
// "Unique page name prefix to indicate staging copy:" => "Unique page name prefix to indicate staging copy:",
// "Hide page name prefix:" => "Hide page name prefix:",
// "Category for staging pages:" => "Category for staging pages:",
// "Category for approved pages:" => "Category for approved pages:",
// "Category for pages out of sync:" => "Category for pages out of sync:",
// "Force bounce of editing of approved pages to staging:" => "Force bounce of editing of approved pages to staging:",
// "Categorize approved pages with categories of staging copy on approval:" => "Categorize approved pages with categories of staging copy on approval:",
// "Replace freetags with that of staging pages on approval:" => "Replace freetags with that of staging pages on approval:",
// "Add new freetags of approved copy (into tags field) when editing staging pages:" => "Add new freetags of approved copy (into tags field) when editing staging pages:",
// "Delete staging pages at approval:" => "Delete staging pages at approval:",
// "If not in the group, edit is always redirected to the staging page edit:" => "If not in the group, edit is always redirected to the staging page edit:",
// "Name length:" => "Name length:",
// "Comment length:" => "Comment length:",
// "Description length:" => "Description length:",
// "Default sort order:" => "Default sort order:",
// "Enable wiki 3D browser:" => "Enable wiki 3D browser:",
// "Load page on navigation:" => "Load page on navigation:",
// "Browser width:" => "Browser width:",
// "Browser height:" => "Browser height:",
// "Navigation depth:" => "Navigation depth:",
// "Node size:" => "Node size:",
// "Text size:" => "Text size:",
// "Spring (connection) size:" => "Spring (connection) size:",
// "Existing page node color:" => "Existing page node color:",
// "Missing page node color:" => "Missing page node color:",
// "Camera distance adjusted relative to nearest node:" => "Camera distance adjusted relative to nearest node:",
// "Camera distance:" => "Camera distance:",
// "Field of view:" => "Field of view:",
// "Feed animation interval (milisecs):" => "Feed animation interval (milisecs):",
// "Friction constant:" => "Friction constant:",
// "Elastic constant:" => "Elastic constant:",
// "Eletrostatic constant:" => "Eletrostatic constant:",
// "Node mass:" => "Node mass:",
// "Node charge:" => "Node charge:",
// "Sandbox:" => "Sandbox:",
// "Anonymous editors must input anti-bot code:" => "Anonymous editors must input anti-bot code:",
// "Last changes:" => "Last changes:",
// "Dump:" => "Dump:",
// "Export:" => "Export:",
// "Rating:" => "Rating:",
// "History:" => "History:",
// "View source:" => "View source:",
// "List pages:" => "List pages:",
// "Backlinks:" => "Backlinks:",
// "Similar:" => "Similar:",
// "Rankings:" => "Rankings:",
// "Undo:" => "Undo:",
// "Save Draft:" => "Save Draft:",
// "MultiPrint:" => "MultiPrint:",
// "Comments:" => "Comments:",
// "Spellchecking:" => "Spellchecking:",
// "Use templates:" => "Use templates:",
// "Warn on edit conflict:" => "Warn on edit conflict:",
// "Edit idle timeout:" => "Edit idle timeout:",
// "Pictures:" => "Pictures:",
// "Show page title:" => "Show page title:",
// "Show page ID:" => "Show page ID:",
// "Cache wiki pages (global):" => "Cache wiki pages (global):",
// "Individual cache:" => "Individual cache:",
// "Footnotes:" => "Footnotes:",
// "Users can lock pages (if perm):" => "Users can lock pages (if perm):",
// "Use WikiWords:" => "Use WikiWords:",
// "Accept dashes and underscores in WikiWords:" => "Accept dashes and underscores in WikiWords:",
// "Link plural WikiWords to their singular forms:" => "Link plural WikiWords to their singular forms:",
// "Use Wiki paragraph formatting:" => "Use Wiki paragraph formatting:",
// "But still create line breaks within paragraphs:" => "But still create line breaks within paragraphs:",
// "Automonospaced text:" => "Automonospaced text:",
// "Tables syntax:" => "Tables syntax:",
// "Uses Slideshow:" => "Uses Slideshow:",
// "Open page as structure:" => "Open page as structure:",
// "Make structure from page:" => "Make structure from page:",
// "Categorize structure pages together:" => "Categorize structure pages together:",
// "Create webhelp from structure:" => "Create webhelp from structure:",
// "Use external link icons:" => "Use external link icons:",
// "User's Page:" => "User's Page:",
// "UserPage prefix:" => "UserPage prefix:",
// "Page creators are admin of their pages:" => "Page creators are admin of their pages:",
// "Import HTML:" => "Import HTML:",
// "Import Page:" => "Import Page:",
// "Protect email against spam:" => "Protect email against spam:",
// "When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page:" => "When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page:",
// "Show/hide heading icon displayed before the heading:" => "Show/hide heading icon displayed before the heading:",
// "Force and limit categorization to within subtree of:" => "Force and limit categorization to within subtree of:",
// "Print Page:" => "Print Page:",
// "Allow HTML:" => "Allow HTML:",
// "Show page version:" => "Show page version:",
// "Page navigation bar position (displayed when page break '...page...' are used):" => "Page navigation bar position (displayed when page break '...page...' are used):",
// "Wiki actions bar position (e.g. Save, Preview, Cancel, ...):" => "Wiki actions bar position (e.g. Save, Preview, Cancel, ...):",
// "Regex search and replace:" => "Regex search and replace:",
// "Edit section:" => "Edit section:",
// "Log bytes changes (+/-) in Action Logs (slows each page modifications)" => "Log bytes changes (+/-) in Action Logs (slows each page modifications)",
// "Maximum number of versions for history:" => "Maximum number of versions for history:",
// "Never delete versions younger than days:" => "Never delete versions younger than days:",
// "IP address displayed in history:" => "IP address displayed in history:",
// "Diff style:" => "Diff style:",
"Create watch for author on page creation:" => "Mettre automatiquement l'auteur en surveillance dés qu'une page est créée :",
"Enable watch events when I am the editor:" => "Surveiller ces propres modifications :",
"Enable watches on comments:" => "Surveiller les commentaires :",
"Watch minor:" => "Surveiller les modifications mineures :",
"Reopen with the same editor" => "Réouvrir avec le même éditeur",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot:" => "Group Bar Plot:",
// "Accumulated Bar Plot:" => "Accumulated Bar Plot:",
// "Custom URL" => "Custom URL",
"Use in" => "Utilisé dans",
// "No features are configured to use templates." => "No features are configured to use templates.",
// "Admin FortuneCookie tpl" => "Admin FortuneCookie tpl",
// "Admin external wikis" => "Admin external wikis",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "show threads preferences" => "show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'." => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'.",
// "To use a menu in a tiki format: " => "To use a menu in a tiki format: ",
// "To use menu in a css/suckerfish format: " => "To use menu in a css/suckerfish format: ",
// "Path to the folder icon for close sections" => "Path to the folder icon for close sections",
// "Example:" => "Example:",
// "Provide also a folder icon for open sections with the same name with the letter 'o' before in the same directory (ex: folder.png and ofolder.png)" => "Provide also a folder icon for open sections with the same name with the letter 'o' before in the same directory (ex: folder.png and ofolder.png)",
// "Default:" => "Default:",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Separator between params:'&'. E.g. maxlen=15&nonums=y." => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Separator between params:'&'. E.g. maxlen=15&nonums=y.",
// "The" => "The",
// "setting will override your selection of specific groups." => "setting will override your selection of specific groups.",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules." => "to make sure users will notice any newly assigned modules.",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Preload Admin Account" => "Preload Admin Account",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "RSS channels" => "RSS channels",
// "View feed" => "View feed",
// "Security checks" => "Security checks",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"." => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\".",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content." => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content.",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information." => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information.",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes!" => "Inodes that are not files or directories are not part of tiki. Review these Inodes!",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod." => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod.",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directories to save:" => "Directories to save:",
// "admin Tracker fields tpl" => "admin Tracker fields tpl",
// "edit" => "edit",
// "Description text is tiki-parsed:" => "Description text is tiki-parsed:",
// "Use Ratings:" => "Use Ratings:",
// "ItemId" => "ItemId",
// "timestamp" => "timestamp",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)." => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>).",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Use site default" => "Use site default",
// "Need to validate email" => "Need to validate email",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Network of Tags related to" => "Network of Tags related to",
// "More Popular Tags" => "More Popular Tags",
// "Categories checking is not done in the database search." => "Categories checking is not done in the database search.",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>." => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>.",
// "The following site was added, but may require validation by the admin before appearing on the lists." => "The following site was added, but may require validation by the admin before appearing on the lists.",
// "Use Ctrl+Click to select multiple categories." => "Use Ctrl+Click to select multiple categories.",
// "Perform action with selected:" => "Perform action with selected:",
// "No records." => "No records.",
// "Or, create a new zone" => "Or, create a new zone",
// "Movie URL" => "Movie URL",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)." => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox).",
// "imalign, height, width, desc, link, rel, title, usemap, class and align are optional" => "imalign, height, width, desc, link, rel, title, usemap, class and align are optional",
// "Plugins" => "Plugins",
// "Plugin" => "Plugin",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "The following pages added have automatically been categorized with the same categories as the structure:" => "The following pages added have automatically been categorized with the same categories as the structure:",
// "Language of newly translated page" => "Language of newly translated page",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "Change language for this page" => "Change language for this page",
// "Select from available options..." => "Select from available options...",
// "Change Language" => "Change Language",
// "No language is assigned to this page." => "No language is assigned to this page.",
// "Please select a language before performing translation." => "Please select a language before performing translation.",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Update '{\$page}' based on '{\$source_page}'" => "Update '{\$page}' based on '{\$source_page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval." => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval.",
// "This is a new staging page that has not been approved before." => "This is a new staging page that has not been approved before.",
// "The current staging copy may contain changes that have yet to be approved." => "The current staging copy may contain changes that have yet to be approved.",
// "View changes since last approval." => "View changes since last approval.",
// "You are editing the approved copy of this page." => "You are editing the approved copy of this page.",
// "There are currently changes in the staging copy that have yet to be approved." => "There are currently changes in the staging copy that have yet to be approved.",
// "the staging copy" => "the staging copy",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer." => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer.",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Replace to" => "Replace to",
// "Translation request" => "Translation request",
// "Add FAQ question" => "Add FAQ question",
"No records to display" => "Aucun enregistrement à afficher",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag." => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag.",
// "Until then, they cannot be translated." => "Until then, they cannot be translated.",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Cancel friendship request" => "Cancel friendship request",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Success" => "Success",
// "Please enter your database connection information" => "Please enter your database connection information",
// "Select the type of database to use with Tiki." => "Select the type of database to use with Tiki.",
// "Enter the hostname or IP for your database. Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Enter the hostname or IP for your database. Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Enter the name of the database that Tiki will use." => "Enter the name of the database that Tiki will use.",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your\nhosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your\nhosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database User" => "Database User",
// "Enter the database user with administrator permission for the Database" => "Enter the database user with administrator permission for the Database",
// "Enter the password for the database user" => "Enter the password for the database user",
// "Welcome to the installation{if \$tikidb_created} &amp; upgrade{/if} script!" => "Welcome to the installation{if \$tikidb_created} &amp; upgrade{/if} script!",
// "No profiles available." => "No profiles available.",
// "See the documentation for <a target=\"_blank\" href=\"http://doc.tikiwiki.org/Profiles\" class=\"link\" title=\"{tr}Description of available profiles." => "See the documentation for <a target=\"_blank\" href=\"http://doc.tikiwiki.org/Profiles\" class=\"link\" title=\"{tr}Description of available profiles.",
// "Then rerun the installer using tiki_1.9to2.0." => "Then rerun the installer using tiki_1.9to2.0.",
// "See <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions" => "See <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions",
// "For information about <strong>tiki-secdb_*.sql</strong> files, please see <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin" => "For information about <strong>tiki-secdb_*.sql</strong> files, please see <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin",
// "operations executed successfully" => "operations executed successfully",
// "Operations failed" => "Operations failed",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages." => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages.",
// "Memory" => "Memory",
// "Change the administrator password" => "Change the administrator password",
// "Continue in installer" => "Continue in installer",
// "Orphan" => "Orphan",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block." => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block.",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl." => "Backl.",
// "User forum topics" => "User forum topics",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Used to update" => "Used to update",
// "Top Voted Polls" => "Top Voted Polls",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Add Structure Pages" => "Add Structure Pages",
// "Received Structures" => "Received Structures",
// "Prefix the checked:" => "Prefix the checked:",
// "Postfix the checked:" => "Postfix the checked:",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page." => "the approved version of this page.",
// "Viewing of changes since last approval is possible only after first approval." => "Viewing of changes since last approval is possible only after first approval.",
// "Latest changes will be synchronized after approval." => "Latest changes will be synchronized after approval.",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time." => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time.",
// "{icon _id=information.png style=\"vertical-align:middle\"} Content may be out of date" => "{icon _id=information.png style=\"vertical-align:middle\"} Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages:" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages:",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request:" => "Request:",
// "Element to compare (Xpath expression):" => "Element to compare (Xpath expression):",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "Notice" => "Notice",
// "PECL HTPP extension present" => "PECL HTPP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTPP and cURL extension not present. Replay of the TikiTest will not be possible." => "PECL HTPP and cURL extension not present. Replay of the TikiTest will not be possible.",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "File Name:" => "File Name:",
// "Start Recording Test" => "Start Recording Test",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "0 for no limit" => "0 for no limit",
// "No gallery available." => "No gallery available.",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
"Currently waiting for user approval" => "En attente d'approbation",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
"Your preferred language" => "Votre langue préférée",
"Can you read more languages?" => "Vous pouvez lire plus de langues?",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
"Select language..." => "Choisir une langue...",
// "Use \"watches\" to monitor wiki pages or other objects." => "Use \"watches\" to monitor wiki pages or other objects.",
// "Watch new items by clicking the {icon _id=eye} button on specific pages." => "Watch new items by clicking the {icon _id=eye} button on specific pages.",
// "watched events" => "watched events",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Watch language wiki page creations" => "Watch language wiki page creations",
// "Editing" => "Editing",
// "Post New" => "Post New",
"Tracker:" => "Formulaire :",
// "Format : x,y,zoom - You can use Google Map Locator in the item view script." => "Format : x,y,zoom - You can use Google Map Locator in the item view script.",
// "Google Map Locator" => "Google Map Locator",
"List authors:" => "Liste des auteurs :",
// "Complete Translation" => "Complete Translation",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available." => "A new %s  major release branch is available.",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Deleted account %s" => "Deleted account %s",
// "Image annotations changed." => "Image annotations changed.",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Last modifications to the blog." => "Last modifications to the blog.",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "You have mistyped the anti-bot verification code; please try again. " => "You have mistyped the anti-bot verification code; please try again. ",
// "You cannot download this file right now. Your score is low or file limit was reached." => "You cannot download this file right now. Your score is low or file limit was reached.",
// "Page is a staging copy. Translation must begin from the approved copy." => "Page is a staging copy. Translation must begin from the approved copy.",
// "The translation set already contains a page in this language." => "The translation set already contains a page in this language.",
// "Last replied forum topics" => "Last replied forum topics",
"Not supported yet." => "Pas encore supporté.",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "I have canceled my friendship request." => "I have canceled my friendship request.",
// "%s - Version %d of this page has been saved by %s." => "%s - Version %d of this page has been saved by %s.",
// "The selected account is not associated with your identity." => "The selected account is not associated with your identity.",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "An error as occured with the mapfile: " => "An error as occured with the mapfile: ",
// "map edit" => "map edit",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password." => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password.",
// "to the email " => "to the email ",
// "You cannot rename staging pages. Please rename the approved page instead." => "You cannot rename staging pages. Please rename the approved page instead.",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
"Report to the Webmaster" => "Signaler à l'administrateur du site",
"You must lock the file before editing it" => "Vous devez vérouiller ce fichier avant de le modifier",
"Password has been changed" => "Le mot de passe a été changé",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again." => "You must suggest a question; please try again.",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "TikiTests Edit" => "TikiTests Edit",
// "You are about to delete a TikiTest file, do you want to continue ?" => "You are about to delete a TikiTest file, do you want to continue ?",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"ID" => "ID",
"Type" => "Type",
"Description" => "Description",
"Afghanistan" => "Afghanistan",
"Angola" => "Angola",
"Anguilla" => "Anguilla",
"Antigua" => "Antigua",
"Aruba" => "Aruba",
"Bahamas" => "Bahamas",
"Bangladesh" => "Bangladesh",
"Belize" => "Belize",
"Botswana" => "Botswana",
"Brunei" => "Brunei",
"Burkina Faso" => "Burkina Faso",
"Burundi" => "Burundi",
"Canada" => "Canada",
"Congo" => "Congo",
"Costa Rica" => "Costa Rica",
"Cuba" => "Cuba",
"Djibouti" => "Djibouti",
"Europe" => "Europe",
"France" => "France",
"Gabon" => "Gabon",
"Ghana" => "Ghana",
"Gibraltar" => "Gibraltar",
"Guadeloupe" => "Guadeloupe",
"Guam" => "Guam",
"Guatemala" => "Guatemala",
"Guyana" => "Guyana",
"Honduras" => "Honduras",
"Hong Kong" => "Hong Kong",
"Iran" => "Iran",
"Iraq" => "Iraq",
"Jersey" => "Jersey",
"Kazakstan" => "Kazakstan",
"Kenya" => "Kenya",
"Kiribati" => "Kiribati",
"Laos" => "Laos",
"Lesotho" => "Lesotho",
"Liechtenstein" => "Liechtenstein",
"Macao" => "Macao",
"Madagascar" => "Madagascar",
"Malawi" => "Malawi",
"Maldives" => "Maldives",
"Mali" => "Mali",
"Martinique" => "Martinique",
"Mayotte" => "Mayotte",
"Monaco" => "Monaco",
"Montserrat" => "Montserrat",
"Mozambique" => "Mozambique",
"Myanmar" => "Myanmar",
"Nauru" => "Nauru",
"Nicaragua" => "Nicaragua",
"Niger" => "Niger",
"Nigeria" => "Nigeria",
"Niue" => "Niue",
"Oman" => "Oman",
"Pakistan" => "Pakistan",
"Palestine" => "Palestine",
"Panama" => "Panama",
"Paraguay" => "Paraguay",
"Philippines" => "Philippines",
"Portugal" => "Portugal",
"Rwanda" => "Rwanda",
"Samoa" => "Samoa",
"Seychelles" => "Seychelles",
"Sierra Leone" => "Sierra Leone",
"Sri Lanka" => "Sri Lanka",
"St Vincent Grenadines" => "St Vincent Grenadines",
"Swaziland" => "Swaziland",
"Taiwan" => "Taiwan",
"Togo" => "Togo",
"Tokelau" => "Tokelau",
"Tonga" => "Tonga",
"Tuvalu" => "Tuvalu",
"Ukraine" => "Ukraine",
"Uruguay" => "Uruguay",
"Vanuatu" => "Vanuatu",
"Vatican" => "Vatican",
"Venezuela" => "Venezuela",
"Zimbabwe" => "Zimbabwe",
"Catalan" => "Catalan",
"Fijian" => "Fijian",
"Tuvaluan" => "Tuvaluan",
"Wiki" => "Wiki",
"Articles" => "Articles",
"Forums" => "Forums",
"FAQs" => "FAQs",
"article" => "article",
"faq" => "faq",
"forum" => "forum",
"newsletter" => "newsletter",
"image" => "image",
"Page" => "Page",
"Contributions" => "Contributions",
"menu" => "menu",
"Score" => "Score",
"Pages" => "Pages",
"Image" => "Image",
"Article" => "Article",
"FAQ" => "FAQ",
"Forum" => "Forum",
"Simple" => "Simple",
"mins" => "mins",
"min" => "min",
"secs" => "secs",
"sec" => "sec",
"km" => "km",
"wiki" => "wiki",
"forums" => "forums",
"index" => "index",
"%d points" => "%d points",
"Item" => "Item",
"max" => "max",
"jscalendar" => "jscalendar",
"action" => "action",
"multimedia" => "multimedia",
"Message" => "Message",
"Division" => "Division",
"Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
"Date" => "Date",
"~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
"code" => "code",
"minutes" => "minutes",
"equation" => "equation",
"description" => "description",
"(version 3)" => "(version 3)",
"(version 2)" => "(version 2)",
"(version 1)" => "(version 1)",
", " => ", ",
"Plugin " => "Plugin ",
"id" => "id",
"desc" => "desc",
"Version" => "Version",
"debug" => "debug",
"Actions" => "Actions",
"Messages" => "Messages",
"Style" => "Style",
"Copyrights" => "Copyrights",
"Total" => "Total",
"podcast (audio)" => "podcast (audio)",
"podcast (video)" => "podcast (video)",
"Archives" => "Archives",
"Tags" => "Tags",
"RSS Wiki" => "RSS Wiki",
"RSS Articles" => "RSS Articles",
"RSS Forums" => "RSS Forums",
"Information" => "Information",
"Contribution" => "Contribution",
"Pan" => "Pan",
"Action" => "Action",
"messages" => "messages",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"OK" => "OK",
"Normal" => "Normal",
"CC" => "CC",
"BCC" => "BCC",
"Archive" => "Archive",
"Cc" => "Cc",
"\$tpl_module_title" => "\$tpl_module_title",
"Modules" => "Modules",
"Menus" => "Menus",
"Mail-in" => "Mail-in",
"phpinfo" => "phpinfo",
"Menu" => "Menu",
"Webmail" => "Webmail",
"Workflow" => "Workflow",
"Structures" => "Structures",
"DSN" => "DSN",
"\$module_title" => "\$module_title",
"\$modcattitle" => "\$modcattitle",
"Sites" => "Sites",
"\$type" => "\$type",
"Standard" => "Standard",
"Images" => "Images",
"`\$slvn_info.label`" => "`\$slvn_info.label`",
"[-]" => "[-]",
"page" => "page",
"Source" => "Source",
"structures" => "structures",
"Copyright" => "Copyright",
"minute" => "minute",
"Important" => "Important",
"pages" => "pages",
"URI" => "URI",
"Test" => "Test",
"RSS" => "RSS",
"Intertiki" => "Intertiki",
"InterTiki" => "InterTiki",
"Freetags" => "Freetags",
"i18n" => "i18n",
"Module" => "Module",
"Look &amp; Feel" => "Look &amp; Feel",
"Multimedia" => "Multimedia",
"Points" => "Points",
"JsCalendar" => "JsCalendar",
"1 minute" => "1 minute",
"5 minutes" => "5 minutes",
"10 minutes" => "10 minutes",
"15 minutes" => "15 minutes",
"30 minutes" => "30 minutes",
"Visible" => "Visible",
"Img" => "Img",
"Distance" => "Distance",
"Ajax" => "Ajax",
"PHPLayers" => "PHPLayers",
"Shadowbox" => "Shadowbox",
"Mootools" => "Mootools",
"Mobile" => "Mobile",
"TikiTests" => "TikiTests",
"6" => "6",
"7" => "7",
"8" => "8",
"9" => "9",
"pixels" => "pixels",
"Parent" => "Parent",
"Unix" => "Unix",
"Windows" => "Windows",
"Log SQL:" => "Log SQL:",
"(standard)" => "(standard)",
"port" => "port",
"IP" => "IP",
"Contact" => "Contact",
"Wysiwyg" => "Wysiwyg",
"Shibboleth" => "Shibboleth",
"PEAR::Auth" => "PEAR::Auth",
"LDAP" => "LDAP",
"Version 1.0" => "Version 1.0",
"Version 2.0" => "Version 2.0",
"image/png" => "image/png",
"image/bmp" => "image/bmp",
"image/x-icon" => "image/x-icon",
"Geourl" => "Geourl",
"geo.position" => "geo.position",
"geo.region" => "geo.region",
"geo.placename" => "geo.placename",
"Robots" => "Robots",
"Configuration" => "Configuration",
"Documentation" => "Documentation",
"Expiration" => "Expiration",
"Quota (Mb)" => "Quota (Mb)",
"latin" => "latin",
"Versions" => "Versions",
"Mods" => "Mods",
"kb" => "kb",
"contribution" => "contribution",
"mns" => "mns",
"Sections" => "Sections",
"Loc" => "Loc",
"Participants" => "Participants",
"Cat" => "Cat",
"Lang" => "Lang",
"Prio" => "Prio",
"Perso" => "Perso",
"h" => "h",
"Custom background color" => "Custom background color",
"Items" => "Items",
"Ver" => "Ver",
"Section" => "Section",
"Avatar" => "Avatar",
"Max:" => "Max:",
"Date (desc)" => "Date (desc)",
"Date (asc)" => "Date (asc)",
"Score (desc)" => "Score (desc)",
"Coms" => "Coms",
"..." => "...",
"Zone" => "Zone",
"zone" => "zone",
"Regex" => "Regex",
"Position" => "Position",
"Port" => "Port",
"mn" => "mn",
"option" => "option",
"Options" => "Options",
"phpLayersMenus" => "phpLayersMenus",
"Option" => "Option",
"Votes" => "Votes",
"type" => "type",
"special" => "special",
"uid" => "uid",
"gid" => "gid",
"suid" => "suid",
"sgid" => "sgid",
"r" => "r",
"w" => "w",
"PDF" => "PDF",
"Alias" => "Alias",
"Question" => "Question",
"Questions" => "Questions",
"question" => "question",
"Table" => "Table",
"Public" => "Public",
"UTF-8" => "UTF-8",
"ISO-8859-1" => "ISO-8859-1",
"Info" => "Info",
"TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
"popup" => "popup",
"Stop" => "Stop",
"Direction" => "Direction",
"Zoom" => "Zoom",
"+" => "+",
"Contacts" => "Contacts",
"Structure" => "Structure",
"cType" => "cType",
"Client" => "Client",
"Pixels" => "Pixels",
"Format" => "Format",
"Indentation" => "Indentation",
"col" => "col",
"page|desc" => "page|desc",
"table" => "table",
"hr" => "hr",
"Original" => "Original",
"points" => "points",
"%" => "%",
"Page alias" => "Page alias",
"votes" => "votes",
"normal" => "normal",
"interactive" => "interactive",
"Minutes" => "Minutes",
"Int" => "Int",
"Interactive" => "Interactive",
"#" => "#",
"inter" => "inter",
"route" => "route",
"Code" => "Code",
"act" => "act",
"val" => "val",
"Instance" => "Instance",
"Workitems" => "Workitems",
"exception" => "exception",
"If:SetNextact" => "If:SetNextact",
"Proc" => "Proc",
"auto" => "auto",
"int" => "int",
"Instances" => "Instances",
"Exceptions" => "Exceptions",
"instance" => "instance",
"Imgs" => "Imgs",
"Portrait" => "Portrait",
"Horizontal" => "Horizontal",
"Vertical" => "Vertical",
"ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
"MultiTiki" => "MultiTiki",
"Installation" => "Installation",
"hist" => "hist",
"v" => "v",
"Impressions" => "Impressions",
"Modifications" => "Modifications",
"/" => "/",
"Distance (km)" => "Distance (km)",
"Vers." => "Vers.",
"Lang." => "Lang.",
"msgs" => "msgs",
"Prefs" => "Prefs",
"Attention" => "Attention",
"licence" => "licence",
"Msgs" => "Msgs",
"Newsgroup" => "Newsgroup",
"quota" => "quota",
"s=source" => "s=source",
"Prologue:" => "Prologue:",
"Site" => "Site",
"tikiwiki.org" => "tikiwiki.org",
"Faqs" => "Faqs",
"Debug" => "Debug",
"Mb" => "Mb",
"SysLog" => "SysLog",
"Config" => "Config",
"top" => "top",
"taskId" => "taskId",
"Pos" => "Pos",
"Mode" => "Mode",
"chg" => "chg",
"info/vote" => "info/vote",
"Dif" => "Dif",
"Q" => "Q",
"1 suggestion" => "1 suggestion",
"suggestions" => "suggestions",
"pts" => "pts",
"Msg" => "Msg",
"Administration" => "Administration",
"beige" => "beige",
"The file does not have the required header:" => "The file does not have the required header:",
"TOP" => "TOP",
"Remove file: " => "Remove file: ",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Cette fonctionnalité est désactivée",
"Permission denied you cannot view pages" => "Droit d'accès refusé : vous ne pouvez pas afficher de pages",
"Cannot write to this file:" => "Ne peut pas écrire ce fichier :",
"Cannot upload this file maximum upload size exceeded" => "Envoi du fichier impossible - taille maximale dépassée",
"Your post has not been posted" => "Votre publication n'a pas été publiée",
"Cookies must be allowed to vote" => "Les cookies doivent être autorisés pour pouvoir voter",
"Re:" => "Re :",
"You have mistyped the anti-bot verification code; please try again." => "Vous avez mal tapé le code anti-bot; recommencez SVP",
"This forum is flat and doesn't allow replies to other replies" => "Ce Forum ne permet répondre individuellement aux réponses.",
"Missing title or body when trying to post a comment" => "Titre ou contenu manquant pour publier un commentaire",
"A contribution is mandatory" => "Une contribution est obligatoire",
"You do not have permission to use this feature" => "Vous n'avez pas le droit d'utiliser cette fonctionnalité.",
"This script cannot be called directly" => "Ce script ne peut pas être appelé directement",
"The copyright management feature is not enabled." => "La fonctionnalité copyright n'est pas activée.",
"Copyright management" => "Gestion du copyright",
"No page indicated" => "Aucune page indiquée",
"You must supply all the information, including title and year." => "Vous devez fournir toutes les informations, y compris titre et année.",
"This feature is for admins only" => "Cette fonctionnalité est réservée aux administrateurs",
"Name" => "Nom",
"Size" => "Taille",
"Created" => "Créé",
"Uploaded" => "Envoyé",
"Last Modified" => "Dernière modification",
"Creator" => "Créateur",
"Author" => "Auteur",
"Last editor" => "Dernier éditeur",
"Comment" => "Commentaire",
"Files" => "Fichiers",
"Hits" => "Visites",
"Locked by" => "Verrouillé par",
"Explorer" => "Explorateur",
"Path" => "Chemin d'accès",
"The text in RED is" => "Le texte en rouge est",
"character(s) too long - please edit it." => "caractère(s) trop long - SVP, modifiez-le.",
"Aland Islands" => "Îles Aland",
"Albania" => "Albanie",
"Algeria" => "Algérie",
"American Samoa" => "Samoa",
"Andorra" => "Andorre",
"Antarctica" => "Antartique",
"Argentina" => "Argentine",
"Armenia" => "Arménie",
"Australia" => "Australie",
"Austria" => "Autriche",
"Azerbaijan" => "Azerbaïdjan",
"Bahrain" => "Bahreïn",
"Barbados" => "Barbade",
"Belarus" => "Biélorussie",
"Belgium" => "Belgique",
"Benin" => "Bénin",
"Bermuda" => "Bermudes",
"Bhutan" => "Bhoutan",
"Bolivia" => "Bolivie",
"Bosnia and Herzegovina" => "Bosnie-Herzégovine",
"Bouvet Island" => "Île Bouvet",
"Brazil" => "Brésil",
"British Indian Ocean Territory" => "Territoire britannique de l'océan Indien",
"British Virgin Islands" => "Îles Vierges britanniques",
"Bulgaria" => "Bulgarie",
"Cambodia" => "Cambodge",
"Cameroon" => "Cameroun",
"Cape Verde" => "Cap-Vert",
"Catalan Countries" => "Pays_catalans",
"Cayman Islands" => "Îles Caïmans",
"Central African Republic" => "République centrafricaine",
"Chad" => "Tchad",
"Chile" => "Chili",
"China" => "Chine",
"Christmas Island" => "Île Christmas",
"Cocos Islands" => "Île Cocos",
"Colombia" => "Colombie",
"Comoros" => "Comores",
"Congo Democratic" => "Congo démocratique",
"Cook Islands" => "Îles Cook",
"Croatia" => "Croatie",
"Cyprus" => "Chypre",
"Czech Republic" => "République tchèque",
"Denmark" => "Danemark",
"Dominica" => "Dominique",
"Dominican Republic" => "République dominicaine",
"Ecuador" => "Equateur",
"Egypt" => "Egypte",
"El Salvador" => "Salvador",
"Equatorial Guinea" => "Guinée équatoriale",
"Eritrea" => "Erythrée",
"Estonia" => "Estonie",
"Ethiopia" => "Ethiopie",
"Falkland Islands" => "Îles Malouines",
"Faroe Islands" => "Îles Féroé",
"Federated States of Micronesia" => "États fédérés de Micronésie",
"Fiji" => "Fidji",
"Finland" => "Finlande",
"French Guiana" => "Guyane",
"French Polynesia" => "Polynésie française",
"French Southern Territories" => "Terres australes et antarctiques françaises",
"Gambia" => "Gambie",
"Georgia" => "Géorgie",
"Germany" => "Allemagne",
"Greece" => "Grèce",
"Greenland" => "Groenland",
"Grenada" => "Grenade",
"Guernsey" => "Guernesey",
"Guinea" => "Guinée",
"Guinea Bissau" => "Guinée-Bissao",
"Haiti" => "Haïti",
"Heard Island and McDonald Islands" => "Île Heard et îles McDonald",
"Hungary" => "Hongrie",
"Iceland" => "Islande",
"India" => "Inde",
"Indonesia" => "Indonésie",
"Ireland" => "Irlande",
"Isle of Man" => "Ile de Man",
"Israel" => "Israël",
"Italy" => "Italie",
"Ivory Coast" => "Côte d'Ivoire",
"Jamaica" => "Jamaïque",
"Japan" => "Japon",
"Jordan" => "Jordanie",
"Kuwait" => "Koweït",
"Kyrgyzstan" => "Kirghizistan",
"Latvia" => "Lettonie",
"Lebanon" => "Liban",
"Liberia" => "Libéria",
"Libya" => "Libye",
"Lithuania" => "Lituanie",
"Luxemburg" => "Luxembourg",
"Macedonia" => "Macédoine",
"Malaysia" => "Malaisie",
"Malta" => "Malte",
"Marshall Islands" => "Îles Marshall",
"Mauritania" => "Mauritanie",
"Mauritius" => "Mauritanie",
"Mexico" => "Mexique",
"Moldova" => "Moldavie",
"Mongolia" => "Mongolie",
"Montenegro" => "Monténégro",
"Morocco" => "Maroc",
"Namibia" => "Namibie",
"Nepal" => "Népal",
"Netherlands" => "Pays-Bas",
"Netherlands Antilles" => "Antilles néerlandaises",
"New Caledonia" => "Nouvelle_Calédonie",
"New Zealand" => "Nouvelle_Zélande",
"None" => "Aucun",
"Norfolk Island" => "Île Norfolk",
"Northern Mariana Islands" => "Îles Mariannes du Nord",
"North Korea" => "Corée du Nord",
"Norway" => "Norvège",
"Other" => "Autre",
"Palau" => "Palaos",
"Papua New Guinea" => "Papouasie - Nouvelle - Guinée",
"Peru" => "Pérou",
"Pitcairn" => "Îles Pitcairn",
"Poland" => "Pologne",
"Puerto Rico" => "Porto Rico",
"Quatar" => "Qatar",
"Republic of Macedonia" => "République de Macédoine",
"Reunion" => "Réunion",
"Romania" => "Roumanie",
"Russia" => "Russie",
"Saint Helena" => "Sainte-Hélène",
"Saint Kitts and Nevis" => "Saint-Christophe-et-Niévès",
"Saint Lucia" => "Sainte-Lucie",
"Saint Pierre and Miquelon" => "Saint Pierre et Miquelon",
"San Marino" => "Saint-Marin",
"Sao Tome and Principe" => "São Tomé-et-Principe",
"Saudi Arabia" => "Arabie Saoudite",
"Senegal" => "Sénégal",
"Serbia" => "Serbie",
"Singapore" => "Singapour",
"Slovakia" => "Slovaquie",
"Slovenia" => "Slovénie",
"Solomon Islands" => "Îles Salomon",
"Somalia" => "Somalie",
"South Africa" => "Afrique du Sud",
"South Georgia and South Sandwich Islands" => "Géorgie du Sud et les îles Sandwich du Sud",
"South Korea" => "Corée du Sud",
"Spain" => "Espagne",
"Sudan" => "Soudan",
"Surinam" => "Suriname",
"Svalbard and Jan Mayen" => "Svalbard et Jan Mayen",
"Sweden" => "Suède",
"Switzerland" => "Suisse",
"Syria" => "Syrie",
"Tajikistan" => "Tadjikistan",
"Tanzania" => "Tanzanie",
"Thailand" => "Thaïlande",
"Timor-Leste" => "Timor oriental",
"Trinidad Tobago" => "Trinité-et-Tobago",
"Tunisia" => "Tunisie",
"Turkey" => "Turquie",
"Turkmenistan" => "Turkménistan",
"Turks and Caicos Islands" => "Îles Turques et Caïques",
"Uganda" => "Ouganda",
"United Arab Emirates" => "Émirats arabes unis",
"United Kingdom" => "Royaume-Uni",
"United Nations Organization" => "Organisation des Nations Unies",
"United States" => "États-Unis",
"United States Minor Outlying Islands" => "Îles mineures éloignées des États-Unis",
"US Virgin Islands" => "Îles Vierges américaines",
"Uzbekistan" => "Ouzbékistan",
"Viet Nam" => "Viêt Nam",
"Wales" => "Pays de Galles",
"Wallis and Futuna" => "Wallis-et-Futuna",
"Western Sahara" => "Sahara occidental",
"World" => "Monde",
"Yemen" => "Yémen",
"Yugoslavia" => "Yougoslavie",
"Zambia" => "Zambie",
"Arabic" => "Arabe",
"Simplified Chinese" => "Chinois simp.",
"Chinese" => "Chinois",
"Czech" => "Tchèque",
"Danish" => "Danois",
"German" => "Allemand",
"English" => "Anglais",
"English British" => "Britannique",
"Spanish" => "Espagnol",
"Greek" => "Grec",
"Farsi" => "Persan",
"Finnish" => "Finnois",
"French" => "Français",
"Galician" => "Galicien",
"Hebrew" => "Hébreu",
"Croatian" => "Croate",
"Italian" => "Italien",
"Japanese" => "Japonais",
"Korean" => "Coréen",
"Hungarian" => "Hongrois",
"Dutch" => "Hollandais",
"Norwegian" => "Norvégien",
"Polish" => "Polonais",
"Português" => "Portugais",
"Brazilian Portuguese" => "Brésilien",
"Russian" => "Russe",
"Pijin Solomon" => "Pidgin des Îles des Salomons",
"Slovak" => "Slovaque",
"Serbian" => "Serbe",
"Serbian Latin" => "Serbe latin",
"Swedish" => "Suédois",
"Traditional Chinese" => "Chinois trad.",
"Ukrainian" => "Ukrainien",
"This instance of activity is already complete" => "Cette instance est déjà finie",
"Fatal error: cannot execute automatic activity \$activityId" => "Erreur fatale : Ne peut pas exécuter l'activité \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Erreur fatale : l'activité suivante pointe vers une activité inexistante",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Erreur fatale : aucune activité candidate pour l'activité suivante",
"Fatal error: non-deterministic decision for autorouting activity" => "Erreur fatale : plusieurs activités suivantes possibles",
"Fatal error: trying to send an instance to an activity but no transition found" => "Erreur fatale :aucune transition trouvée lors de l'envoi d'une instance à une activité",
"Cannot add transition only split activities can have more than one outbound transition" => "Ne peut pas ajouter de transition - seulement les activités découpées peuvent avoir plus d'une transition outbound",
"Circular reference found some activity has a transition leading to itself" => "Boucle trouvée : une activité a une transition pointant vers elle-même",
"Process does not have a start activity" => "Le processus n'a pas d'activité initiale",
"Process does not have exactly one end activity" => "Le processus n'a pas une et une seule activité finale",
"End activity is not reachable from start activity" => "L'activité finale ne peut être atteinte depuis l'activité initiale",
"Activity" => "Activité",
" is interactive but has no role assigned" => " est interactive sans rôle attribué",
" is non-interactive and non-autorouted but has no role assigned" => " est ni interactive, ni autoroutée mais n'a pas de rôle attribué",
" is standalone but has transitions" => " est indépendante mais n'a pas de transition",
"Role" => "Rôle",
" is not mapped" => " n'est pas associée",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "L'activité '.\$res['name'].' est indépendante et utilise l'objet \$instance",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "L'activité '.\$res['name'].' est interactive et ainsi doit utiliser la méthode \$instance->complete()",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "L'activité '.\$res['name'].' n'est pas interactive et doit ainsi utiliser la méthode \$instance->complete()",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activité '.\$res['name'].' est échangé ainsi la méthode \$instance->setNextActivity(\$actname) doit être utilisée",
"Process %d has been activated" => "Le processus %d a été activé",
"Process %d has been deactivated" => "Le processus %d a été désactivé",
"Process %s %s imported" => "Processus %s %s importé",
"Process %s removed" => "Processus %s supprimé",
"Process %s has been updated" => "Le processus %s a été mis à jour",
"Process %s has been created" => "Le processus %s a été créé",
"Permission denied" => "Droit d'accès refusé",
"Template %s not registered" => "Gabarit %s non enregistré",
"The file is not a CSV file or has not a correct syntax" => "Le fichier n'est pas un fichier CSV ou la syntaxe est incorrecte",
"Error line: %d" => "Erreur à la ligne : %d",
"locked" => "verrouillé",
"locked by" => "verrouillé par",
"Administration:" => "Administration :",
"in" => "dans",
"continued" => "se continue",
"New Image Uploaded by" => "Nouvelle image envoyée par",
"New Subscriptions" => "Nouvelles inscriptions",
"New Item in Tracker" => "Nouvelle fiche dans les formulaires",
"tracker" => "formulaire",
"by" => "par",
"Image Gallery" => "Galerie d'images",
"Blogs" => "Blogues",
"Directory" => "Répertoire des liens",
"File Gallery" => "Galerie de fichiers",
"Quizzes" => "QCMs",
"Trackers" => "Formulaires",
"Survey" => "Enquête",
"Newsletter" => "Lettre d'informations",
"Charts" => "Palmarès",
"blog" => "blogue",
"directory" => "répertoire des liens",
"file gallery" => "galerie de fichiers",
"image gallery" => "galerie d'images",
"poll" => "sondage",
"quiz" => "QCM",
"survey" => "enquête",
"wiki page" => "page wiki",
"calendar" => "calendrier",
"Cannot write to this file: " => "Impossible d'écrire ce ficher : ",
"(not registered)" => "(non enregistré)",
"Anonymous" => "Anonyme",
"Use this thread to discuss the %s page." => "Utilisez la page %s pour discuter le fil de discussion",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: nombre de lignes différent: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_check : a échoué",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check : séquence de modification non optimale",
"WikiDiff Okay: LCS = %s" => "WikiDiff OK: LCS = %s",
"Line:" => "Ligne :",
"Lines:" => "Lignes :",
"Newsletter subscription information at " => "Abonnement à une lettre d'informations sur ",
"Tiki Link - Insert internal link" => "Tiki Link - Insérer un lien interne",
"Select a Wiki page to link to:" => "Sélectionnez une page Wiki vers laquelle pointer le lien :",
"Find" => "Trouver",
"find" => "trouver",
"prev" => "précédent",
"next" => "suivant",
"Link" => "Lien",
"Page name" => "Nom de la page",
"Cannot open this file:" => "Impossible d'ouvrir ce fichier :",
"Wiki Home" => "Accueil-Wiki",
"Home" => "Accueil",
"Blog" => "Blogue",
"previous page" => "page précédente",
"next page" => "page suivante",
"posted on" => "publié le",
"Continue" => "Continuer",
"By:" => "Par :",
"Read" => "Lu",
"List articles" => "Liste des articles",
"Last post" => "Dernière publication",
"Invalid imagename (using filters for filenames)" => "Nom d'image invalide (avec les filtres pour les noms de fichiers)",
"Errors detected" => "Erreurs détectées",
"Upload was not successful" => "L'envoi s'est mal passé",
"No image yet, sorry." => "Pas encore d'images, désolé.",
"unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "Répertoire cible inconnu. SVP le configurez dans <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
"unlink failed" => "unlink a échoué",
"Query point:" => "Point de recherche :",
"layer:" => "couche:",
"Record:" => "Enregistrement :",
"No valid ogr2ogr executable" => "Aucun exécutable ogr2ogr valide",
"Could not create \$tdo.mif in data directory" => "Ne peut pas créer \$tdo.mif dans ce répertoire",
"Could not create \$tdo.mid in data directory" => "Ne peut pas créer \$tdo.mid dans ce répertoire",
"unknown" => "inconnu",
"User Map Generated in:" => "Carte utilisateur générée dans :",
"Image Map Generated in:" => "Carte image générée dans :",
"NONE" => "AUCUN",
"File %s not found" => "Fichier %s non trouvé",
"File %s is not a valid archive" => "Le fichier %s n'est pas une archive valide",
"Impossible to open %s : %s" => "Impossible d'ouvrir %s : %s",
"The content retrieved at %s is not a list of mods" => "Le contenu recupéré à %s n'est pas une liste de Mods",
"Can't chdir to '%s'" => "Ne peut pas aller dans le répertoire '%s' (chdir)",
"%s impossible to remove" => "Impossible d'effacer %s",
"section edit" => "édition de la section",
"This poll is closed." => "Ce sondage est fermé.",
"Wiki top pages" => "Pages Wiki les plus populaires",
"Most relevant pages" => "Pages les plus pertinentes",
"Relevance" => "Pertinence",
"Wiki last pages" => "Dernières pages Wiki",
"Modified" => "Modifié",
"Forums last topics" => "Derniers sujets de forum",
"Topic date" => "Date du sujet",
"Forums last posts" => "Derniers articles de forum",
"Forums most read topics" => "Sujets de forums les plus lus",
"Reads" => "Lectures",
"Forums best topics" => "Sujets de forums les plus populaires",
"Forums most visited forums" => "Forums les plus visités",
"Visits" => "Visites",
"Forums with most posts" => "Forums avec le plus d'articles",
"Posts" => "Articles",
"Wiki top galleries" => "Galeries Wiki les plus populaires",
"Wiki top file galleries" => "Galeries de fichiers Wiki les plus populaires",
"Wiki top images" => "Images Wiki les plus populaires",
"Wiki top files" => "Fichiers Wiki les plus populaires",
"Downloads" => "Téléchargements",
"Wiki last images" => "Dernières images Wiki",
"Upload date" => "Date d'envoi",
"Wiki last files" => "Derniers fichiers Wiki",
"Wiki top articles" => "Articles Wiki les plus populaires",
"Most visited blogs" => "Blogues les plus visités",
"Most active blogs" => "Blogues les plus actifs",
"Blogs last posts" => "Dernières publications de blogue",
"Post date" => "Date de publication",
"Wiki top authors" => "Auteurs Wiki les plus actifs",
"Top article authors" => "Auteurs d'articles les plus actifs",
"The passwords do not match" => "Les mots de passe ne sont pas identiques",
"User already exists" => "Cet utilisateur existe déjà",
"Wrong registration code" => "Mauvais code d'enregistrement",
"Invalid username" => "Nom d'utilisateur invalide",
"Username is too long" => "Nom d'utilisateur trop long",
"Username cannot contain whitespace" => "Le nom d'utilisateur ne doit pas contenir d'espace",
"Wrong passcode you need to know the passcode to register in this site" => "Passcode invalide : vous devez connaître le passcode pour vous inscrire dans ce site",
"Invalid email address. You must enter a valid email address" => "Adresse électronique invalide. Vous devez saisir une adresse valide",
"The registration mail can't be sent. Contact the administrator" => "Le message de confirmation ne peut être envoyé. Contactez l'administrateur",
"Feed provided by %s. Click to visit." => "Canaux de syndication fourni par %s. Cliquer pour voir.",
"Login" => "Connexion",
"See other user's profile" => "Voir les informations d'un autre utilisateur",
"Have your profile seen" => "Avoir ses informations visibles",
"Make friends" => "Se faire un ami",
"Receive message" => "Reçoit un message",
"Send message" => "Envoyer un message",
"Read an article" => "Lire un article",
"Publish an article" => "Publier un article",
"Have your article read" => "Avoir son article lu",
"Create new file gallery" => "Créer une nouvelle galerie de fichiers",
"Upload new file to gallery" => "Envoyer un nouveau fichier dans une galerie",
"Download other user's file" => "Télécharger un fichier d'un autre utilisateur",
"Have your file downloaded" => "Avoir un de ses fichiers téléchargé",
"Create a new image gallery" => "Créer une nouvelle galerie d'images",
"Upload new image to gallery" => "Envoyer une nouvelle image dans une galerie",
"See other user's gallery" => "Afficher une galerie d'images d'un autre utilisateur",
"See other user's image" => "Afficher une image d'un autre utilisateur",
"Have your gallery seen by other user" => "Avoir sa galerie affichée par un autre utilisateur",
"Have your image seen" => "Avoir une de ses images affichée",
"Create new blog" => "Créer un nouveau blogue",
"Post in a blog" => "Publier dans un blogue",
"Read other user's blog" => "Lire un blogue d'un autre utilisateur",
"Have your blog read" => "Avoir un de ses blogues lu",
"Create a new wiki page" => "Créer une nouvelle page Wiki",
"Edit an existing page" => "Modifier une page existante",
"Attach file" => "Joindre un fichier",
"Tracker" => "Formulaire",
"Unknown" => "Inconnu",
"Trackeritem" => "FicheFormulaire",
"Directory category" => "Catégorie du répertoire",
"Gallery" => "Galerie",
"File" => "Fichier",
"Blog post" => "Article de blogue",
"Tracker item" => "Fiche de formulaire",
"Advanced" => "Advancé",
"Fast Prev" => "Retour rapide",
"Prev" => "Préc.",
"Next" => "Suivant",
"Help page:" => "Page d'aide :",
"View tpl:" => "Voir le tpl :",
"Edit Template" => "Modifier le gabarit",
"Admin Feature" => "Admin Fonctionnalités",
"help" => "aide",
"All" => "Tous",
"The text is" => "Le texte est",
"Date Selector" => "Sélection de la date",
"phplayers are not available on this site" => "la fonctionalité phplayers n'est pas disponible sur ce site",
"Invert Sort" => "Inverser le tri",
"days" => "jours",
"day" => "jour",
"hours" => "heures",
"hour" => "heure",
"done" => "fait",
"Text cut here" => "Texte coupé ici",
"Task" => "Tâche",
"from" => "de",
"for" => "pour",
"Priority" => "Priorité",
"Start date:" => "Date de début :",
"End date:" => "Date de fin:",
"Friend" => "Ami",
"Last seen on " => "Dernièrement vu le ",
"(idle for %s seconds)" => "(aucune activité depuis %s secondes)",
"User information - Click for more info" => "Info. utilisateur - Cliquer pour en savoir plus",
"More info about \$other_user" => "Plus d'information sur \$other_user",
"(idle for \$idletime seconds)" => "(inactif depuis \$idletime secondes)",
"Use this tree to copy the structure" => "Utiliser cet arbre pour copier la structure",
"created from structure" => "créé à partir d'une structure",
"Table of contents" => "Table des matières",
"unknown error" => "erreur inconnue",
"You are not logged in" => "Vous n'êtes pas connecté",
"Page cannot be found" => "Page introuvable",
"cannot be found" => "ne peut pas être trouvé",
"An error occured in a database query!" => "Une erreur a été rencontrée dans une requête à la base de données!",
"Help" => "Aide",
"You are banned from" => "Vous êtes interdit de la section ",
"img-g" => "gal-img",
"file-g" => "gal-fichiers",
"faqs" => "FAQs",
"quizzes" => "QCMs",
"arts" => "articles",
"blogs" => "blogues",
"games" => "jeux",
"picture not found" => "image non trouvée",
"drawing not found" => "dessin non trouvé",
"Click to edit dynamic variable" => "Cliquer ici pour modifier la variable dynamique",
"Update variables" => "Mettre à jour les variables",
"Edit Section" => "Editer la section",
"Show" => "Montrer",
"Hide" => "Cacher",
"You are not allowed to upload this type of file." => "Vous n'êtes pas autorisé à envoyer ce type de fichiers.",
"The file you are trying upload was only partially uploaded." => "Le fichier que vous tentez d'envoyer n'a été transféré que partiellement.",
"You must select a file." => "Vous devez sélectionner un fichier.",
"Altering database table failed" => "Echec de la modification de la table de la base de données",
"Removed" => "Supprimé",
"__WARNING__: No such module \$plugin! " => "__ATTENTION__: Aucun module \$plugin! ",
"at" => "à",
"new" => "créer",
"Create page:" => "Créer la page :",
"Unknown language" => "Langue inconnue",
"Click here to confirm your action" => "Cliquer ici pour confirmer votre action",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) détecté. Opération bloquée.",
"Status:" => "États :",
"Upload was not successful. Duplicate file content ?" => "L'envoi n'a pas réussi. Le fichier existe peut-être déjà ?",
"(unchanged)" => "(sans changement)",
"Item Modification" => "Modification de la fiche",
"Item creation" => "Création d'une fiche",
"Tracker was modified at " => "Le formulaire a été modifié à ",
"Field is not numeric" => "Le champ n'est pas numérique",
"Field is not a link to mp3 in the gallery" => " le champ n'est pas un lien vers un MP3 de la galerie",
"Field is not a link to FLV in the gallery" => "le champ n'est pas un lien vers un FLV de la galerie",
"Field is not a link to FLV or MP3 in the gallery" => "le champ n'est pas un lien vers un FLV ou MP3 dans la galerie",
"text field" => "champ texte",
"half column" => "demi-colonne",
"size" => "taille",
"prepend" => "concaténer avant",
"append" => "Ajouter",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Champ texte : 1, taille, préfixe, suffixe, max. - avec taille en caractères, le préfixe et le suffixe entourent le champ, max est le nombre maximal de caractères qui sera sauvegardé, et le 1 initial indique que la prochaine colonne doit se trouver sur la même rangée. Si vous indiquez seulement le 1, le champ suivant est dans la même rangée aussi.",
"textarea" => "zone de texte",
"Textarea options: quicktags,width,height,max,listmax,wordmax - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax is the maximum number of characters that are displayed in list mode, wordmax>0 alert if word count exceeded, wordmax<0 display word count." => "Options de la zone de texte: quicktags,width,height,max,listmax,wordmax - Utiliser les quicktags : 1 ou 0, width est donné en chiffre, height est la hauteur en nombre de lignes, max est le nombre max de caractères pouvant être enregistrés, listmax est le nombre max de caractères affichés en mode liste, wordmax>0 : alerte si le nombre de mots max est dépassé, wordmax<0 affiche le nombre de mots.",
"checkbox" => "à cocher",
"Checkbox options: put 1 if you need that next field is on the same row." => "A cocher : mettre 1 si vous voulez que le champ suivant soit sur la même rangée.",
"numeric field" => "champ numérique",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numérique: 1,taille,préfixe,suffixe la taille est en caractères, le préfixe et le suffixe entourent le champ, et le 1 initial indique que la prochaine colonne doit se trouver sur la même rangée.",
"drop down" => "liste déroulante",
"Dropdown options: list of items separated with commas." => "Liste déroulante : liste des éléments séparés par des virgules",
"Default value is specified by having the value indicated twice consecutively" => "La valeur par défaut est spécifiée en indiquant la valeur 2 fois de suite consécutivement",
"drop down with other textfield" => "liste déroulante avec champ de texte autre",
"radio buttons" => "boutons radio",
"Radio buttons options: list of items separated with commas." => "Options des boutons radio: liste des valeurs séparées par des virgules.",
"user selector" => "sélection automatique d'utilisateur",
"User Selector options: automatic field feeding,email - feeding=1 for author login or feeding=2 for modificator login - email=1 to send an email to the user if the tracker is modified" => "Options du sélecteur d'utilisateurs: remplissage automatique de champ,email - feeding=1 pour le login de l'auteur ou feeding=2 pour le login du modificateur - email=1 pour envoyer un mail à l'utilisateur si le formulaire est modifié",
"group selector" => "sélection automatique de groupe",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Sélection de groupe: Vous pouvez utiliser 1 pour le groupe de création et 2 pour le groupe de modification. Le groupe par défaut est utilisé par cette option et s'il n'est pas fixé le premier groupe trouvé pour l'utilisateur sera utilisé.",
"IP selector" => "sélection de l'IP",
"IP Selector: use options for automatic field feeding : you can use 1 for author IP or 2 for modificator IP." => "Sélection de l'IP : mettre un eoption pour une sélection automatique : 1 pour l'IP du créateur ou 2 pour l'IP de l 'éditeur.",
"country selector" => "sélection de pays",
"Country Selector options: name/flag, sortorder - name/flag is 0,1 or 2 where 1 shows only country name, 2 shows only country flag, 0 shows both (default). sortorder is 0 or 1 where 0 sorts according to translated text (default) and 1 sorts according to english country names even if country names are translated" => "Options du sélecteur de pays: name/flag, sortorder - name/flag : 0,1 ou 2 où 1 n'affiche que le nom du pays, 2 n'affiche que le drapeau du pays, 0 affiche les deux (par défaut). sortorder : 0 ou 1 où 0 trie par rapport au texte traduit (défaut) et 1 trie en fonction du nom du pays en anglais même si les nomsd de pays sont traduits",
"date and time" => "date et horaire",
"Date Time options: date_time,year0,year1 where date_time=d|dt(default), d displays only date, year0 is the first year, year1 the last" => "Options de Date et d'Heure: date_heure,année0,année1 où date_heure=d|dt(par défaut), d affiche seulement la date, année0 est la première année, année1 la dernière",
"Jscalendar options: date_time where date_time=d|dt(default), d displays only date" => "Options de Jscalendar: date_heure où date_heure=d|dt(par défaut), d affiche seulement la date",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Options pour image : xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indiqués en pixels.",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Options pour l'action : Intitulé, post, tiki-index.php, page : nomduchamp, highlight=test",
"header" => "intertitre",
"static text" => "texte statique",
"Static text options: Wikisyntax,listmax - Use Wikisyntax is 1 or 0, listmax is the maximum number of characters that are displayed in list mode." => "Options pour texte statique : pour utiliser la syntaxe Wiki 1 sinon 0, maxlist est le nombre maximum de caractères affichés en mode liste.",
"category" => "catégorie",
"Category options: parentId,d|m|radio|checkbox(default),1|0(default) to have a select all button, d for dropdown, m for multiple drop down" => "Options pour catégorie : parentId,d|m|radio|checkbox(default),1|0(default) pour avoir un bouton \"Sélectionner tout\", d pour liste déroulante (dropdown), m pour liste déroulante multiple",
"item link" => "lien de fiche",
"Item Link options: trackerId,fieldId,linkToItem,displayedfieldslist links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing.  Display displayedfieldslist(separate with |) instead of the target item" => "Options pour un lien de fiche: IdFormulaire,IdChamp,lienVersFiche,IdChamps - lien vers la fiche du formailre IdFormulaire dont fieldId correspond au contenu de ce champ, lienVersFiche 1|0 pour créer un lien vers le champ en mode vue ou liste, IdChamps pour remplacer IdChamps par une liste de champs séparés par |",
"items list" => "liste de fiches",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Options pour la liste des fiches: IdFormulaire, IdChampLa, IdChampIci, IdChampAffichéLa, lienVersFiches affiche la liste des IdChampAffichéLa de la fiche dans le formulaire IdFormulaire où IdChampLa correspond à IdChampIci. LiensVersFiches 1|0 pour créer un lien vers les fiches en vue modification ou liste",
"dynamic items list" => "liste dynamique",
"dynamic items list options: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere insert the list of listFieldIdThere from item in tracker trackerId where filterFieldIdThere matches filterFieldIdHere where status is statusThere." => "Options de la liste dynamique: IdFormulaire, ChampFiltreLàBas, ChampFiltreIci, ChampListéLàBas, statutLàBas - Insère les éléments de ChampListéLàbas du formulaire IdFormulaire si ChampFiltreLàBas correspond à ChampFiltreIci et le statut est statutLàBas",
"email" => "adresse électronique",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Options pour l'adresse électronique: 0|1|2 où 0 affiche l'adresse en texte plein, 1 affiche le lien en hexadécimal (Plus protégé contre le spam et les web spiders) et 2 fait le href mailto normal.",
"auto-increment" => "auto-incrément",
"user subscription" => "réservation utilisateur",
"Google Maps" => "Carte Google",
"Use Google Maps." => "Utiliser Google Maps.",
"system" => "système",
"computed field" => "champ calculé",
"Formula for computation, using # for indicating fields and +,*,/,- and parenthesis for operations." => "Formule de calcul, utilisez # pour indiquer un champ et +,*,/,- ainsi que des parenthèses pour les opérations.",
"user preference" => "préférence utilisateur",
"attachment" => "fichier joint",
"listview=nst, n to see name/t to see type/s to see type/u to see user in list mode" => "listview=nst, n pour vir le nom / t pour voir le type / s pour voir le type / u pour voir l'utilisateur en mode liste",
"open" => "en cours (o)",
"pending" => "en attente",
"closed" => "fermé",
"Added:" => "Ajouté :",
"Removed:" => "Supprimé :",
"Remaining:" => "Restant ::",
"Old:" => "Vieux :",
"New:" => "Nouveau :",
"No extra information for that attached file. " => "Aucune information supplémentaire pour ce fichier joint. ",
"child categories" => "sous-catégories",
"objects in category" => "objets dans la catégorie",
"(AT)" => "(À)",
"(DOT)" => "(PT)",
"The administrator has not yet validated your account. Please wait." => "L'administrateur n'a pas encore validé votre compte. Attendez SVP.",
"You must validate your account first. An email has been sent to you" => "Vous devez tout d'abord valider votre compte. Un courriel vous a été envoyé.",
"Password should be at least" => "Le mot de passe doit avoir au moins",
"characters long" => "caractères",
"Password must contain both letters and numbers" => "Le mot de passe doit contenir des lettres et des chiffres",
"The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "Le message d'enregistrement n'a pas pu être envoyé puisqu'aucun serveur de messagerie n'est configuré, et cette fonctionnalité est désactivée",
"The user email confirmation can't be sent. Contact the administrator" => "Le courriel de confirmation n'a pas pu être envoyé. Contactez l'administrateur SVP",
"Personal Phone" => "Téléphone privé",
"Personal Mobile" => "Portable privé",
"Personal Fax" => "Télécopieur privé",
"Work Phone" => "Téléphone professionnel",
"Work Mobile" => "Portable professionnel",
"Work Fax" => "Fax professionnel",
"Company" => "Société",
"Organization" => "Organisation",
"Department" => "Départment",
"Job Title" => "Poste",
"Street Address" => "Adresse postale",
"City" => "Ville",
"State" => "État",
"Zip Code" => "Code postal",
"Country" => "Pays",
"Use BLOGLIST to include posts from a blog. Syntax is" => "Utiliser BLOGLIST pour inclure des posts d'un blog. La syntax est",
" where Id is the blog Id and Items is the max number of posts to display" => " où Id est l'Id du blog et Items est le nombre max de posts à afficher",
"Title" => "Titre",
"Lists files in a directory" => "Liste des fichiers d'un répertoire",
"could not be opened because it doesn't exist or permission was denied" => "ne peut pas être ouvert parce que n'existe pas ou vous n'avez pas les droits",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Modifie le texte entre les balises REGEX avec l'expression régulière",
"data" => "données",
"one data per line" => "une donnée par ligne",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "Le plugin SNARF remplace l'URL avec le code HTML associé. Des remplacements regex arbitraires peuvent être faits sur le contenu en utilisant regex et regexres, ce dernier étant utilisé comme second paramètre de preg_replace.",
"This data is put in a CODE caption." => "Cette donnée est mise dans un bloc CODE.",
"Missing url parameter for SNARF plugin." => "Paramètre manquant pour le plugin SNARF.",
"users" => "utilisateurs",
"Displays a list of registered users" => "Affiche une liste d'utilisateurs inscrits",
"Displays browser client info" => "Affiche les informations du navigateur client",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Met un lien vers un ancrage dans la page. A utiliser avec le plugin ANAME qui positionne l'ancrage et son nom",
"linktext" => "texte_du_lien",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Met un ancrage dans la page. A utiliser avec le plugin ALINK qui crée le lien vers l'ancrage",
"Includes an article" => "Inclut un article",
"Id is optional. If not given, last article is used. Default field is heading." => "Id est optionnel. S'il n'est pas indiqué, le drnier article est utilisé. Le champ par défaut est l'entête.",
"Includes articles listing into a wiki page" => "Inclut des listes d'articles dans une page wiki",
"No such attachment on this page" => "Fichier joint inexistant sur cette page",
"Displays an attachment or a list of them" => "Afficher un fichier joint ou la liste des fichiers joints",
"Gives the name of the attached file to link to" => "Donne le nom des fichiers rattachés à lier",
"Same as name" => "Idem à name",
"Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Donne le nom d'une autre page où le fichier rattaché l'est également. Ne fonctionne qu'avec les pages wiki",
"Shows the description as the link text instead of the file name" => "Affiche la description du fichier en lieu et place du nom du fichier",
"Makes the list of attachments a bulleted list" => "Présente la liste des fichiers attachés sous forme de liste à puces",
"Says that this file is an image, and should be displayed inline using the img tag" => "Indique que ce fichier est une image qui devrait être présentée dans la page dans une balise html img",
"Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Place le contenu entre les balises {ATTACH} comme lien textuel en lieu et place du nom du fichier ou de la description",
"Shows all attachments from the whole wiki" => "Montre tous les fichiers rattachés à travers tout le wiki",
"Gives the number, in the list of attachments, of the attachment to link to" => "Donne le nombre, dans la liste des rattachements, de l'attachement vers lequel lier",
"Gives the actual id of the attachment to link in. You probably should never use this" => "Donne l'id de l'attachement courant pour faire des liens. Vous ne devriez pas utiliser celà",
"Puts the number of downloads in the alt comment" => "Insère le nombre de téléchargements dans le texte alternatif (balise alt)",
"Shows a file icon" => "Affiche une icône de fichier",
"Displays the user Avatar" => "Affiche l'avatar utilisateur",
"username" => "nom utilisateur",
"List all pages which link to specific pages" => "Liste toutes les pages pointant vers un groupe de pages spécifiques",
"No pages links to" => "Aucune page ne pointe vers",
"One page links to" => "Une page pointe vers",
"pages link to" => "pages pointent vers",
"Insert theme styled box on wiki page" => "Insère le contenu du plugin dans une boîte avec une en-tête colorée",
"text" => "texte",
"Calendar" => "Calendrier",
"Insert list of items for the current/given category into wiki page" => "Insère la liste d'items pour la catégorie courante ou donnée",
"Categories are disabled" => "Les catégories sont désactivées",
"Display Tiki objects that have not been categorized" => "Affiche les objets Tiki qui n'ont pas été catégorisés",
"Insert the full category path for each category that this wiki page belongs to" => "Insère l'arborescence complète de la catégorie pour chaque catégorie à laquelle appartient cette page",
"Centers the plugin content in the wiki page" => "Centre le contenu du plugin dans la page Wiki",
"Chart" => "Palmarès",
"title" => "titre",
"Chart as PDF" => "Graphique en PDF",
"Chart as PostScript" => "Graphique en PostScript",
"Displays a snippet of code" => "Affiche un petit bout de code",
"note: colors and ln are exclusive" => "remarque : colors et ln sont exclusifs",
"Insert copyright notices" => "Insère les notices de copyright",
"Example" => "Exemple",
"and" => "et",
"seconds" => "secondes",
"Insert a division block on wiki page" => "Insère un bloc div dans une page Wiki",
"Creates a definition list" => "Crée une liste de définition",
"term" => "terme",
"definition" => "définition",
"one definition per line" => "une définition par ligne",
"~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insère un feed rss dans une page wiki",
"Upcoming events" => "Évènements à venir",
"Displays the data using the Tikiwiki odd/even table style" => "Affiche les données en utilisant le style Tikiwiki de table pair/impair ",
"cells" => "cellules",
"heads and cells separated by ~|~" => "en-têtes et cellules séparés par ~|~",
"Missing parameter movie to the plugin flash" => "Paramètre manquant au plugin flash",
"Displays a SWF on the wiki page" => "Affiche un SWF dans une page Wiki",
"Formula" => "Formule",
"No formula specified." => "Aucune formule spécifiée.",
"Impossible to render the graphic." => "Impossible de générer le graphique.",
"View graphic" => "Voir le graphique",
"Displays a graphical GAUGE" => "Affiche une jauge graphique",
"Display wiki text if user is in one of listed groups" => "Affiche le texte wiki si l'utilisateur se trouve au moins dans l'un des groupes listés",
"Include a page" => "Insère une page",
"Runs a Java applet to access a local Jabber service" => "Lance un applet Java pour accéder au service loval Jabber",
"Displays the text only if the language matchs" => "Affiche le texte seulement si la langue correspond",
"List wiki pages." => "Liste des pages wiki.",
"Displays a map" => "Affiche une carte",
"Feature disabled" => "Fonctionnalité désactivée",
"Displays an miniquiz" => "Affiche un mini QCM",
"Please choose a module" => "SVP choisissez un module",
"to be used as argument" => "à être utilisé comme paramètre",
"Displays a module inlined in page" => "Affiche un module à l'intérieur de la page",
"Sorry no such module" => "Désolé module inexistant",
"Displays the data using a monospace font" => "Affiche le texte en utilisant une police de caractères mono-espacée",
"Displays a SWF myspace mp3 playlist on the wiki page" => "Affiche un SWF myspace mp3 playlist dans une page wiki",
"Displays object hit info by object and days" => "Affiche les informations sur les visites d'un objet par objet et par jours",
"Provides a list of plugins on this wiki." => "Affiche la liste des plugins.",
"No version indicated" => "Aucune version indiquée",
"No arguments indicated" => "Aucun argument indiqué",
"Displays the output of a poll, fields are indicated with numeric ids." => "Affiche les sorties d'un sondage, les champs sont indiqués par leur ID numérique.",
"missing poll ID for plugin POLL" => "ID de sondage inexistant pour le plugin POLL",
" wrote:" => " écrit :",
"Quote:" => "Citation :",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Texte de la citation entouré d'une boîte, comme dans [QUOTE] de BBCode",
"Displays a comment, tip, note or warning box" => "Affiche une boite de commentaire, une astuce ou une alerte",
"You need to specify a RSS Id" => "Vous devez spécifier un identifiant RSS",
"RSS Id incorrect:" => "Identifiant RSS incorrect&nbsp;:",
"~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insère la syndication RSS dans une page Wiki",
"Automatically creates a link to the appropriate SourceForge object" => "Crée automatiquement un lien à l'objet Sourceforge correspondant",
"TikiSheet" => "Feuillets",
"Sheet Heading" => "Entête de feuillet",
"Edit Sheet" => "Editer la feuille de calcul",
"List wiki pages" => "Liste des pages Wiki",
"Last modified by" => "Dernière modification par",
"Clickable Skype link" => "Lien Skype clickable",
"Sorts the plugin content in the wiki page" => "Trie les lignes de données",
"Edit" => "Modifier",
"Split a page into rows and columns" => "Découpe une page en rangées et colonnes",
"row1col1" => "rangée1col1",
"row1col2" => "rangée1col2",
"row2col1" => "rangée2col1",
"row2col2" => "rangée2col2",
"Missing db param" => "Le paramètre db manque",
"Run a sql query" => "Exécuter une requête sql",
"sql query" => "requête sql",
"Displays text in subscript." => "Affiche le texte en lettres inférieures.",
"Subscribe or unsubscribe to a group" => "S'inscrire ou se désinscrire d'un groupe",
"Missing parameter" => "Paramètre manquant",
"Incorrect param" => "Paramètre incorrect",
"Displays text between an html tag" => "Affiche le texte entre les balises html",
"Displays the thumbnail for an image" => "Affiche la vignette pour une image",
"Search the titles of all pages in this wiki" => "Cherche parmi les titres des pages Wiki",
"No pages found for title search" => "Aucune page trouvée avec la recherche par titre",
"One page found for title search" => "Une page trouvée avec la recherche par titre",
" pages found for title search" => " pages trouvées avec la recherche par titre",
"List top scoring users" => "Liste des utilisateurs ayant le meilleur score",
"Translate a string" => "Traduire une chaine",
"Incorrect fieldId:" => "Mauvais fieldId:",
"Error" => "Erreur",
"Following mandatory fields are missing" => "Les champs obligatoires suivants sont manquants",
"Following fields are incorrect" => "Les champs suivants sont incorrects",
"Rating" => "Cote",
"Other:" => "Autre :",
"Select All" => "Tout sélectionner",
"Displays an input form for tracker submit" => "Affiche un champ de saisie pour soumettre un formulaire",
"You do not have permission to insert an item" => "Vous n'avez pas le droit d'ajouter une fiche",
"You do not have permission to modify an item" => "Vous n'avez pas les droits pour modifier un élément",
"Fields marked with a * are mandatory." => "Les champs marqués d'une astérisque(*) sont obligatoires",
"Filter" => "Filtrer",
"Filters the items of a tracker, fields are indicated with numeric ids." => "Filtre les fiches d'un formulaire, les champs sont indiqués par leur Id.",
"missing parameters" => "paramètres manquants",
"tracker field type not processed yet" => "champ de formulaire non traité pour l'instant",
"Wiki text" => "Texte Wiki",
"incorrect filterfield" => "filterfield incorrect",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Affiche la sortie du contenu du formulaire, les champs sont indiqués par des IDs numériques.",
"Error in tracker ID" => "Erreur sur l'ID du formulaire",
"No field indicated" => "Aucun champ indiqué",
"Displays some stat of a tracker content, fields are indicated with numeric ids." => "Affiche des statistiques sur le contenu d'un formulaire - les champs sont indiqués par leur Ids numériques.",
"incorrect fieldId" => "fieldId incorrect",
"Links to a translated content" => "Liens au contenu traduit",
"Displays the number of registered users" => "Affiche le nombre d'utilisateurs inscrits",
"Split the text in parts visible only under some conditions" => "Découpe le texte en parties visibles seulement sous certaines conditions",
"This is the default text" => "Ceci est le texte de la page",
"This is version 3 info" => "Voici les informations de la version 3",
"This is version 2 info" => "Voici les informations de la version 2",
"This is version 1 info" => "Voici les informations de la version 1",
"Lists ''wanted'' Wiki pages: " => "Pages Wiki ''voulues'' : ",
"Page-Pattern" => "Expression régulière pour page",
"^Parameters: key=>value,...\n" => "^Paramètres: clé=>valeur,...\n",
"__key__ | __default__ | __comments__\n" => "__clé__ | __défaut__ | __commentaires__\n",
"empty string" => "chaîne vide",
"(refer to PHP function fnmatch() for details)\n" => "(voir la fonction PHP fnmatch() pour plus de détails)\n",
"possible values: characters\n" => "valeurs possibles: characters\n",
"possible values: " => "valeurs possible: ",
"a valid regex-expression (PCRE)" => "une expression régulière regex (PCRE) valide",
"non-valid custom regex" => "expression régulière regex invalide",
"ignored" => "ignoré",
"External Wiki" => "Wiki externe",
"dash-WikiWord" => "WikiWord-tiret",
"WikiWord" => "MotWiki",
"not in level" => "pas dans le niveau",
"valid" => "valide",
"End of debug output." => "Fin des messages de debug.",
"Wanted Page" => "Page voulue",
"Referenced By Page" => "Reférencé par une page",
"Missing parameter movie to the youtube plugin" => "Le paramètre de la vidéo youtube est manquant dans le plugin",
"Display youtube video in a wiki page" => "Afficher la vidéo youtube dans une page wiki",
"Removed version \$version" => "Version \$version supprimée",
"rollback version " => "retour à la version ",
"Changed actual version to \$version" => "Version courante changée en \$version",
"failed" => "a échoué",
"Page locked" => "Page verrouillée",
"Page unlocked" => "Page déverrouillée",
"Removed last version" => "Dernière version supprimée",
"ERROR: Either the subject or body must be non-empty" => "ERREUR : Le sujet et le corps ne peuvent pas être vides en même temps",
"ERROR: No valid users to send the message" => "ERREUR : Aucun utilisateur valide à qui envoyer le message",
"Invalid user" => "Utilisateur invalide",
"Message sent to" => "Message envoyé à",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "La boîte des messages envoyés est pleine. Archivez ou supprimez quelques messages envoyés avant, si vous souhaitez pouvoir envoyer d'autres messages.",
"You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "Vous devez pouvoir recevoir des messages pour pouvoir en envoyer. Allez dans vos préférences utilisateur et activez 'Autoriser des messages d'autres utilisateurs'",
"User %s can not receive messages, mailbox is full" => "L'user %s ne peut pas recevoir de messages. Sa boîte à lettres est pleine",
"User %s can not receive messages" => "L'utilisateur %s ne peut pas recevoir de messages",
"Invalid user: %s" => "Utilisateur invalide : %s",
"Message will be sent to: " => "Le message a été envoyé à : ",
"Archive is full. Delete some messages from archive first." => "L'archive est pleine. Supprimez des messages de l'archive d'abord.",
"No more messages" => "Plus de messages",
"Tiki Calendar" => "Calendrier Tiki",
"list topics with links to the articles" => "liste des sujets avec liens vers les articles",
"Article Topics" => "Sujets des articles",
"Categorize %s in %s" => "Catégoriser %s dans %s",
"Please provide an Id" => "SVP donnez un ID",
"no object here yet" => "pas encore d'objet",
"This module requires parameters trackerId and name set" => "Ce module requiert que trackerId et name soient positionnés",
"Create/Edit" => "Créer/Modifier",
"Quick Edit a Wiki Page" => "Créer/modifier une page Wiki",
"new users" => "nouveau(x) utilisateur(s)",
"Since your last visit" => "Depuis votre dernière visite",
"Changes" => "Modifications",
"since" => "depuis",
"Changes since" => "Modifications depuis",
"new comments" => "nouveau(x) commentaire(s)",
"new posts" => "nouveau(x) article(s) de forum",
"wiki pages changed" => "page(s) Wiki modifiée(s)",
"new articles" => "nouveau(x) article(s)",
"new submissions" => "nouvelles soumissions",
"new FAQs" => "nouvelle(s) FAQ(s)",
"new sites" => "nouveaux sites",
"new blogs" => "nouveau(x) blogue(s)",
"new blog posts" => "nouvelle(s) publication(s) de blogue",
"new image galleries" => "nouvelle(s) galerie(s) d'images",
"new images" => "nouvelle(s) image(s)",
"new file galleries" => "nouvelle(s) galerie(s) de fichiers",
"new files" => "nouveau(x) fichier(s)",
"new polls" => "nouveau(x) sondage(s)",
"new tracker items" => "nouvelle(s) fiche(s) de formulaire",
"new calendar events" => "nouveaux évènements du calendrier",
"The task title must have at least 3 characters" => "Le titre du message doit avoir au moins 3 caractères",
"Invalid server key" => "Clé du serveur invalide",
"Invalid username or password" => "Nom d'utilisateur ou mot de passe invalide",
"Cookie not found" => "Cookie non trouvé",
"Admin live support system" => "Droit d'administrer le système d'assistance en ligne",
"Administrator, can admin banners" => "Administrateur, peut administrer les bannières",
"Administrator, can create channels remove channels etc" => "Administrateur, peut créer et supprimer des canaux",
"Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrateur, peut gérer les comptes utilisateurs, les groupes, les permissions, les mots/liens automatiques (Hotwords) ainsi que les fonctionnalités du blogue",
"Auto approve forum posts" => "Validation automatique des articles du forum",
"Autovalidate suggestions" => "Validation automatique des suggestions",
"Can  receive tasks from other users" => "Peut se voir affecter des tâches par d'autres utilisateurs",
"Can abort a process instance" => "Peut interrompre une instance d'un process",
"Can access site when closed" => "Peut accéder au site lorsqu'il est fermé",
"Can add and change ratings on wiki pages" => "Droit d'ajouter et modifier les notes associées aux pages du wiki",
"Can add events in the calendar" => "Droit d'ajouter des évènements dans le calendrier",
"Can admin any mypage" => "Droit d'administrer les mespages",
"Can admin attachments to wiki pages" => "Droit d'administrer les fichiers joints aux pages wiki",
"Can admin blogs" => "Droit d'administrer les blogues",
"Can admin categories" => "Droit d'administrer les catégories",
"Can admin charts" => "Droit d'administrer les palmarès",
"Can admin contributions" => "Droit d'administrer les contributions",
"Can admin cookies" => "Droit d'administrer les cookies",
"Can admin directory categories" => "Droit d'administrer les catégories de répertoire",
"Can admin directory sites" => "Droit d'administrer les sites des répertoires",
"Can admin drawings" => "Droit d'administrer les dessins",
"Can admin faqs" => "Droit d'administrer les faqs",
"Can admin file galleries" => "Droit d'administrer les galeries de fichiers",
"Can admin forums" => "Droit d'administrer les forums",
"Can admin freetags" => "Peut administrer les freetags",
"Can admin games" => "Droit d'administrer les jeux",
"Can admin Image Galleries" => "Droit d'administrer les galeries d'images",
"Can admin integrator repositories and rules" => "Droit d'administrer les dépots d'intégration Tiki et les rêgles",
"Can admin mail-in accounts" => "Droit d'administrer les comptes mail-in",
"Can admin newsletters" => "Droit d'administrer les newsletters",
"Can admin polls" => "Droit d'administrer les sondages",
"Can admin public tasks" => "Droit d'administrer les tâches publiques",
"Can admin quicktags" => "Droit d'administrer les raccourcis",
"Can admin quizzes" => "Droit d'administrer les QCMs",
"Can admin received articles" => "Droit d'administrer les articles reçus",
"Can admin received pages" => "Droit d'administrer les pages reçues",
"Can admin rss modules" => "Droit d'administrer les modules rss",
"Can admin sheet" => "Droit d'administrer les feuillets",
"Can admin shoutbox (Edit/remove msgs)" => "Droit d'administrer le mégaphone Tiki (Editer/supprimer les msgs)",
"Can admin surveys" => "Droit d'administrer les enquêtes",
"Can admin the cms" => "Droit d'administrer les articles (cms)",
"Can admin the directory" => "Droit d'administrer le répertoire des liens",
"Can admin the dynamic content system" => "Droit d'administrer le système de contenu dynamique",
"Can admin the TikiTests" => "Droit d'administrer les TikiTests",
"Can admin the wiki" => "Droit d'administrer le wiki",
"Can admin trackers" => "Droit d'administrer les formulaires",
"Can admin users" => "Droit d'administrer les utilisateurs",
"Can admin workflow processes" => "Droit d'administrer les processus du workflow",
"Can approve submissions" => "Droit d'approuver les soumissions",
"Can assign perms to blog" => "Droit d'assigner des permissions sur les blogues",
"Can assign perms to file gallery" => "Droit d'assigner des permissions sur les galeries de fichiers",
"Can assign perms to image gallery" => "Droit d'assigner les droits d'accès des galeries d'images",
"Can assign perms to mypage" => "Droit d'assigner des permissions aux mespages",
"Can assign perms to wiki pages" => "Droit d'assigner des permissions aux pages wiki",
"Can attach files to tracker items" => "Droit d'attacher des fichiers aux fiches de formulaire",
"Can attach files to wiki pages" => "Droit d'attacher des fichiers aux pages wiki",
"Can attach to forum posts" => "Droit d'attacher des fichiers aux articles du forum",
"Can ban users or ips" => "Droit de bannir des utilisateurs ou des ips",
"Can broadcast messages to all user" => "Droit de diffuser des messages vers tous les utilisateurs",
"Can broadcast messages to groups" => "Droit de diffuser des messages vers les groupes",
"Can browse freetags" => "Droit de parcourir les freetags",
"Can browse the calendar" => "Droit de parcourir le calendrier",
"Can cache user bookmarks" => "Droit de mettre des signets en antémémoire",
"Can change events in the calendar" => "Droit de modifier des évènements dans le calendrier",
"Can change tracker items" => "Droit de changer des fiches de forumulaire",
"Can clean cache" => "Droit de vider le cache",
"Can configure modules" => "Droit de configurer des modules",
"Can create a blog" => "Droit de créer des blogues",
"Can create and edit sheets" => "Droit de créer et éditer des feuillets",
"Can create and edit structures" => "Droit de créer et éditer des structures",
"Can create file galleries" => "Droit de créer des galeries de fichiers",
"Can create image galleries" => "Droit de créer des galeries d'images",
"Can create items in personal menu" => "Droit de créer des éléments du menu personnel",
"Can create new css suffixed with -user" => "Droit de créer des css suffixé avec -user",
"Can create new items for trackers" => "Droit de créer de nouvelles fiches de formulaire",
"Can create new mapfile" => "Droit de créer de nouveaux fichiers-carte",
"Can create user bookmarks" => "Droit de créer des signets utilisateur",
"Can create/admin calendars" => "Droit de créer/administrer les calendriers",
"Can declare an instance as exception" => "Droit de déclarer une instance comme exception",
"Can delete comments" => "Droit de supprimer des commentaires",
"Can delete mapfiles" => "Droit de supprimer des fichiers-carte",
"Can download files" => "Droit de télécharger des fichiers",
"Can edit a gallery file" => "Droit d'édition d'un fichier de la galerie",
"Can edit all comments" => "Droit d'édition de tous les commentaires",
"Can edit any mypage" => "Droit d'édition de toutes les mespages",
"Can edit articles" => "Droit de modifier les articles",
"Can edit content templates" => "Droit de modifier les gabarits de contenu",
"Can edit copyright notices" => "Droit de modifier les messages de copyright",
"Can edit drawings" => "Droit de modifierldes dessins",
"Can edit dynamic variables" => "Droit de modifier les variables dynamiques",
"Can edit HTML pages" => "Droit de modifier les pages HTML",
"Can edit items in categories" => "Droit de modifier les éléments dans les catégories",
"Can edit mapfiles" => "Droit de modifier les fichiers-carte",
"Can edit menu" => "Droit de modifier les menus",
"Can edit menu option" => "Droit de modifier les options des menus",
"Can edit object permissions" => "Droit de modifier les permissions des objets",
"Can edit own forum posts" => "Droit de modifier ses propres articles du forum",
"Can edit pages" => "Droit de modifier des pages wiki",
"Can edit site templates" => "Droit de modifier les gabarits de site",
"Can edit submissions" => "Droit de modifier les soumissions",
"Can edit TikiTests" => "Droit d'éditer des TikiTests",
"Can edit translations and create new languages" => "Droit de modifier les traductions et d'ajout de nouvelles langues",
"Can execute workflow activities" => "Droit d'exécution d'instances du workflow",
"Can export wiki pages using the export feature" => "Droit d'exporter des pages wiki avec la fonctionnalité d'export",
"Can insert comments for tracker items" => "Droit d'ajouter des commentaires aux fiches de formulaire",
"Can list file galleries" => "Droit de lister les galeries de fichiers",
"Can list image galleries" => "Droit de lister le contenu des galeries d'images",
"Can list mypages" => "Droit de lister les mespages",
"Can list registered users" => "Droit de lister les utilisateurs enregistrés",
"Can list trackers" => "Droit de lister les formulaires",
"Can lock pages" => "Droit de verrouiller des pages",
"Can participate to rating of wiki pages" => "Droit de participer à la notation des pages du wiki",
"Can play games" => "Droit de jouer aux jeux",
"Can post in forums" => "Droit de publier dans le forum",
"Can post messages in shoutbox" => "Droit de publier des messages dans le megaphone Tiki",
"Can post new comments" => "Droit de publier de nouveaux commentaires",
"Can post to a blog" => "Droit de publier dans un blogue",
"Can read a topic (Applies only to individual topic perms)" => "Droit de lire un élément (ne s'applique qu'aux éléments individuels)",
"Can read article headings" => "Droit de lire les en-têtes d'articles",
"Can read articles" => "Droit de lire les articles",
"Can read blogs" => "Droit de lire les blogues",
"Can read comments" => "Droit de lire des commentaires",
"Can read forums" => "Droit de lire des forums",
"Can remove" => "Droit de supprimer les pages Wiki",
"Can remove articles" => "Droit de suppression d'articles",
"Can remove association between two pages in a translation set" => "Droit de supprimer l'association entre des pages d'un jeu de traduction",
"Can remove submissions" => "Droit de suppression de soumissions",
"Can rename pages" => "Droit de renommer des pages",
"Can replay the TikiTests" => "Droit de rejouer des TikiTests",
"Can report a link to the webmaster" => "Droit de signaler un lien à l'administrateur du site",
"Can report msgs to moderator" => "Droit de rapporter des messages vers le modérateur",
"Can rollback pages" => "Droit de revenir vers des versions antérieures",
"Can save as minor edit" => "Droit d'enregistrer en tant que version mineure",
"Can search" => "Droit de rechercher",
"Can send a link to a friend" => "Droit d'envoyer un lien à un ami",
"Can send articles to other sites" => "Droit d'envoyer des articles vers d'autres sites",
"Can send articles to this site" => "Droit d'envoyer des articles à ce site",
"Can send instances after completion" => "Droit d'envoyer des éléments après accomplissement",
"Can send newsletters" => "Droit d'envoyer des newsletters",
"Can send pages to other sites" => "Droit d'envoyer des pages vers d'autres sites",
"Can send pages to this site" => "Droit d'envoyer des pages à ce site",
"Can send tasks to other users" => "Droit d'envoyer des tâches à d'autres utilisateurs",
"Can start threads in forums" => "Droit de démarrer des fils de discussion dans le forum",
"Can submit articles" => "Droit de soumettre des articles",
"Can submit sites to the directory" => "Droit de soumettre des sites au répertoire des liens",
"Can subscribe any email to newsletters" => "Droit de souscrire toute adresse mail aux newsletters",
"Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Droit de soumettre des adresses mail par lot (recquiert tiki_p_subscribe email)",
"Can subscribe to groups" => "Droit de s'inscrire dans les goupes",
"Can subscribe to newsletters" => "Droit de s'inscrire à des newsletters",
"Can suggest faq questions" => "Droit de suggérer des questions dans les faqs",
"Can suggest items" => "Droit de suggérer des éléments",
"Can tag objects" => "Droit de marquer des objets",
"Can take quizzes" => "Droit de remplir des QCMs",
"Can take surveys" => "Droit de remplir des enquêtes",
"Can unassign tags from an object" => "Droit de supprimer des tags associés à un objet",
"Can upload files" => "Droit d'envoyer (upload) des fichiers",
"Can upload images" => "Droit d'envoyer (upload) des images",
"Can upload personal files" => "Droit d'envoyer (upload) des fichiers personels",
"Can upload pictures to wiki pages" => "Droit d'envoyer des images vers des pages wiki",
"Can upload zip files with files" => "Droit d'envoyer des fichiers zip avec les fichiers",
"Can upload zip files with images" => "Droit d'envoyer des fichiers zip avec les images",
"Can use content templates" => "Droit d'utiliser des gabarits de contenu",
"Can use Directory Batch Load" => "Droit d'utiliser le chargement par lot dans le répertoire des liens",
"Can use Directoy Batch Load" => "Droit d'utiliser le le téléchargement par lot",
"Can use HTML in pages" => "Droit d'utiliser du code HTML dans les pages",
"Can use live support system" => "Droit d'utiliser le système de support en ligne",
"Can use tasks" => "Droit d'utiliser les tâches",
"Can use the chat system" => "Droit d'utiliser le système de discussions (chat)",
"Can use the directory" => "Droit d'utiliser le répertoire des liens",
"Can use the messaging system" => "Droit d'utiliser le système de messagerie",
"Can use the mini event calendar" => "Droit d'utiliser Mon Calendrier",
"Can use the newsreader" => "Droit d'utiliser le lecteur de news",
"Can use the notepad" => "Droit d'utiliser le bloc-notes",
"Can use webmail" => "Droit d'utiliser le webmail",
"Can validate submited links" => "Droit de valider des liens soumis",
"Can view action log" => "Droit de voir le journal des actions",
"Can view action log for users of his own groups" => "Droit de voir le journal des actions pour ses propres groupes",
"Can view categories" => "Droit de voir des catégories",
"Can view categorized items" => "Droit de voir des éléments catégorisés",
"Can view charts" => "Droit de voir le palmarès",
"Can view contents of mapfiles" => "Droit de voir le contenu des fichiers-carte",
"Can view events details" => "Droit de voir le détail des évènements",
"Can view faqs" => "Droit de voir les faqs",
"Can view file galleries" => "Droit de voir les galeries de fichiers",
"Can view file galleries explorer" => "Droit de voir l'explorateur de galeries de fichiers",
"Can view file galleries path" => "Droit de voir le chemin des galeries de fichiers",
"Can view HTML pages" => "Droit de voir les pages HTML",
"Can view image galleries" => "Droit de voir les galeries d'images",
"Can view integrated repositories" => "Droit de lecteure sur les dépots d'intégration",
"Can view mapfiles" => "Droit de voir les fichiers-cartes",
"Can view page/pages" => "Droit de voir les pages wiki",
"Can view poll results" => "Droit de voir des résultats de sondages",
"Can view quiz stats" => "Droit de voir les statistiques du QCM",
"Can view rating of wiki pages" => "Droit de voir les notations des pages du wiki",
"Can view rating result for tracker items" => "Droit de voir les notations pour les fiches de formulaire",
"Can view referer stats" => "Droit de voir les statistiques des origines",
"Can view sheet" => "Droit de voir les feuillets",
"Can view sheet history" => "Droit de voir l'historique des feuillets",
"Can view shoutbox" => "Droit de voir le mégaphone Tiki",
"Can view site stats" => "Droit de voir les statistiques du site",
"Can view site templates" => "Droit de voir les modèles du site",
"Can view source of wiki pages" => "Droit de voir le source des pages wiki",
"Can view survey stats" => "Droit de voir les statistiques des enquêtes",
"Can view Tikiwiki tools calendar" => "Droit de voir les outils du calendrier Tikiwiki",
"Can view trackers" => "Droit de voir les formulaires",
"Can view trackers closed items" => "Droit de voir les fiches de formlaires cloturées",
"Can view trackers pending items" => "Droit de voir les fiches de formulaire en attente",
"Can view user quiz results" => "Droit de voir les résultats des QCMs",
"Can view wiki attachments and download" => "Droit de voir les pièces jointes aux pages wiki et de les télécharger",
"Can view wiki comments" => "Droit de voir les commentaires associés aux pages wiki",
"Can view wiki history" => "Droit de voir l'historique des pages wiki",
"Can vote" => "Droit de vote",
"Can vote a rating for tracker items" => "Droit de noter les fiches de formulaire",
"Can vote comments" => "Droit de voter pour un commentaire",
"Can vote comments in forums" => "Droit de voter pour des commentaires dans les forums",
"Can vote polls" => "Droit de voter à un sondage",
"Can watch structure" => "Droit de voir les structures",
"Can watch tracker" => "Droit de voir les formulaires",
"Submited articles automatically approved" => "Les articles soumis sont automatiquement approuvés",
"Submited links are valid" => "Les liens soumis sont valides",
"Anti-Bot verification code" => "Code de vérification anti-bot",
"Random Image" => "Image choisie au hasard",
"Enter the code you see above" => "Entrer le code que vous voyez au-dessus",
"List of attached files" => "Liste des fichiers joints",
"uploaded" => "envoyé",
"View" => "Afficher",
"Download" => "Télécharger",
"Delete" => "Effacer",
"Remove" => "Supprimer",
"Upload file" => "Envoyer un fichier",
"Attach" => "Joindre",
"Attach a file to this item" => "Joindre un fichier à cette fiche",
"Attachments" => "Fichiers joints",
"more info" => "plus d'informations",
"No attachments for this item" => "Aucun fichier joint à cette fiche",
"Fatal error" => "Erreur fatale",
"Description:" => "Description :",
"Created by" => "Créé par",
" on " => " le ",
"Post" => "Publier",
"RSS feed" => "Syndication RSS",
"Edit blog" => "Modifier le blogue",
"Monitor this Blog" => "Surveiller ce blogue",
"Stop Monitoring this Blog" => "Arrêter de surveiller ce blogue",
"Activity=" => "Activité=",
"Watched by categories" => "Surveillé via une catégorie",
"Properties" => "Propriétés",
"No records found" => "Aucun résultat",
"Category" => "Catégorie",
"Categorize" => "Catégoriser",
"Show Categories" => "Afficher les catégories",
"Hide Categories" => "Masquer les catégories",
"Tip" => "Astuce",
"Hold down CTRL to select multiple categories" => "Maintenir la touche CTRL appuyée pour une sélection multiple",
"categorize this object" => "catégoriser cet objet",
"Uncheck the above checkbox to uncategorize this page/object" => "Décochez la case au-dessus pour décategoriser l'objet ou page",
"No categories defined" => "Aucune catégorie définie",
"Admin Categories" => "Administrer les catégories",
"Browse Category" => "Parcourir les catégories",
"on" => "le",
"posts:" => "Articles:",
"stars" => "étoiles",
"User Level" => "Niveau utilisateur",
"private message" => "message privé",
"Send eMail to User" => "Envoyer un email à l'utilisateur",
"user online" => "utilisateur connecté",
"user offline" => "utilisateur non connecté",
"Attachment" => "Fichier joint",
"Vote" => "Voter",
"top of page" => "haut de page",
"Reply" => "Répondre",
"Report this post" => "Rapporter cette publication",
"Save to notepad" => "Enregistrer dans le bloc-note",
"Monitor this Topic" => "Surveiller ce sujet",
"Stop Monitoring this Topic" => "Arrêter de surveiller ce sujet",
"Moderator actions" => "Actions du modérateur",
"reported:" => "dénoncé :",
"queued:" => "en attente :",
"Move to topic:" => "Déplacer vers le sujet :",
"Move" => "Déplacer",
"Delete Selected" => "Effacer les sélectionnés",
"Plain" => "A plat",
"Threaded" => "Emboîté",
"Headers Only" => "En-têtes seulement",
"Sort" => "Tri",
"Newest first" => "Le plus récent d'abord",
"Oldest first" => "Le plus vieux d'abord",
"Title (desc)" => "Titre (desc)",
"Title (asc)" => "Titre (asc)",
"Threshold" => "Seuil",
"Search" => "Recherche",
"Set" => "Valider",
"Replies" => "Réponses",
"below your current threshold" => "en dessous de votre seuil courant",
"New Reply" => "Nouvelle réponse",
"Editing reply" => "Modifier la réponse",
"Preview" => "Aperçu",
"Reply to the selected post" => "Répondre au message sélectionné",
"Post new message" => "Publier un nouveau message",
"Editing comment" => "Modifier le commentaire sélectionné",
"Comment on the selected post" => "Répondre au commentaire sélectionné",
"Post new comment" => "Publier un nouveau commentaire",
"Required" => "Requis",
"Smileys" => "Frimousses",
"Quicktags" => "Raccourcis",
"Reply to parent post" => "Répondre à un message parent",
"Post new reply" => "Publier un nouveau message",
"Enter your name" => "Saisir votre nom",
"Post as Anonymous" => "Poster en tant qu'Anonyme",
"Cancel" => "Annuler",
"Posting replies" => "Publier des réponses",
"Posting comments" => "Publier des commentaires",
"Use" => "Utilisation",
"or" => "ou",
"for links" => "pour les liens",
"HTML tags are not allowed inside posts" => "Les balises HTML sont interdites dans les messages",
"Go back" => "Revenir à la page précédente",
"Return to home page" => "Retour à la page d'accueil",
"Type of contribution:" => "Type de contribution :",
"Contributors" => "Contributeurs",
"Year" => "Année",
"Authors" => "Auteurs",
"Add" => "Ajouter",
"Syntax" => "Syntaxe",
"Page generation debugging log" => "Trace de debug de la génération de la page",
"Features state" => "État de la fonctionnalité",
"features matched" => "fonctionnalités trouvées",
"Watchlist" => "Liste des variables surveillées",
"Duplicate File Gallery" => "Dupliquer une galerie",
"Duplicate categories" => "Dupliquer les catégories",
"Duplicate perms" => "Dupliquer les droits d'accès",
"duplicate" => "dupliquer",
"There are individual permissions set for this file gallery" => "Des droits d'accès individuels ont été mis cette galerie de fichiers",
"Save" => "Enregistrer",
"View inserted gallery" => "Voir la galerie insérée",
"Display Properties" => "Propriétés d'affichage",
"required field for podcasts" => "champ obligatoire pour podcasts",
"any file" => "tout fichier",
"Gallery is visible to non-admin users?" => "Cette galerie est visible aux utilisateurs autres qu'administrateur?",
"This Gallery is Public" => "Cette galerie est publique",
"The files can be locked at download:" => "Les fichiers peuvent être verrouillés au téléchargement :",
"Maximum number of archives for each file" => "Nombre maximum d'archives pour chaque fichier",
"unlimited" => "illimité",
"none" => "aucun",
"Parent gallery" => "Galerie parente",
"Owner of the gallery" => "Propriétaire de la galerie",
"Default sort order" => "Ordre du tri par défaut",
"descending" => "décroissant",
"ascending" => "croissant",
"Max description display size" => "Taille maximum affichée de la description",
"Max Rows per page" => "Nombre maximum de rangées par page",
"Listing configuration" => "Configuration de l'affichage",
"Perhaps you were looking for:" => "Peut-être vous cherchez :",
"There are no wiki pages similar to '{\$page}'" => "Il n'y a pas de page similaire à '{\$page}'",
"You are not logged in." => "Vous n'êtes pas connecté.",
"Go to Login Page" => "Aller à la page de connexion",
"Create this page" => "Créer cette page",
"(page will be orphaned)" => "(la page sera orpheline)",
"Close Window" => "Fermer la fenêtre",
"Go to" => "Aller dans",
"Private Gallery" => "Galerie privée",
"Active Perms" => "Perms activées",
"Perms" => "Droits",
"Display" => "Afficher",
"Upload New Version" => "Envoyer une Nouvelle Version",
"Unlock" => "Déverrouiller",
"Download and lock" => "Télécharger et verrouiller",
"Lock" => "Verrouiller",
"Name-filename" => "Nom-Nom du fichier",
"Filename only" => "Nom du fichier uniquement",
"Show as a column" => "Afficher en tant que colonne",
"Show in popup box" => "Montrer dans une popup",
"Both" => "Les deux",
"Show an icon in a column" => "Afficher une icône dans une colonne",
"Exact&nbsp;match" => "Contient&nbsp;exactement",
"any type" => "tout type",
"all topic" => "tous les sujets",
"any language" => "toute langue",
"any category" => "toutes catégories",
"Number of displayed rows" => "Nombre de lignes affichées",
"Show php error messages" => "Afficher les messages d'erreurs PHP",
"Last update from SVN" => "Derniêre mise à jour depuis SVN",
"Folksonomy Tags" => "Marqueurs de folksonomie (freetags)",
"Put tags separated by spaces. For tags with more than one word, use no spaces and put words together." => "Séparer les freetags par des espaces. Les tags formés par des mots composés sont à saisir sans espaces entre les différents mots (ex pour \"en dehors\" saisir \"endehors\").",
"Translate tags" => "Traduire les freetags",
"Images Galleries" => "Galeries d'images",
"Edit this page!" => "Editer cette page !",
"RSS Blogs" => "RSS Blogues",
"RSS Image Galleries" => "RSS Galeries d'images",
"RSS File Galleries" => "RSS Galeries de fichiers",
"RSS Maps" => "RSS Cartes",
"RSS Directories" => "RSS Répertoires",
"RSS Calendars" => "Calendriers RSS",
"Loading" => "Chargement",
"Cancel Fullscreen" => "Annuler plein écran",
"Fullscreen" => "Plein Écran",
"Show Tree" => "Montrer l'Arbre",
"Hide Tree" => "Masquer l'Arbre",
"Perform action with checked:" => "Faire l'action sur les sélectionnés :",
"Move Selected Files" => "Déplacer les fichiers sélectionnés",
"Are you sure you want to delete the selected files?" => "Êtes-vous certain de vouloir détruire les fichiers sélectionnés?",
"Move to" => "Déplacer vers",
"Filename" => "Nom du fichier",
"Other Sorts" => "Autres Tris",
"No Additionnal Sort" => "Pas de tri additionnel",
"No information" => "Pas d'information",
"Hi {\$mail_user} has sent you this link:" => "Bonjour, {\$mail_user} vous signale ce lien :",
"Blog post:" => "Article de blogue :",
"at:" => "sur :",
"Somebody or you tried to subscribe this email address at our site:" => "Une demande d'inscription de votre adresse électronique a été faite sur notre site :",
"To the newsletter:" => "à la newsletter :",
"In order to confirm your subscription you must access the following URL:" => "Pour confirmer votre inscription, cliquez sur le lien ci-dessous :",
"To validate your account and login to the site, please click on the following link:" => "Pour valider votre compte et vous connecter au site, veuillez cliquer sur le lien suivant",
"The administrator approved your account." => "L'administrateur a validé votre compte.",
"Confirm your email at %s" => "Confirmez votre adresse électronique à %s",
"Author:" => "Auteur :",
"A new message was posted to forum" => "Un nouveau message a été posté sur le forum ",
"New topic:" => "Nouveau sujet :",
"Topic:" => "Sujet :",
"You sent a request with the subject:" => "Vous avez envoyé une requête avec le sujet :",
"Use the subject to indicate the operation to apply:" => "Utilisez le sujet du message pour indiquer l'opération à appliquer :",
"GET:WikiName to get a wiki page" => "GET:NomPageWiki pour récupérer une page Wiki",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:NomPageWikiName pour mettre à jour/créer une page Wiki (le corps du message = le contenu de la page)",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:NomPageWikipour ajouter en fin de page Wiki (le corps du message = le contenu de la page à ajouter)",
"PREPEND:WikiName to append the data at the top" => "PREPEND:NomPageWiki pour ajouter en haut de page Wiki",
"Tiki mail-in instructions" => "Instruction pour le mail-in Tiki",
"Tiki mail-in auto-reply." => "Réponse automatique du mail-in Tiki.",
"Page not found:" => "Aucune page trouvée :",
"Hi," => "Bonjour,",
"A new message was posted to you at {\$mail_machine}" => "Un nouveau message vous a été envoyé sur {\$mail_machine}",
"From" => "De",
"Subject" => "Sujet",
"New message arrived from %s" => "Un nouveau message est arrivé sur %s",
"Hi" => "Bonjour",
"Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Votre compte Tiki pour le site {\$mail_site} a été validé par l'administrateur de ce site. Votre compte est maintenant actif.",
"To login with your username and password, please follow this link:" => "Pour vous connecter avec votre nom d'utilisateur et votre mot de passe, suivez le lien :",
"Enjoy the site!" => "Bonne visite sur le site!",
"Tiki User Account Activated" => "Compte utilisateur Tiki activé",
"{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> a demandé un mot de passe sur {\$mail_site}, mais vous devez valider son compte d'abord",
"has requested an account on" => "a demandé un compte sur",
"To validate that account, please follow the link:" => "Pour valider ce compte, suivez ce lien :",
"best regards" => "Salutations",
"your Tikiwiki" => "votre Tikiwiki",
"Tiki User Registration Request" => "Demande d'inscription d'un utilisateur",
"Go to your friendship network to accept or refuse this request" => "Allez au réseau des amis pour accepter ou refuser cette demande",
"You're invited to join my network of friends!" => "Vous êtes invité à vous joindre à mon réseau d'amis",
"The user" => "L'utilisateur",
"registered at your site" => "s'est inscrit au site",
"New user registration" => "Inscription d'un nouvel utilisateur",
"Bye bye!" => "Au revoir!",
"This email address has been removed to the list of subscriptors of:" => "Cette adresse électronique a été supprimée de la liste des inscrits à :",
"Newsletter:" => "Lettre d'informations :",
"Bye bye from %s at %s" => "Désinscription à %s de %s",
"You can unsubscribe from this newsletter following this link" => "Vous pouvez vous désinscrire de la newsletter en suivant ce lien ",
"Welcome to our newsletter!" => "Bienvenue sur notre newsletter!",
"This email address has been added to the list of subscriptors of:" => "Cette adresse électronique a été ajoutée à la liste des inscrits à :",
"You can always cancel your subscription using:" => "Vous pouvez toujours vous désinscrire en allant sur :",
"Welcome to %s at %s" => "Bienvenue sur %s de %s",
"Tiki email notification" => "Email de notification Tiki",
"Someone coming from IP Address" => "Quelqu'un avec cette adresse IP",
"requested a reminder of the password for your account" => "a demandé de vous renvoyer votre mot de passe pour votre compte",
"requested password reset for your account" => "a demandé un nouveau mot de passe pour votre compte",
"Since this is your registered email address we inform that the password for this account is" => "Comme ceci est l'adresse électronique de votre inscription, nous vous informons que le mot de passe pour ce compte est",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Veuillez cliquer sur le lien suivant pour confirmer que votre désir de réinitialiser votre mot de passe puis allez sur l'écran où vous devrez saisir un nouveau mot de passe \"permanent\". Veuillez choisir un mot de passe dont vous vous souviendrez et ne le partagez avec personne.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nFait ! Vous devriez être connecté.",
"Important: Username & password are CaSe SenSitiVe" => "Important : Nom d'utilisateur et mot de passe tiennent compte de la casse (lettres minuscules vs MAJUSCULES)",
"Important: The old password remains active if you don't click the link above." => "Important: L'ancien mot de passe reste actif tant que vous ne cliquez pas sur le lien ci-dessus",
"Your Tiki account information for %s" => "Les informations de votre compte Tiki sur %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Un nouvel article a été soumis par {\$mail_user} sur {\$mail_site} le {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Vous pouvez modifier la soumission en suivant le lien :",
"Title:" => "Titre :",
"Heading:" => "En-tête :",
"Body:" => "Corps :",
"New article submitted at %s" => "Nouvel article soumis sur %s",
"Look at this link:" => "Allez voir ce lien :",
"A friend sends you a link from: " => "Un ami vous a envoyé un lien de : ",
"View the tracker item at:" => "Voir la fiche du formulaire à :",
"Download the file at:" => "Télécharger le fichier à :",
"Tracker was modified at" => "Formulaire modifié à",
"Please visit this link before login again:" => "Merci de visiter ce lien avant de vous re-connecter :",
"Confirm your account at %s" => "Confirmez votre compte à %s",
"you or someone registered this email address at" => "Vous (ou quelqu'un d'autre) a inscrit cette adresse électronique à",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Si vous voulez pouvoir vous connecter sur ce site, vous devrez suivre le lien suivant pour la première connexion :",
"Your Tiki information registration" => "Votre inscription Tiki",
"You will receive an email with information to login for the first time into this site" => "Vous allez recevoir un email avec les informations vous expliquant comment activer votre compte.",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Votre demande de compte a été enregistrée et va être traitée dès que possible par un administrateur",
"You'll receive email notification once your account is activated." => "Vous allez recevoir un courriel dès que votre compte aura été activé.",
"Please do not attempt to login until you receive the email notification." => "Merci de ne pas essayer de vous connecter avant réception du courriel de confirmation.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nouvel article publié : {\$mail_title} par {\$mail_user} à {\$mail_date|tiki_short_datetime}",
"View the article at:" => "Pour voir cet article :",
"If you don't want to receive these notifications follow this link:" => "Si vous ne voulez plus recevoir ces notifications, suivez le lien :",
"New article post at %s" => "Nouvel article publié sur %s",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nouvel article de blogue: {\$mail_title}, \"{\$mail_post_title}\", par {\$mail_user} à {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "Le blogue peut être vu à :",
"New blog post at %s" => "Nouvelle publication dans un blogue de %s",
"View item calendar at:" => "voir cet évènement de calendrier à :",
"Modified calendar item" => "Évènement de calendrier modifié",
"New calendar item" => "Nouvel évènement de calendrier",
"changed" => "modifié",
"A new category was created in" => "Une nouvelle catégorie a été créee dans",
"created" => "créé",
"A category was removed in" => "Une catégorie a été supprimée dans",
"Removed by" => "Supprimé par",
"removed" => "supprimé",
"A category was updated" => "Une catégory a été mise à jour",
"Updated by" => "Mise à jour par",
"Old" => "Vieux",
"New" => "Nouveau",
"updated" => "mis à jour",
"File Gallery %s changed" => "La galerie de fichiers %s a été changée",
"A file was removed from the file gallery" => "Le fichier a été retiré de la galerie",
"File Name" => "Nom du fichier",
"A new file was posted to file gallery" => "Un nouveau fichier a été téléchargé dans la galerie de fichiers",
"Posted by" => "Envoyé par",
"File Description" => "Description du fichier",
"Image Gallery {\$galleryName} changed" => "La galerie d'images {\$galleryName} a changé",
"A new file was posted to image gallery" => "Un nouveau fichier a été téléchargé dans une galerie d'images ",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "La carte - {\$mail_page} - a été changée par {\$mail_user} à {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Vous pouvez afficher la carte mise à jour en suivant ce lien :",
"You can edit the map following this link:" => "Vous pouvez modifier la carte en suivant ce lien :",
"An object was added to category" => "Un object a été ajouté dans une catégorie",
"Added by" => "Ajouté par",
"Object" => "Objet",
"Object type" => "Type de l'objet",
"An object was removed from category" => "Un objet a été supprimé d'une catégorie",
"A page has been added to your watched sub-structure:" => "Une page a été ajoutée à la sous-structure que vous surveillez :",
"A page has been removed from your watched sub-structure:" => "Une page a été retirée de la sous-structure que vous surveillez :",
"A page has been promoted out your watched sub-structure:" => "Une page a été promue dans la sous-structure que vous surveillez :",
"A page has been demoted to your watched structure:" => "Une page a été dépromue de la sous-structure que vous surveillez :",
"Structure modified" => "Structure modifiée",
"A new file have been attached to page" => "Un nouveau fichier a été attaché à la page",
"File name" => "Nom du fichier",
"New attachment on %s, page" => "Nouveau fichier joint sur la page %s",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "La page - {\$mail_page} - a été créée par {\$mail_user} à {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "La page - {\$mail_page} - a été changée par {\$mail_user} le {\$mail_date|tiki_short_datetime}",
"Comment:" => "Commentaire :",
"You can view the page by following this link:" => "Vous pouvez voir la page en suivant le lien :",
"You can view a diff back to the previous version by following this link:" => "Vous pouvez voir les différences avec la version immédiatement précédente en suivant le lien :",
"The changes in this version follow below, followed after by the current full page text." => "Ci-dessous, les changements de cette version suivis du texte complet de la page",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lignes: {\$oldd} changées en +Lignes: {\$newd}",
"The new page content follows below." => "Ci-dessous, le nouveau contenu de la page :",
"Wiki page %s changed" => "La page Wiki %s a été modifiée",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "La page - {\$mail_page} - a été commentée par {\$mail_user} à {\$mail_date|tiki_short_datetime}",
"Wiki page %s was commented on by" => "La page Wiki %s a été commentée par",
"an anonymous user" => "un utilisateur anonyme",
"Wiki page renamed" => "Page Wiki renommée",
"Old name" => "Ancien nom",
"New name" => "Nouveau nom",
"Thank you for your registration. You may log in now." => "Merci pour votre inscription. Vous pouvez vous connecter maintenant.",
"click on the map to zoom or pan, do not drag" => "cliquer sur la carte pour zoomer ou faire un panoramique, ne pas faire glisser ",
"Query Results" => "Résultats de la requête",
"Querying" => "Requête",
"Scroll Up" => "Défiler vers le haut",
"Scroll Down" => "Défiler vers le bas",
"Scale" => "Échelle",
"Zoom out" => "Zoom arriêre",
"Query" => "Requête",
"Zoom in" => "Zoom avant",
"Redraw" => "Redessiner",
"select zoom/pan/query and image size" => "sélectionner zoom/panoramique/recherche et la taille de l'image",
"Go" => "OK",
"View the Map Only" => "Voir la carte seulement",
"Reset Map" => "Réinitialiser la carte",
"Click on the map or click redraw" => "Cliquer sur la carte ou cliquer sur Redessiner",
"Comments" => "Commentaires",
"Last modification date" => "Date de dernière modification",
"Overview" => "Vue d'ensemble",
"Legend" => "Légende",
"Layer Manager" => "Gestion des couches",
"Layer" => "Couche",
"On" => "Le",
"Label" => "Étiquette",
"Download Layer" => "Télécharger une layer",
"This layer has been set by the maps administrator to not be downloadable" => "Cette layer a été configurée par l'administrateur pour ne pas être téléchargeable",
"you have requested to download the layer:" => "vous avez demandé de télécharger la layer :",
"from the mapfile:" => "du fichier-carte :",
"Here are the files to download, do not forget to rename them:" => "Ici sont les fichiers à télécharger, n'oubliez pas de les renommer :",
"Mapfiles" => "Fichiers-carte",
"Mapfile" => "Fichier-carte",
"Available mapfiles" => "Fichiers-carte disponibles",
"hits last 7 days" => "visites ces derniers 7 jours",
"monitor this map" => "surveiller cette carte",
"Stop Monitoring this Map" => "Arrêter de surveiller cette carte",
"Create a new mapfile" => "Créer un nouveau fichier-carte",
"Create" => "Créer",
"Mapfile listing" => "Liste des fichiers-carte",
"Reload" => "Recharger",
"History" => "Historique",
"You can view this map in your browser using" => "Vous pouvez afficher cette carte votre navigateur en utilisant",
"Zoom out x2" => "Zoom arrière x2",
"Zoom in x2" => "Zoom avant x2",
"Mapfile History" => "Historique des cartes",
"of" => "de",
"Compare" => "Comparer",
"Comparing version {\$old.version} with version {\$new.version}" => "Comparaison de la version {\$old.version} à la version {\$new.version}",
"Version:" => "Version :",
"Current" => "En&nbsp;cours",
"Versions are identical" => "Les versions sont identiques",
"Legend:" => "Légende :",
"v=view" => "v=afficher",
"c=compare" => "c=comparer",
"d=diff" => "d=différences",
"Full side-by-side diff" => "Diff. côte à côte complet",
"Unified diff" => "Diff. entrelacé",
"Side-by-side view" => "Affichage côte à côte",
"User" => "Utilisateur",
"Ip" => "IP",
"Diff" => "Différences",
"Older Version" => "Version plus ancienne",
"Directories" => "Répertoires",
"back to" => "revenir à",
"Upload From Disk:" => "Envoyer à partir du disque :",
"Upload Files" => "Envoyer un fichier",
"Bytes maximum" => "Maximum d'octets",
"Create Directory:" => "Créer un répertoire :",
"index file (.shp):" => "fichier index (.shp):",
"files to index (regexp):" => "fichiers à indexer (regexp):",
"Message Archive" => "Message archivé",
"Edit template" => "Modifier le gabarit",
"Archive is full!" => "l'archive est pleine !",
"Unread" => "Non-lu",
"Flagged" => "Avec drapeau",
"Unflagged" => "Pas de drapeau",
"Containing" => "Contient",
"Sender" => "expéditeur",
"No messages to display" => "Aucun message à afficher",
"Broadcast message" => "Diffuser un message",
"Message Broadcast" => "Diffusion du message",
"Group" => "Groupe",
"All users" => "Tous les utilisateurs",
"Lowest" => "Mini",
"Low" => "Peu prioritaire",
"High" => "Prioritaire",
"Very High" => "Très prioritaire",
"Send" => "Envoyer",
"Compose message" => "Composer un message",
"Compose Message" => "Composer un message",
"If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences." => "Si vous voulez donner la possibilité aux autres utilisateurs de vous répondre, activez <a href='tiki-user_preferences.php'>Autoriser les messages d'autres utilisateurs</a> dans vos préférences.",
"ERROR" => "ERREUR",
"Invalid" => "Invalide",
"Separate multiple usernames with a comma (&nbsp;,&nbsp;)." => "Séparez les différents noms d'utilisateurs par des virgules (&nbsp;,&nbsp;).",
"To" => "À",
"No messages to download" => "Pas de messages à télécharger",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "La boîte à lettre est pleine! Détruisez ou archivez des messages si vous voulez continuer à en recevoir",
"is reply to" => "répond à",
"Find replied message" => "trouver les messages répondus",
"Mark as read" => "Marquer lu",
"Mark as unread" => "Marquer non-lu",
"Mark as flagged" => "Mettre un drapeau",
"Mark as unflagged" => "Ne pas mettre de drapeau",
"Mark" => "marquer",
"Mailbox" => "Boîte à lettre",
"Compose" => "Envoyer à des utilisateurs",
"Broadcast" => "Envoyer à un groupe",
"Sent" => "Envoyé",
"Auto-archive age for read messages:" => "Temps où les messages sont auto-archivés",
"Read message" => "Lire le message",
"Return to mailbox" => "Revenir à la boîte principale",
"replyall" => "répondre à tous",
"Unflag" => "Supprimer le drapeau",
"Flag this message" => "Mettre un drapeau à ce message",
"Return to archive" => "Retourner aux archives",
"Return to outbox" => "Retourner à la boite à lettres",
"Sent Messages" => "Messages envoyés",
"Replied" => "Répondu",
"Not replied" => "Pas répondu",
"move to archive" => "mettre dans l'archive",
"receiver" => "destinataire",
"No" => "Non",
"'name' parameter for tikimodule missed" => "le paramètre 'name' manque à tikimodule",
"Move module up" => "Remonter le module",
"Up" => "+haut",
"Move module down" => "Descendre le module",
"Down" => "+bas",
"Move module to opposite side" => "Déplacer le module vers le côté opposé",
"opp side" => "côté opposé",
"Unassign this module" => "Désattribuer ce module",
"Are you sure you want to unassign this module?" => "Êtes vous sûre que vous voulez désattribuer ce module?",
"Toggle module contents" => "Afficher/cacher le contenu du module",
"toggle" => "afficher/cacher",
"Admin Menu" => "Menu d'administration",
"Live support" => "Assistance en ligne",
"Banning" => "Interdiction",
"Users" => "Utilisateurs",
"Groups" => "Groupes",
"Cache" => "Antémémoire",
"Links" => "Liens",
"Hotwords" => "Mot/liens automatiques",
"RSS modules" => "Syndication RSS",
"Polls" => "Sondages",
"Mail notifications" => "Notification par courrier",
"Search stats" => "Statistiques des recherches",
"QuickTags" => "Raccourcis",
"Chat" => "Discussion",
"Categories" => "Catégories",
"Banners" => "Bannières",
"Edit templates" => "Modifier les gabarits",
"Admin drawings" => "Administrer les dessins",
"Dynamic content" => "Contenu dynamique",
"Cookies" => "Citations",
"Content templates" => "Gabarits de contenu",
"HTML pages" => "Pages HTML",
"Shoutbox" => "Mégaphone",
"Shoutbox Words" => "Tabous du mégaphone",
"Referer stats" => "Statistiques des origines",
"Import PHPWiki Dump" => "Importer un PHPWiki Dump",
"Admin dsn" => "Administrer les DSNs",
"External wikis" => "Wikis externes",
"System Admin" => "Admin système",
"Security Admin" => "Admin sécurité",
"Syntax highlighting" => "Mise en relief de la syntaxe",
"Display type unknown, you have to enter the banner type" => "Type de bannière inconnu. Vous devez donner le type de bannière",
"You forgot your Google ad_client number !" => "Vous avez oublié votre nombre Google ad_client!",
"Contact us" => "Nous contacter",
"Stats" => "Statistiques",
"Games" => "Jeux",
"MyMenu" => "Cliquer pour voir le sous-menu",
"MyTiki" => "MonTiki",
"MyTiki home" => "Accueil-MonTiki",
"Preferences" => "Préférences",
"Tasks" => "Tâches",
"Bookmarks" => "Signets",
"Newsreader" => "Lecteur de news",
"Notepad" => "Bloc-note",
"My files" => "Mes fichiers",
"User menu" => "Menu utilisateur",
"Mini calendar" => "Mon calendrier",
"My watches" => "Mes notifications",
"WfMenu" => "Cliquer pour voir le sous-menu",
"Admin processes" => "Administrer les processus",
"Monitor processes" => "Surveiller les processus",
"Monitor activities" => "Surveiller les activités",
"Monitor instances" => "Surveiller les instances",
"User processes" => "Processus utilisateur",
"User activities" => "Activités de l'utilisateur",
"User instances" => "Instances utilisateur",
"FriendsMenu" => "MenuAmis",
"Community" => "Communauté",
"User list" => "Liste des utilisateurs",
"Friendship Network" => "Réseau des amis",
"WikiMenu" => "Cliquer pour voir le sous-menu",
"Last changes" => "Dernières modifications",
"Dump" => "Fichier-dump",
"Rankings" => "Classements",
"List pages" => "Liste des pages",
"Orphan pages" => "Pages orphelines",
"Sandbox" => "Bac à sable",
"Print" => "Imprimer",
"Send pages" => "Envoyer des pages",
"Received pages" => "Pages reçues",
"GalMenu" => "Cliquer pour voir le sous-menu",
"Image Galleries" => "Galeries d'images",
"Galleries" => "Galeries",
"Upload image" => "Envoyer une image",
"System gallery" => "Galerie système",
"Articles home" => "Accueil-articles",
"Submit article" => "Soumettre un article",
"View submissions" => "Liste des soumissions",
"New article" => "Nouvel article",
"Send articles" => "Envoyer des articles",
"Received articles" => "Articles reçus",
"Admin topics" => "Administrer les sujets",
"Admin types" => "Administrer les types",
"List blogs" => "Liste des blogues",
"Create/Edit blog" => "Ajouter/modifier un blogue",
"Admin posts" => "Administrer les publications",
"ForMenu" => "Cliquer pour voir le sous-menu",
"List forums" => "Liste des forums",
"Admin forums" => "Administrer les forums",
"DirMenu" => "Cliquer pour voir le sous-menu",
"Submit a new link" => "Soumettre un nouveau lien",
"Browse directory" => "Parcourir le répertoire",
"Admin directory" => "Administrer les liens",
"FileGalMenu" => "Cliquer pour voir le sous-menu",
"File Galleries" => "Galeries de fichiers",
"List galleries" => "Liste des galeries",
"List FAQs" => "Liste des FAQs",
"Admin FAQs" => "Administrer les FAQs",
"Maps" => "Cartes",
"Layer management" => "Gestion des layers",
"QuizMenu" => "Cliquer pour voir le sous-menu",
"List quizzes" => "Liste des QCMs",
"Quiz stats" => "Statistiques sur les QCMs",
"Admin quiz" => "Administrer les QCMs",
"ShtMenu" => "MenuFeuillets",
"TrkMenu" => "Cliquer pour voir le sous-menu",
"List trackers" => "Liste des formulaires",
"Admin trackers" => "Administrer les formulaires",
"SrvMenu" => "Cliquer pour voir le sous-menu",
"Surveys" => "Enquêtes",
"List surveys" => "Liste des enquêtes",
"Admin surveys" => "Administrer les enquêtes",
"Newsletters" => "Lettres d'informations",
"Send newsletters" => "Envoyer une lettre d'informations",
"Admin newsletters" => "Administrer les lettres d'informations",
"Events" => "Évènements",
"Send events" => "Envoyer des évènements",
"Admin events" => "Administrer les évènements",
"EphMenu" => "Cliquer pour voir le sous-menu",
"Ephemerides" => "Éphémérides",
"Ephemerides Admin" => "Administrer les éphémérides",
"ChartMenu" => "Cliquer pour voir le sous-menu",
"Charts Admin" => "Administrer les palmarès",
"AdmMenu" => "Cliquer pour voir le sous-menu",
"Admin" => "Administrer",
"Admin home" => "Accueil-administrer",
"Debugger console" => "Console de debug",
"Theme control" => "Contrôle des thèmes",
"Drawings" => "Dessins",
"Edit languages" => "Modifier une langue",
"Integrator" => "Intégrateur",
"Mods Admin" => "Administrer les Mods",
"UsrMenu" => "Cliquer pour voir le sous-menu",
"Click here to manage your personal menu" => "Cliquer ici pour gérer votre menu personnel",
"User Menu" => "Menu utilisateur",
"More..." => "La suite...",
"Tikiwiki Assistant" => "Assistant Tikiwiki",
"Thank you for installing Tikiwiki" => "Merci d'avoir installé Tiki",
"To configure your Tiki" => "Pour configurer votre Tiki",
"Select" => "Choisir",
"Admin Home" => "Accueil administration",
"from the menu" => "du menu",
"Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Lire la <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">documentation sur la configuration</a>",
"To remove this module" => "Pour retirer ce module",
"Admin Modules" => "Administrer les modules",
"and remove the assistant module" => "et retirer l'assistant module",
"You can also add other modules" => "Vous pouvez aussi ajouter d'autres modules",
"To customize the menu" => "Pour modifier le menu",
"Admin Menus" => "Administrer les menus",
"and edit menu ID 42" => "et modifier le menu ID 42",
"Or, create your own menu and add it to a module" => "Ou créez votre propre menu et ajoutez-le à un module",
"To begin configuring Tiki, please" => "Pour commencer la configuration de Tiki : ",
"login" => "identification",
"as the Admin" => "en tant qu'Admin",
"The Tikiwiki Community" => "La Communauté Tikiwiki",
"To learn more, visit: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>" => "Pour en savoir plus, visitez: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>",
"Tikiwiki Documentation" => "Documentation Tikiwiki",
"For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "Pour de l'aide, visitez <a href=\"http://doc.tikiwiki.org\" title=\"Documentation Tikiwiki\" target=\"_blank\">http://doc.tikiwiki.org</a>",
"Last `\$module_rows` blog comments" => "`\$module_rows` derniers commentaires de blogues",
"Last blog comments" => "Derniers commentaires de blogues",
" on blogpost " => " sur l'article de blogue ",
"Recently visited pages" => "Dernières pages visitées",
"January" => "Janvier",
"February" => "Février",
"March" => "Mars",
"April" => "Avril",
"May" => "Mai",
"June" => "Juin",
"July" => "Juillet",
"August" => "Août",
"September" => "Septembre",
"October" => "Octobre",
"November" => "Novembre",
"December" => "Décembre",
"Monday" => "Lundi",
"Tuesday" => "Mardi",
"Wednesday" => "Mercredi",
"Thursday" => "Jeudi",
"Friday" => "Vendredi",
"Saturday" => "Samedi",
"Sunday" => "Dimanche",
"Today" => "Aujourd'hui",
"Received objects" => "Objets reçus",
"Pages:" => "Pages :",
"Last `\$module_rows` Sites" => "Les `\$module_rows` derniers sites",
"Last Sites" => "Derniers sites",
"Directory Stats" => "Statistiques sur le répertoire des liens",
"Sites to validate" => "Sites à valider",
"Searches" => "Recherches",
"Visited links" => "Liens visités",
"Top \$module_rows Sites" => "Les \$module_rows sites les plus populaires",
"Top Sites" => "Sites vedette",
"Current events" => "Évènements courants",
"Featured links" => "Liens vedette",
"Top `\$module_rows` topics" => "Les `\$module_rows` sujets les plus populaires",
"Top topics" => "Sujets les plus populaires",
"Last `\$module_rows` forum posts" => "Derniers `\$module_rows` articles de forum",
"Last forum posts" => "Derniers articles de forum",
"Last `\$module_rows` forum topics" => "Les `\$module_rows` derniers sujets de forum",
"Last forum topics" => "Derniers sujets de forum",
"Most commented forums" => "Forums avec le plus de commentaires",
"Most read topics" => "Sujets les plus lus",
"Most visited forums" => "Forums les plus visités",
"Folksonomy" => "Folksonomie",
"Tags This Page Has" => "Tags associés à cette page",
"Add tags" => "Ajouter des tags",
"Most popular tags" => "Tags les plus populaires",
"My prefered tags" => "Mes Tags préférés",
"Google Search" => "Rechercher avec Google",
"Last `\$module_rows` actions" => "Dernières `\$module_rows` actions",
"Last actions" => "Dernières actions",
"Last `\$module_rows` articles" => "Les `\$module_rows` derniers articles",
"Last articles" => "Derniers articles",
"Last `\$module_rows` blog posts" => "Les `\$module_rows` derniers articles de blogues",
"Last blog posts" => "Derniers articles de blogue",
"Last" => "Derniers",
"Last `\$module_rows` Created blogs" => "Les `\$module_rows` derniers blogues créés",
"Last Created blogs" => "Derniers blogues créés",
"Last `\$module_rows` Created FAQs" => "Les `\$module_rows` derniers FAQs créés",
"Last Created FAQs" => "Dernières FAQs créées",
"Last `\$module_rows` Created Quizzes" => "Les `\$module_rows` derniers QCMs créés",
"Last Created Quizzes" => "Derniers QCMs créés",
"Last `\$module_rows` modified file galleries" => "Les `\$module_rows` dernières galeries de fichier modifiées",
"Last modified file galleries" => "Dernières galeries de fichiers modifiés",
"Last `\$module_rows` Files" => "Les `\$module_rows` derniers fichiers",
"Last Files" => "Derniers fichiers",
"Last `\$module_rows` galleries" => "Les `\$module_rows` dernières galeries d'images",
"Last galleries" => "Dernières galeries",
"Last `\$module_rows` Images" => "Dernières `\$module_rows` Images",
"Last Images" => "Dernières images",
"insert original" => "inserer l'original",
"insert thumbnail" => "inserer la miniature",
"Last `\$module_rows` modified events" => "Derniers `\$module_rows` évènements modifiés",
"Last modifed events" => "Derniers évènements modifiés",
"Last `\$module_rows` changes" => "Les `\$module_rows` dernières modifications",
"more" => "plus",
"Last `\$module_rows` Modified Items" => "Les `\$module_rows` dernières fiches modifiés",
"Last Modified Items" => "Dernières fiches modifiées",
"Last `\$module_rows` Modified blogs" => "Les `\$module_rows` derniers blogues modifiés",
"Last Modified blogs" => "Derniers blogues modifiés",
"Last `\$module_rows` submissions" => "Les `\$module_rows` dernières soumissions",
"Last submissions" => "Dernières soumissions",
"Last `\$module_rows` Modified Comments" => "Derniers `\$module_rows` commentaires modifiés",
"Last Modified Comments" => "Derniers commentaires modifiés",
"Last `\$module_rows` Items" => "Les `\$module_rows` dernières fiches",
"Last Items" => "Derniers Items",
"Last `\$module_rows` visitors" => "Derniers `\$module_rows` visiteurs",
"Last Visitors" => "Derniers visiteurs",
"No avatar." => "Aucun avatar.",
"Register" => "S'inscrire",
"You" => "Vous",
"Open operator console" => "Ouvrir une console opérateur",
"Online users" => "Utilisateurs connectés",
"We have" => "Il y a",
"online users" => "utilisateurs connectés",
"Logged in as" => "Connecté comme",
"Logout" => "Fermer la connexion",
"Switch User" => "Se connecter comme",
"Paramaters" => "Paramètres",
"applicable for this item" => "s'applique à cet élément",
"Switch" => "Échanger",
"Switch user" => "Se connecter comme",
"Login through CAS" => "Connexion avec CAS",
"Login as admin" => "Connexion comme admin",
"Login through Shibboleth" => "Connection via Shibboleth",
"Login as" => "Connexion comme",
"Email" => "Adresse électronique",
"eMail" => "Adresse électronique",
"Password" => "Mot de passe",
"Remember me" => "Mémorisez-moi",
"Click here to register" => "Cliquer ici pour vous inscrire",
"Click here if you've forgotten your password" => "Cliquer ici si vous avez oublié votre mot de passe",
"I forgot my pass" => "J'ai oublié mon mot de passe",
"I forgot my password" => "J'ai oublié mon mot de passe",
"Click here to login using the default security protocol" => "Cliquer ici pour vous connecter avec le protocole de sécurité par défaut",
"Click here to login using a secure protocol" => "Cliquer ici pour vos connecter en utilisant un protocole sécurisé",
"Secure" => "Sécurisé",
"Stay in ssl Mode" => "Rester dans le mode SSL",
"local account" => "compte local",
"OpenID Login" => "Login OpenID",
"Tiki Logo" => "Logo Tiki",
"You have" => "Vous avez",
"New Messages" => "Nouveaux messages",
"New Message" => "Nouveau message",
"You have 0 new messages" => "Vous n'avez aucun nouveau message",
"Waiting Submissions" => "Soumissions en attente",
"submissions waiting to be examined" => "Soumissions en attente d'examen",
"Old articles" => "Archives",
"Send a message to" => "Envoyer un message à",
"Send a message" => "Envoyer un message",
"Random Images" => "Images choisies au hasard",
"Random Pages" => "Pages choisies au hasard",
"Register as a new user" => "S'inscrire comme nouvel utilisateur",
"Your email could not be validated; make sure you email is correct and click register below." => "Votre adresse électronique ne peut pas être validée, vérifier qu'il est correct et cliquer sur S'inscrire.",
"Your registration code:" => "Votre code d'enregistrement :",
"Username" => "Nom d'utilisateur",
"Passcode to register (not your user password)" => "Passcode pour s'inscrire (pas votre mot de passe d'utilisateur)",
"Registration code" => "Code d'enregistrement",
"Repeat password" => "Encore",
"Generate a password" => "Générer un mot de passe",
"RSS Feeds" => "Canaux de syndication RSS",
"Wiki RSS" => "RSS Wiki",
"Blogs RSS" => "RSS Blogues",
"Articles RSS" => "RSS Articles",
"Image Galleries RSS" => "RSS Galeries d'images",
"File Galleries RSS" => "RSS Galeries de fichiers",
"Forums RSS" => "RSS Forums",
"Maps RSS" => "RSS Cartes",
"Calendars" => "Calendriers",
"Entire Site" => "Tout le site",
"Wiki Pages" => "Pages Wiki",
"Image Gals" => "Galeries d'images",
"Blog Posts" => "Articles du blogue",
"Search Wiki PageName" => "Rechercher une page Wiki par nom",
"Read More" => "En lire plus",
"Since your last visit on" => "Depuis votre dernière visite :",
"New Images" => "Nouvelle(s) image(s)",
"Wiki Pages Changed" => "Page(s) Wiki modifiée(s)",
"New Files" => "Nouveau(x) fichier(s)",
"New Comments" => "Nouveau(x) commentaire(s)",
"New Tracker Items" => "Nouvelle(s) fiche(s) de formulaire",
"New Calendar Events" => "Nouveaux évènements du calendrier",
"New Users" => "Nouveau(x) utilisateur(s)",
"click to edit" => "cliquer pour modifier",
"Nothing has changed" => "Aucun changement",
"click to show/hide" => "cliquer pour afficher/masquer",
"Site Language:" => "Langue du site : ",
"Site default" => "Réglage par défaut du site",
"TikiTests Menu" => "Menu TikiTests",
"List Tests" => "Liste de Tests",
"Create Test" => "Créer un Test",
"Most Active blogs" => "Blogues les plus actifs",
"Top `\$module_rows` articles" => "Les `\$module_rows` articles les plus populaires",
"Top articles" => "Articles les plus populaires",
"Top `\$module_rows` File Galleries" => "Les `\$module_rows` galeries de fichiers les plus populaires",
"Top File Galleries" => "Galeries de fichiers les plus populaires",
"Top `\$module_rows` files" => "Les `\$module_rows` fichiers les plus populaires",
"Top files" => "Fichiers les plus populaires",
"Top `\$module_rows` Forum Posters" => "Les `\$module_rows` plus actifs publieurs de forum",
"Top Forum Posters" => "Publieurs de forum les plus actifs",
"Top `\$module_rows` games" => "Les `\$module_rows` jeux les plus populaires",
"Top games" => "Jeux les plus populaires",
"Top `\$module_rows` galleries" => "Les `\$module_rows` galeries d'images les plus populaires",
"Top galleries" => "Galeries les plus populaires",
"Top `\$module_rows` Images" => "Les `\$module_rows` images les plus populaires",
"Top Images" => "Images les plus populaires",
"Top `\$module_rows` Objects" => "Les `\$module_rows` objets les plus vus",
"Top Objects" => "Objets les plus vus",
"Top `\$module_rows` Pages" => "Les `\$module_rows` pages les plus populaires",
"Top Pages" => "Pages les plus populaires",
"Top `\$module_rows` Quizzes" => "Les `\$module_rows` QCMS les plus populaires",
"Top Quizzes" => "QCMs les plus populaires",
"Most `\$module_rows` visited blogs" => "Les `\$module_rows` blogues les plus visités",
"Top `\$module_rows` Visited FAQs" => "Les `\$module_rows` FAQs les plus visités",
"Top Visited FAQs" => "Dernières FAQs visitées",
"Page translation" => "Traduction de Page",
"There are no translations of this page." => "Il n'y a pas de traductions de cette page.",
"view" => "afficher",
"Equivalent translations" => "Traductions équivalentes",
"Translations that need improvement" => "Traductions à affiner",
"update it" => "mettre à jour",
"Upcoming `\$module_rows` events" => "Les `\$module_rows` prochains évènements",
"The Next Event" => "Le prochain évènement",
"No Upcoming Events" => "Aucun évènement à venir",
"click to view" => "cliquer pour voir",
"My blogs" => "Mes blogues",
"My galleries" => "Mes galeries",
"My Pages" => "Mes pages",
"User tasks" => "Tâches utilisateur",
"Done" => "fait",
"Del" => "Effacer",
"Public tasks" => "Tâches publiques",
"select" => "choisissez",
"User informations" => "Info Utilisateur",
"Group informations" => "Info Groupe",
"You need to activate user and/or group trackers" => "Vous devez activer les formulaires utilisateur et/ou groupe",
"Top users" => "Utilisateurs les plus actifs",
"More" => "Plus",
"Whats related" => "En relation?",
"online user" => "utilisateur connecté",
"on host" => "sur le serveur",
"Last `\$module_rows` wiki comments" => "Les `\$module_rows` derniers commentaires Wiki",
"Last wiki comments" => "Derniers commentaires Wiki",
" on page " => " sur la page ",
"Real Name" => "Nom réel",
"Click to see the ratings" => "Cliquer pour voir les notations",
"vote" => "voter",
"Errors" => "Erreurs",
"Insert/Edit an internal wiki link" => "Insérer/Éditer un lien wiki interne",
"Wiki Link insert" => "Inserer un lien Wiki",
"Please make a selection of text in order to create a link" => "Veuillez sélectionner un texte pour pouvoir créer un lien",
"Insert an image" => "Insérer une image",
"Tiki Image - Insert an image" => "Tiki Image - Insérer une image",
"Structures:" => "Structures :",
"show structures" => "montrer les structures",
"hide structures" => "masquer les structures",
"Manage structures" => "Gérer les structures",
"Are you sure you want to remove this module?" => "Etes-vous sûr(e) de vouloir supprimer ce module ?",
"Powered by" => "Utilise",
"Execution time" => "Temps d'exécution",
"Memory usage" => "Mémoire utilisée",
"database queries used" => "Requêtes à la base de données utilisées",
"Server load" => "Charge du serveur",
"Locked" => "Verrouillé",
"page id" => "id page",
"Cached" => "Dans l'antémémoire",
"3d browser" => "navigateur 3d",
"Refresh" => "Réactualiser",
"Monitor this Page" => "Surveiller cette page",
"Stop Monitoring this Page" => "Arrêter de surveiller cette page",
"Backlinks" => "Pages pointant cette page",
"Previous page" => "Page précédente",
"Parent page" => "Page parente",
"Next page" => "Page suivante",
"Child" => "Enfant",
"Add Page" => "Ajouter des pages",
"First page" => "Première page",
"Last page" => "Dernière page",
"Last edited by" => "Dernièrement modifié par",
"based on work by" => "Basé sur le travail de",
"Page last modified on" => "Page modifiée dernièrement le",
"Contributors to this page" => "Collaborateur(s) de cette page",
"Created by:" => "Créé par :",
"Last Modification:" => "Dernière modification:",
"To edit the copyright notices" => "Pour modifier les notices de copyright",
"Click Here" => "Cliquer ici",
"The content on this page is licensed under the terms of the" => "Le contenu de cette page est licencié sous les termes ",
"The original document is available at" => "Le document d'origine est disponible à",
"For" => "Pour",
"Jump to Content" => "Aller au contenu",
"Report to Webmaster" => "Signaler au Webmaster",
"Made with" => "Utilise",
"powered by" => "Utilise",
"database queries used in " => "requête à la base de données utilisés dans ",
"on:" => "le :",
"star" => "étoile",
"half star" => "demi étoile",
"Send a link" => "Envoyer un lien",
"Translation" => "Traduction",
"Article image" => "Image d'article",
"Topic image" => "image du sujet",
"Add Comment" => "Commenter",
"1 comment" => "1 commentaire",
"comments" => "commentaires",
"close" => "fermer",
"Location : " => "Position : ",
"Show/Hide Left Menus" => "Voir/Cacher menus de gauche",
"Show/Hide Right Menus" => "Voir/Cacher menus de droite",
"Email this page" => "Envoyez cette page par courrier électronique",
"Rename" => "Renommer",
"Similar" => "Similaire",
"Undo" => "Annuler",
"Slides" => "Diapositives",
"Export" => "Exporter",
"Discuss" => "Discussion",
"Attach File" => "Fichier-joint",
"1 File Attached" => "1 fichier joint",
"{\$atts_cnt} files attached" => "{\$atts_cnt} fichiers joints",
"Last Modification" => "Dernière modification",
"logged as" => "Connecté comme",
"pass" => "mot de passe",
"Page generated in" => "Page générée en",
"The newsletter was sent to {\$sent} email addresses" => "Cette lettre d'informations a été envoyée à {\$sent} adresses électroniques",
"This newsletter will be sent to {\$subscribers} email addresses." => "Cette lettre d'informations va être envoyée à {\$subscribers} adresses électroniques.",
"Prepare a newsletter to be sent" => "Préparer une lettre d'informations pour être envoyée",
"Apply template" => "Appliquer un gabarit",
"Data" => "Contenu",
"Send Newsletters" => "Envoyer des lettres d'informations",
"Sent editions" => "Lettres d'informations envoyées",
"sent" => "envoyé",
"User List" => "Liste des Utilisateurs",
"Homework" => "Devoirs",
"Assignments" => "Devoirs",
"Last Changes" => "Dernières modifications",
"Edit article" => "Modifier un article",
"Backups" => "Sauvegardes",
"{|} Files Attached" => "{|} Fichiers attachés",
"User files" => "Fichiers utilisateur",
"Favorites" => "Préférés",
"Watches" => "Notifications",
"home" => "page d'accueil",
"chat" => "discuter",
"contact us" => "nous contacter",
"Member list" => "Liste des membres",
"dump" => "fichier-dump",
"rankings" => "classements",
"List Pages" => "Liste des pages",
"orphan pages" => "pages orphelines",
"sandbox" => "bac à sable",
"received pages" => "pages reçues",
"Articles Home" => "Accueil - Articles",
"Create/Edit Blog" => "Ajouter/modifier un blogue",
"Browse Directory" => "Parcourir les liens du répertoire",
"List Quizzes" => "Liste des QCMs",
"List Trackers" => "Liste des formulaires",
"List Surveys" => "Liste des enquêtes",
"Back to Homepage" => "Retourner à la page d'accueil",
"This page is being edited by" => "Cette page est en train d'être modifiée par",
"Proceed at your own peril" => "Continuez à vos propres risques",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Le bac à sable est une page où vous pouvez vous entraîner à mettre à jour une page : utiliser la fonction 'Aperçu' pour avoir un aperçu de la page; aucune version de cette page ne sera sauvegardée.",
"My Footnotes" => "Mes notes de bas de page personnelles",
"Edit Summary" => "Résumé de la modification",
"Year:" => "Année :",
"Authors:" => "Auteurs :",
"Allow HTML" => "Permettre le HTML",
"Spellcheck" => "Correcteur orthographique",
"Import page" => "Importer une page",
"export all versions" => "exporter toutes les versions",
"Upload picture" => "Envoyer une image",
"no cache" => "non",
"License" => "Licence",
"Minor" => "Mineur",
"Cancel Edit" => "Annuler la modification",
"RSS Trackers" => "Canal de syndication RSS pour les formulaires",
"left/right" => "gauche/droite",
"Unassign module" => "Désattribuer un module",
"debugger console" => "console de débug",
"Mini Calendar" => "Mon calendrier",
"Edit mapfiles" => "Modifier les fichiers-carte",
"Quick edit a Wiki page" => "Créer/modifier une page Wiki",
"Language: " => "Langue : ",
"Language" => "Langue",
"Edit Post" => "Modifier une publication",
"Use wysiwyg editor" => "Utiliser un éditeur Wysiwyg",
"Use normal editor" => "Utiliser un éditeur non Wysiwyg",
"View Blog" => "Afficher le blogue",
"List Blogs" => "Liste des blogues",
"Use ...page... to separate pages in a multi-page post" => "Utiliser ...page... pour séparer les pages",
"Upload image for this post" => "Envoyer cette image pour cette publication",
"Trash" => "Corbeille",
"Mark entry as private:" => "Marquer l'entrée comme privé :",
"Send trackback pings to:" => "Envoyer des pings 'je vous ai référencé' :",
"(comma separated list of URIs)" => "(liste des URIs séparées par des virgules)",
"Save and Exit" => "Enregistrer et quitter",
"This is" => "",
"by the" => "par la",
"Tiki community" => "communauté Tiki",
"Find:" => "Trouver :",
"Sort posts by:" => "Trier les articles par :",
"read more" => "en lire plus",
"Permalink" => "URL du blogue (permalink)",
"View Comments" => "Afficher les commentaires",
"Email This Post" => "envoyer par email cet article",
"Viewing blog post" => "Affichage des articles du blogue",
"Return to blog" => "Retourner au blogue",
"Trackback pings" => "Pings 'je vous ai référencé'",
"Blog name" => "Nom du blogue",
"Show/Hide Left Modules" => "Afficher/Cacher les Modules gauche",
"Show/Hide Right Modules" => "Afficher/Cacher les Modules droits",
"Last update from CVS" => "Dernière mise à jour CVS",
"Translate in" => "Traduire en",
"babelfish it" => "utiliser Babelfish",
"Welcome to" => "Bienvenue sur",
"Enlarge area height" => "Augmenter la hauteur de la zone",
"Reduce area height" => "Réduire la hauteur de la zone",
"Do not group by item" => "Ne pas grouper par élément",
"Group by item" => "Grouper par élément",
"Calendar View" => "Vue calendrier",
"List View" => "Vue en liste",
"Tiki Action Calendar" => "Calendrier des actions Tiki",
"Tools Calendars" => "Calendriers des objets Tiki",
"Check / Uncheck All" => "Cocher/décocher tout",
"Apply" => "Appliquer",
"Reset" => "Réinitialiser",
"Site Ads and Banners" => "Bannières et publicité du site",
"Activate" => "Activer",
"Content" => "Contenu",
"Publish" => "Le publier",
"General" => "Général",
"Features" => "Fonctionnalités",
"Meta Tags" => "Méta balises",
"Wysiwyg editor" => "Editeur Wysiwyg",
"Customize look and feel of your Tiki" => "Modifier l'aspect et la convivialité de votre Tikiwiki",
"Text area" => "Zone de texte",
"To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "Pour ajouter ou supprimer un blogue, aller dans \"Ajouter/modifier un blogue\" sous \"Blogues\" dans le menu application, ou",
"Home Blog" => "Accueil-Blogue",
"Home Blog (main blog)" => "Accueil - Blogues",
"Blog features" => "Fonctionnalités des blogues",
"Blog level comments" => "Commentaires au niveau blogue",
"Post level comments" => "Commentaires au niveau article",
"Trackbacks Pings" => " Pings 'je vous ai référencé'",
"Spellchecking" => "Correction orthographique",
"Not Installed" => "Pas installé",
"Blogs have a custom heading" => "Personnalisation des entêtes de blogues",
"Default ordering for blog listing" => "Ordre par défaut d'affichage des blogues",
"Creation date (desc)" => "Date de création (desc)",
"Last modification date (desc)" => "Date de dernière modification (desc)",
"Blog title (asc)" => "Titre du blogue (asc)",
"Number of posts (desc)" => "Nombre d'articles (desc)",
"Visits (desc)" => "Visites (desc)",
"Activity (desc)" => "Activité (desc)",
"Force and limit categorization to within subtree of" => "Forcer et limiter la catégorisation à cette sous-arborescence",
"Change preferences" => "Modifier les préférences",
"Blog listing configuration (when listing available blogs)" => "Configuration de l'affichage des blogues (quand la liste des blogues est disponible)",
"Title length" => "Longueur du titre",
"Creation date" => "Date de création",
"Last modification time" => "Dernière modif.",
"Disabled" => "Désactivée",
"Plain text" => "Texte en clair",
"Link to user information" => "Lien vers les informations utilisateur",
"User avatar" => "Avatar utilisateur",
"Blog comments settings" => "Configuration des commentaires de blogues",
"Default number of comments per page" => "Nb. max. de commentaires par page",
"Comments default ordering" => "Ordre par défaut des commentaires",
"To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "Pour ajouter/supprimer des calendriers, allez à Calendrier sous l'option Administrer du menu application, ou",
"Group calendar sticky popup" => "Popups des calendriers de groupe collante",
"Group calendar item view tab" => "Onglet vue d'un item pour le calendrier de groupe",
"Default view mode" => "Vue par défaut",
"Day" => "Jour",
"Week" => "Semaine",
"Month" => "Mois",
"Quarter" => "Trimestre",
"Semester" => "Semestre",
"Calendar manual selection of time/date" => "Sélection manuelle temps/date dans le calendrier",
"First day of the week" => "Premier jour de la semaine",
"Depends user language" => "Selon langue utilisateur",
"Split hours in periods of" => "Découpage des heures par",
"First year in the dropdown, either year number, or relative to current year (+/- N)" => "Première année dans les listes déroulantes, sinon le nombre d'années, ou relativement à l'année courante (+/- N)",
"if no jscalendar" => "Si jscalendar non activé",
"Last year in the dropdown, either year number, or relative to current year (+/- N)" => "Derniêre année dans les listes déroulantes, sinon le nombre d'années, ou relativement à l'année courante (+/- N)",
"Change settings" => "Changer la configuration",
"Use categories to regroup various Tiki objects" => "Utilisez les catégories pour regrouper différents objets Tiki",
"Link to" => "Lien vers",
"Browse categories" => "Parcourir les catégories",
"Administer categories" => "Administrer les catégories",
"Show Category Path" => "Montrer l'arborescence des catégories",
"Show Category Objects" => "Montrer les objets de la catégorie",
"Search may show forbidden results. Much better performance though." => "La recherche peut montrer des résultats interdits. Les performances sont meilleures cependant",
"Ignore category viewing restrictions" => "Ignorer les restrictions d'affichage sur les catégories",
"Permission to all (not just any) of an object's categories is required for access" => "Le droit d'accès à un objet nécessite les permissions sur toutes (pas seulement l'une d'entre elles) des catégories associées à un objet (ex catégories renforcées)",
"Categories browse uses PhpLayers" => "Le parcours des catégories se fait à l'aide de PhpLayers",
"The feature must be activated" => "La fonctionnalité doit être activée",
"Look under \"Articles\" on the application menu for links to" => "Regardez sous \"Articles\" dans le menu application pour les liens vers",
"CMS features" => "Fonctionnalités du CMS",
"Submissions" => "Soumissions",
"Use templates" => "Utiliser les gabarits",
"Print article" => "Imprimer un article",
"Can specify notification emails when creating an article" => "Peut demander les mails de notification lors de la création d'un article",
"Settings for page articles home" => "Configuration pour la page d'accueil des articles",
"Maximum number of articles in home" => "Nombre maximal d'articles dans l'accueil",
"Topic" => "Sujet",
"Article comments settings" => "Configuration des commentaires d'articles",
"Fields to display on page" => "Champs à afficher sur la page",
"Publish Date" => "Date de publication",
"Expire Date" => "Date d'expiration",
"Import CSV file" => "Importer un fichier CSV",
"Batch upload (CSV file):" => "Chargement par lot (fichier CSV) :",
"Import" => "Importer",
"User identity features" => "Configuration de l'identité d'un utilisateur",
"Show user's info on mouseover" => "Montrer ses info. utilisateur au passage de la souris",
"Picture" => "Image",
"Number of friends" => "Nombre d'amis",
"E-mail" => "Adresse électronique",
"Last login" => "Dernière connexion",
"Set features" => "Valider les fonctionnalités",
"Users sort order" => "Ordre de tri des utilisateurs",
"Score ascending" => "Score croissant",
"Score descending" => "Score décroissant",
"Name ascending" => "Nom croissant",
"Name descending" => "Nom décroissant",
"Login ascending" => "Login croissant",
"Login descending" => "Login décroissant",
"Copyright allows to determine a copyright for all the objects of tikiwiki" => "Le Copyright permet de fixer le droit d'exploitation sur tous les objets du tikiwiki",
"Copyright Management" => "Administration du Copyright",
"License Page" => "Page de la licence",
"Submit Notice" => "Soumettre une notice",
"Enable Feature for Wiki" => "Active le copyright pour les pages wiki",
"Enable Feature for Articles" => "Active le copyright pour les articles",
"Enable Feature for Blogues" => "Active le copyright pour les blogues",
"Enable Feature for Faqs" => "Active le copyright pour les FAQs",
"To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "Pour configurer vos liens, allez dans \"Administrer les liens \" dans \"Répertoire de liens\" dans le menu application, ou",
"Number of columns per page when listing categories" => "Nombre de colonnes par page à l'affichage des catégories",
"Links per page" => "Liens par page",
"Validate URLs" => "Tester la validité des adresses Web",
"enable cool sites" => "Activer les sites cools",
"Show Country Flag" => "Afficher les drapeaux des pays",
"Method to open directory links" => "Méthode pour ouvrir les liens du répertoire",
"replace current window" => "remplacer la fenêtre courante (r)",
"New Window" => "Nouvelle fenêtre (n)",
"inline frame" => "cadre dans la fenêtre (i)",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Pour créer/supprimer une FAQ, allez dans \"Administrer les FAQs\" dans \"FAQs\" dans le menu application, ou",
"Question and Answer prefix on Answers" => "Préfixes aux questions et réponses dans la partie réponses",
"Q and A" => "Q et R",
"Question ID" => "Niméro de la question",
"Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site." => "Merci d'aller voir <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>l'évaluation de chaque fonctionnalité</a> sur le site de développement de TikiWiki.",
"No tabs" => "Pas d'onglets",
"Main" => "Principales",
"Global Features" => "Fonctionnalités globales",
"More Functionality" => "Autres Fonctionnalités",
"Technology" => "Techno.",
"UI Enhancements" => "Interface",
"Extra Stuff &amp; Fun" => "Spécial &amp; Fun",
"Content Related" => "Contenu",
"Main Features" => "Fonctionnalités Principales",
"Action Log" => "Journal des actions",
"Action log setting" => "Configuration du journal des actions",
"Feature documentation links" => "Liens vers la documentation des fonctionnalités",
"Help System (Feature documentation links)" => "Système d'aide (Liens vers la documentation des fontionnalités)",
"Featured Help" => "Aide Liens vedette",
"Spreadsheet" => "Tableur",
"Tiki Sheet" => "Feuillet Tiki",
"Copyright System" => "Droits réservés(Copyright)",
"Copyright system" => "Système de copyright",
"Live Support" => "Assistance en ligne",
"Live support system" => "Système d'assistance en ligne",
"Tell a Friend" => "Dire à un ami",
"Allow to post comments as Anonymous" => "Autoriser de poster des commentaires en tant qu'Anonyme",
"Technical Features" => "Fonctionnalités techniques",
"XMLRPC API" => "API XMLRPC",
"HTML Purifier" => "Purificateur HTML",
"HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Le contenu est nettoyé en XHTML 1.1 Strict à chaque enregistrement)",
"PhpLayers Dynamic menus" => "Menus dynamiques PhpLayers",
"Allow users to activate fullscreen mode" => "Autoriser les utilisateurs à activer le mode plein écran",
"required" => "obligatoire",
"Experimental Features" => "Fonctionnalités expérimentales",
"Workflow engine" => "Moteur de workflow",
"Friendship" => "Réseaux d'amis",
"Morcego 3D browser" => "Navigateur 3D Morcego",
"Content Features" => "Fonctionnalités contenu",
"Edit Templates" => "Modifier les gabarits",
"Hotwords in New Windows" => "Mot/liens automatiques dans une nouvelle fenêtre",
"Use File Galleries for images inclusion" => "Utiliser les galeries de fichiers pour l'inclusion d'images",
"Custom Home" => "Page d'accueil personnalisée",
"HTML Pages" => "Pages HTML",
"Dynamic Content System" => "Système de contenu dynamique",
"Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Pour le texte auquel on répond, utilise le plugin QUOTE à la place de &ldquo;&gt;&rdquo;",
"Administration Features" => "Fonctionnalités administrateur",
"Banning System" => "Système d'interdiction",
"Banning system" => "Système d'interdiction",
"Debugger Console" => "Console de debug",
"Action Calendar" => "Calendrier des actions",
"Tiki action calendar" => "calendrier des actions Tiki",
"Referer Stats" => "Statistiques des origines",
"Contact Us" => "Nous contacter",
"Contact Us (Anonymous)" => "Nous contacter (anonymement)",
"Redirect On Error" => "Re-direction en cas d'erreur",
"Communications (send/receive objects)" => "Communications (envoyer/recevoir des objets)",
"User Features" => "Fonctionnalités utilisateur",
"Display 'MyTiki' in the application menu" => "Affiche 'MonTiki' dans le menu application",
"User Preferences Screen" => "Écrans des préférences utilisateur",
"User Notepad" => "Bloc-note utilisateur",
"User Bookmarks" => "Signets utilisateur",
"User Contacts" => "Contacts utilisateur",
"User Watches" => "Mes notifications de changement",
"User Watches Translations" => "Notification par email des changements dans un jeu de traduction",
"User Tasks" => "Tâches utilisateur",
"User Messages" => "Messages utilisateur",
"User Files" => "Fichiers utilisateur",
"User Levels" => "Niveaux Utilisateurs",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Pour créer/supprimer une galerie de fichiers, allez dans \"Galeries de fichiers\" dans le menu application, ou",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Si vous décidez d'archiver les fichiers dans un répertoire vous devez vous assurez que les utilisateurs ne peuvent accéder directement au répertoire.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Vous avez deux options pour effectuer cela:<br /><ul><li>Utiliser un répertoire hors du repertoire Web, assurer vous que votre script php ne peut pas lire et écrire dans ce répertoire</li><li>Uitiliser un répertoire dans le répertoire Web et utiliser un fichier .htaccess pour empêcher les utilisateur de lire le contenu du répertoire</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Pour configurer le chemin du répertoire, utiliser la syntaxe UN*X, comme par exemple : fichiers/ ou c:/foo/fichiers ou /www/fichiers/",
"Home Gallery" => "Accueil-Galerie d'images",
"Home Gallery (main gallery)" => "Accueil - Galerie",
"Galleries features" => "Fonctionnalités des galeries",
"File author" => "Auteur du fichier",
"For not registered author" => "Pour auteurs non enregistrés",
"Allow same file to be uploaded more than once" => "Permettre à un même fichier d'être envoyé plusieurs fois",
"Never" => "Jamais",
"Yes, even in the same gallery" => "Oui, aussi dans la même galerie",
"Only in different galleries" => "Seulement dans des galeries différentes",
"Use database to store files" => "Utiliser la base de données pour stocker les fichiers",
"Use a directory to store files" => "Utiliser un répertoire pour stocker les fichiers",
"Directory path" => "Chemin du répertoire",
"The server must be able to read/write the directory." => "Le serveur web doit avoir les droits en lecture écriture sur le répertoire.",
"The directory can be outside the web space." => "Le répertoire peut être en-dehors de l'espace web",
"PodCast directory (must be web accessible):" => "Répertoire de podcast (doit être accessible depuis le web):",
"Directory Batch Loading" => "Répertoire de téléchargement par lot",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "Si vous autorisez le téléchargement par lots, il vous faudra définir un répertoire accessible en lecture depuis le web (en-dehors de votre espace web serait mieux). Ensuite, prévoir un moyen pour télécharger des fichiers vers ce répertoire (par scp, ftp ou d'autres protocoles).",
"Enable directory batch loading" => "Permettre le téléchargement par lot par répertoire",
"Batch loading directory" => "Répertoire de téléchargement par lot",
"The server must be able to read the directory." => "Le serveur web doit avoir les droits en lecture sur le répertoire.",
"Uploaded filenames must match regex" => "Les noms de fichiers envoyés doivent correspondre aux expressions régulières",
"Uploaded filenames cannot match regex" => "Noms de fichiers envoyés ne doivent pas correspondre aux expressions régulières",
"Gallery listing configuration" => "Configuration de l'affichage des galeries",
"Change configuration" => "Modifier la configuration",
"File galleries comments settings" => "Configuration des commentaires de galeries de fichiers",
"File galleries search indexing" => "Indexation des galeries de fichiers",
"Leave command blank to delete handler" => "Laisser la commande à blanc pour détruire l'association",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Utiliser %1 pour indiquer le nom du fichier interne dans la commande (exemple: \"strings %1\" pour convertir le fichier en texte en utilisant la commande unix strings)",
"Enable auto indexing on file upload or change" => "Permettre l'indexation automatique à l'envoi ou changement de fichier",
"MIME Type" => "Type MIME",
"System command" => "Commande système",
"Reindex all files for search" => "Ré-indexe tous les fichiers pour la recherche",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Pour créer/supprimer un forum, allez dans \"Administrer les forums\" sous \"Forums\" dans le menu application, ou",
"Home Forum" => "Accueil-Forum",
"Home Forum (main forum)" => "Accueil - forums",
"Forums features" => "Fonctionnalités des forums",
"Accept wiki syntax" => "Accepter la syntaxe Wiki",
"Enable topics archiving" => "Activer l'archivage des sujets",
"Allow first posts of a thread to have an empty body (will be a thread title)" => "Permettre aux premiers articles d'un fil de discussion d'avoir un corps vide (sera un titre d'article)",
"Reply posts are empty" => "Ne pas mettre de citation dans les réponses",
"Forum quick jumps" => "Aller directement au forum",
"Ordering for forums in the forum listing" => "Ordre des forums dans la liste",
"Creation Date (asc)" => "Date de Création (asc)",
"Creation Date (desc)" => "Date de création (desc)",
"Topics (desc)" => "Sujets (desc)",
"Threads (desc)" => "Fils de discussion (desc)",
"Last post (desc)" => "Dernier article (desc)",
"Name (desc)" => "Nom (desc)",
"Name (asc)" => "Nom (asc)",
"Search some forums by name (on \"forum list\")" => "Rechercher des forums par leur nom (sur la liste des forums)",
"Search some forums by content on \"forum list\" (needs feature_search activated)" => "Trouver des forums par le contenu dans la liste des forums (nécessite l'activation de feature_search)",
"Search in topics content on forum page (needs feature_search activated)" => "Rechercher dans le contenu des forums sur les pages des forums (nécessite l'activation de feature_search)",
"Do not prefix messages titles by 'Re: '" => "Ne pas préfixer les titres des messages par 'Re : '",
"Forum listing configuration" => "Configuration de l'affichage des forums",
"Topics" => "Sujets",
"Posts per day" => "Publications par jour",
"Threads default preferences" => "Préférences des articles par défaut",
"Allow to manage thread defaults in each forum configuration" => "Permettre de configurer les paramètres par défaut des articles dans chaque configuation de forum",
"Display thread configuration bar to override defaults" => "Afficher la barre de configuration de l'affichage pour pouvoir modifier les paramètres par défaut",
"Configuration bar settings are kept for all forums during the user session:" => "Les paramètres d'affichage sont conservés pour tous les forums pendant la session de l'utilisateur :",
"Default thread style" => "Style par défaut du fil",
"Default thread sort mode" => "Tri par défaut des articles",
"Freetags rock!" => "Freetags est super!",
"Freetag Browsing" => "Parcourir les freetags",
"Show Tag Cloud" => "Montrer le nuage de mots-clés (Tag Cloud)",
"Random tag cloud colors (separated by comma)" => "Couleurs des éléments du nuage choisies au hasard(liste séparée par des virgules)",
"Preload freetag random search when arriving on <a href=\"tiki-browse_freetags.php\">freetag search grid</a>" => "Recherche aléatoire sur un tag en arrivant sur la <a href=\"tiki-browse_freetags.php\">page de recherche de freetags</a>",
"Number of Tags to show in Cloud" => "Nombre de mots-clés à afficher dans le nuage",
"Number of Tags to show in Tag Suggestions" => "Nombre de tags à présenter dans les suggestions de tags",
"Valid characters pattern" => "Expression régulière des caractères valides ",
"Only accept alphanumeric ASCII freetags (no accents or special chars)" => "N'accepter que des mots-clés alphanumériques ASCII (pas d'accents ou de caractères spéciaux)",
"Accept all" => "Accepter tout",
"Only accept lowercase freetags" => "N'accepter les freetags qu'en minuscule",
"Handle multilingual freetags" => "Gérer les freetags multilingues",
"Tag Management" => "Gestion des freetags",
"Cleanup unused tags" => "Purge des freetags inutilisés",
"cleanup" => "nettoyage",
"basic" => "basique",
"weighted" => "pondéré",
"Freetag 3D Browser Configuration" => "Configuration du navigateur de mots-clés 3D",
"Enable freetags 3D browser" => "Activer le navigateur de mots-clés 3D",
"Browser width" => "Largeur du navigateur",
"Browser height" => "Hauteur du navigateur",
"Graph appearance" => "Apparence du graphique",
"Navigation depth" => "Profondeur de navigation",
"Node size" => "Taille de noeud",
"Text size" => "Taille du texte",
"Spring (connection) size" => "Taille de l'élastique (connexion)",
"Node color" => "Couleur des noeuds",
"Camera settings" => "Propriétés de la caméra",
"Camera distance adjusted relative to nearest node" => "Distance de la camera ajustée relativement au noeud le plus proche",
"Camera distance" => "Distance de la camera",
"Field of view" => "Champ de vision",
"Feed animation interval (milisecs)" => "Intervalle (millisecs) de rafraîchissement",
"Physics engine" => "Moteur physique",
"Friction constant" => "Constante de friction",
"Elastic constant" => "Constante d'élasticité",
"Eletrostatic constant" => "Constante électrostatique",
"Node mass" => "Masse du noeud",
"Node charge" => "Charge de noeud",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Pour créer/supprimer une galerie d'images, allez dans \"Galeries d'images\" dans le menu application, ou",
"You can upload images of a size of " => "Vous pouvez envoyer des images d'une taille de ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Modifier les variables dans php.ini : file_uploads, upload_max_filesize, post_max_size et les variables de base de donnée (max_allowed_packet pour mysql) pour changer cette valeur",
"Uses Slideshow" => "Permettre les diaporamas",
"Use database to store images" => "Utiliser la base de données pour stocker les images",
"Use a directory to store images" => "Utiliser un répertoire pour stocker les images",
"Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below." => "Remarque : si vous changez le répertoire, vous devez déplacer le contenu dans le nouveau répertoire. Vous pouvez aussi utiliser l'outil 'Déplacer' ci-dessous.",
"Library to use for processing images" => "Librairie à utiliser pour transformer les images",
"Uploaded image names must match regex" => "Les noms d'images envoyées doivent correspondre aux expressions régulières",
"Uploaded image names cannot match regex" => "Les noms d'images envoyées ne doivent pas correspondre aux expressions régulières",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Si vous activez le téléchargement par lot, vous devez créer un répertoire pouvant être lu par le serveur web (de préférence hors de l'arborescence du site). Ensuite installer un moyen d'envoyer les images dans ce répertoire par ftp, scp ou autres",
"Display image informations in a mouseover box" => "Afficher les informations lors du survol de l'image dans une fenêtre popup",
"Yes" => "Oui",
"yes, and don't display those informations under the image" => "Oui et ne plus afficher ces informations sous l'image",
"Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Utiliser les paramètres nombre max de rangées, images par rangée, taille des vignettes et échelle par défaut pour toutes les galeries (valeurs fixées ci-dessous)",
"Images per row" => "Nombre d'images par rangée",
"Thumbnails size X" => "Taille X des vignettes",
"Thumbnails size Y" => "Taille Y des vignettes",
"Default scale size" => "Echelle par défaut",
"Exterminator" => "Nettoyer les caches",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Supprimer les images de la galerie système qui ne sont pas utilisées dans les pages Wiki, dans les articles ou dans les articles des blogues",
"Mover" => "Déplacer",
"Move images from database storage to filesystem storage" => "Déplacer les images de la base de données vers le filesystem",
"Move images from filesystem storage to database storage" => "Déplacer les images du filesystem vers la base de données",
"All galleries" => "Toutes les galeries",
"Move images from old filesystem store to new directory" => "Déplace les images de l'ancien filesystem dans un nouveu répertoire",
"Moved" => "Déplacé",
"Last modified" => "Modifié",
"Image galleries comments settings" => "Configuration des commentaires de galeries d'images",
"General Preferences" => "Préférences générales",
"Tikiwiki version" => "Version Tikiwiki",
"Use group homepages" => "Utiliser les pages d'accueil de groupe",
"Go to group homepage only if login from default homepage" => "Aller à la page d'accueil du groupe seulement si loggé depuis la page d'accueil par défaut",
"Use URI as Home Page" => "Utiliser cette URI comme page d'accueil",
"Home page" => "Page d'accueil",
"Custom home" => "Personnaliser l'accueil",
"OS" => "Système d'exploitation",
"Unknown/Other" => "Inconnu/Autre",
"PHP error reporting level:" => "Niveau de rapport d'erreurs PHP :",
"No error reporting" => "Rapport d'erreurs désactivé",
"Report all PHP errors" => "Rapporter toutes les erreurs PHP",
"Report all errors except notices" => "Rapporter toutes les erreurs sauf les notices",
"visible to admin only" => "visible seulement par les administrateurs",
"smarty notice reporting" => "signaler les notices Smarty",
"Log Mail in Tiki Logs:" => "Logguer les mail dans les Tiki Logs:",
"Default charset for sending mail:" => "Encodage des caractères par défaut pour envoyer des emails :",
"Mail end of line:" => "Fin des lignes des mails:",
"(some Unix MTA)" => "(certains serveurs de mail Unix. Ex: gmail)",
"General Settings" => "Configuration générale",
"Disallow access to the site (except for those with permission)" => "Refuser l'accès au site (sauf pour les utilisateurs ayant le droit \"tiki_p_access_closed_site\")",
"Message to display when site is closed" => "Message à afficher quand le site est fermé",
"Disallow access when load is above the threshold (except for those with permission)" => "Refuser l'accès au site quand la charge est au-dessus du seuil (sauf pour les utilisateurs ayant le droit \"tiki_p_access_closed_site\")",
"Max average server load threshold in the last minute" => "Moyenne maximale de la charge du serveur dans la dernière minute",
"Message to display when server is too busy" => "Message à afficher quand le serveur est trop chargé",
"Use cache for external pages" => "Utiliser l'antémémoire pour les pages externes",
"Use cache for external images" => "Utiliser l'antémémoire pour les images externes",
"Tikiwiki.org help" => "Aide de Tikiwiki.org",
"Use gzipped output" => "Compacter les sorties (gzip)",
"output compression is active." => "compression en sortie activée.",
"compression is handled by" => "compression géré par",
"Count admin pageviews" => "Compter les affichages de pages d'administration",
"Browser title" => "Titre des fenêtres",
"Temporary directory" => "Répertoire temporaire",
"Sender Email" => "Adresse électronique des messages envoyés",
"Contact user" => "Utilisateur du contact",
"Allow anonymous users to \"Contact Us\"" => "Permettre aux utilisateurs anonymes le \"Nous contacter\"",
"contact feature disabled" => "fonctionnalité contact désactivée",
"Store session data in database" => "Sauvegarder les données de session dans la base de données",
"Session lifetime in minutes" => "Durée d'une session en minutes",
"Use proxy" => "Utiliser un serveur proxy",
"Proxy Host" => "IP du serveur proxy",
"Proxy port" => "Port du serveur proxy",
"Maximum number of records in listings" => "Nombre maximum d'éléments affichés dans chaque liste",
"Help System" => "Système d'aide",
"Help URL" => "URL de l'aide",
"Please expect not found help-pages with the default-URL." => "SVP, attendez vous à des pages non trouvées avec l'URL par défaut.",
"Any help with the documentation is welcome." => "Toute aide avec la documentation est bienvenue.",
"Release check" => "Contrôle de version",
"Check frequency" => "Fréquence des contrôles",
"Each day" => "Chaque jour",
"Each week" => "Chaque semaine",
"Each month" => "Chaque mois",
"Release checks are made when you browse admin main page only" => "Les contrôles de version ne se font que lorsque vous naviguez sur la page d'administration principale",
"Force immediate check" => "Forcer un contrôle immédiat",
"Date and Time Formats" => "Format des dates et temps",
"Default timezone" => "Fuseau horaire par défaut",
"Long date format" => "Format long pour la date",
"Short date format" => "Format court pour la date",
"Long time format" => "Format long pour le temps",
"Short time format" => "Format court pour le temps",
"Fields display order" => "Ordre d'affichage des champs",
"Date and Time Format Help" => "Aide sur le format des dates et temps",
"When possible, show the real user name instead of login:" => "Lorsque possible, afficher le nom réel de l'utilisateur au lieu du login :",
"Locations separator" => "Séparateur de fils d'Ariane",
"Examples" => "Exemples",
"Choices separator" => "Séparateur des choix",
"Preference syntax" => "Syntaxe des préférences",
"Change admin password" => "Modifier le mot de passe de l'administrateur",
"New password" => "Nouveau mot de passe",
"Change password" => "Changer votre mot de passe",
"Google Map setup" => "Configuration des cartes Google",
"Google Map Key" => "Clé Carte Google",
"Default x for map center" => "x par défaut pour le centre de la carte",
"Default y from map center" => "y par défaut pour le centre de la carte",
"Default zoom level" => "Niveau du zoom par défaut",
"whole earth" => "toute la terre",
"country size" => "taille pays",
"city size" => "taille ville",
"max zoom" => "zoom maximum",
"Internationalization" => "Internationalisation",
"I18n setup" => "Configuration I18n",
"Default Language" => "Langue choisie par défaut ",
"Multilingual" => "Multilingue",
"Multilingual structures" => "Structures multilingues",
"Show pages in user's preferred language" => "Afficher les pages dans la langue préférée de l'utilisateur ",
"Detect browser language" => "Utiliser la préférence langue du navigateur",
"Restrict supported languages" => "Restreindre la liste des langues disponibles ",
"Available languages (Ctrl+Click to select multiple languages):" => "Langues disponibles (faire Ctrl+Clic pour sélectionner plusieurs langues) :",
"Use database for translation" => "Utiliser la base de données pour les traductions",
"Edit or ex/import Languages" => "Modifier ou Im/Export une langue",
"Record untranslated" => "Enregistrement non traduit",
"Show Babelfish Translation URLs" => "Afficher les URLs de traduction Babelfish",
"Show Babelfish Translation Logo" => "Afficher le logo de traduction Babelfish",
"Intertiki exchange feature" => "Fonctionnalité d'échange InterTiki",
"Intertiki client" => "Client Intertiki",
"Tiki Unique key" => "Clé unique Tiki",
"InterTiki Slave mode" => "Mode InterTiki esclave",
"Warning: overrides manually registered local users" => "Attention: écrase manuellement les utilisateurs localement enregistrés",
" as master" => " comme maître",
"Import user preferences" => "Importer des préférences utilisateur",
"Import user groups" => "Importer des groupes d'utilisateurs",
"Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limiter les groupes importés (liste séparée par des virgules des groupes, laisser vide pour ne pas limiter)",
"Intertiki shared cookie for sliding auth under same domain" => "Cookie partagé par plusieurs Tiki pour le partage de l'authentification pour un même domaine",
"InterTiki Server" => "Serveur InterTiki",
"host" => "hôte",
"Add new server" => "Ajouter un nouveau serveur",
"Intertiki server" => "Serveur Intertiki",
"Intertiki Server enabled" => "Serveur Intertiki activé",
"Access Log file" => "Fichier log des accès",
"Errors Log file" => "Fichier log des erreurs",
"Known hosts" => "Hôtes connus",
"Key" => "Clé",
"Enable/disable Tiki features in " => "Activez/désactivez les fonctionnalités Tiki dans ",
", but configure them elsewhere" => ", mais configurez les dans leurs pages associées",
"Text Area" => "Zone de texte",
"Admin Groups" => "Administrer les groupes",
"Admin Users" => "Administrer les utilisateurs",
"User registration and login" => "Inscription et connexion des utilisateurs",
"Authentication method" => "Méthode d'authentification",
"Just Tiki" => "Juste Tiki",
"Web Server" => "Serveur Web",
"Tiki and PEAR::Auth" => "Tiki et PEAR::Auth",
"Tiki and PAM" => "Tiki et l'authentification PAM",
"CAS (Central Authentication Service)" => "CAS (Service Centralisé d'Authentification)",
"OpenID and Tiki" => "OpenID et Tiki",
"Tiki and HTTP Auth" => "Auth Tiki et HTTP",
"Use WebServer authentication for Tiki" => "Utiliser l'authentification du serveur Web pour Tiki",
"Users can register" => "Permettre aux utilisateurs de s'inscrire",
"... but need admin validation" => "... Mais a besoin d'une validation de l'administrateur",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "Vous devez configurer <a href=\"tiki-admin.php?page=general\">Adresse électronique des messages envoyés</a>",
"Create a group for each user <br />(with the same name as the user)" => "Créer un groupe pour chaque utilisateur<br />(avec le même nom que le nom utilisateur)",
"Use tracker for more user information" => "Utiliser les formulaires pour plus d'informations sur les utilisateurs",
"Use tracker for more group information" => "Utiliser les formulaires pour plus d'information sur les groupes",
"Request passcode to register" => "Exiger un passcode pour s'inscrire",
"Prevent automatic/robot registration" => "Empêcher l'enregistrement automatique par des robots",
" - Php GD library required" => " - Librairie PHP GD obligatoire",
"Use login as email" => "Utilisez votre adresse électronique pour vous connecter",
"Validate users by email" => "Valider les utilisateurs par email",
"Validate user email server" => "Valider le serveur de messages de l'utilisateur",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Rappel de mot de passe par email (si \"Sauvegarder les mots de passe en texte plein\" est activé.) Sinon, Réinitialisation de votre mot de passe par email",
"Store plaintext passwords" => "Sauvegarder les mots de passe en texte plein",
"Crypt passwords method" => "Méthode d'encryptage des mots de passe",
"tikihash (old)" => "hashtiki (vieux)",
"Reg users can change password" => "Les utilisateurs inscrits peuvent changer de mot de passe",
"Reg users can change theme" => "Les utilisateurs inscrits peuvent changer de thème",
"Restrict available themes" => "Limiter les thèmes disponibles",
"Available styles:" => "Styles disponibles :",
"Reg users can change language" => "Les utilisateurs inscrits peuvent changer de langue",
"Restrict available languages" => "Limiter les langues disponibles",
"Available languages:" => "Langues disponibles :",
"Minimum username length" => "Longueur minimale d'un nom d'utilisateur",
"Maximum username length" => "Longueur maximale d'un nom d'utilisateur",
"Force lowercase username" => "Forcer le nom d'utilisateur en minuscules",
"Use challenge/response authentication" => "Utiliser une authentification challenge/réponse",
"Force to use chars and nums in passwords" => "Obliger d'utiliser caractères et numériques dans un mot de passe",
"Minimum password length" => "Longueur minimum d'un mot de passe",
"Password invalid after days" => "Mot de passe invalide après (en jours)",
"-1 for never" => "-1 pour jamais",
"Re-validate user by email after days" => "Demander aux utilisateurs de se confirmer par courrier électronique après x jours",
"Re-validate user by email after unsuccessful logins" => "Demander à l'utilisateur de se valider par courriel après x logins non réussis",
"HTTPS login" => "Login HTTPS",
"Allow secure (https) login" => "Permettre une connexion sécurisée (HTTPS)",
"Encourage secure (https) login" => "Encourager les logins sècurisés (https)",
"Consider we are in always in HTTPS, but do not check" => "Considère que nous sommes toujours en HTTPS, sans le vérifier",
"Require secure (https) login" => "Exiger une connexion sécurisée (HTTPS)",
"Users can choose to stay in SSL mode after an HTTPS login" => "Les utilisateurs peuvent choisir de rester en mode SSL après un login HTTPS",
"Users can switch between secured or standard mode at login" => "Les utilisateurs peuvent commuter entre le mode standard et le mode sécurisé au login",
"HTTP port" => "Port HTTP",
"HTTPS port" => "Port HTTPS",
"Remember me feature" => "Fonctionnalité \"Mémorisez moi\"",
"User's choice" => "Choix de l'utilisateur",
"Always" => "Toujours",
"Duration:" => "Durée :",
"week" => "semaine",
"month" => "mois",
"year" => "année",
"Remember me name" => "Mémorisez-moi",
"Remember me domain" => "Domaine du cookie Mémorisez-moi",
"Remember me path" => "Chemin du cookie Mémorisez-moi",
"Protect against CSRF with a confirmation step" => "Protéger contre CSRF avec une étape de confirmation",
"Protect against CSRF with a ticket" => "Se protéger contre le Sea surfing(CSRF) avec des tickets",
"Highlight Group" => "Style appliqué aux noms d'utilisateur d'un groupe",
"choose a group ..." => "choisir un groupe...",
"User can choose beyond these groups at registration time" => "Un utilisateur peut choisir parmi ces groupes à l'inscription",
"Specify the fields that will be asked in admin->groups" => "Choix des champs qui vont être demandés dans admin->groupes",
"Displays user's contribution in the user information page" => "Afficher les contributions de l'utilisateur dans sa page d'information",
"Displays UserTracker information in user information page. Format: trackerId, fieldId1, fieldId2, …" => "Affiche les informations du formulaire utilisateur dans la page d'information d'un utilisateur. Format: IdFormulaire, IdChamp1, IdChamp2, …",
"Deactivate login autocomplete (do not remember login and password)" => "Désactiver le renseignement automatique du login (ne pas se souvenir du login et du mot de passe)",
"Create user if not in Tiki?" => "Créer un utilisateur s'il n'est pas dans Tiki?",
"Create user if not in Auth?" => "Créer un utilisateur s'il n'est pas dans Auth?",
"Just use Tiki auth for admin?" => "Utiliser uniquement l'authentification Tiki pour l'administrateur?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "URL LDAP<br />Si positionné, écrasera le port et le hôte ci-dessous",
"LDAP Host" => "Hôte LDAP",
"LDAP Port" => "Port LDAP",
"LDAP Scope" => "Scope LDAP",
"LDAP Base DN" => "DN LDAP de la base",
"LDAP User DN" => "DN LDAP d'un utilisateur",
"LDAP User Attribute" => "Attribut LDAP d'un utilisateur",
"LDAP User OC" => "OC LDAP d'un utilisateur",
"LDAP Group DN" => "DN LDAP du groupe",
"LDAP Group Attribute" => "Attribut LDAP du groupe",
"LDAP Group OC" => "OC LDAP d'un groupe",
"LDAP Member Attribute" => "Attribut LDAP d'un membre",
"LDAP Member Is DN" => "Attribut LDAP d'un membre est un DN",
"LDAP Admin User" => "Administrer les utilisateurs LDAP",
"LDAP Admin Pwd" => "Administrer les mots de passe LDAP",
"LDAP Version" => "Version LDAP",
"LDAP Realname Attribute" => "Attribut LDAP Realname",
"PAM" => "AuthentificationPAM",
"PAM service" => "Service PAM",
"Currently unused" => "Actuellement non utilisé",
"You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "Vous devez aussi envoyer la <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">bibliothèque phpCAS</a> séparément dans lib/phpcas/.",
"CAS server version" => "Version du serveur CAS",
"CAS server hostname" => "Adresse internet du serveur CAS",
"CAS server port" => "Port du serveur CAS",
"CAS server path" => "Chemin d'accès au serveur CAS",
"Change CAS preferences" => "Modifier les préférences CAS",
"Shibboleth Authentication " => " Authentification Shibboleth ",
"Create with default group?" => "Créer avec un groupe par défaut ?",
"Default group: " => "Groupe par défaut: ",
"Change Shibboleth preferences" => "Changer les préférences Shibboleth",
"Users Defaults" => "Paramètres par défaut des utilisateurs",
"Users Default Preferences" => "Préférences de l'utilisateur par défaut",
"Does your mail reader need a special charset" => "Votre lecteur de messages a-t-il besoin d'un encodage des caractères particulier",
"default" => "défaut",
"Theme" => "Thème",
"Number of visited pages to remember" => "Nombre de pages visitées à conserver",
"Displayed time zone" => "Fuseau horaire affiché",
"Detect user timezone if browser allows, otherwise site default" => "Détecter le fuseau horaire utilisateur (si le navigateur le permet). Sinon, appliquer le fuseau horaire par défaut",
"User information" => "Confidentialité",
"Private" => "Privé",
"public" => "publique",
"Use double-click to edit pages" => "Utiliser le double clic pour modifier une page",
"Messages per page" => "Messages par page",
"Allow messages from other users" => "Autoriser des messages d'autres utilisateurs",
"Note author when reading his mail" => "Marque le message dans les messages envoyés de l'auteur quand son message est lu",
"Send me an email for messages with priority equal or greater than" => "Envoyez-moi un email pour les messages de priorité égale ou supérieure à",
"Auto-archive read messages after x days" => "Archiver les messages automatiquement après x jours",
"never" => "jamais",
"Tasks per page" => "Tâches par page",
"My Tiki" => "Mon Tiki",
"My pages" => "Mes pages",
"My messages" => "Mes messages",
"My tasks" => "Mes tâches",
"My forum topics" => "Mes sujets dans le forum",
"My forum replies" => "Mes réponses dans le forum",
"My items" => "Mes fiches",
"My workflow" => "Mon workflow",
"Change users defaults" => "Change les défauts utilisateur",
"General Layout" => "Mise en page générale",
"Slideshows theme" => "Thème des diaporamas",
"Use transition style sheet from version" => "Utiliser une feuille de style de transition depuis la version",
"Never use transition css" => "Ne jamais utiliser de feuille de style de transition",
"Use @version:x.x specified in theme css or none if not specified" => "Utiliser @version:x.x spécifiée dans le thème css ou aucune si non spécifiée",
"Use @version:x.x specified in theme css or 1.8 if not specified" => "Utiliser @version:x.x spécifiée dans le thème css ou 1.8 si non spécifiée",
"Use @version:x.x specified in theme css or 1.9 if not specified" => "Utiliser @version:x.x spécifiée dans le thème css ou 1.9 si non spécifiée",
"Edit CSS" => "Modifier le CSS",
"Theme Control" => "Contrôle des thèmes",
"Template Viewing" => "Affichage du gabarit",
"Tiki Template Viewing" => "Affichage du gabarit Tiki",
"Site Identity" => "Identité du site",
"Required for all the following features" => "Nécessaire pour toutes les fonctionalités suivantes",
"General Layout options" => "Options générales de mise en page",
"Custom Site Header" => "Entête du site sur mesure",
"Site Logo" => "Logo du site",
"Site logo source (image path)" => "Source du logo du site (chemin d'accès de l'image)",
"Site logo background color" => "Couleur du fond du logo du site",
"Site logo alignment" => "Alignement du logo",
"on left side" => "à gauche",
"on center" => "au centre",
"on right side" => "à droite",
"Site logo title (on mouse over)" => "Titre du logo du site logo (quand la souris passe dessus)",
"Alt. description (e.g. for text browsers)" => "Description Alt. (pour les navigateurs textuels)",
"Site Search Bar" => "Barre de recherche",
"Top Bar" => "Barre du haut",
"Site menu bar" => "Barre de menu sur le site",
"Note: This feature also requires PHPLayers to be turned on in " => "Remarque : cette fonctionnalité nécessite que la fonctionnalité PHPLayers soit activée dans ",
"Menu ID" => "ID du menu",
"Current Version" => "Version courante",
"Users can Flip Columns" => "Les utilisateurs peuvent afficher/cacher la colonne",
"Left column" => "Colonne de gauche",
"always" => "toujours",
"user decides" => "l'utilisateur décide",
"Site Breadcrumbs" => "Fils d'Ariane du site",
"Site location bar" => "Fil d'Ariane du site",
"at top of page" => "en haut de la page",
"at top of center column" => "en haut de la colonne du centre",
"Larger font for" => "Police de caractères plus large pour",
"entire location" => "fil d'Ariane complet",
"page name" => "nom de la page",
"Use page description:" => "Utiliser la description de la page :",
"Right column" => "Colonne de droite",
"Custom Site Footer" => "Bas de page du site sur mesure",
"Bottom bar" => "Barre du bas",
"Bottom bar icons" => "Barre du bas avec les icônes",
"Bottom bar debug" => "Barre du bas de debug",
"Pagination links" => "Liens de pagination",
"Use relative (next / previous) pagination links" => "Utiliser des liens de pagination (suivant / précédent) relatifs",
"Use direct pagination links" => "Utiliser les liens de pagination directs",
"Max. number of links around the current item:" => "Nombre maximum de liens autour de l'élément courant :",
"Max. number of links after the first or before the last item:" => "Nombre maximum de liens après le premier ou avant le dernier élément :",
"Display 'First' and 'Last' links" => "Afficher les 'Premier' et 'Dernier' liens",
"Display fast move links (by 10 percent of the total number of pages) " => "Afficher des liens rapides (par tranches de 10% du nombre total de pages)",
"Use Icons" => "Utiliser les Icons",
"Display menus as folders" => "Afficher les icônes des menus comme des répertoires",
"Use Tabs" => "Utiliser les onglets",
"Layout per section" => "Mise en page par section",
"Admin layout per section" => "Administrer la mise en page par section",
"Other options" => "Autres options",
"Favicon icon file name:" => "Nom du fichier de l'icône Favicon :",
"Favicon icon MIME type:" => "Type MIME de l'icône :",
"full path to mapfiles" => "Chemin d'accès complet aux fichiers-carte",
"default mapfile" => "fichier-carte par défaut",
"Wiki Page for Help" => "Page Wiki d'aide",
"Wiki Page for Comments" => "Page Wiki des commentaires",
"Full path to gdaltindex" => "Chemin d'accès complet à gdaltindex",
"Full path to ogr2ogr" => "Chemin d'accès à ogr2ogr",
"Map Zone" => "Zone carte",
"Generate User Map" => "Générer la carte utilisateur",
"Users can opt-out internal messages" => "Les utilisateurs peuvent désélectionner les messages internes",
"Users accept internal messages by default" => "Les utilisateurs acceptent les messages internes par défaut",
"Maximum mailbox size (messages, 0=unlimited)" => "Taille maximum d'une boîte à lettres (messages, 0=illimité)",
"Maximum mail archive size (messages, 0=unlimited)" => "Taille maximum d'une archive de boîte à lettres (messages, 0=illimité)",
"Maximum sent box size (messages, 0=unlimited)" => "Taille maximum d'une boîte à lettres de messages envoyés (messages, 0=illimité)",
"Value" => "Valeur",
"Meta Keywords" => "Méta mots clés",
"Meta Description" => "Méta description",
"Meta Author" => "Méta Auteur",
"meta robots" => "méta robots",
"revisit after" => "revisiter après",
"Right &amp; left boxes" => "Boites gauches &amp; droites",
"Administer modules" => "Administrer les modules",
"Show Module Controls" => "Afficher les contrôles de module",
"Users can Configure Modules" => "Les utilisateurs peuvent configurer les modules",
"Users can Shade Modules" => "Les utilisateurs peuvent afficher/cacher les modules",
"module decides" => "le module décide",
"Display modules to all groups always" => "Toujours afficher les modules à tous les groupes",
"Hide anonymous-only modules from registered users" => "Cacher aux utilisateurs inscrits les modules assignés aux utilisateurs anonymes",
"Video Lenght" => "Largeur de la video",
"Video Heigth" => "Hauteur de la video",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Pour créer/supprimer un sondage, aller dans \"Sondages\" sous \"Admin\" dans le menu application",
"Allow Anonymous Poll Voting" => "Permettre aux anonymes de voter dans les sondages",
"Show categories" => "Montrer les catégories",
"Show objects" => "Montrer les objets",
"Tikiwiki Profiles" => "Profils Tikiwiki",
"List" => "Liste",
"Feed for articles" => "Canaux de syndication des articles",
"Feature is disabled." => "Fonctionalité désactivée.",
"Enable now" => "Activer maintenant",
"Feed for image galleries" => "Canal de syndication pour les galeries d'images",
"Image galleries" => "Galeries d'images",
"Feed for file galleries" => "Canaux de syndication des galeries de fichiers",
"Feed for wiki" => "Canaux de syndication de wiki",
"Feed for forums" => "Syndication des forums",
"Calendar events" => "Évènements du calendier",
"Feed for directory" => "Canaux de syndication des répertoires des liens",
"Feed for maps" => "Canaux de syndication des cartes",
"Map files" => "Fichiers de cartes",
"Defaults" => "Defauts",
"Default RDF version" => "Version RDF par défaut",
"Specification" => "Spécification",
"Editor" => "Éditeur",
"Webmaster" => "Administrateur du site",
"Image Path" => "Chemin vers l'image",
"Caching time:" => "Temps en antémémoire:",
"seconds (0 = cache inactive)" => "secondes (0 = pas de cache)",
"Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public." => "Activer la mise en antémémoire (caching) va passer outre aux permissions existantes - Tout le contenu sera public. N'activer cette option <strong>que</strong> si votre contenu syndiqué peut être public.",
"You can see users rank by score in the module users_rank, for that go to" => "Vous pouvez voir le classement des utilisateurs dans le modules users_rank, pour cela allez à",
"Admin modules" => "Administrer les modules",
"can be seen on page" => "peut être vu sur la page",
"in Admin menu" => "dans le menu Admin",
"Referer Search Highlighting" => "Mise en relief de la chaîne recherchée",
"Parse the result (can be slow)" => "Analyser le résultat (peut être lent)",
"Database Search using MySQL 'Full-Text' Feature" => "Recherche exploitant la fonctionnalité 'texte intégral' (Full-Text) de MySQL",
"Activate MySQL Full-Text feature" => "Activer la fonctionnalité 'texte intégral' (Full-Text) de MySQL",
"Activate MySQL 'Full-Text' feature" => "Activate la fonctionnalité MySQL 'Full-Text'",
"Performance issues" => "Améliorations de performance",
"Ignore individual object permissions" => "Ignorer les droits individuels sur les objets",
"Database Independent Full Text Search or Tiki Search" => "Recherche \"Full text\" indépendente de la base données ou recherche Tiki",
"This is activated by default if MySQL 'Full-Text' feature is not activated above" => "Ceci est activé par défaut si la recherche 'texte intégral'n'a pas été activée",
"Refresh wiki search index now" => "Refaire la table d'index des pages Wiki maintenant",
"Refresh trackers search index now" => "Réactualiser les indexes des formulaires maintenant",
"Refresh tracker search index now" => "Réactualiser les indexes des formulaires maintenant",
"Search features" => "Fonctionnalités de la recherche",
"SearchStats" => "Statistiques des recherches",
"Settings for searching content" => "Configuration pour chercher le contenu",
"Search refresh mode" => "Mode d'indexation des données",
"random" => "au hasard",
"Search refresh rate" => "Fréquence de réactualisation de la recherche",
"0 for no refresh" => "0 pour ne pas rafraîchir",
"Minimum length of search word" => "Longueur minimum des mots pouvant être cherchés",
"Max. number of words containing a syllable" => "Nombre max. de mots contenant une syllabe",
"Max. age in hours of syllable search cache" => "Durée max. en heures du cache recherche sur syllabe",
"LRU list purging rate" => "Taux de nettoyage du 'dernier utilisé'(LRU)",
"LRU list length" => "Longueur de la liste 'dernier utilisé'(LRU)",
"Text area (that apply throughout many features)" => "Zones de texte (que l'on retrouve à travers plusieurs fonctionnalités)",
"Allow Smileys" => "Permettre les frimousses",
"AutoLinks" => "Liens automatiques",
"Open external links in new window" => "Ouvrir les liens externes dans une nouvelle fenêtre",
"Show quicktags over textareas (instead on left side)" => "Afficher les raccourcis au-dessus des zones de texte (en lieu et place du coté gauche)",
"Default number of rows (wiki)" => "Nombre de lignes par défaut (wiki)",
"Default number of rows (comments)" => "Nombre de lignes par défaut (commentaires)",
"Default number of rows (forum)" => "Nombre de lignes par défaut (forum)",
"Default number of rows (forum replies)" => "Nombre de lignes par défaut (réponses de forum)",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Pour configurer vos formulaires, allez sur \"Administrer les formulaires\" sous \"Formulaires\" dans l'application menu, ou",
"Trackers attachments preferences" => "Préférence pour les fichiers joints de formulaire",
"Trackers with mirror tables" => "Formulaires avec des tables miroirs",
"Use trackers with mirror tables" => "Utiliser les formulaires avec les tables miroirs",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Les valeurs sont stockées dans une table dédiée pour chaque formulaire. Elles peuvent ainsi être facilement manipulées à l'extérieur de Tikiwiki",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "ATTENTION : Les anciens et nouveaux formulaires ne peuvent pas cohabiter. Les formulaires créés avec la nouvelle bibliothèque ne fonctionneront pas avec l'ancienne et vice-versa",
"Validate choice" => "Valider le choix",
"Trackers attachments" => "Fichiers joints des formulaires",
"dls" => "téléchgts",
"Storage" => "Stockage",
"Change" => "Modifier",
"Change all to db" => "Les mettre tous dans la base de données",
"Change all to file" => "Les mettre tous en fichiers",
"Use database to store userfiles" => "Utiliser la base de données pour stocker les fichiers utilisateurs",
"Use a directory to store userfiles" => "Utiliser un répertoire pour stocker les fichiers utilisateurs",
"Allow viewing HTML mails?" => "Permettre d'afficher les mails en HTML?",
"Maximum size for each attachment" => "Taille maximum des fichiers joints",
"Unlimited" => "Illimité",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Pour créer/modifier des pages Wiki facilement, ajoutez le module quick_edit , ou",
"Dumps" => "Fichiers-dump",
"Generate dump" => "Générer un fichier-dump",
"Download last dump" => "Télécharger le dernier fichier-dump",
"Create a Tag for the Current Wiki" => "Créer un marqueur pour le Wiki courant",
"Restore the Wiki" => "Restaurer le Wiki",
"restore" => "restaurer",
"Remove a Tag" => "Retirer un marqueur",
"Wiki Comments Settings" => "Configuration des commentaires Wiki",
"List displayed by default" => "Liste affichée par défaut",
"Export Wiki Pages" => "Exporter les pages Wiki dans un Dump PhpWiki",
"Wiki attachments" => "Fichiers joints Wiki",
"Manage attachments" => "Administrer les fichiers joints",
"Wiki Administration" => "Administration Wiki",
"Remove unused pictures" => "Supprimer les images inutilisées",
"Wiki Home Page" => "Page d'accueil Wiki",
"Wiki Discussion" => "Discussion Wiki",
"Discuss pages on forums" => "Discuter les pages dans un forum",
"Forums are disabled." => "Les forums sont disactivés.",
"No forums" => "Aucun forum",
"Wiki Link Format" => "Format d'un lien Wiki",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Contrôle la reconnaissance des liens Wiki avec la syntaxe des doubles parenthèses <i>((nom de la page))</i>.",
"complete" => "presque tout",
"english" => "anglais",
"Wiki Page List Configuration" => "Configuration de l'affichage de la liste des pages Wiki",
"Id" => "ID",
"Last version" => "Dernière version",
"Status" => "État",
"Categories path" => "Chemin des catégories",
"Wiki 3D Browser Configuration" => "Configuration du navigateur Wiki 3D",
"Wiki Features" => "Fonctionnalités Wiki",
"|| for rows" => "|| pour les rangées",
"\\n for rows" => "\\n pour rangées",
"Top bar" => "Barre du haut",
"Wiki History" => "Historique Wiki",
"Only with last version" => "Seulement avec la dernière version",
"Any 2 versions" => "2 versions au choix",
"History only for data, description, comment change" => "Historique seulement pour changement de contenu, description ou commentaire",
"Wiki Watch" => "Notification par email des changements Wiki",
"Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg signifie \"What You See Is What You Get\" (Ce que vous avez est ce que vous obtenez) et est implémenté dans Tikiwiki par <a href=\"http://fckeditor.net\">FCKeditor</a>",
"Wysiwyg Editor Features" => "Options de l'éditeur wysiwyg",
"Wysiwyg Editor is optional" => "L'éditeur wysiwyg est optionnel",
"... and is displayed by default" => "... et est affiché par défaut",
"Content is parsed like wiki page" => "Le contenu est analysé comme une page wiki",
"Content is partially parsed" => "Le contenu est partiellement analysé",
"Toolbar skin" => "Habillage de la barre d'outils",
"Toolbar content" => "Contenu de la barre d'outils",
"Restore defaults" => "Restaurer les valeurs par défaut",
"A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>." => "Une nouvelle version de Tikiwiki, <b>{\$tiki_release}</b>, est disponible. Vous utilisez actuellement la version <b>{\$tiki_version}</b>. Veuillez visiter <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>.",
"disabled" => "désactivé",
"enabled" => "activé",
"More Links" => "Liens supplémentaires",
"Crosslinks to other features and settings" => "Liens vers d'autres fonctionnalités et configurations",
"Other sections" => "Autres sections",
"Administration features" => "Fonctionnalités d'administration",
"Security" => "Sécurité",
"System" => "Système",
"SysLogs" => "Logs système",
"Transversal features" => "Fonctionnalités transversales",
"which apply to more than one section" => "qui s'appliquent à plus d'une section",
"Navigation features" => "Fonctionnalités de navigation",
"Look &amp; feel" => "Aspect &amp; conviviabilité",
"themes" => "thèmes",
"Text area features" => "Fonctionnalités des zones de texte",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "fonctionnalités que vous pouvez utiliser dans toutes les zones de texte, comme dans les pages Wiki, les blogues, les articles, les forums",
"Stats &amp; banners" => "Statistiques &amp; bannières",
"View tpl" => "Voir le gabarit",
"Admin Groups Template" => "Gabarit de l'administration des groupes",
"Report" => "Rapport",
"Setting" => "Configuration",
"Please select some actions to view." => "Veuillez sélectionner des actions à visualiser.",
"User:" => "Utilisateur :",
"Group:" => "Groupe:",
"Category:" => "Categorie :",
"bytes" => "octets",
"Background color:" => "Couleur de fond:",
"Legend background color:" => "Couleur de fond des légendes:",
"Save graphs to image gallery:" => "Enregistrer les graphiques dans la galerie d'image:",
"contributor" => "contributeur",
"Edit Contribution" => "Modifier la contribution",
"Edit Action" => "Modifier l'action",
"Save Action" => "Sauvegarder l'action",
"Statistics" => "Statistiques",
"Volumes are equally distributed on each contributors/author" => "Les volumes sont distribués équitablement entre chaque contributeur ou auteur",
"connection time" => "durée de connexion",
"connection seconds" => "seconde de connexion",
"Volumn per category" => "Volume par catégorie",
"Volumn per category and per user" => "Volume par catégorie et par utilisateur",
"Number of actions per user" => "Nombre d'actions par utilisateur",
"Total number of users" => "Nombre total d'utilisateurs",
"Number of actions per object" => "Nombre d'actions par objet",
"Total number of objects" => "Nombre total d'objets",
"Number of actions per category" => "Nombre d'actions par catégorie",
"Number of actions per category and per user" => "Nombre d'actions par catégorie et par utilisateur",
"Volumn per the users'group and per contribution" => "Volume par le groupe de l'utilisateur et par contribution",
"Volumn per group and per contribution" => "Volume par groupe et par contribution",
"Volumn per user and per contribution" => "Volume par utilisateur et par contribution",
"Volumn per users'contribution and time" => "Volume par contribution d'utilisateur et heure",
"Volumn per contribution and time" => "Volume par contribution et heure",
"Days" => "Jours",
"Weeks" => "Semaines",
"recorded" => "enregistré",
"viewed" => "vu",
"Wiki page actions except viewed will always be recorded but can be not reported" => "Les actions sur les pages Wiki sauf la visualisation seront toujours enregistrées mais peuvent ne pas être affichées",
"Help on Banning System" => "Aide sur le système de bannières",
"Admin banning tpl" => "Gabarit de l'administration des bannières",
"Add or edit a rule" => "Ajouter/modifier une règle",
"Rule title" => "Titre de la règle",
"Username regex matching" => "Expression régulière sur les noms d'utilisateur",
"IP regex matching" => "Expression régulière sur les IP",
"Banned from sections" => "Interdit des sections",
"Rule activated by dates" => "Règle activée sur des dates",
"Rule active from" => "Règle active depuis",
"Rule active until" => "Règle active jusqu'à",
"Custom message to the user" => "Message personnalisé à l'utilisateur",
"Rules" => "Règles",
"x" => "supprimer",
"User/IP" => "Utilisateur/IP",
"Admin Calendars" => "Administrer les calendriers",
"Configure/Options" => "Configurer/Options",
"List of Calendars" => "Liste des calendriers",
"Url" => "Adresse Web",
"Subscription" => "Inscription",
"Permissions" => "Droits d'accès",
"Create/edit Calendars" => "Ajouter/modifier un calendrier",
"Custom Locations" => "Lieux configurables",
"Custom Participants" => "Participants configurables",
"Custom Categories" => "Catégories configurables",
"Custom Languages" => "Langues configurables",
"Custom Subscription List" => "Liste d'inscriptions configurables",
"Custom Priorities" => "Priorités configurables",
"Personal Calendar" => "Calendrier personnel",
"Start of day" => "Début de la journée",
"End of day" => "Fin de la journée",
"Custom foreground color" => "Couleur d'avant-plan particulière",
"Delete events older than:" => "Effacer les évènements plus vieux que :",
"Admin Categories tpl" => "Admin le gabarit des catégories",
"browse the category system" => "parcourir le système de catégories",
"Current category" => "Catégorie courante",
"Top" => "Racine",
"Current Category ID:" => "ID Catégorie courant :",
"Child categories" => "Sous-catégories",
"Edit permissions for this category" => "Modifier les permissions pour cette catégorie",
"Assign Permissions" => "Attribuer des droits d'accès",
"Edit this category:" => "Modifier cette catégorie :",
"Create New" => "Créer un nouveau",
"Add new category" => "Ajouter une nouvelle catégorie",
"Perms inherited from closest parent if possible or from global perms" => "Permissions héritées du parent le plus proche ou des permissions globales",
"Assign permissions automatically" => "Attribuer les permissions automatiquement",
"recommended for best performance" => "recommandé pour une meilleure performance",
"Objects in category" => "Objets dans la catégorie",
"Remove from this Category" => "Supprimer de cette catégorie",
"No records found." => "Aucun résultat.",
"Add objects to category" => "Ajouter des objets à la catégorie",
"image gal" => "gal image",
"file gal" => "gal fichier",
"Poll" => "Sondage",
"Admin chart items" => "Administrer les items d'un palmarès",
"charts" => "palmarès",
"Edit Chart" => "Modifier un palmarès",
"Add or edit an item" => "Ajouter/modifier un item",
"URL" => "Adresse Web",
"Update" => "Mettre à jour",
"Chart items" => "Items de palmarès",
"No items defined yet" => "Aucun item n'a encore été défini",
"Admin charts" => "Administrer les palmarès",
"View template" => "Afficher le gabarit",
"Admin Charts Template" => "Gabarit de l'administration des palmarès",
"Add or edit a chart" => "Ajouter/modifier un palmarès",
"Active" => "Activé",
"Users can vote for only one item from this chart per period" => "Les utilisateurs ne peuvent voter que pour un item de ce palmarès par période",
"Prevent users from voting for the same item more than once" => "Empêcher les utilisateurs de voter pour le même item plusieurs fois",
"Users can suggest new items" => "Les utilisateurs peuvent suggérer de nouveaux items",
"Auto validate user suggestions" => "Valider automatiquement les suggestions des utilisateurs",
"Ranking shows" => "Le classement montre",
"All items" => "Tous les éléments",
"Top 10 items" => "10 premiers items",
"Top 20 items" => "20 premiers items",
"Top 40 items" => "40 premiers items",
"Top 50 items" => "50 premiers items",
"Top 100 items" => "100 premiers items",
"Top 250 items" => "250 premiers items",
"Voting system" => "Système de vote",
"Vote items" => "Voter oui ou non",
"Rank 1..5" => "Note 1..5",
"Rank 1..10" => "Note 1..10",
"Ranking frequency" => "Fréquence des classements",
"Realtime" => "En temps réel",
"Each 5 minutes" => "Toutes les 5 minutes",
"Daily" => "Journalier",
"Weekly" => "Hebdomadaire",
"Monthly" => "Mensuel",
"Show Average" => "Afficher la moyenne",
"Show Votes" => "Afficher les votes",
"Use Cookies for unregistered users" => "Utiliser des cookies pour les utilisateurs anonymes",
"Users can vote again after" => "Les utilisateurs peuvent encore voter après",
"Anytime" => "N'importe quand",
"1 day" => "1 jour",
"1 week" => "1 semaine",
"1 month" => "1 mois",
"Ranks" => "Classements",
"No charts defined yet" => "Aucun palmarès n'a encore été défini",
"Chat Administration" => "Administrer les discussions",
"Chat Admin" => "Administrer les discussions",
"Chat Admin tpl" => "gabarit de l'administration des discussions",
"Create/edit channel" => "Ajouter/modifier un salon de discussion",
"Refresh rate" => "Fréquence de réactualisation",
"Half a second" => "Demi-seconde",
"second" => "seconde",
"Chat channels" => "Salons de discussion",
"Admin templates" => "Administrer les gabarits",
"Admin Content Templates" => "Administrer les gabarits",
"Admin Content Templates Template" => "Gabarit de l'administration des gabarits",
"Edit this template:" => "Modifier ce gabarit :",
"Create new template" => "Créer un nouveau gabarit",
"CMS" => "Articles",
"Template" => "Gabarit",
"Templates" => "Gabarits",
"Last Modif" => "Dernière modif.",
"Admin Contributions" => "Administrer les contributions",
"Edit the contribution:" => "Modifier la contribution:",
"Settings" => "Configurations",
"Contributions are mandatory in wiki pages" => "Contributions obligatoires dans les pages wiki",
"Contributions are mandatory in forums" => "Contributions obligatoires dans les forums",
"Contributions are mandatory in comments" => "Contributions obligatoires dans les commentaires",
"Contributions are mandatory in blogs" => "Contributions obligatoires dans les blogues",
"Contributions are displayed in the comment/post" => "Contributions affichées avec les commentaires ou les articles",
"Create a new contribution" => "Créer une nouvelle contribution",
"List of contributions" => "Liste des contributions",
"Admin cookies" => "Administrer les citations",
"Cookie" => "Citation",
"To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "Pour utiliser un cookie dans une zone de texte (page Wiki, etc.), un <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> ou un gabarit, utiliser {literal}{cookie}{/literal}.",
"Create/edit cookies" => "Ajouter/modifier une citation",
"Upload Cookies from textfile" => "Envoyer un fichier texte de citations",
"Upload from disk:" => "Envoyer à partir de son disque :",
"Upload" => "Envoyer",
"Remove all cookies" => "Supprimer toutes les citations",
"cookie" => "citation",
"Help on Drawings" => "Aide sur les dessins",
"Admin Drawings tpl" => "Administrer les modèles de dessins",
"To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "Pour insérer un dessin dans une page Wiki, utiliser {literal}{draw name=foo}{/literal}, où foo est le nom du dessin. Après sauvegarde, cliquer le lien du dessin.",
"Available drawings" => "Dessins disponibles",
"Admin DSN" => "Administrer les DSNs",
"tiki-admin_dsn tpl" => "gabarit de l'administration des DSNs",
"Use Admin DSN to define the database to be used by the SQL plugin." => "Aller à Administration->DSN pour définir la base de données utilisée dans le plugin SQL.",
"Create/edit dsn" => "Ajouter/modifier un DSN (Data Source Name)",
"Admin External Wikis" => "Administrer des Wikis externes",
"tiki admin external wikis template" => "gabarit de l'administration des Wiki externes",
"Create/Edit External Wiki" => "Créer/modifier un Wiki externe",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "Adresse Web ( \$page sera remplacé par le nom de la page dans l'URL - exemple : http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "Wiki externe",
"Admin Forums" => "Administrer les forums",
"Admin Forums Template" => "Gabarit de l'administration des forums",
"Create new forum" => "Créer un nouveau forum",
"Duplicate forum" => "Dupliquer un forum",
"View this forum" => "Voir ce forum",
"Import forums" => "Importer des forums",
"Edit this Forum:" => "Modifier ce forum :",
"Create New Forum" => "Créer un nouveau forum",
"There are individual permissions set for this forum" => "Des droits d'accès individuels ont été mis sur ce forum",
"Show description" => "Afficher la description",
"Prevent flooding" => "Empêcher les raz-de-marée",
"Minimum time between posts" => "Temps minimum entre 2 publications",
"Create new" => "Créer une nouvelle",
"Moderator user" => "Utilisateur modérateur",
"Moderator group" => "Groupe modérateur",
"Password protected" => "Protéger par un mot de passe",
"Topics only" => "Sujets uniquement",
"All posts" => "Tous les articles",
"Forum password" => "Mot de passe du forum",
"Only allow replies to the first message (flat forum)" => "Ne permettre des réponses qu'au dernier message (forum à plat)",
"Send this forums posts to this email" => "Envoyer les articles de ce forum à cette adresse électronique",
"Prune unreplied messages after" => "Éliminer les messages sans réponses après",
"Prune old messages after" => "Éliminer les anciens messages après",
"Topic list configuration" => "Configuration de la liste des sujets",
"Posts can be rated" => "Les publications peuvent être notées",
"Display last post titles" => "Afficher les titres des dernières publications",
"no display" => "pas affiché",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Faire suivre les messages de ce forum à cette adresse électronique, dans un format pouvant être renvoyé au forum",
"Send mails even when the post is generated by inbound mail" => "Envoyer un mail, si le commentaire posté est généré par une procédure de mail interne",
"Append a reply link to outbound mails" => "Ajouter un lien de réponse aux messages sortants",
"Originating e-mail address for mails from this forum" => "Adresse électronique de l'expéditeur des messages du forum",
"Add messages from this email to the forum" => "Ajouter les messages venant de cette adresse électronique au forum",
"POP3 server" => "Serveur POP3",
"Use topic smileys" => "Pouvoir mettre un émoticône sur un sujet",
"Show topic summary" => "Afficher le résumé du sujet",
"User information display" => "Informations affichées de l'éditeur",
"Flag" => "Drapeau",
"Online" => "Connecté",
"Approval type" => "Type d'approbation",
"All posted" => "Tout approuver automatiquement",
"Queue anonymous posts" => "Approuver les non-anonymes automatiquement",
"Queue all posts" => "Ne rien approuver automatiquement",
"No attachments" => "Aucun fichier joint",
"Everybody can attach" => "Tout le monde peut joindre un fichier",
"Only users with attach permission" => "Seuls les utilisateurs ayant droit peuvent joindre un fichier",
"Moderators and admin can attach" => "Modérateur et administrateur peuvent joindre un fichier",
"Store attachments in:" => "Sauver les fichiers joints dans :",
"Database" => "Base de données",
"Max attachment size (bytes)" => "Taille max. des fichiers joints (octets)",
"Default ordering for topics" => "Ordre par défaut des sujets",
"Replies (desc)" => "Réponses (desc)",
"Reads (desc)" => "Lectures (desc)",
"Topics per page" => "Nombre de sujets par page",
"Default ordering for threads" => "Ordre par défaut des fils de discussion",
"Default style for threads" => "Style par défaut des fils de discussion",
"Duplicate Forum" => "Dupliquer un forum",
"Duplicate" => "Dupliquer",
"List Forums" => "Liste des Forums",
"Age" => "Âge",
"PPD" => "Ar/jo",
"Last Post" => "Dernier article",
"Admin Hotwords" => "Administrer les mot/liens automatiques",
"Admin Hotwords Template" => "Gabarit de l'administration des mot/liens automatiques",
"Add Hotword" => "Ajouter un mot/lien automatique",
"Word" => "Mot",
"Admin HTML Page Dynamic Zones" => "Administrer les zones dynamiques des pages HTML",
"Admin HTML pages" => "Administrer les pages HTML",
"Edit this page" => "Modifier cette page",
"View page" => "Afficher la page",
"Edit zone" => "Modifier une zone",
"Dynamic zones" => "Zones dynamiques",
"content" => "contenu",
"Mass update" => "Mise à jour massive",
"Admin Html Pages" => "Administrer les pages HTML",
"Admin Html Pages Template" => "Administrer les modèles de pages HTML",
"Create new HTML page" => "Créer une nouvelle page HTML",
"Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Utiliser {literal}{ed id=name}{/literal} ou {literal}{ted id=name}{/literal} pour insérer des zones dynamiques",
"Edit this HTML page:" => "Modifier cette page HTML :",
"Dynamic" => "Dynamique",
"Static" => "Statique",
"Tiki integrator" => "Integrateur Tiki",
"An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "Un moyen facile d'intégrer le contenu d'un autre site dans Tiki est via des liens iframe utilisant la fonctionnalité Tiki <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> .",
"Edit Repository:" => "Modifier le répertoire:",
"Create New Repository" => "Créer un nouveau répertoire",
"List Repositories" => "Liste des répertoires",
"New Repository" => "Nouveau répertoire",
"View Repository" => "Afficher le répertoire",
"Human readable repository name" => "Nom compréhensible du répertoire",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Chemin d'accès au répertoire (si local : relative ou absolu / racine web - sinon: préfixé avec 'http://'",
"File name of start page" => "Nom du fichier pour la première page",
"Start page" => "Première page",
"CSS file to load when browse this repository" => "Fichier CSS à charger pour parcourir ce répertoire",
"CSS file" => "Fichier CSS",
"Is repository visible to users" => "Ce répertoire est-il visible par les utilisateurs",
"Can files from repository be cached" => "Les fichiers du répertoire peuvent-ils être mis en antémémoire",
"Cacheable" => "Peut être mis en antémémoire",
"Are files from repository can be cached" => "Les fichiers du répertoire peuvent ils être dans l'antémémoire",
"Clear all cached pages of this repository" => "Supprimer toutes les pages de ce répertoire qui ont été mis dans l'antémémoire",
"Clear cache" => "Vider l'antémémoire",
"Seconds count 'till cached page will be expired" => "Secondes jusqu'à ce que la page en antémémoire soit supprimé",
"Cache expiration" => "Expiration de l'antémémoire",
"Human readable text description of repository" => "Description compréhensible du répertoire",
"Available Repositories" => "Répertoires disponibles",
"Start" => "Début",
"CSS File" => "Fichier CSS",
"Edit rules" => "Modifier les règles",
"Edit Rules for Repository:" => "Modifier les règles du répertoire:",
"Configure Repositories" => "Configurer les répertoires",
"Configure this Repository" => "Configurer ce répertoire",
"View this Repository" => "Voir ce répertoire",
"Add new rule" => "Ajouter une nouvelle règle",
"New Rule" => "Nouvelle règle",
"view/hide copy rules dialog" => "afficher/masquer le dialogue des règles pour copier",
"Copy Rules" => "Recopie des règles",
"Source repository" => "Répertoire source",
"Copy" => "Recopie",
"According this order rules will be applied ('0' or empty = auto)" => "Ordre dans lequel les règles s'appliquent ('0' ou vide = automatique)",
"Rule order" => "Ordre des règles",
"Text to search for" => "Texte recherché",
"Text to replace" => "Texte à remplacer",
"Replace" => "Remplacer",
"Is this regular expression or simple search/replacer" => "Est ce une expression régulière ou un simple chercher/remplacer",
"Is case sensitive (for simple replacer)" => "La casse est-elle prise en compte (pour un simple remplacer)",
"Case sensitive" => "Casse prise en compte",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "sous ensemble de caractères : imsxeADSXUu, qui sont des modificateurs Regex",
"Regex modifiers" => "Modificateurs Regex",
"Human readable text description of rule" => "Description facilement compréhensible de la règle",
"Check to enable this rule" => "Cocher pour permettre cette règle",
"Enabled" => "Activé",
"Preview options" => "Options de l'aperçu",
"Apply all rules or just this to generate preview" => "Appliquer toutes les règles ou seulement celle-là pour générer l'aperçu",
"Apply all rules" => "Appliquer toutes les règles",
"View source code after rules applied" => "Voir le code source après l'application des règles",
"Code preview" => "Aperçu du code",
"Generate HTML preview" => "Générer un aperçu HTML",
"HTML preview" => "Aperçu HTML",
"Test file from repository to generate preview for (empty = configured start page)" => "Fichier de test du répertoire pour créer un aperçu (vide = page initiale configurée)",
"Preview Results" => "Aperçu des résultats",
"Rules List" => "Liste des règles",
"Case" => "Casse",
"Admin layout" => "Administrer la mise en page",
"layout options" => "Options de mise en page",
"Admin Featured Links" => "Administrer les liens vedette",
"Admin Featured Links Template" => "Gabarit de l'administration des liens vedette",
"To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "Pour utiliser ces liens, vous devez assigner le <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.Liens vedette",
"Generate positions by hits" => "Générer les positions par le nombre de visites",
"List of featured links" => "Liste des liens vedette",
"Add Featured Link" => "Ajouter un lien vedette",
"Edit this Featured Link:" => "Modifier ce lien vedette :",
"Create new Featured Link" => "Créer un nouveau lien vedette",
"disables the link" => "désactive l'hyper-lien",
"Link type" => "Type de lien",
"replace current page" => "remplacer la page en cours",
"framed" => "encadré",
"open new window" => "ouvrir nouvelle fenêtre",
"Mail-in accounts" => "Comptes mail-ins",
"Admin Webmail" => "Administrer les Webmails",
"Admin Mailing Template" => "Gabarit de l'administration des mail-ins",
"Account" => "Compte",
"Add new Mail-in account" => "Ajouter un nouveau compte Mail-in",
"Edit Mail-in account" => "Modifier un compte mail-in",
"Account name" => "Nom du compte",
"POP server" => "Serveur POP",
"SMTP server" => "Serveur SMTP",
"SMTP requires authentication" => "SMTP exige une authentification",
"article-put" => "recevoir-article",
"wiki-get" => "envoyer-wiki",
"wiki-put" => "recevoir-wiki",
"wiki-append" => "concaténer-wiki",
"Article Topic" => "Sujet de l'article",
"Article Type" => "Type de l'article",
"Allow anonymous acces" => "Permettre un accès anonyme",
"Allow attachments" => "Permettre les fichiers joints",
"Discard to the end from" => "Ignorer la fin à partir de",
"Check Mail-in accounts" => "Vérifier les comptes mail-ins",
"Check automatically" => "Vérifier automatiquement",
"Frequency" => "Fréquence",
"List menus" => "Liste des menus",
"Edit this menu" => "Modifier ce menu",
"Edit menu options" => "Modifier les options du menu",
"Show Quick Urls" => "Montre l'aide URLs",
"Some useful URLs" => "Adresses Web utiles",
"Hide Quick Urls" => "Cacher l'aide URLs",
"For wiki page, use ((PageName))." => "Pour les pages wiki, utilisez ((NomdePage)).",
"Separate multiple sections with a comma ( , )." => "Séparer chaque section avec une virgule ( , ).",
"Separate multiple permissions with a comma ( , )." => "Séparer chaque permission par avec une virgule ( , ).",
"Use Ctrl+Click to select multiple groups." => "Utilisez Ctrl+Clic pour sélectioner de multiples groupes.",
"Level" => "Niveau",
"section level 0" => "section niveau 0",
"section level 1" => "section niveau 1",
"section level 2" => "section niveau 2",
"section level 3" => "section niveau 3",
"sorted section level 0" => "section triée niveau 0",
"separator" => "intercalaire",
"Choose" => "Choisir",
"Home Page" => "Page d'accueil",
"Home Image Gal" => "Accueil-Gal. images",
"Home Image Gallery" => "Accueil-Galerie d'images",
"Home File Gal" => "Accueil-Gal. fichiers",
"Home File Gallery" => "Accueil-Galerie de fichiers",
"User preferences" => "Préférences utilisateur",
"User prefs" => "Préf. utilisateur",
"List image galleries" => "Liste des galeries d'images",
"Gallery Rankings" => "Classements des galeries",
"Browse a gallery" => "Parcourir une galerie",
"All articles" => "Tous les articles",
"Submit" => "Soumettre",
"Create blog" => "Créer un blogue",
"File galleries" => "Galeries de fichiers",
"View a forum" => "Afficher un forum",
"View a thread" => "Afficher un fil de discussion",
"View a FAQ" => "Afficher une FAQ",
"Take a quiz" => "Remplir un QCM",
"Stats for a Quiz" => "Statistiques sur le QCM",
"Preview menu" => "Aperçu du menu",
"Menu options" => "Options du menu",
"Number of lines" => "Nombre de lignes",
"switch with previous option" => "échanger avec l'option précédente",
"switch with next option" => "échanger avec l'option suivante",
"Export CSV data" => "Exporter des données CSV",
"Import CSV data" => "Importer des données CSV",
"Admin Menu Builder" => "Administrer le constructeur de menu",
"Admin Menus Template" => "Gabarit de l'administration des menus",
"To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu." => "Pour utiliser les menus dans un <a href=\"tiki-admin_modules.php\">module</a>, l'<a href=\"tiki-admin.php?page=siteid\">identité du site</a> ou un template, utiliser {literal}{menu id=x}{/literal}, où x est l'ID du menu.",
"To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "Pour utiliser <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, vous pouvez utiliser l'une des trois syntaxes suivantes :",
"This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "Cela va marcher (ou non !) selon votre thème. Pour en apprendre plus sur les <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">thèmes</a>",
"Edit this Menu:" => "Modifier ce menu :",
"Create new Menu" => "Créer un nouveau menu",
"dynamic collapsed" => "sous-menus non vus",
"dynamic extended" => "sous-menus vus",
"fixed" => "fixe",
"Admin Modules Template" => "Gabarit d'administration des modules",
"Assign Module" => "Attribuer un module",
"Left Modules" => "Modules gauches",
"Right Modules" => "Modules droits",
"Edit/Create" => "Modifier/Ajouter",
"Clear Cache" => "Vider l'antémémoire",
"User Modules" => "Modules utilisateur",
"Assign" => "Attribuer",
"Assign new module" => "Attribuer un nouveau module",
"Edit this assigned module:" => "Modifier ce module attribué :",
"Module Name" => "Nom de module",
"Left" => "Gauche",
"Right" => "Droit",
"Order" => "Ordre",
"Cache Time" => "Temps d'antémémoire",
"Rows" => "Nb max. de rangées (si applicable au module)",
"Parameters" => "Paramètres",
"Display Modules to All Groups" => "Afficher les modules à tous les groupes",
"Visibility" => "Visibilité",
"Displayed now for all eligible users even with personal assigned modules" => "Affiché pour tous les utilisateurs ayant droit même avec des modules personnellement assignés",
"Displayed for the eligible users with no personal assigned modules" => "Affiché pour les utilisateurs ayant droit sans module personnellement assigné",
"Displayed now, can't be unassigned" => "Affiché maintenant, ne peut pas être désassigné",
"Not displayed until a user chooses it" => "Non affiché jusqu'à ce que l'utilisateur en décide autrement",
" or " => " ou ",
"Assigned Modules" => "Modules attribués",
"Move Up" => "Déplacer vers le haut",
"Move Down" => "Déplcer vers le bas",
"Move to Right Column" => "Déplacer vers la colonne de droite",
"Unassign" => "Désattribuer",
"Move to Left Column" => "Déplacer vers la colonne de gauche",
"Create new user module" => "Créer un nouveau module utilisateur",
"Edit this user module:" => "Modifier ce module utilisateur :",
"Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site." => "Créer votre module fait sur mesure. Assurez vous de faire un aperçu avant de <a href=\"#assign\">l'assigner</a>. L'utilisation d'une mauvaise syntaxe wiki ou de code smarty (pas de problème avec html) peut vous empêcher d'utiliser le site",
"Must be wiki parsed" => "Doit être analysé Wiki",
"Objects that can be included" => "Objets pouvant être inclus",
"Available polls" => "Sondages disponibles",
"Random active poll" => "Sondage actif choisi au hasard",
"Random current poll" => "Sondage courant choisi au hasard",
"Use Poll" => "Utiliser ce sondage",
"Random image from" => "Image choisie au hasard de",
"Use Gallery" => "Utiliser cette galerie",
"Dynamic content blocks" => "Blocs de contenu dynamique",
"Use Dynamic Content" => "Utiliser ce contenu",
"Use RSS Module" => "Utiliser ce RSS",
"Use Menu" => "Utiliser ce menu",
"Use phplayermenu" => "Utiliser phplayermenu",
"Banner zones" => "Zones de bannière",
"Use Banner Zone" => "Utiliser cette bannière",
"Use Wiki Structure" => "Utiliser cette structure Wiki",
"Admin newsletter subscriptions" => "Administrer les abonnements à une lettre d'informations",
"List Newsletters" => "Liste des lettres d'informations",
"Admin Newsletters" => "Administrer les lettres d'informations",
"Add a subscription newsletters" => "Ajouter un abonné à une lettre d'informations",
"You can add several email addresses by separating them with commas." => "Vous pouvez ajouter plusieurs courriels en les séparant par des virgules.",
"Add email:" => "Ajouter l'adresse électronique :",
"Add user:" => "Ajouter l'utilisateur :",
"Group users" => "Utilisateurs du groupe",
"Group subscription also subscribes included groups" => "L'inscription d'un groupe inscrit aussi les groupes inclus.",
"Don't send confirmation mail" => "Ne pas envoyer de messages de confirmation",
"The user email will be refreshed at each newsletter sending" => "L'adresse électronique de l'utilisateur sera reconstruite à chaque envoi de lettre d'informations",
"Batch e-mail subscribe" => "Inscription d'adresse éledtronique par lot",
"txt file, one e-mail per line" => "fichier texte, une adresse par ligne",
"Export Subscriber Emails" => "Exporter les adresses électroniques des inscrits",
"Subscribe group" => "Inscrire un groupe",
"Included group, group users and emails will be refreshed at each newsletter sending" => "Les groupes inclus, les utilisateurs des groupes et leurs adresses électroniques seront reconstruits à chaque envoi de lettre d'informations",
"Add subscribers of another newsletter" => "Ajouter les inscrits d'une autre lettre d'informations",
"Subscriptions" => "Inscriptions",
"Valid" => "Valide",
"subscribed" => "inscrit",
"Admin Newsletters Template" => "Administrer un gabarit de lettre d'informations",
"Create/Edit Newsletters" => "Ajouter/Modifier une lettre d'informations",
"There are individual permissions set for this newsletter" => "Des droits individuels ont été mis sur cette lettre d'informations",
"Users can subscribe/unsubscribe to this list" => "Les utilisateurs peuvent s'abonner/se désabonner à cette liste",
"Users can subscribe any email address" => "Les utilisateurs peuvent s'abonner avec une adresse électronique différente",
"Add unsubscribe instructions to each newsletter" => "Ajouter les instructions pour se désabonner dans chaque lettre d'informations envoyée",
"Validate email addresses" => "Les inscriptions sont validées après réponse à un email",
"Editions" => "éditions",
"Drafts" => "Brouillons",
"Last Sent" => "Dernier envoi",
"Send Newsletter" => "Envoyer la lettre d'informations",
"EMail notifications" => "Notification par email",
"Admin Email Notifications" => "Admin notifications par courriel",
"Admin Notifications Template" => "Gabarit de l'administration des notifications",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications." => "Vous devez configurer <a href=\"tiki-admin.php?page=general\">l'Email de l'émetteur</a> avant de poser des notifications par mail.",
"Add notification" => "Ajouter une notification",
"Alert" => "Alerte",
"Event" => "Évènement",
"A user registers" => "Un utilisateur s'inscrit",
"A user submits an article" => "Un utilisateur soumet un article",
"Any wiki page is changed" => "Une page Wiki est changée",
"Any wiki page is changed, even minor changes" => "Toute page Wiki est marquée changée, même si les modifications sont mineures",
"A comment in a wiki page is posted or edited" => "Un commentaire dasn une page Wiki a été envoyé ou modifié",
"PHP error" => "Erreur PHP",
"Email:" => "Adresse électronique :",
"Admin Polls" => "Administrer les sondages",
"List polls" => "Liste des sondages",
"Edit this poll" => "Modifier ce sondage",
"Preview poll" => "Aperçu du sondage",
"Poll options" => "Options de sondage",
"Admin Polls Template" => "Gabarit de l'administration des sondages",
"Configure Polls" => "Configurer les sondages",
"Set last poll as current" => "Mettre le dernier sondage comme courant",
"Close all polls but last" => "Fermer tous les sondages sauf le dernier",
"Activate all polls" => "Activer tous les sondages",
"active" => "activé",
"current" => "en cours",
"template" => "gabarit",
"object" => "objet",
"PublishDate" => "Date de publication",
"Objects" => "Objets",
"Add poll to pages" => "Ajouter un sondage à des pages",
"Wiki pages" => "Pages Wiki",
"Use Ctrl+Click to select multiple pages." => "Utilisez Ctrl+Clic pour sélectionner plusieurs pages.",
"Lock the pages" => "Verrouiller les pages",
"Admin Quicktags" => "Administrer les raccourcis",
"tiki admin quicktags template" => "gabarit de l'administration des raccourcis",
"Create/Edit QuickTags" => "Créer/modifier un raccourci",
"Quicktags category filter" => "Filtre des raccourcis",
"Insert (use 'text' for figuring the selection)" => "Ajout (utiliser 'text' pour représenter la sélection)",
"Path to the tag icon" => "Chemin d'accès à l'icône",
"Admin RSS modules" => "Administrer les canaux de syndication RSS",
"Admin RSS Modules" => "Admin modules RSS",
"Admin RSSmodules Template" => "Administrer les Gabarits des modules RSS",
"Tips" => "Astuces",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Cette page permet de configurer les canaux de syndication RSS lus/importés par Tiki. Pour créer/exporter des canaux de syndication RSS, regardez \"Canaux de syndication RSS\" dans le panneau d'administration, ou",
"To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "Pour utiliser une alimentation RSS dans une zone de texte (page Wiki page, etc.), un <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> ou un gabarit, utiliser {literal}{rss id=x}{/literal}, où x est l'Id de l'alimentation RSS.",
"Content for the feed" => "Affichage du canal",
"Edit this RSS module:" => "Modifier ce module RSS :",
"Create new RSS module" => "Créer un nouveau module RSS",
"show feed title" => "aff. titre",
"show publish date" => "afficher la date de publication",
"Last update" => "Modifié le",
"Show Title?" => "Afficher le titre ?",
"Show Date?" => "Afficher la date ?",
"Score System" => "Système de score",
"security admin" => "administrer la sécurité",
"security admin tpl" => "gabarit de l'administration de la sécurité",
"To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "Pour <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">signaler tout problème de sécurité</a>.",
"PHP settings" => "Configuration PHP",
"PHP variable" => "Variable PHP",
"Risk Factor" => "Facteur de risque",
"Explanation" => "Explication",
"Tikiwiki settings" => "Configuration Tikiwiki",
"Tiki variable" => "Variable Tikiwiki",
"Check all tiki files" => "Vérifier tous les fichiers Tikiwiki",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Remarque : cela peut prendre beaucoup de temps. Vous devez vérifier votre temps maximum d'exécution max_execution_time dans php.ini",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Remarque : Vous devez importer vos données de sécurité via le processus d'installation (<a href=\"tiki-install.php\">tiki-install.php</a>). Importez les fichiers *secdb* mis à jour dans votre base de données.",
"File checks" => "Fichiers vérifiés",
"Check file permissions" => "Vérification des permissions des fichiers",
"This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments." => "Cette vérification tente de trouver des fichiers avec des permissions problématiques. Certains fichiers qui sont présentés ici comme posant problème peuvent ne pas être problématiques ou inévitables dans certains environnements.",
"See end of table for detailed explanations." => "Voir la fin de la table pour des explications détaillées.",
"owner" => "propriétaire",
"user" => "utilisateur",
"group" => "groupe",
"other" => "autre",
"sticky" => "captivant",
"Set User ID (suid) files" => "Set User ID (suid) des fichiers",
"World writable files or directories" => "Fichiers ou répertoires modifiables par tout le monde",
"Files or directories the Webserver can write to" => "Fichiers ou répertoires dans lesquels le serveur Web peut écrire",
"Strange Inodes (not file, not link, not directory)" => "Inodes étranges (ni fichier, ni lien, ni répertoire)",
"Executable files" => "Fichiers exécutables",
"What to do with these check results?" => "Que faire de ces résultats ?",
"Admin Shoutbox Words" => "Administration des mots du mégaphone",
"Admin Shoutbox Words Template" => "Gabarit d'administration des mots du mégaphone",
"Add Banned Word" => "Ajouter un mot tabou",
"Are you sure you want to delete this word?" => "Etes-vous sûr(e) de vouloir enlever ce tabou ?",
"Admin structures template" => "Administrer les gabarits de structures",
"The structure" => "La structure",
"has just been created." => "vient d'être crée.",
"You will remove structure" => "Vous allez supprimer la structure",
"Destroy the structure leaving the wiki pages" => "Détruire la structure en laissant les pages Wiki",
"Destroy the structure and remove the pages" => "Détruire la structure et supprimer les pages",
"Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict:" => "Veuillez noter que les pages suivantes font également partie d'une autre structure. Assurez-vous que les permissions d'accès (le cas échéant) ne rentrent pas en conflit:",
"The following pages have automatically been categorized with the same categories as the structure:" => "Les pages suivantes ont été automatiquement catégorisées dans la même catégorie que la structure:",
"The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent:" => "Les pages suivantes sont dans des catégories contrairement à la structure. Pour rester consistant, il faudrait les sortir de ces catégories:",
"The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent:" => "Les pages suivantes sont dans des catégories dans laquelle ne se trouve pas la structure. Pour assurer la cohérence, vous pourriez vouloir les recatégoriser :",
"Structure ID" => "ID de la structure",
"Edit structure" => "Modifier la structure",
"Export Pages" => "Exporter les pages",
"Dump Tree" => "Dumper l'arbre",
"Create WebHelp" => "Créer l'aide Web",
"View WebHelp" => "Afficher l'aide-web",
"Create new structure" => "Ajouter une nouvelle structure",
"Tree" => "Arbre",
"Note" => "Remarque",
"Use single spaces to indent structure levels" => "Utiliser un seul espace pour une mise en retrait",
"Create New Structure" => "Ajouter une nouvelle structure",
"Edit survey questions" => "Modifier les questions d'une enquête",
"Survey Stats" => "Statistiques sur les enquêtes",
"this survey stats" => "statistiques sur cette enquête",
"Edit this Survey" => "Modifier cette enquête",
"Admin Surveys" => "Administrer les enquêtes",
"Create/edit questions for survey" => "Ajouter/modifier une question de l'enquête",
"One choice" => "1 choix (c)",
"Multiple choices" => "Choix multiple (m)",
"Short text" => "Texte court (t)",
"Wiki textaera" => "Zone de texte Wiki",
"Rate (1..5)" => "Notation (1..5) (r)",
"Rate (1..10)" => "Notation (1..10) (s)",
"Rate" => "Notation",
"For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "Pour une question à multiple réponses, mettre les réponses dans le champ suivant séparés par des virgules. Example: un,deux,trois",
"For a rate, you can give the maximum value." => "Pour une notation, vous pouvez utiliser la valeur maximum.",
"Options (if apply)" => "Les options (si elles s'appliquent)",
"administer surveys template" => "gabarit de l'administration des enquêtes",
"Edit this Survey:" => "Modifier cette enquête :",
"Create New Survey" => "Créer une nouvelle enquête",
"There are individual permissions set for this survey" => "Des droits d'accès individuels ont été placés sur cette enquête",
"Open" => "En cours (o)",
"system admin" => "administration système",
"system admin tpl" => "gabarit de l'administration système",
"If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "Si votre Tiki se comporte bizarrement, la première chose à faire est de vider vos caches. Il est aussi important de vider les caches après un upgrade (utiliser FTP/SSH si nécessaire).",
"Empty" => "Vider",
"All user prefs sessions" => "Toutes les préférences dans les sessions utilisateur",
"Templates compiler" => "Compiler les gabarits",
"Compile" => "Compiler",
"Advanced feature" => "Fonctionnalité avancée",
"Fix UTF-8 Errors in Tables" => "Corriger les erreurs UTF-8 dans les tables",
"Warning: Make a backup of your Database before using this function!" => "Attention : Faire une sauvegarde de votre base de données avant d'utiliser cette fonction!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Attention: Si vous avez de grandes tables, augmenter le temps maximum d'exécution dans votre php.ini!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Cette fonction convertit les chaînes encodées en ISO-8859-1 dans vos tables en UTF-8",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Ceci peut être nécessaire si vous avez utilisé tiki &lt; 1.8.4 et la configuration apache Default Charset=ISO-8859-1 pour créer du contenu",
"UTF-8 Errors fixed" => "Erreurs UTF-8 réparées",
"Field" => "Champ",
"Investigate" => "Examiner",
"Fix it" => "Réparer",
"Admin Topics" => "Administrer les sujets",
"Admin Topics Template" => "Gabarit de l'administration des sujets",
"Create a new topic" => "Créer un nouveau sujet",
"Topic Name" => "Libellé du sujet",
"Upload Image" => "Envoyer une image",
"List of topics" => "Liste des sujets",
"Active?" => "Activé?",
"Articles (subs)" => "Articles (soumis)",
"topic image" => "image du sujet",
"Remove with articles" => "Supprimer avec les articles",
"Inactive - Click to Activate" => "Inactif - cliquer pour activer",
"Deactivate" => "Désactiver",
"Active - Click to Deactivate" => "Actif - cliquer pour désactiver",
"Active Permissions" => "Permissions activées",
"Admin Tracker" => "Administrer le formulaire",
"Admin Trackers" => "Administrer les formulaires",
"Edit This Tracker" => "Modifier ce formulaire",
"View This Tracker's Items" => "Liste des fiches de ce formulaire",
"New tracker field" => "Nouveau champ du formulaire",
"Edit tracker field" => "Modifier le champ du formulaire",
"Select list items that will be displayed:" => "Choisir la liste des éléments qui seront affichés :",
"Is column visible when listing tracker items?" => "La colonne est-elle visible en mode liste ?",
"Column links to edit/view item?" => "La colonne a-t-elle un lien vers la fiche ?",
"Multilingual content" => "Contenu multilingue",
"Column is searchable?" => "La colonne est filtrable?",
"Field is public? (viewed in trackerlist plugin)" => "Le champ est-il public ? (visible par l'intermédiaire du plugin trackerlist)",
"Field is hidden?" => "Le champ est-il caché?",
"not hidden" => "non caché",
"editable by admin only" => "modifiable par admin seulement",
"visible by creator &amp; admin only" => "visible par le créateur &amp; l'administrateur seulement",
"The option creator needs a field of type user selector and option 1" => "L'option créateur a besoin d'un champ de type sélection automatique d'utilisateur avec le paramètre 1",
"Visible by:" => "Visible par :",
"Editable by:" => "Editable par :",
"Field is mandatory?" => "Le champ est-il obligatoire?",
"Error message:" => "Message d'erreur :",
"Tracker fields" => "Champs du formulaire",
"isMain" => "Principal",
"Tbl vis" => "Visible",
"Searchable" => "Filtrable",
"Hidden" => "Caché",
"Mandatory" => "Obligatoire",
"Import/Export Trackers Fields" => "Importer/exporter des champs de formulaires",
"Export fieldId also" => "Exporter les Ids de champs aussi",
"Admin Trackers tpl" => "Admin le gabarit des formulaires",
"Edit This Tracker's Fields" => "Modifier les champs de ce formulaire",
"Edit Tracker" => "Modifier ce formulaire",
"Import/Export" => "Importer/Exporter",
"Create Trackers" => "Créer un nouveau formulaire",
"Duplicate Tracker" => "Dupliquer un formulaire",
"Found" => "Trouvé",
"trackers" => "formulaires",
"Fields" => "Champs",
"with" => "avec",
"Create/Edit Trackers" => "Ajouter/modifier un formulaire",
"There are individual permissions set for this tracker" => "Des droits d'accès individuels sont utilisés par ce formulaire",
"No individual permissions. Global permissions apply." => "Pas de droit d'accès individuel : les droits globaux s'appliquent",
"with values" => "avec valeurs",
"and display rating results in listing?" => "et afficher les résultats des notes dans les listes?",
"Auto create corresponding categories" => "Crée automatiquement les catégories correspondantes",
"Use \"explicit\" names in the mirror table" => "Utilisez des noms \"explicites\" dans la table miroir",
"tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "Le nom du formulaire doit être unique, les noms des champs doivent être uniques dans le formulaire et doivent être des noms valides SQL",
"Show status" => "Voir les statuts",
"Default status displayed in list mode" => "État par défaut affiché en mode liste",
"Show status to tracker admin only" => "Ne montrer les statuts qu'aux administrateurs du formulaire",
"Send copies of all activity in this tracker to this e-mail address" => "Envoyer toute activité dans ce formulaire à cette adresse électronique",
"Use simplified e-mail format" => "Utiliser un format email simplifié",
"The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "Le formulaire utilisera le champ de texte nommé Subject s'il existe, le courriel de l'utilisateur si existe ou pour un anonyme le champ email de la fiche si existe",
"New items are created with status" => "Les nouvelles fiches sont créées avec le statut",
"Authoritative status for modified items" => "Statut qui sera positionné pour les fiches modifiées",
"No change" => "Aucun changement",
"Item creator can modify his items?" => "Le créateur d'une fiche peut la modifier ?",
"The tracker needs a user field with the option 1" => "Le formulaire a besoin d'un champ utilisateur avec l'option 1",
"Only one item per user or IP" => "Une seule fiche par utilisateur ou IP",
"The tracker needs a user or IP field with the option 1" => "le formulaire a besoin d'un champ utilisateur ou IP avec l'option 1",
"Member of the default group of creator can modify items?" => "Les membres du groupe par défaut du créateur d'une fiche peuvent la modifier ?",
"The tracker needs a group field with the option 1" => "Le formulaire a besoin d'un champ groupe avec l'option1",
"Show creation date when listing tracker items?" => "Afficher la date de création à l'affichage des fiches ?",
"Format if not the default short one:" => "Format si n'est pas le format court par défaut :",
"Show creation date when viewing tracker item?" => "Montre la date de création lors de l'affichage d'une fiche?",
"Show lastModif date when listing tracker items?" => "Afficher la date de dernière modification à l'affichage des fiches ?",
"Show lastModif date when viewing tracker item?" => "Montre la date de la dernière modification lors de l'affichage d'une fiche?",
"What field is used for default sort?" => "Quel est le champ utilisé pour l'ordre de tri par défaut ?",
"LastModif" => "dernière modif.",
"What is default sort order in list?" => "Quel est le sens de l'ordre de tri par défaut ?",
"Tracker items allow ratings?" => "Les fiches de formulaire peuvent être notées?",
"Tracker items allow comments?" => "Commentaires permis dans les fiches ?",
"and display comments in listing?" => "et afficher les commentaires en mode liste ?",
"Tracker items allow attachments?" => "Fichiers joints permis dans les fiches ?",
"and display attachments in listing?" => "et afficher les fichiers joints en mode liste ??",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Options d'affichage des fichiers joints (utilisez des chiffres pour ordonner les éléments, 0 inhibe l'affichage, et les valeurs négatives s'afficheront dans une popup)",
"Filesize" => "Taille du fichier",
"Filetype" => "Type du fichier",
"LongDesc" => "Desc-longue",
"Items can be created only during a certain time" => "Les fiches ne peuvent être créées que pendant un certain temps",
"After:" => "Après :",
"Before:" => "Avant :",
"Do not show empty fields in item view?" => "Ne pas montrer les champs vides à l'affichage d'une fiche?",
"Show these fields (ID comma separated) in a popup on item link when listing tracker items?" => "Montrer ces champs (Ids séparés par des virgules) dans une popup au passage sur le lien vers la fiche lors de l'affichage des fiches d'un formulaire?",
"Import/export trackers" => "Importer/exporter des formulaires",
"Charset encoding" => "Encodage des caractères",
"Separator" => "Séparateur",
"Delimitors" => "Délimiteurs",
"Carriage Return inside Field Value" => "Sauts de lignes dans la valeur du champs",
"Parse" => "Analyser",
"status" => "état",
"lastModif" => "Dernière modif.",
"Fields visible in items list" => "Champs visibles dans la liste des items",
"Fields searchable or visible in items list" => "Champs visible ou que l'on peut rechercher dans la liste des items",
"Fields visible in an item view" => "Champs visibles dans l'affichage d'une fiche",
"All fields" => "Tous les champs",
"or list of fields separated by comma" => "ou liste de champs séparés par une virgule",
"Date Format" => "Format de Date",
"Admin groups" => "Administrer les groupes",
"Admin users" => "Administrer les utilisateurs",
"Add new group" => "Ajouter un nouveau groupe",
"Edit group" => "Modifier le groupe",
"Members" => "Membres",
"Add a New Group" => "Ajouter un nouveau groupe",
"List of existing groups" => "Liste des groupes existants",
"Includes" => "Inclut",
"User Choice" => "Choix utilisateur",
"Include" => "Inclus les droits de",
"Only directly included" => "Seulement directement inclus",
"Group Homepage" => "Page d'accueil du groupe",
"Use wiki page name or full URL" => "Utiliser le nom de la page Wiki ou l'URL complet",
"Enable now." => "Activer maintenant.",
"Group Theme" => "Thème du groupe",
"Group Information Tracker" => "Formulaire d'information sur le groupe",
"choose a group tracker ..." => "choisissez un formulaire pour le groupe ...",
"choose a field ..." => "choisissez un champ ...",
"Users Information Tracker" => "Formulaire d'information sur l'utilisateur",
"choose a users tracker ..." => "choisissez un formulaire pour les utilisateurs ...",
"Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Champs du formulaire utilisateur demandé à l'enregistrement<br />(IdChamps séparés par) :",
"User can assign to the group himself" => "Un utilisateur peut se mettre dans ce groupe lui-même",
"Group tracker item : {\$groupitemid}" => "La fiche du groupe : {\$groupitemid}",
"Edit Item" => "Modifier la fiche",
"Group tracker item not found" => "La fiche du groupe non trouvée",
"Create item" => "Créer une fiche",
"Members List" => "Liste des membres",
"Remove from Group" => "Supprimé du groupe",
"users in group" => "utilisateurs du groupe",
"Download CSV export" => "Exporter en CSV",
"Charset encoding:" => "Encodage des caractères :",
"Assign users to group:" => "Affecter des utilisateurs à des groupes:",
"User must already exist." => "L'utilisateur doit déjà exister.",
"To create users and assign them to groups, got to admin->users" => "Pour créer des utilisateurs et les affecter à des groupes, allez dans administrer->utilisateurs",
"CSV File" => "Fichier CSV",
"Admin Users Template" => "Gabarit de l'administration des utilisateurs",
"Add a New User" => "Ajouter un nouvel utilisateur",
"Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Attention : comme le site tiki est en mode esclave, toute information utilisateur que vous entrez manuellement sera automatiquement écrasée par l'autre site, y compris les permissions utilisateur",
"Batch Upload Results" => "Résultats de l'envoi par lot",
"Updated users" => "Utilisateurs mis à jour",
"Rejected users" => "Utilisateurs refusés",
"Reason" => "Raison",
"Edit user" => "Modifier l'utilisateur",
"More Criteria" => "Plus de critères",
"Group (direct)" => "Groupe (direct)",
"Change user preferences" => "Changer les préférences utilisateur",
"Edit Account Settings" => "Modifier la configuration du compte",
"User Information" => "Information utilisateur",
"Assign Group" => "Mettre dans un groupe",
"Edit Included Group" => "Modifier les groupes inclus",
"Validate" => "Valider",
"Remove Users and their Userpages" => "Supprimer les utilisateurs et leurs pages utilisateur",
"Manage Group Assignments" => "Mettre dans des groupes",
"Set Default Groups" => "Positionner les groupes par défaut",
"Assign selected to" => "Mettre les sélectionnés dans",
"Remove selected from" => "Supprimer les sélectionnés de",
"the following groups:" => "les groupes suivants:",
"Tip: Hold down CTRL to select multiple" => "Astuce : Maintenir la touche CTRL enfoncée pour une sélection multiple",
"Set the default group of the selected users to" => "Positionner le groupe par défaut des utilisateurs sélectionnés",
"Assign to Groups" => "Mettre dans les groupes",
"Use the email as username" => "Utilisez l'adresse électronique comme nom d'utilisateur",
"Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Attention : changer le nom utilisateur va demander de changer le mot de passe et va créer des problèmes avec les sites esclaves InterTiki qui utilisent ce site comme maître",
"Warning: changing the username will require the user to change his password" => "Attention: changer le nom de l'utilisateur va lui demander de changer son mot de passe",
"No password is required" => "Un mot de passe n'est pas obligatoire",
"Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth." => "Tikiwiki est configuré pour déléguer la gestion des mots de passe par LDAP via PEAR Auth.",
"Pass" => "Mot de passe ",
"Again" => "Encore",
"User must change his password at first login" => "L'utilisateur doit changer son mot de passe lors de sa première connexion",
"Registration" => "Enregistrement",
"Overwrite" => "Écraser",
"Overwrite but keep the previous login if the login exists in another case" => "Écrase mais garde le nom d'utilisateur précédent si ce nom existe déja dans une autre case",
"Don't overwrite" => "Ne pas écraser",
"Overwrite groups:" => "Groupes qui ont été écrasés :",
"User tracker item : {\$usersitemid}" => "Fiche de l'utilisateur: {\$usersitemid}",
"Loading..." => "En train de charger...",
"New attachments" => "Nouvelles pièces jointes",
"Old attachments" => "Anciennes pièces jointes",
"Admin Article Types" => "Administrer les types des articles",
"Article Types tpl" => "Gabarit des types d'article",
"show help" => "afficher l'aide",
"Shows up in the drop down list of article types" => "Montrer la liste des types d'articles",
"Allow ratings by the author" => "Permettre à l'auteur de noter",
"Show before publish date" => "Afficher avant la date de publication",
"non-admins can view before the publish date" => "Les utilisateurs autres que l'administrateur peuvent voir l'article avant la date de publication",
"Show after expire date" => "Afficher après la date d'expiration",
"non-admins can view after the expire date" => "Les utilisateurs autres que l'administrateur peuvent voir l'article après la date d'expiration",
"Heading only" => "En-tête seulement",
"No article body, heading only" => "Pas de corps d'article, uniquement un en-tête",
"Allow comments for this type" => "Permettre les commentaires pour ce type",
"Comment Can Rate Article" => "Les commentaires entrent dans le vote des articles",
"Allow comments to include a rating value" => "Permettre aux commentaires d'avoir une note",
"Show image" => "Afficher l'image",
"Show topic or own image" => "Montrer l'image propre ou celle du sujet",
"Show avatar" => "Afficher l'avatar",
"Show author's avatar" => "Montrer l'avatar de l'auteur",
"Show author" => "Afficher l'auteur",
"Show author name" => "Montrer le nom de l'auteur",
"Show publish date" => "Afficher la date de publication",
"Show expire date" => "Afficher la date d'expiration",
"Show reads" => "Afficher le nombre de lecture",
"Show the number of times the article was read" => "Montrer le nombre de fois que l'article est lu",
"Show size" => "Afficher la taille",
"Show the size of the article" => "Montrer la taille de l'article",
"Show topline" => "Montrer le surtitre",
"Show a small title over the title" => "Montrer un petit titre au-dessus du titre",
"Show subtitle" => "Montrer le sous-titre",
"Show the subtitle" => "Montrer le sous-titre",
"Show source" => "Montrer la source",
"Show link to source after article body" => "Montrer le lien vers la source après le corps de l'article",
"Show Image Caption" => "Montrer la légende de l'image",
"Show a legend under the image" => "Montrer une légende en dessus de l'image",
"Show Language" => "Montrer la langue",
"Show the language" => "Montrer la langue",
"Creator can edit" => "Le créateur peut modifier",
"The person who submits an article of this type can edit it" => "L'utilisateur qui soumet un article de ce type peut le modifier",
"Delete this type" => "Supprimer ce type",
"List of types" => "Liste des types",
"Show lang" => "Montrer la langue",
"Review" => "Article noté",
"Classified" => "Annonce",
"Create a new type" => "Créer un nouveau type",
"Assign permissions to group" => "Attribuer des droits d'accès au groupe",
"Help for Assigning Permissions" => "Aide pour attribuer des droits d'accès",
"Edit Article Tpl" => "Modifier le gabarit de l'article",
"Group Information" => "Information sur le groupe",
"Desc" => "Description",
"level configuration" => "configuration du niveau",
"Create level" => "Créer un niveau",
"all permissions in level" => "tous les droits d'accès dans le niveau",
"level" => "niveau",
"inherited from" => "hérite de",
"inherited" => "héritée",
"Assign User {\$assign_user} to Groups" => "Affecter l'utilisateur {\$assign_user} dans des groupes",
"Default Group" => "Groupe par défaut",
"Assign Perms to this Group" => "Attribuer des permissions à ce groupe",
"Assign User to Group" => "Affecter l'utilisateur dans ce groupe",
"backlinks to" => "Pages pointant vers",
"No backlinks to this page" => "Aucune page ne pointe vers cette page",
"Directory batch upload" => "Répertoire d'envoi par lot",
"Browse gallery" => "Parcourir la galerie",
"Upload from disk" => "Envoyer à partir de son disque",
"available images" => "images disponibles",
"width" => "largeur",
"height" => "hauteur",
"Remove File Extension from Image Name" => "Donner comme nom d'image, le nom du fichier sans son extension",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "ex. pour \"digicam0001.jpg\" le nom sera digicam0001",
"convert the last sub directory to a sub gallery" => "convertir le dernier sous répertoire en une sous galerie",
"Use the last sub directory name as description" => "Utiliser le nom de la dernière sous-catégorie comme description",
"Select a Gallery" => "Sélectionner une galerie",
"Process" => "Traiter",
"Browse file gallery" => "Parcourir la galerie de fichiers",
"Please do not use this feature to upload data into the database." => "SVP, n'utilisez pas cette fonctionnalité pour envoyer des données dans la base de données.",
"available files" => "fichiers disponibles",
"Select a File Gallery" => "Sélectionner une galerie de fichiers",
"Process files" => "Traiter les fichiers",
"If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "A Noter: pour insérer des images, enregistrer votre message tout d'abord avant de pouvoir éditer/poster des images. Vous pouvez utiliser le code &lt;img&gt; pour inclure des images disponibles sur ce tiki ou l'URL pour inclure des images avec l'éditeur Wysiwyg.",
"Wiki Help" => "Aide Wiki",
"The TikiWiki community" => "La communauté TikiWiki",
"Admin the Category System" => "Administrer le système de catégories",
"Admin Category" => "Administrer les catégories",
"Watch Only This Category" => "Surveiller seulement cette catégorie",
"Watch This Category and Their Descendants" => "Surveiller cette catégorie et ses descendants",
"Stop Watching Only This Category" => "Arrêter de surveiller seulement cette catégorie",
"Stop Watching This Category and Their Descendants" => "Arrêter de surveiller seulement cette catégorie et ses descendants",
"Browse in" => "Parcourir dans",
"Trackers Items" => "Fiches de formulaires",
"Sheets" => "Feuillets",
"in the current category - and its subcategories: " => "dans la catégorie courante - et dans ses sous-catégories",
"Hide subcategories objects" => "Cacher les objets des sous-catégories",
"Show subcategories objects" => "Montrer aussi les objets des sous-catégories",
"Upper level" => "Niveau supérieur",
"Browse related tags" => "Recherche à l'aide des freetags",
"Clear" => "Effacer",
"With all selected tags" => "Avec tous les tags sélectionnés",
"With one selected tag" => "Avec l'un des tags sélectionnés",
"With last selected tag" => "Avec le dernier tag sélectionné",
"Sort:" => "Tri:",
"Alphabetically" => "Alphabetique",
"By Size" => "par taille",
"Cloud" => "Nuage",
"results found" => "résultats trouvés",
"Browsing Gallery" => "Galerie",
"List Galleries" => "Liste des galeries",
"Edit Gallery" => "Modifier la galerie",
"Rebuild Thumbnails" => "Refaire les vignettes",
"Directory batch" => "Téléchargement serveur",
"List Gallery" => "Contenu de la galerie",
"All Images" => "Toutes les images",
"Monitor this Gallery" => "Surveiller cette galerie",
"Stop Monitoring this Gallery" => "Ne plus surveiller cette galerie",
"Sort Images by" => "Trier les images par",
"subgallery" => "sous-galerie",
"Subgallery" => "Sous-galerie",
"Hit" => "Visite",
"Original Size" => "Taille originale",
"rotate right" => "pivoter à droite",
"rotate" => "pivoter",
"Details" => "Détails",
"Browsing Image" => "Image",
"Return to Gallery" => "Retour à la galerie",
"Edit Image" => "Modifier l'image",
"First Image" => "Première image",
"Prev Image" => "Image précédente",
"Smaller" => "Plus petit",
"Bigger" => "Plus grand",
"Popup window" => "Fenêtre popup",
"Next Image" => "Image suivante",
"Slideshow Forward" => "Diapositive suivante",
"Last Image" => "Dernière image",
"Cyclic" => "Cyclique",
"Click to zoom" => "Cliquer pour zoomer",
"Image Name" => "Nom de l'image",
"Image size" => "pixel image",
"Image Scale" => "échelleImage",
"Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/degrés décimaux)",
"Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/degrés décimaux)",
"Move image" => "Déplacer l'image",
"You can view this image in your browser using" => "Vous pouvez afficher cette page dans votre navigateur en utilisant ",
"You can include the image in an HTML page using one of these lines" => "Vous pouvez insérer l'image dans une page HTML en utilisant l'une de ces lignes",
"You can include the image in a tiki page using one of these lines" => "Vous pouvez insérer l'image dans une page Wiki en utilisant l'une de ces lignes",
"Add Event" => "Ajouter un évènement",
"Click to select visible calendars" => "Cliquer pour sélectionner les calendriers visibles",
"Visible Calendars" => "Calendriers visibles",
"Group Calendars" => "Calendriers de groupe",
"Change Focus" => "Changer le focus",
"Hours" => "Heures",
"Calendar Item" => "Évènement",
"Config Calendars" => "Config calendriers",
"Edit Calendar" => "Édit calendrier",
"View event" => "Voir un évènement",
"Edit event" => "Modifier un évènement",
"New event" => "Nouvel évènement",
"Edit Calendar Item" => "Modifier un évènement de calendrier",
"New Calendar Item" => "Nouvel évènement de calendrier",
"End" => "Fin",
"Duration" => "Durée",
"Date and time of end" => "Date et heure de fin",
"Tentative" => "Proposé",
"Confirmed" => "Confirmé",
"Cancelled" => "Annulé",
"or new" => "ou nouveau",
"Location" => "Lieu",
"Organized by" => "Organisé par",
"Roles" => "Rôles",
"chair" => "president de séance",
"default role" => "rôle par défaut",
"required participant" => "participant requis",
"optional participant" => "participant non obligatoire",
"non participant" => "non-participant",
"Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in:" => "Donner la liste des participants en les séparants par des virgules. Les rôles des participants sont à donner en préfixant par un double-point(:) comme dans l'exemple suivant :",
"role:login_or_email,login_or_email" => "rôle:login_ou_email,login_ou_email",
"If no role is provided, default role will be \"Chair participant\"." => "Si aucun rôle n'est défini, le rôle attribué par défaut sera \"président de séance\".",
"Duplicate to" => "Dupliquer dans",
"Calendar import" => "Importation de calendrier",
"Calendar has been updated" => "Le calendrier a été mis à jour",
"import" => "importer",
"Focus:" => "Focus :",
"Assign permissions to category" => "Attribuer des droits d'accès à une catégorie",
"Current permissions for this category" => "Droits d'accès donnés à cette catégorie",
"Permission" => "Droit d'accès",
"Remove from this Category Only" => "Supprimer seulement de cette catégorie",
"Remove from this Category &amp; all its Children" => "Supprimer de cette catégorie &amp; tous ces enfants",
"Assign permissions" => "Attribuer des droits d'accès",
"to group" => "au groupe",
"this category &amp; all its children" => "cette catégorie &amp; et tous ses enfants",
"this category only" => "cette catégorie seulement",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Attribuer les permissions à <b>tous les enfants</b> est recommandé pour une meilleure performance.",
"Change password enforced" => "Changement de mot de passe imposé",
"Old password" => "Ancien mot de passe",
"Again please" => "Encore une fois",
"Send a message to us" => "Nous envoyer un message",
"Contact us by email" => "Nous contacter par email",
"Click here to send us an email" => "Cliquer ici pour nous envoyer un email",
"Group View" => "Vue par groupe",
"Create/edit contacts" => "Ajouter/modifier un contact",
"First Name" => "Prénom",
"Publish this contact to groups" => "Partager ce contact avec les groupes",
"Last Name" => "Nom de famille",
"Nickname" => "Surnom",
"You can browse the generated WebHelp here" => "Vous pouvez parcourir l'aide Web ici",
"Top page" => "Page du 1ier niveau",
"Tiki Debugger Console" => "Console de debug Tiki",
"Close" => "Fermer",
"Current URL" => "URL courante",
"Command" => "Commande",
"exec" => "exécuter",
"Type <code>help</code> to get list of available commands" => "Taper <code>help</code> pour avoir une liste des commandes disponibles",
"Add a new site" => "Ajouter un nouveau site",
"You cannot add sites until Directory Categories are setup." => "Vous ne pouvez pas ajouter de sites avant que les catégories de répertoires soient configurées",
"Please contact the Site Administrator" => "SVP, contacter l'administrateur du site",
"Site added" => "Site ajouté",
"Edit a site" => "Editer un site",
"Add a site" => "Ajouter un site",
"URL:" => "URL :",
"Categories:" => "Catégories :",
"Is valid" => "Est valide",
"Directory Administration" => "Administrer le répertoire des liens",
"Admin Directory tpl" => "Gabarit de l'administration des répertoires de liens",
"Edit Tpl" => "Modifier le gabarit",
"There are" => "Il y a",
"invalid sites" => "sites invalides",
"valid sites" => "sites valides",
"Users have visited" => "Les utilisateurs ont visité",
"sites from the directory" => "sites de ce répertoire",
"Users have searched" => "Les utilisateurs ont cherché",
"times from the directory" => "fois de ce répertoire",
"Admin sites" => "Administrer les sites",
"Admin category relationships" => "Administrer les relations entre catégories",
"Validate links" => "Valider les liens",
"Browse" => "Parcourir",
"Related" => "En relation",
"Admin directory categories" => "Administrer les catégories des liens",
"Admin Directory Categories tpl" => "Gabarit de l'administration des catégories des liens",
"Parent category" => "Catégorie père",
"Add a directory category" => "Ajouter une catégorie de répertoire",
"Edit this directory category" => "Modifier les catégories de ce répertoire",
"Children type" => "Type de l'affichage complémentaire",
"Most visited sub-categories" => "Sous-catégories les plus visitées",
"Category description" => "Description de la catégorie",
"Random sub-categories" => "Sous-catégories choisies au hasard",
"Maximum number of children to show" => "Nombre maximum de sous-catégories à montrer",
"Allow sites in this category" => "Permettre des sites dans cette catégorie",
"Show number of sites in this category" => "Afficher le nombre de sites dans cette catégorie",
"Editor group" => "Groupe éditeur",
"Subcategories" => "Sous-catégories",
"allow" => "permis",
"count" => "nombre",
"editor" => "éditeur",
"relate" => "relation",
"Admin related categories" => "Administrer les catégories en relation",
"Admin Directory Related " => "Administrer les répertoires en relation",
"directory admin related tpl" => "gabarit de l'administration des répertoires en relation",
"Add a related category" => "Ajouter une catégorie en relation",
"Mutual" => "Mutuelle",
"Related categories" => "Catégories en relation",
"Admin Directory Sites" => "Administrer les sites des répertoires",
"Admin Directory Sites tpl" => "gabarit de l'administration des sites des répertoires",
"New Sites" => "Nouveaux sites",
"Cool Sites" => "Sites cools",
"Add a Site" => "Ajouter un site",
"Add a Category" => "Ajouter une catégorie",
"any" => "quelconque",
"in entire directory" => "dans le répertoire entier",
"in current category" => "dans la catégorie courante",
"Sort by" => "Trier par",
"name (desc)" => "nom (desc)",
"name (asc)" => "nom (asc)",
"hits (desc)" => "visites (desc)",
"hits (asc)" => "visites (asc)",
"creation date (desc)" => "date de création (desc)",
"creation date (asc)" => "date de création (asc)",
"last updated (desc)" => "dernière mise à jour (desc)",
"last updated (asc)" => "dernière mise à jour (asc)",
"sort" => "trier",
"Added" => "Ajouté",
"Last updated" => "Dernière modification",
"Total categories" => "Nombre total de catégories",
"Total links" => "Nombre total de liens",
"Links to validate" => "Liens à valider",
"Searches performed" => "Recherches faites",
"Total links visited" => "Nombre total de liens visités",
"Directory ranking" => "Classement des liens du répertoire",
"Search results" => "Résultats de la recherche",
"Validate sites" => "Sites validés",
"Validate Sites" => "Sites validés",
"directory validate sites tpl" => "gabarit de l'administration des sites validés",
"country" => "pays",
"Edit Article" => "Modifier un article",
"List Articles" => "Liste des articles",
"View Articles" => "Afficher les articles",
"One of the email addresses you typed is invalid" => "L'une des adresses email que vous avez tapé est invalide",
"Topline" => "Surtitre",
"Subtitle" => "Sous-titre",
"Author Name" => "Nom de l'auteur",
"Own Image" => "Image associée",
"Use own image" => "Utiliser l'image associée",
"Float text around image" => "Texte flottant autour de l'image",
"Own image size x" => "Taille x de l'image associée",
"Own image size y" => "Taille y de l'image associée",
"Image caption" => "Légende de l'image",
"Heading" => "En-tête",
"Body" => "Corps",
"Expiration Date" => "Date d'expiration",
"Emails to be notified (separated with commas)" => "Adresses électroniques à notifier (séparaté par des virgules)",
"Edit or create banners" => "Ajouter/modifier une bannière",
"List banners" => "Liste des bannières",
"URL to link the banner" => "Adresse Web de la bannière",
"Max impressions" => "Max. d'impressions",
"-1 for unlimited" => "-1 pour illimté",
"Show the banner only between these dates" => "Afficher la bannière seulement entre ces dates",
"From date" => "De cette date",
"To date" => "À cette date",
"Use dates" => "Avec des dates",
"Show the banner only in this hours" => "Afficher la bannière seulement entre ces heures",
"to" => "à",
"Show the banner only on" => "Afficher la bannière seulement les",
"Mon" => "lun.",
"Tue" => "mar.",
"Wed" => "mer.",
"Thu" => "jeu.",
"Fri" => "ven.",
"Sat" => "sam.",
"Sun" => "dim.",
"Select ONE method for the banner" => "Sélectionner UNE méthode pour la bannière",
"Use HTML" => "Utiliser le HTML",
"HTML code" => "Code HTML",
"Use image" => "Utiliser l'image",
"Image:" => "Image :",
"Current Image" => "Image en cours",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Utiliser l'image provenant de cette adresse Web (cette image va être cherchée à cette adresse Web à chaque impression)",
"Use Flash" => "Utiliser Flash",
"Use text" => "Utiliser le texte",
"Text" => "Texte",
"Save the Banner" => "Enregistrer la bannière",
"Remove Zones (you lose entered info for the banner)" => "Supprimer les zones (vous perdrez toute l'information entrée pour la bannière)",
"Edit Blog" => "Modifier le blogue",
"Create Blog" => "Créer un blogue",
"Edit Blog Tpl" => "Gabarit de la modification des blogues",
"A category is mandatory" => "Une catégorie est obligatoire",
"Current heading" => "En-tête courant",
"There are individual permissions set for this blog" => "Des droits d'accès individuels ont été mis sur ce blogue",
"Number of posts to show" => "Nombre d'articles à afficher",
"Allow other user to post in this blog" => "Permettre à un autre utilisateur de publier des articles dans ce blogue",
"Use titles in blog posts" => "Utiliser les titres dans les articles de blogue",
"Allow search" => "Permettre les recherches",
"Allow comments" => "Permettre les commentaires",
"Show user avatar" => "Afficher les avatars",
"Blog heading" => "En-tête de blogue",
"Edit Style Sheet" => "Modifier la feuille de style",
"Style Sheet" => "Feuille de style",
"choose a stylesheet" => "choisissez une feuille de style",
"Try" => "Essayer",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Seuls les fichiers avec un nom se terminant par -{\$user} sont modifiables. Les autres sont seulement duplicables et peuvent être utilisés comme modèle.",
"Show Plugins Help" => "Montrer l'aide pour les modules d'extension(plugin)",
"For more information, please see <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>" => "Pour plus d'informations, veuillez visiter <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>",
"Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines." => "Puisque la fonction de formattage des paragraphes est active, tous les groupes de lignes avec du texte sont rassemblées au sein de paragraphes. Les lignes, qui peuvent être de tailles indifférentes, sont agrégées avec les lignes suivantes. Les paragraphes sont séparés par des lignes blanches.",
"Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line." => "Puisque la fonction de formattage des paragraphes est désactivée, chaque ligne sera présentée comme vous la saisissez. Celà signifie que si vous voulez que les paragraphes soient présentés convenablement, vous devez saisir tout le paragraphe consécutivement.",
"Quicktag" => "Raccourci",
"Wiki Syntax" => "Syntaxe Wiki",
"Bold text" => "Texte en gras",
"underscores" => "soulignements",
"Italic text" => "Texte en italique",
"single quotes" => "apostrophes simples",
"Centered text" => "Texte centré",
"colons" => "points",
"some text" => "texte",
"Underlined text" => "Texte souligné",
"equals" => "signes égal",
"Text box" => "Boîte texte",
"One carat" => "Un caractère",
"Creates a box with the data" => "pour mettre le texte dans un pavé",
"Box content" => "texte",
"Title bar" => "Barre de titre",
"creates a title bar" => "pour une barre de titre",
"Colored text" => "Texte coloré",
"Will display using the indicated HTML color or color name" => "Va afficher le texte avec la couleur indiquée (code ou nom Html)",
"Lists" => "Listes",
"for bullet lists" => "pour une liste à puces",
"for numbered lists" => "pour une liste numérotée",
"for definiton lists" => "pour une définition",
"Creates an indentation for each plus(useful in list to continue at the same level)" => "Ajoute un niveau d'indentation pour chaque plus (utile dans une liste pour pouvoir poursuivre au même niveau)",
"Headings" => "Entêtes",
"make headings" => "faire des entêtes",
"Show/Hide" => "Afficher/Cacher",
"show/hide heading section. + (shown) or - (hidden) by default" => "montre/cache les entêtes de sections. + (vu) ou - (caché) par défaut",
"Autonumbered Headings" => "En-têtes autonumérotées",
"make autonumbered headings" => "faire des en-têtes autonumérotées",
"Tables" => "Tableaux",
"row" => "rangée",
"creates a table" => "pour créer un tableau",
"Horizontal rule" => "Règle horizontale",
"makes a horizontal rule" => "pour une règle horizontale",
"Wiki References" => "Références Wiki",
"JoinCapitalizedWords or use" => "JuxtaposerLesMotsEnMajuscules ou utiliser",
"for wiki references" => "pour une référence Wiki",
"page|#anchor" => "page|#anchrage",
"page|#anchor|desc" => "page|#anchrage|desc",
"SomeName" => "UnNom",
"prevents referencing" => "pour empêcher de faire une référence",
"External links" => "Liens externes",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Pour un Wiki externe, utiliser NomWikiExterne:NomPage ou ((Nom Wiki Externe: Nom Page))",
"displays an image" => "pour afficher une image;",
"Non cacheable images" => "Images hors antémémoire",
"height width desc link and align are optional" => "la hauteur, la largeur et la description du lien sont optionnelles",
"Line break" => "Saut de ligne",
"(very useful especially in tables)" => "(très utile particulièrement dans les tables)",
"creates the editable drawing foo" => "Créera le dessin éditable foo",
"Multi-page pages" => "Multi-pages",
"to separate pages" => "pour séparer les pages",
"Wiki File Attachments" => "Fichiers joints Wiki",
"Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Crée un lien sur le fichier nommé. Si la page n'est pas donnée, le fichier sera joint à la page courante. Si la description n'est pas donnée, le nom du fichier sera utilisé pour le texte du lien, à moins que showdesc soit utilisé, ce qui fait utiliser la description du fichier comme texte du lien. Si image=1, le fichier joint est traité comme une image et est affiché directement dans la page; aucun lien n'est généré",
"RSS feeds" => "Canaux de syndication RSS",
"displays rss feed with id=n maximum=m items" => "pour afficher le canal de syndication RSS d'identifiant n avec m items au maximum",
"Will be replaced by the actual value of the dynamic content block with id=n" => "pour afficher la valeur courante du contenu dynamique d'identifiant n",
"Dynamic variables" => "Variable dynamique",
"Inserts an editable variable" => "Insérer une variable dynamique",
"Non parsed sections" => "Sections non analysables",
"Prevents wiki parsing of the enclosed data." => "Empêche l'analyse Wiki pour les données encadrées.",
"Preformated sections" => "Sections préformatées",
"\"~pp~ data ~/pp~\" Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  \"~pre~ data ~/pre~\" also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text." => "\"~pp~ ddonnées ~/pp~\" Affiche du texte préformatté. Aucun traitement wiki n'est appliqué à l'intérieur de ces sections (comme pour le tag np). L'espacement est fixe (les mots ne sont pas agrégés). \"~pre~ données ~/pre~\" affiche également du texte préformatté à taille fixe, mais le traitement wiki est appliqué.",
"\"~tc~ Tiki Comment ~/tc~\" makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  \"~hc~ HTML Comment ~/hc~\" makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar." => "\"~tc~ Commentaire Tiki ~/tc~\" Créé un commentaire Tiki. Ce commentaire sera enregistré avec la page (pour une utilisation future) mais ne sera pas affiché. \"~hc~ Commentaire HTML ~/hc~\" Créé un commentaire HTML qui sera introduit dans la page en tant que commentaire HTML; Ces commentaires ne sont, en principe, pas affichés par les navigateurs, mais peuvent être vus en utilisant la fonction \"voir le source\" (ou assimilée).",
"Square Brackets" => "Crochets",
"Use [[foo] to show [foo]." => "Utiliser [[toto] pour afficher [toto].",
"Block Preformatting" => "Préformatter un bloc de texte",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indente le texte avec autant de caractères que nécessaire pour suivre les autres instructions Wiki. L'indentation sera la même que celle que vous utilisez. Remarquez que ce mode ne conserve pas exactement le même nombre d'espaces et de retours à la ligne; utiliser ~pp~...~/pp~ pour cela.",
"Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew." => " Insertion de, respectivement, une partie de texte orientée de droite à gauche ou de gauche à droite (jusquà la fin du texte) et des marqueurs pour les langues arabes ou hébraïques",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\" et \"{literal}{maketoc}{/literal}\" affichent la table des matières de la page courante basée sur les structures (toc) ou sur les entêtes (maketoc)",
"Misc" => "Divers",
"Show Text Formatting Rules" => "Montrer les règles de présentation du texte",
"Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt;" => "A noter que les arguments des plugins peuvent être encadrés par des double-cotes (&quot;); Ceci leur permet de comporter des virgules (,), des \"égal\" (=) ou des \"supérieur à\" (&gt;)",
"No description available" => "Aucune description disponible",
"bold" => "gras",
"italic" => "italique",
"underline" => "souligné",
"table new" => "nouvelle table",
"external link" => "lien externe",
"wiki link'" => "lien wiki'",
"heading1" => "entête1",
"title bar" => "barre de titre",
"box" => "boîte",
"rss feed" => "canal de syndication RSS",
"dynamic content" => "contenu dynamique",
"tagline" => "citation",
"center text" => "centré",
"colored text" => "texte coloré",
"dynamic variable" => "variable dynamique",
"New wms Metadata" => "Nouvelle méta données wms",
"New Class" => "Nouvelle classe",
"New Projection" => "Nouvelle projection",
"New Query" => "Nouvelle requête",
"New Scalebar" => "Nouvelle échelle graphique",
"New Layer" => "Nouvelle couche",
"New Label" => "Nouvelle étiquette",
"New Reference" => "Nouvelle référence",
"New Legend" => "Nouvelle légendé",
"New Web" => "Nouveau Web",
"New Outputformat" => "Nouveau format de sortie",
"New Mapfile" => "Nouveau fichier carte",
"Add another image" => "Ajouter une image",
"special chars" => "caractères spéciaux",
"special characters" => "caractères spéciaux",
"Browse Images" => "Parcourir les images",
"Edit successful!" => "Modification réussie!",
"The following image was successfully edited" => "L'image suivante a été modifiée avec succès",
"Image Description" => "Description de l'image",
"Upload from disk to change the image:" => "Charger depuis le disque pour changer l'image :",
"Save and Go Next" => "Enregistrer et continuer",
"Edit and create Languages" => "Ajouter/modifier une langue",
"Im- Export Languages" => "Langues Im/Export",
"Edit and create languages" => "Ajouter/modifier une langue",
"Create Language" => "Créer une langue",
"Shortname" => "Diminutif",
"like" => "comme",
"Longname" => "Nom complet",
"Select the language to edit" => "Sélectionner la langue à modifier",
"Add a translation" => "Ajouter une traduction",
"Edit translations" => "Modifier une traduction",
"Translate recorded" => "Traduction enregistrée",
"Translate" => "Traduire",
"reset table" => "vider la table",
"Program dynamic content for block" => "Programmer le contenu dynamique pour le bloc",
"Create New Block" => "Créer un nouveau bloc",
"Return to block listing" => "Retour à la liste de blocs",
"Block description: " => "Description du bloc : ",
"You are editing block:" => "Vous éditez le bloc :",
"Publishing date" => "Date de publication",
"Publishing Date" => "Date de publication",
"Edit question options" => "Modifier les options d'une question",
"Quiz Stats" => "Statistiques sur les QCMs",
"This Quiz Stats" => "Statistiques de ce QCM",
"Edit this Quiz" => "Modifier ce QCM",
"Admin Quizzes" => "Administrer les QCMs",
"Create/edit options for question" => "Ajouter/modifier une option à la question",
"Admin quizzes" => "Administrer les QCMs",
"Admin Quizzes tpl" => "Gabarit de l'administration des QCMs",
"Create/edit quizzes" => "Ajouter/modifier un QCM",
"There are individual permissions set for this quiz" => "Des droits d'accès individuels ont été mis sur ce QCM",
"Quiz can be repeated" => "Le QCM peut être rempli plusieurs fois",
"Store quiz results" => "Stocker les résultats du QCM",
"Immediate feedback" => "Commentaires immédiats",
"Show correct answers" => "Montrer les réponses correctes",
"Shuffle questions" => "Mélanger les questions",
"Shuffle answers" => "Mélanger les réponses",
"Questions per page" => "Nombre de questions par page",
"Quiz is time limited" => "Durée limitée pour remplir le QCM",
"Maximum time" => "Temps maximum",
"Passing Percentage" => "Pourcentage d'accomplissement",
"canRepeat" => "rempliNFois",
"timeLimit" => "limiteDeTemps",
"Results" => "Résultats",
"Edit quiz questions" => "Modifier les questions du QCM",
"Edit Quiz Questions" => "Modifier les questions du QCM",
"Edit Quiz Questions Tpl" => "Modifier le gabarit de la modification des QCMs",
"Create/edit questions for quiz" => "Ajouter/modifier une question au QCM",
"Question Type" => "Type de la question",
"Import questions from text" => "Importer des questions d'un texte",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructions: tapez ou collez vos questions à choix multiples ci-dessous. Une ligne pour la question, ensuite sur les lignes suivantes les choix de réponses. Séparez chaque nouvelle question par une ligne blanche. Indiquez les réponses correctes en les commençant par un caractère \"*\" (sans guillemet).",
"Input" => "Saisie",
"maxScore" => "Score max.",
"From Points" => "Des points",
"To Points" => "Aux points",
"Answer" => "Réponse",
"Modify Structure" => "Modifier une structure",
"You will remove" => "Vous allez supprimer",
"and its subpages from the structure, now you have two options:" => "et ses sous-pages de la structure, maintenant vous avez 2 choix :",
"and its subpages from the structure" => "et les sous-pages de la structure",
"Remove only from structure" => "Retirer seulement de la structure",
"Remove from structure and remove page too" => "Retirer de la structure et supprimer la page aussi",
"The page already exists. The page that has been added to the structure is the existing one." => "La page existe déjà. La page qui a été ajoutée à la structure est celle qui existe.",
"Structure Layout" => "Contenu de la structure",
"Monitor the Sub-Structure" => "Surveiller la sous-structure",
"Stop Monitoring the Sub-Structure" => "Arrêter de surveiller cette sous-structure",
"Promote" => "Promouvoir",
"Demote" => "Rétrograder",
"Previous" => "Précédent",
"Current Node" => "Courante structure",
"Move in this structure" => "Déplacer dans cette structure",
"Move to another structure" => "Déplacer dans une autre structure",
"at the beginning" => "au début",
"at the end" => "à la fin",
"Add pages to current node" => "Ajouter la page à la structure courante",
"After page" => "Après la page",
"Create Page" => "Créer une page",
"Use pre-existing page" => "Utiliser une page préexistante",
"Categorize all pages in structure together" => "Catégoriser toutes les pages dans la structure",
"Remove existing categories from ALL pages before recategorizing" => "Supprimer toutes les catégories de TOUTES les pages avant \"re-catégorisation\"",
"Help on Articles" => "Aide sur les articles",
"Edit Submissions Tpl" => "Gabarit de la modification des soumissions",
"List Submissions" => "Liste des soumissions",
"<b>*</b>=optional" => "<b>*</b>=optionnel",
"<b>Topline</b>=small line above Title" => "<b>Surtitre</b>=petite ligne au-dessus du titre",
"<b>Subtitle</b>=small line below Title" => "<b>Sous_titre</b>=petite ligne en dessous du titre",
"<b>Source</b>=URL to article source" => "<b>Source</b>=URL vers le source de l'article",
"Submit Article" => "Soumettre l'article",
"Auto-Approve Article" => "Auto-approuver l'article",
"EditTemplates" => "Modifier les gabarits",
"EditTemplates tpl" => "gabarit de la modification des gabarits",
"Template listing" => "Liste des gabarits",
"Available templates" => "Gabarits disponibles",
"Save Only in the Theme:" => "Sauvegarder uniquement dans le thème:",
"Delete the copy in the theme:" => "Supprimer la copie dans le thème",
"Edit a topic" => "Modifier un sujet",
"Add Notification Email" => "Ajouter une Notification par Email",
"Admin notifications" => "Administrer les notifications",
"Translate:" => "Traduire :",
"Edit Translations" => "Modifier les traductions",
"Edit Translations Template" => "Gabarit de la modification de traductions",
"You must specify the object language" => "Vous devez spécifier la langue de l'objet",
"The object doesn't exist" => "L'objet n'existe pas",
"The object doesn't have a language" => "L'objet n'a pas d'indication de langue",
"The object has already a translation for this language" => "L'objet a déjà une traduction pour cette langue",
"The object is already in the set of translations" => "L'objet est déjà dans le jeu de traductions",
"detach" => "détacher",
"Edit Section:" => "Modifier une section:",
"View object" => "Voir l'objet",
"Preview your changes." => "Avoir un aperçu de vos modifications.",
"Save the page." => "Enregistrer la page.",
"Cancel the edit, you will lose your changes." => "Annuler la modification, vous allez perdre les modifications.",
"Your edit session will expire in" => "Votre session d'édition va expirer dans",
"Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits." => "Votre session d'édition va expirer dans une minute. Il faut effectuer maintenant une prévisualisation ou une sauvegarde pour ne pas perdre vos modifications.",
"Are you sure you do not want to edit" => "Etes-vous sûr de ne pas vouloir éditer",
"instead?" => "à la place ?",
"Draft written on" => "Brouillon écrit sur",
"Warning: new versions of this page have been made after this draft" => "Attention : de nouvelles versions de cette page ont été faites après ce brouillon",
"Perhaps you are looking for:" => "Peut-être cherchez-vous :",
"This edit session will expire in {\$edittimeout} minutes" => "Cette session d'édition va expirer dans {\$edittimeout} minutes",
"Use rating" => "Utiliser les notes",
"disable" => "désactivé",
"There is no available poll template." => "Il n'y a aucun gabarit de sondage.",
"You should ask an admin to create them." => "Vous devez demander à l'administrateur de les créer.",
"or use" => "ou utiliser",
"an existing poll" => "un sondage existant",
"Regex search " => "Recherche avec expression régulière",
"Case Insensitivity" => "Casse non différiencée",
"Send urgent translation request." => "Envoyer une demande de traduction urgente.",
"Import HTML" => "Importer du HTML",
"Try to convert HTML to wiki" => "Essayer de convertir du HTML en Wiki",
"Lock this page" => "Verrouiller cette page",
"List Sheets" => "Liste des feuillets",
"Graph" => "Graphe",
"Export to file" => "Exporter dans un fichier",
"Autodetect" => "Détection automatique",
"Admin FAQ" => "Administrer la FAQ",
"View FAQ" => "Afficher les FAQs",
"Edit this FAQ" => "Modifier cette FAQ",
"New Question" => "Nouvelle question",
"Edit FAQ question" => "Modifier les questions de la FAQ",
"Use a question from another FAQ" => "Utiliser une question d'une autre FAQ",
"FAQ questions" => "Questions de la FAQ",
"Suggested questions" => "Questions suggérées",
"Approve" => "Approuver",
"No suggested questions" => "Aucune question suggérée",
"File Archive" => "Archive de fichiers",
"Upload File" => "Envoyer un fichier",
"File Galleries tpl" => "gabarit des galeries de fichiers",
"Be carefull to set the right permissions on the files you link to" => "Soyez vigilant aux permissions des fichiers que vous liez",
"Browse Gallery" => "Parcourir la galerie",
"Create New File Gallery" => "Créer une nouvelle galerie de fichiers",
"You can access the file gallery using the following URL" => "Vous pouvez accéder à cette galerie de fichiers par cette adresse Web",
"Size (width x height)" => "Dimensions (largeur x hauteur)",
"Forum Importer" => "Import de Forums",
"Import from a Local SQL File" => "Importer depuis un fichier SQL local",
"Forum Type" => "Type de forum",
"DB Prefix" => "Préfixe de la base de données",
"Local SQL Filename on Server (path will be stripped)" => "Nom du Fichier SQL local sur le serveur (le chemin sera strippé)",
"Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Doit être dans tikiroot/{\$tmpdir} ou tikiroot/img/wiki_up",
"Verification" => "Vérification",
"File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>." => "Le fichier doit être un fichier SQL et se situer soit dans <i>\$tikiroot/temp</i> ou <i>\$tikiroot/img/wiki_up</i>.",
"File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred." => "Le fichier n'a pas été spécifié ou n'a pas pu être trouvé dans l'un des répertoires. Veuillez placer le fichier dans l'un des répertoires et recommencez l'opération. Si le fichier est à la fois dans les deux répertoires, celui dans \$tikiroot/{\$filecheck} sera préféré.",
"Select a Forum You Wish to Move (ONE at a time!)" => "Sélectionnez un Forum que vous voulez déplacer (UN seul à la fois !)",
"Which Forum Do You Wish to Import this Into?" => "Quel Forum voulez-vous importer dans celui-ci ?",
"Message queue for" => "Messages en attente sur",
"back to forum" => "retourner au forum",
"Edit queued message" => "Modifier un message en attente",
"make this a thread of" => "faire de ceci un fil de discussion",
"None, this is a thread message" => "Aucun, c'est un message de fil de discussion",
"summary" => "résumé",
"announce" => "annonce",
"hot" => "populaire",
"no feeling" => "pas de sentiment",
"frown" => "renfrogné",
"exclaim" => "exclamatif",
"idea" => "idée!",
"mad" => "furieux",
"neutral" => "neutre",
"sad" => "triste",
"happy" => "heureux",
"wink" => "clin d'oeil",
"Save and Approve" => "Enregistrer et approuver",
"convert to topic" => "convertir en sujet",
"List of messages" => "Liste des messages",
"New Topic" => "Nouveau sujet",
"no summary" => "aucun résumé",
"No messages queued yet" => "Aucun message en attente actuellement",
"Reject" => "Rejeter",
"Search by name" => "Chercher par le nom",
"Search in content" => "Chercher dans le contenu",
"Configure Forum" => "Configurer le forum",
"Reported messages for" => "Messages dénoncés dans",
"Reported by" => "Dénoncé par",
"Perfom action with checked:" => "Réaliser l'opération sur les éléments cochés :",
"Universal" => "Universel",
"Show the following languages" => "Afficher les langues suivantes",
"friends tpl" => "Gabarit Amis",
"Pending requests" => "Requêtes en attente",
"Request Time" => "Date de la requête",
"Accept" => "Accepter",
"Refuse" => "Refuser",
"Waiting requests" => "Requêtes en attente",
"Your friends" => "Vos amis",
"break friendship" => "casser une amitié",
"Activity completed" => "Activité terminée",
"Admin process activities" => "Administrer les activités de processus",
"To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "Pour apprendre plus le <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">workflow Galaxia</a>",
"Add or edit an activity" => "Ajouter/modifier une activité",
"activity" => "activité",
"split" => "découpé",
"join" => "joindre",
"standalone" => "autonome",
"auto routed" => "automatiquement routé",
"Expiration Time" => "Temps d'expiration",
"Years" => "Années",
"Months" => "Mois",
"Add transitions" => "Ajouter une transition",
"Add transition from:" => "Ajouter une transition de :",
"Add transition to:" => "Ajouter une transition à :",
"No roles associated to this activity" => "Aucun rôle associé à cette activité",
"Add Role" => "Ajouter un rôle",
"Add New" => "Ajouter un nouveau",
"Process activities" => "Activités du processus",
"Routing" => "Routage",
"Automatic" => "Automatique",
"Auto routed" => "Automatiquement routé",
"Manual" => "Manuel",
"(no roles)" => "(aucun rôle)",
"No activities defined yet" => "Aucune activité n'a encore été définie",
"Process Transitions" => "Transitions du processus",
"List of transitions" => "Liste des transitions",
"From:" => "De :",
"Origin" => "Origine",
"No transitions defined yet" => "Aucune transition n'a encore été définie",
"Add a transition" => "Ajouter une transition",
"Process Graph" => "Graphe des processus",
"Galaxia Admin Graph" => "Graphe d'administration Galaxia",
"Galaxia Admin Graph tpl" => "Administrer le gabarit de Admin Graph",
"This process is invalid" => "Ce processus est invalide",
"Process Graph for" => "Graphes des processus pour",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "Aucun graphe de processus disponible. Soit le processus contient des erreurs, Soit le graphe n'est pas encore généré, soit <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> n'est pas correctement installé.",
"List of processes" => "Liste des processus",
"Inactive" => "Inactif",
"Active Process" => "Activer le processus",
"Invalid Process" => "Invalider le processus",
"Valid Process" => "Valider le processus",
"Activities" => "Activités",
"New Minor" => "Nouveau mineur",
"New Major" => "Nouveau majeur",
"No processes defined yet" => "Aucun processus n'a encore été défini",
"Admin instance" => "Administrer une instance",
"Process:" => "Processus :",
"completed" => "fini",
"Aborted" => "Interrompu",
"Owner" => "Créateur",
"Send all to" => "Envoyer à tous",
"Don't move" => "Ne pas déplacer",
"Started" => "Débuté le",
"Act status" => "État act.",
"Ended" => "Terminé",
"Not Defined" => "Non défini",
"Not Interactive" => "Non interactive",
"Not Ended" => "Non terminé",
"Property" => "Propriété",
"Add property" => "Ajouter une propriété",
"run instance" => "lancer l'instance",
"Executed" => "Terminé(es)",
"Pop-up" => "Popup",
"erase" => "effacer",
"Galaxia Admin Processes" => "Administrer les processus Galaxia",
"Galaxia Admin Processes tpl" => "gabarit de l'administration des processus Galaxia",
"Add or edit a process" => "Ajouter/modifier un processus",
"Process Name" => "Nom du processus",
"ver:" => "ver :",
"is active?" => "est actif?",
"Or upload a process using this form" => "Ou afficher le formulaire pour envoyer un processus",
"Admin process roles" => "Administrer les rôles de processus",
"Add or edit a role" => "Ajouter/modifier un rôle",
"Process roles" => "Rôles de processus",
"No roles defined yet" => "Aucun rôle n'a encore été défini",
"Map users to roles" => "Associer un utilisateur à un rôle",
"Map" => "Carte",
"map" => "associer",
"Map groups to roles" => "Associer un groupe à un rôle",
"Operation" => "Opération",
"Warning" => "Avertissement",
"No roles are defined yet so no roles can be mapped" => "Aucun rôle n'a été défini, les rôles ne peuvent donc pas être associés",
"List of mappings" => "Liste des associations",
"No mappings defined yet" => "Aucune association définie",
"Admin process sources" => "Administrer les sources de processus",
"select source" => "sélectionner une source",
"Shared code" => "Code partagé",
"Set next user" => "Valider l'utilisateur suivant",
"Get property" => "Récupérer la propriété",
"Set property" => "Valider la propriété",
"Complete" => "Fini",
"Process form" => "Formulaire de processus",
"Set Next act" => "Valider l'activité suivante",
"Switch construct" => "Échanger la construction",
"Map process roles" => "Associer un processus à un rôle",
"Admin Processes" => "Administrer les processus",
"Admin Activities" => "Administrer les activités",
"Admin Roles" => "Administrer les rôles",
"Edit this Process" => "Modifier ce processus",
"Galaxia Monitor Activities" => "Surveiller les activités Galaxia",
"Galaxia Monitor Activities tpl" => "gabarit de la surveillance des activités Galaxia",
"List of activities" => "Liste des activités",
"routing" => "routage",
"run" => "lancer",
"run activity" => "lancer une activité",
"Enter the name of this instance" => "Donner le nom de cette instance",
"The name is not valid. Please, enter the name again" => "Le nom est invalide. SVP, donnez en un autre",
"Monitor" => "Surveiller",
"monitor processes" => "surveiller les processus",
"monitor activities" => "surveiller les activités",
"monitor instances" => "surveiller les instances",
"monitor workitems" => "surveiller les workitems",
"Galaxia Monitor Instances" => "Surveiller les instances Galaxia",
"Galaxia Monitor Instances tpl" => "gabarit de la surveillance des instances Galaxia",
"List of instances" => "Liste des instances",
"Not ended" => "Non terminé",
"No instances created yet" => "Aucune instance n'a encore été créée",
"Galaxia Monitor Processes" => "Surveiller les processus Galaxia",
"Galaxia Monitor Processes tpl" => "gabarit de la surveillance des processus Galaxia",
"processes" => "processus",
"being run" => "en cours d'exécution",
"Completed" => "Fini",
"Monitor workitems" => "Surveiller les workitems",
"List of workitems" => "Liste des workitems",
"Instance Id" => "Id de l'instance",
"Instance Name" => "Nom de l'instance",
"Instance Status" => "État de l'instance",
"Elapsed time" => "Temps écoulé",
"My activities" => "Mes activités",
"Current Activity" => "Activité courante",
"Assigned To" => "Attribué à",
"exception instance" => "instance exception",
"exceptions instance" => "instance exceptions",
"Send Instance" => "Envoyer une instance",
"abort instance" => "interrompre l'instance",
"grab instance" => "prendre l'instance",
"release instance" => "relâcher l'instance",
"No activities found" => "Aucune activité trouvée",
"My instances" => "Mes instances",
"No instances found" => "Aucune instance trouvée",
"User Activities" => "Activités Utilisateur",
"Galaxia User Activities" => "Activités utilisateur Galaxia",
"Galaxia User Activities tpl" => "gabarit des activités utilisateur Galaxia",
"process" => "processus",
"No processes defined or activated yet" => "Aucun processus défini ou activé pour l'instant",
"user processes" => "processus utilisateur",
"user activities" => "activités utilisateur",
"user instances" => "instances utilisateur",
"Galaxia User Instances" => "Instances utilisateur Galaxia",
"Galaxia User Instances tpl" => "Gabarit des instances utilisateur Galaxia",
"Inst Status" => "État de l'inst.",
"Not defined" => "Non défini",
"No instances defined yet" => "Aucune instance n'a été définie",
"Galaxia User Processes" => "Processus utilisateur Galaxia",
"Galaxia User Processes tpl" => "gabarit des processus utilisateur Galaxia",
"Browsing Workitem" => "Parcourir le workitem",
"Workitem information" => "Information sur le workitem",
"galleries tpl" => "gabarit des galeries d'images",
"Create New Gallery" => "Créer une nouvelle galerie",
"Create a gallery" => "Créer une galerie",
"Edit this gallery:" => "Modifier cette galerie :",
"There are individual permissions set for this gallery" => "Des droits d'accès individuels ont été mis sur cette galerie",
"Geographic" => "Géographique",
"Fields to show during browsing the gallery" => "Champs affichés au parcours de la galerie",
"Image ID" => "Id Image",
"Creation Date" => "Date de création",
"XY-Size" => "Taille-XY",
"Gallery Image" => "Galerie d'images",
"Available scales" => "Échelles disponibles",
"Global default" => "Défaut global",
"Bounding box" => "Boite maximale",
"default scale" => "échelle par défaut",
"No scales available" => "Aucune échelle disponible",
"Original image is default scale" => "L'échelle par défaut est la taille d'origine de l'image",
"Add scaled images with bounding box of square size" => "Ajouter des images avec un cadre à l'échelle suivante",
"Other users can upload images to this gallery" => "Les autres utilisateurs peuvent envoyer des images vers cette galerie",
"You can access the gallery using the following URL" => "Vous pouvez accéder à cette galerie par l'adresse Web suivante",
"Available Galleries" => "Galeries disponibles",
"Choose a filter" => "Choisir un filtre",
"Make Map" => "Construire une carte",
"Save clicked point" => "Sauvegarder le point cliqué",
"Save current view as default" => "Sauvegarder la vue courante comme défaut",
"Reset view to site-wide default" => "Réinitialiser la vue au défaut du site",
"Users Map" => "Carte utilisateur",
"Select Graphic Type" => "Sélectionner le type de graphique",
"Pie Chart" => "Graphique circulaire",
"Multiline" => "Multi-ligne",
"Multibar" => "Multi-barre",
"Bar Stack" => "Pile des barres",
"Landscape" => "Paysage",
"Independant Scale" => "Echelle indépendante",
"Horizontal Scale" => "Echelle horizontale",
"Bottom" => "Bas",
"Vertical Scale" => "Echelle verticale",
"Series" => "Séries",
"Wiki plug-in" => "Plug-in Wiki",
"Ical import / Export" => "Importer/exporter en Ical",
"Select The calendar to export" => "Sélectionner le calendrier à exporter",
" To " => " Vers ",
"Calendar Import" => "Importer un calendrier",
"ICal File" => "Fichier ICal",
"Im- Export languages" => "Langues Im/Export",
"Select the language to Import" => "Sélectionner la langue à importer",
"Select the language to Export" => "Sélectionner la langue à exporter",
"Import From File" => "Importer d'un fichier",
"Grab Wiki Tables" => "Récupérer les tables Wiki",
"Import pages from a Structured Text Dump" => "Importer les pages d'un Dump Texte Structuré",
"tiki-import_phpwiki tpl" => "gabarit des tiki-import_phpwiki",
"Name of the dump file (it has to be in dump/)" => "Nom du fichier-dump (il doit être dans dump/)",
"Overwrite existing pages if the name is the same" => "Écraser les pages existantes si le nom est le même",
"Previously remove existing page versions" => "Supprimer les versions préexistantes de la page",
"excerpt" => "extrait",
"Result" => "Résultat",
"body" => "corps",
"Tiki installer" => "Installateur Tiki",
"MultiTiki setup" => "Configuration MultiTiki",
"To add a new virtual host" => "Ajouter un nouveau serveur virtuel",
"To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "Pour ajouter un nouveau serveur virtuel, exécuter le script setup.sh avec le nom de domaine du nouveau site comme dernier paramètre",
"Tiki cannot find a database connection" => "Tiki ne peut pas accéder à la base de données",
"Database type" => "Type de base de données",
"Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension." => "Les seuls moteurs de bases de données qui sont listés ici sont ceux acceptés par votre installation PHP. Si votre moteur de base de données ne figure pas dans cette liste, essayez d'installer les bonnes extensions PHP.",
"Host:" => "Serveur :",
"Database name" => "Nom de la bnase de données",
"Connect" => "Connecter",
"Reinstall database." => "Réinstaller une base de données.",
"This will destroy your current database" => "Cette opération va détruire votre base de données",
"Install" => "Installer",
"Create a new database (clean install) with profile" => "Créer une nouvelle base de données (installation propre) avec les profils",
"Upgrade" => "Mise à jour",
"Backup your database with mysqldump, phpmyadmin, or other before upgrading." => "Sauvegarder votre base de données avec mysqldump ou phpmyadmin ou autres avant de failre la mise à jour.",
"Update database using script" => "Mettre à jour la base de données en utilisant le script",
"No scripts available." => "Aucun script disponible.",
"To upgrade from" => "Pour mettre à jour de",
"Use this script" => "Use ce script",
"Other Options" => "Autres options",
"Do nothing and enter Tiki" => "Ne faire rien et entrer dans Tiki",
"Reset database connection settings" => "Réinitialiser les paramètres de connexion base de données",
"This site has an admin account configured" => "Ce site a déjà un utilisateur admin",
"Please login with your admin password to continue" => "Veuillez vous connecter avec votre mot de passe admin pour poursuivre",
"Your database has been configured and Tikiwiki is ready to run!" => "Votre base de données a été configurée et Tikiwiki est prèt à fonctionner !",
"If this is your first install, your admin password is <strong>admin</strong>." => "Si ceci est votre première installation, veuillez noter que le mot de passe admin est <strong>admin</strong>.",
"You can now log in into Tikiwiki as user <strong>admin</strong> and start configuring the application." => "Vous pouvez maintenant vous connecter à Tikiwiki en tant qu'<strong>admin</strong> et débuter la configuration de l'application.",
"SQL queries" => "Requêtes SQL",
"Failed" => "Echoué",
"Display details" => "Afficher les détails",
"Important Information" => "Information importante",
"Please read the following notes before entering Tikiwiki." => "Merci de lire les notes suivantes avant d'entrer dans Tikiwiki.",
"TikiWiki requires <strong>at least</strong> 16MB of PHP memory for script execution. Use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 16M) and restart your webserver" => "TikiWiki nécessite <strong>au minimum</strong> 16Mo de mémoire PHP pour l'exécution des scripts. Utilisez le paramètre <strong>memory_limit</strong> de votre fichier <strong>php.ini</strong> (par exemple : memory_limit = 16M) et redémarrez votre serveur web",
"Allocating too little memory will cause TikiWiki to display blank pages" => "Une trop faible allocation de mémoire provoque l'affichage de pages blanches",
"Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki n'a pas pu détecté une limite de la mémoire PHP. Cela veut probablement dire que vous n'avez pas de limite ( parfait!)",
"Tiki has detected your PHP memory limit at" => "Tiki a détecté que votre mémoire PHP est limitée à ",
"Tiki has detected your PHP memory_limit at" => "Tiki a détecté que votre limite de mémoire PHP (memory_limit) est fixée à",
"If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "Si ceci est votre première installation, ouvrez la page <strong>tiki-admin.php</strong> après connexion pour démarrer la configuration de votre Tiki",
"If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu." => "Si ceci est une évolution, nettoyez les caches manuellement (le répertoire <strong>templates_c</strong>) ou en utilisant l'option <strong>Admin &gt; System</strong> du menu d'administration.",
"Entering TikiWiki" => "Entrer dans TikiWiki",
"Go back and run another install/upgrade script" => "Relancer le script d'installation et de mise à jour",
"Do not use your browser's Back button." => "Ne pas utiliser le bouton 'Retour' de votre navigateur.",
"Clear cached version and refresh cache" => "Vider l'antémémoire et la reconstruire",
"configure rules" => "configurer les règles",
"Edit Repository" => "Modifier un répertoire",
"Interactive translator" => "Translation interactive",
"has been updated" => "a été mis à jour",
"Close this window" => "Fermer cette fenêtre",
"Go Back" => "Retour",
"Clicking 'Close this window' will reload the main window from where it was opened" => "Cliquer sur 'Fermer cette fenêtre' va recharger la fenêtre principale à partir de l'endroit où elle a été ouverte",
"weeks" => "semaines",
"Search by Date" => "Recherche par date",
"LastChanges" => "DerniersChangements",
"Rollback" => "Reprendre",
"Pages like" => "Pages similaires à",
"No pages found" => "Aucun résultat",
"List Articles Tpl" => "Gabarit des listes des articles",
"Edit New Article" => "Créer un article",
"ExpireDate" => "Date d'expiration",
"AuthorName" => "Auteur",
"Admin Banners" => "Admin bannières",
"Admin Banners tpl" => "Admin gabarit bannières",
"To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "Pour utiliser une bannière dans un <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> ou un gabarit, utiliser {literal}{banner zone=ABC}{/literal}, où ABC est le nom de la zone.",
"Create banner" => "Créer une bannière",
"Method" => "Méthode",
"Use Dates?" => "Utiliser des dates?",
"Max Impressions" => "Max. d'impressions",
"Clicks" => "Clics",
"Create New Blog" => "Créer un nouveau blogue",
"Admin Cache" => "Administrer l'antémémoire",
"Admin Cache tpl" => "Gabarit de l'administration de l'antémémoire",
"The cache is used by:" => "L'antémémoire est utilisée par :",
"Dynamic content system" => "Système de contenu dynamique",
"Help on Dynamic Content" => "Aide sur le contenu dynamique",
"Admin DynamicContent tpl" => "Admin gabarit Contenu Dynamique",
"To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "Pour utiliser les blocs de contenus dans une zone de texte (page Wiki page, etc.), un <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> ou un gabarit, utiliser {literal}{content id=x}{/literal}, où x est l'Id du bloc de contenu.",
"Available content blocks" => "Blocs de contenu disponibles",
"Current ver" => "Version en cours",
"Next ver" => "Prochaine version",
"Future vers" => "Versions futures",
"Program" => "Programmer",
"List FAQs Tpl" => "Gabarit des listes de FAQs",
"Edit this FAQ:" => "Modifier cette FAQ :",
"Create new FAQ" => "Créer une nouvelle FAQ",
"Create New FAQ:" => "Créer une nouvelle FAQ :",
"Users can suggest questions" => "Les utilisateurs peuvent suggérer des questions",
"Available FAQs" => "FAQs disponibles",
"Create a file gallery" => "Créer une galerie de fichiers",
"SlideShow" => "Diaporama",
"Your comment" => "Votre commentaire",
"optional" => "facultatif",
"Property <b>{\$fgp_name}</b> Changed" => "Propriété <b>{\$fgp_name}</b> Modifiée",
"Gallery Images" => "Galerie d'images",
"games tpl" => "gabarit jeu",
"All games are from" => "Tous les jeux proviennent de",
"visit the site for more games and fun" => "Visiter le site pour plus de jeux et de plaisir",
"Upload a game" => "Envoyer un jeu",
"Upload a new game" => "Envoyer un nouveau jeu",
"Flash binary (.swf or .dcr)" => "Binaire Flash (.swf or .dcr)",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Vignette (si le jeu est foo.swf, la vignette doit être appelée foo.swf.gif ou foo.swf.png ou foo.swf.jpg)",
"Edit game" => "Modifier le jeu",
"Played" => "Joué",
"times" => "fois",
"If you can't see the game then you need a flash plugin for your browser" => "Si le jeu ne s'affiche pas à l'écran, vous avez besoin du module d'extension Flash",
"List Posts Tpl" => "Gabarit des listes de publications",
"Blog Title" => "Titre du blogue",
"List Quizzes Tpl" => "Gabarit de la liste de QCMs",
"Edit New Submission" => "Créer une nouvelle soumission",
"Edit Quiz Stats Tpl" => "Modifier le gabarit de la liste des formulaires",
"Survey stats" => "Statistiques sur les enquêtes",
"Take Survey" => "Remplir une enquête",
"List Trackers Tpl" => "Gabarit de la liste des formulaires",
"users registered" => "utilisateurs enregistrés",
"List Movies" => "Liste des films",
"Choose a movie" => "Choisir un film",
"Last mod" => "Der. mod",
"Last modification" => "Dernière modification",
"Page creator" => "Créateur",
"Last author" => "Dernier auteur",
"Last ver." => "Derniêre ver.",
"Status of the page" => "Statut de la page",
"Page size" => "Taille de page",
"unlocked" => "non verrouillé",
"Perform action with checked" => "Action à mener sur les items sélectionnés",
"Admin Live Support tpl" => "Gabarit de l'administration de l'assistance en ligne",
"Open client window" => "Ouvrir une console client",
"Generate HTML" => "Générer en HTML",
"Transcripts" => "Rapports",
"Support tickets" => "Tickets d'assistance",
"Online operators" => "Opérateur connecté",
"Operator" => "Opérateur",
"Accepted requests" => "Demandes acceptées",
"transcripts" => "rapports",
"offline" => "non connecté",
"Offline operators" => "Opérateurs non connectés",
"Add an operator to the system" => "Ajouter un opérateur au système",
"Operators must be tiki users" => "Les opérateurs doivent être des utilisateurs Tiki",
"Set as Operator" => "Le mettre en opérateur",
"Chat started" => "Discussion commencée",
"Operator:" => "Opérateur :",
"Live support:User window" => "Assistance en ligne : Fenêtre utilisateur",
"Request live support" => "Demande d'assistance en ligne",
"Request support" => "Demande d'assistance",
"Open a support ticket instead" => "Ouvrir un ticket d'assistance à la place",
"Your request is being processed" => "Votre demande a été prise en compte",
"cancel request and exit" => "supprimer la demande et sortir",
"cancel request and leave a message" => "supprimer la demande et laisser un message",
"Live support:Console" => "Assistance en ligne : Console",
"be online" => "se connecter",
"be offline" => "se déconnecter",
"Support requests" => "Demandes d'assistance",
"Requested" => "Demandé",
"Join" => "Joindre",
"Support chat transcripts" => "Rapports des discussions d'assistance",
"back to admin" => "retourner à l'administration",
"operator" => "opérateur",
"started" => "commencé",
"reason" => "raison",
"Transcript" => "Rapport",
"For security purposes we must periodically validate your email address to allow continued access to this site." => "Pour des raisons de sécurité, vous devez périodiquement revalider votre adresse électronique pour pouvoir accéder au site.",
"A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site." => "Un courriel de validation vous a été envoyé. SVP ouvrez le et suivez les instructions pour pouvoir réaccéder au site",
"Thank you" => "Merci",
"Mail-in feature" => "Fonctionnalité mail-in",
"User Calendar" => "Mon calendrier",
"User Calendar Doc tpl" => "Gabarit de la doc. de mon calendrier",
"Remove old events" => "Supprimer les vieux évènements",
"duration" => "durée",
"Add event" => "Ajouter un évènement",
"Mini Calendar: Preferences" => "Mon Calendrier : Préférences",
"User Calendar Doc" => "Doc calendrier utilisateur",
"User Calendar Preferences Doc tpl" => "Gabarit de la doc préférences du calendrier utilisateur",
"Calendar Interval in daily view" => "Intervalle de temps dans la vue journalière",
"Start hour for days" => "Première heure vue du jour",
"End hour for days" => "Dernière heure vue du jour",
"Reminders" => "Rappels",
"no reminders" => "Aucun rappel",
"Or enter path or URL" => "Ou donner un chemin d'accès ou une adresse Web",
"Add Topic" => "Ajouter le sujet",
"Tikiwiki Mods" => "Mods Tikiwiki",
"Mods Configuration" => "Configuration des Mods",
"Update remote index" => "Mettre à jour l'index à partir du serveur distant",
"Rebuild local list" => "Reconstruire la liste locale",
"Republish all" => "Republier tout",
"Publish all" => "Publier tout",
"Unpublish all" => "Dépublier tout",
"Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>." => "Les Tiki \"mods\" sont des fonctionnalités additionnelles qui ne sont pas incluses dans la version publique de Tikiwiki. Pour en savoir plus, aller sur <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>.",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./fixperms fix\" for example)." => "Apache a les permissions pour écrire des fichiers dans le répertoire, ce qui active l'installation, la suppression ou la mise à jour des paquets. Quand vous aurez terminé ces opérations, pensez à fixer les permissions dans un état sécurisé (utilisez \"./fixperms fix\" par exemple).",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that permission (using \"./fixperms fix\")." => "Pour installer, supprimer ou mettre à jour les paquets, vous devez donner les droits à Apache d'écrire des fichiers dans l'arborescence de votre site web (vous pouvez utiliser \"./fixperms.sh open\" pour lui donner les droits). Après l'installation vous devrez supprimer les permissions (utilisez \"./fixperms fix\").",
"all types" => "tous les types",
"Display only this type" => "N'afficher que ce type",
"Unpublish" => "Le dépublier",
"Republish" => "Republier",
"Tikiwiki Mods Configuration" => "Configuration des Mods Tikiwiki",
"Mods Install/uninstall" => "Installer/Désinstaller les mods",
"Enable Mods providing" => "Permettre au serveur local d'être serveur de Mods",
"Mods local directory" => "Répertoire des Mods sur le serveur local",
"Mods remote server" => "Répertoire des Mods sur le serveur distant",
"Package Config" => "Configuration des Progiciels",
"my tiki tpl" => "gabarit MonTiki",
"User Pages" => "Mes pages",
"y" => "oui",
"User Galleries" => "Mes galeries",
"Assigned items" => "Fiches attribués",
"Unread Messages" => "Messages non lus",
"Forum topics" => "Sujets de forum",
"Date of post" => "Date du post",
"User forum replies" => "Réponses de l'utilisateur dans le forum",
"Forum replies" => "Réponses dans le forum",
"User Blogs" => "Mes blogues",
"To display the objects you participate:" => "Pour afficher les objets auxquels vous participez :",
"Contacts Preferences" => "Préférences des contacts",
"MyFiles" => "MesFichiers",
"My Infos" => "Mes infos",
"My Contacts" => "Mes contacts",
"My Wiki Pages" => "Mes pages Wiki",
"My Galleries" => "Mes galeries",
"My Tracker Items" => "Mes fiches de formulaire",
"My Messages" => "Mes messages",
"My Tasks" => "Mes tâches",
"Subscribe" => "S'abonner",
"Sent Edition" => "Lettre d'informations envoyée",
"HTML version" => "Version HTML",
"Text version" => "Version texte",
"Errors:" => "Erreurs :",
"Delete errors" => "Effacer les erreurs",
"Not sent" => "Non envoyé",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Merci pour votre inscription. Vous recevrez un email bientôt pour confirmer votre inscription. Aucune lettre d'information ne vous sera envoyée tant que l'inscription ne sera pas confirmée.",
"Your email address was removed from the list of subscriptors." => "Votre adresse électronique a été supprimée dans la liste des abonnés",
"Subscription confirmed!" => "Votre inscription est confirmée!",
"Subscribe to Newsletter" => "S'abonner à une lettre d'informations",
"Subscribe to This Newsletter" => "S'abonner à cette lettre d'informations",
"Available Newsletters" => "Lettres d'informations disponibles",
"Select news group" => "Choisir un groupe de news",
"Back to servers" => "Retour au serveur",
"News from" => "Des nouvelles de",
"Back to groups" => "Retour aux groupes",
"Save position" => "Enregistrer la position",
"Reading article from" => "Article lu de",
"Back to list of articles" => "Retour à la liste des articles",
"First" => "Prem.",
"Configure news servers" => "Configurer les serveurs de news",
"Configure Newsreader" => "Configurer le lecteur de news",
"configure newsreader server tpl" => "gabarit de la configuration de lecteur de news",
"Select a news server to browse" => "Sélectionner un serveur de news à parcourir",
"server" => "serveur",
"Read the news" => "Lire les news",
"Add a news server" => "Ajouter un serveur de news",
"Edit news server" => "Editer le serveur de  news",
"News server" => "Serveur de news",
"Notes" => "Liste des notes",
"Write a note" => "Écrire une note",
"No notes yet" => "Aucune note pour l'instant",
"Merge selected notes into" => "fusionner les notes sélectionnées dans",
"Reading note:" => "Note lue :",
"List notes" => "Liste des notes",
"Write note" => "Écrire une note",
"Wiki Create" => "Créer la page Wiki",
"Wiki Overwrite" => "écraser la page Wiki",
"Assign permissions to " => "Attribuer des droits d'accès : ",
"Back" => "Retour",
"View Permissions" => "Voir les permissions",
"Edit Permissions" => "Editer les permissions",
"These permissions override any global permissions or category permissions affecting this object." => "Ces permissions remplacent toutes les permissions globales ou de catégories rattachées à cet objet.",
"To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>." => "Pour attribuer les droits d'accès globaux <a class=\"rbox-link\" href=\"tiki-admingroups.php\">cliquer ici</a>.",
"Current permissions for this object" => "Droits d'accès pour cet objet",
"No individual permissions, category permissions apply" => "Aucune permission individuelle ne s'applique, les permissions sur les catégories s'appliquent",
"Current permissions for categories that this object belongs to" => "Permissions courantes sur les catégories auxquelles cet objet appartient",
"These permissions do not apply. Special permissions apply." => "Ces permissions ne s'appliquent pas. Les permissions spéciales s'appliquent.",
"No category permissions; global permissions apply" => "Aucune permission sur les catégories : les droits globaux s'appliquent",
"No category permissions; special permissions apply" => "Pas de permissions sur les catégories; les permissions spéciales s'appliquent",
"and also to all pages of the sub-structure:" => "et aussi à toutes els pages de la sous structure :",
"Assign permissions to this object" => "Attribuer de nouveaux droits d'accès à cet objet",
"Perms Help" => "Aide pour les droits d'accès",
"Published" => "Publié",
"Your OpenID identity is valid" => "Votre compte OpenID est correct",
"However, no account is associated to the OpenID identifier." => "Cependant, aucun compte est associé avec l'identifi",
"Create a new Tikiwiki account from OpenID" => "Créer un compte Tikiwiki pour cet OpenId",
"Your identity gives you access to multiple user accounts." => "Votre identité vous donne accès à plusieurs comptes utilisateur.",
"Select account" => "Choisir un compte",
"Orphan Pages" => "Pages orphelines",
"Browser not supported" => "Navigateur non supporté",
"Make Structure" => "Créer une structure",
"Preview of version" => "Aperçu de cette version",
"(current)" => "(courant)",
"Rollback to this version" => "Revenir à cette version",
"Source of version" => "Source de cette version",
"b=rollback" => "b=reprendre",
"HTML diff" => "diff HTML",
"Side-by-side diff" => "Diff. côte à côte",
"Side-by-side diff by characters" => "Diff. côte à côte sur les caractères",
"Inline diff" => "Diff. entrelacée",
"Inline diff by characters" => "Diff. entrelacée sur les caractères",
"Full side-by-side diff by characters" => "Diff. côte à côte complète sur les caractères",
"Full inline diff" => "Diff. entrelacée complète",
"Full inline diff by characters" => "Diff. entrelacée complète sur les caractères",
"Updated from" => "Mis à jour par",
"Update Translation" => "Mettre à jour la traduction",
"Hide translation history" => "Cacher l'historique des traductions",
"Show translation history" => "Montrer l'historique des traductions",
"Avatar:" => "Avatar :",
"Pick your avatar" => "Choisissez votre avatar",
"User Preferences" => "Préférences utilisateur",
"Your current avatar" => "Votre avatar actuel",
"no avatar" => "aucun avatar",
"reset" => "réinitialiser",
"Pick avatar from the library" => "Choisissez un avatar de la bibliothèque",
"Pick user Avatar" => "Choisissez un avatar utilisateur",
"Hide all" => "Masquer tout",
"icons" => "icônes",
"Show all" => "Montrer tout",
"Avatar Image" => "Image avatar",
"Upload your own avatar" => "Envoyer votre avatar",
"(Only .gif images, and aproximately 45px x 45px)" => "(Seulement les images .gif, et approximativement 45px x 45px)",
"Any" => "Tout",
"Items found:" => "Fiches trouvées :",
"atts" => "joints",
"List Attachments" => "Liste des fichiers joints",
"View Results" => "Voir les résultats",
"Vote poll" => "Voter",
"Other Polls" => "Autres sondages",
"Poll Results" => "Resultats des sondages",
"Average:" => "Moyenne :",
"List Votes" => "Liste des votes",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Note : Ceci est un aperçu, et n'a pas encore été sauvegardé",
"Permission denied. You do not have permission to read complete articles." => "Droit d'accès refusé : vous ne pouvez pas consulter les articles complets.",
"Print multiple pages" => "Imprimer des pages multiples",
"Selected Structures" => "Structures Sélectionnées",
"Add Structure" => "Ajouter une structure",
"No structures" => "Aucune structure",
"Add Pages" => "Ajouter les pages",
"No pages" => "Aucune page",
"Add Pages from Structures" => "Ajouter les pages des structures",
"Selected Pages" => "Pages sélectionnées",
"No pages selected." => "Aucune page n'a été sélectionnée.",
"Edit quiz" => "Modifier un QCM",
"General Options" => "Options générales",
"Name:" => "Nom :",
"Publication Date" => "Date de publication",
"at " => "à ",
"Use " => "Utilisez ",
"randomly selected questions." => "questions choisies au hasard.",
"Test-time Options" => "Options sur la période de test",
"Limit questions displayed per page to " => "Limiter les questions affiché par page à ",
"&nbsp question(s)." => "&nbsp; question(s).",
"Impose a time limit of " => "Imposer un temps limite de ",
"Allow students to store partial results and return to quiz." => "Permettre aux étudiants de sauvegarder des réponses partielles et de revenir au QCM",
"Allow students to retake this quiz " => "Permettre aux étudiants de repasser ce QCM",
"Grading and Feedback" => "Corrections et commentaires",
"Grading method " => "Méthode de correction ",
"Show students their score " => "Montrer aux étudiants leur score",
"Show students the correct answers " => "Montrer aux étudiants les réponses correctes",
"Publish statistics " => "Publier les statistiques ",
"Extra Options" => "Options supplémentaires",
"Solicit additional questions from students" => "Solliciter des questions supplémentaires aux étudiants",
"Link quiz to forum named: " => "Lié le QCM au forum de nom : ",
"Epilogue:" => "Epilogue :",
"Quiz result stats" => "Statistiques sur les résultats de QCM",
"Quiz" => "QCM",
"Time" => "Temps",
"User answers" => "Réponses de l'utilisateur",
"Stats for quizzes" => "Statistiques sur les QCMs",
"taken" => "réponses",
"Av score" => "Score moyen",
"Av time" => "Temps moyen",
"Stats for quiz" => "Statistiques sur les QCMs",
"Clear Stats" => "Effacer les statistiques",
"time taken" => "temps utilisé",
"P/F" => "R/E",
"Passed" => "Réussi",
"Stats for this quiz Questions " => "Statistiques sur les questions de ce QCM",
"Question:" => "Question :",
"Average" => "Moyenne",
"Top 10" => "10 premiers",
"Top 20" => "20 premiers",
"Top 50" => "50 premiers",
"Top 100" => "100 premiers",
"Received Articles" => "Articles reçus",
"received articles tpl" => "gabarit des articles reçus",
"Edit received article" => "Modifier l'article reçu",
"Use Image" => "Utiliser images",
"Image x size" => "Image x pixel",
"Image y size" => "Image y pixel",
"Image name" => "Nom de l'image",
"Accept Article" => "Accepter article",
"Received Pages" => "Pages reçues",
"Help on Communication Center" => "Aide sur le Centre de communication",
"received pages tpl" => "gabarit des pages reçues",
"Edit Received Page" => "Editer les pages reçues",
"The highlight pages already exist." => "Les pages surlignées existent déjà.",
"Please, change the name if you want the page to be uploaded." => "Veuillez changer le nom si vous désirez pouvoir charger la page.",
"Admin Referer Stats" => "Administrer les statistiques des origines",
"Admin Referer Stats tpl" => "Gabarit de l'administration des statistiques des origines",
"Use your email as login" => "Utilisez votre adresse électronique pour vous connecter",
"Lowercase only" => "Minuscules seulement",
"A valid email is mandatory to register" => "Une adresse électronique valide est nécessaire pour s'inscrire",
"Select your group" => "Choissisez votre groupe",
"NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "Attention: mettez le domaine du site en liste blanche dans votre logiciel de mail pour que les courriels du site ne partent pas dans la boîte aux lettres des indésirables!",
"Tiki site registered" => "Site Tiki enregistré",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Le site suivant a été ajouté, la validation de l'administrateur est peut être nécessaire",
"You don't have permission to use this feature." => "Vous n'avez pas le droit d'utiliser cette fonctionnalité.",
"Please register." => "Enregistrez-vous",
"Register this site at tikiwiki.org" => "Enregistrez ce site sur tikiwiki.org",
"Read this first!" => "Lisez ceci d'abord!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Sur cette page, vous pouvez faire connaître votre site à tikiwiki.org",
"Registering is voluntary." => "L'inscription est libre.",
"Registering does not give you any benefits except one more link to your site." => "L'inscription n'apporte rien de plus qu'un lien vers votre site.",
"You don't get any emails, we don't sell the data about your site." => "Vous ne recevrez pas d'emails. Nous ne vendons pas vos informations.",
"Registering is just for us to get an overview of Tiki's usage." => "L'inscription nous sert à avoir une idée de l'utilisation de Tiki.",
"If your site is private or inside your intranet, you should not register!" => "Si votre site est privé ou sur un intranet, ne l'inscrivez pas!",
"Information about your site" => "Information sur votre site",
"Enter your username or email." => "Entrer votre compte ou adresse mail.",
"Send me my Password" => "Envoyez-moi mon mot de passe",
"Request Password Reset" => "Demander une réinitialisation du mot de passe",
"Return to HomePage" => "Retourner à la PageAccueil",
"Remove page" => "Supprimer la page",
"Last Version" => "Dernière version",
"return to wikipage" => "retourner à la page Wiki",
"You are about to remove the page" => "Vous êtes sur le point de supprimer la page",
"permanently" => "définitivement",
"Remove all versions of this page" => "Supprimer toutes les versions de la page",
"Rename page" => "Renommer la page",
"Replicate" => "Réplication",
"Slave" => "Esclave",
"Master" => "Maître",
"Operations" => "Opérations",
"Operations Log" => "Journal des opérations",
"Rollback page" => "Retour en arrière",
"to_version" => "à la version",
"Search Stats" => "Statistiques des recherches",
"search stats tpl" => "gabarit des statistiques des recherches",
"Searched" => "Recherché",
"Search in" => "Rechercher dans",
"Simple search" => "Recherche simple",
"No pages matched the search criteria" => "Aucune page ne correspond au critère de recherche",
"Send blog post" => "Envoyer l'article de blogue",
"A link to this post was sent to the following addresses:" => "Un lien vers cet article a été envoyé aux adresses suivantes :",
"Send post to this addresses" => "Envoyer les articles à ces adresses",
"List of email addresses separated by commas" => "Listes des adresses électroniques séparées par une virgule",
"referenced by" => "référencés par",
"references" => "références",
"Please Confirm" => "Confirmer l'envoi",
"Apply content template" => "Appliquer un gabarit de contenu",
"Data HTML" => "Données HTML",
"Data Txt" => "Données Txt",
"Save as Draft" => "Enregistrer comme brouillon",
"Send objects" => "Envoyer des objets",
"Admin Send Objects tpl" => "Gabarit des envois d'objets",
"Transmission results" => "Transmission des résultats",
"Send Wiki Pages" => "Envoyer des pages Wiki",
"Send a structure" => "Envoyer une structure",
"Send Articles" => "Envoyer des articles",
"Add Article" => "Ajouter un article",
"Send objects to this site" => "Envoyer des objets à ce site",
"Ex: http://tikiwiki.org or localhost" => "Exemple : http://tikiwiki.org ou localhost",
"sheets tpl" => "gabarit feuillet",
"Create a sheet" => "Créer un feuillet",
"Edit this sheet:" => "Modifier ce feuillet:",
"Create New Sheet" => "Créer un nouveau feuillet",
"There are individual permissions set for this sheet" => "Des droits d'accès individuels ont été mis sur ce feuillet",
"Class Name" => "Nom de la classe",
"Header Rows" => "Rangées entête",
"Footer Rows" => "Rangées bas-de-page",
"Create new Sheet" => "Créer un nouveau feuillet",
"You can access the sheet using the following URL" => "Vous pouvez accéder à ce feuillet par l'adresse Web suivante",
"Available Sheets" => "Feuillets disponibles",
"Tiki Shoutbox" => "Mégaphone Tiki",
"Admin Tiki Shoutbox" => "Admin le mégaphone",
"Admin Tiki Shoutbox tpl" => "Admin le gabarit mégaphone",
"Change shoutbox general settings" => "Changer la configuration générale du mégaphone",
"auto-link urls" => "reconnaissance automatique des URLs",
"Post or edit a message" => "Publier ou modifier un message",
"Click to Navigate" => "Cliquer pour naviguer",
"Approve changes." => "Approuver les modifications.",
"TOC" => "Sommaire",
"big grin" => "large sourire",
"confused" => "confus",
"cool" => "relax",
"cry" => "pleure",
"eek" => "oh!",
"evil" => "diable",
"lol" => "riant fort",
"mr green" => "inexpérimenté",
"razz" => "nargue",
"redface" => "rougissant",
"rolleyes" => "yeux qui tournent",
"smile" => "sourire",
"surprised" => "surpris",
"twisted" => "dingue",
"arrow" => "flèche",
"santa" => "Père Noël",
"Most viewed objects" => "Objets les plus vus",
"Most viewed objects in the last 7 days" => "Objets les plus vus ces derniers 7 jours",
"Site Stats" => "Statistiques du site",
"Days online" => "Nombre de jours en ligne",
"Total pageviews" => "Total des pages vues",
"Average pageviews per day" => "Nombre moyen de pages vues par jour",
"pvs" => "pages vues",
"Best day" => "Jour le plus populaire",
"Worst day" => "Jour le moins populaire",
"Wiki Stats" => "Statistiques de Wiki",
"Size of Wiki Pages" => "Taille totale des pages Wiki",
"Average page length" => "Taille moyenne d'une page",
"Average versions per page" => "Nombre moyen de versions par page",
"Visits to wiki pages" => "Nombre de visites aux pages Wiki",
"Average links per page" => "Nombre moyen de liens par page",
"Image galleries Stats" => "Statistiques sur les galeries d'images",
"Average images per gallery" => "Nombre moyen d'images par galerie",
"Total size of images" => "Taille totale des images",
"Average image size" => "Taille moyenne d'une image",
"Visits to image galleries" => "Nombre de visites aux galeries d'images",
"File galleries Stats" => "Statistiques sur les galeries de fichiers",
"Average files per gallery" => "Nombre moyen de fichiers par galerie",
"Total size of files" => "Taille totale des fichiers",
"Average file size" => "Taille moyenne d'un fichier",
"Visits to file galleries" => "Nombre de visites aux galeries de fichiers",
"CMS Stats" => "Statistiques sur les articles",
"Total reads" => "Nombre total de lectures",
"Average reads per article" => "Nombre moyen de lectures par article",
"Total articles size" => "Taille totale des articles",
"Average article size" => "Taille moyenne d'un article",
"Forum Stats" => "Statistiques sur les forums",
"Total topics" => "Nombre total de sujets",
"Average topics per forums" => "Nombre moyen de sujets par forum",
"Total replies" => "Nombre total de réponses",
"Average number of replies per topic" => "Nombre moyen de réponses par sujet",
"Visits to forums" => "Visites aux forums",
"Blog Stats" => "Statistiques sur les blogues",
"Weblogs" => "Blogues",
"Total posts" => "Total des articles",
"Average posts per weblog" => "Moyenne d'articles par blogue",
"Total size of blog posts" => "Taille totale des articles du blogue",
"Average posts size" => "Taille moyenne d'un article",
"Visits to weblogs" => "Visites aux blogues",
"Poll Stats" => "Statistiques sur les sondages",
"Total votes" => "Total de votes",
"Average votes per poll" => "Nombre moyen de votes par sondage",
"FAQ Stats" => "Statistiques des FAQ",
"Total questions" => "Nombre total de questions",
"Average questions per FAQ" => "Nombre moyen de questions par FAQ",
"User Stats" => "Statistiques sur les utilisateurs",
"User bookmarks" => "Signets des utilisateurs",
"Average bookmarks per user" => "Nombre moyen de signets par utilisateur",
"Average questions per quiz" => "Nombre moyen de questions par QCM",
"Quizzes taken" => "QCMs remplis",
"Average quiz score" => "Moyenne des scores de QCM",
"Average time per quiz" => "Temps moyen pour remplir un QCM",
"Usage chart" => "Graphe d'utilisation",
"Usage chart image" => "Image du graphe d'utilisation",
"Daily Usage" => "Usage journalier",
"Stats for surveys" => "Statistiques sur les enquêtes",
"Last taken" => "Dernière réponse",
"Stats for survey" => "Statistiques sur les enquêtes",
"Stats for this survey Questions " => "Statistiques sur les questions de cette enquête",
"System log help" => "Aide des system log",
"system logs" => "logs du système",
"system logs tpl" => "gabarit des logs du système",
"Clean logs older than" => "Nettoyer les entrées de journal plus vieilles que",
"months" => "mois",
"Clean" => "Nettoyer",
"Time Left" => "Temps restant",
"Send Answers" => "Envoyer les réponses",
"Thank you for your submission" => "Merci pour votre soumission",
"Send a link to a friend" => "Envoyer ce lien à un ami",
"Your email was sent" => "Votre email a été envoyé",
"The link was sent to the following addresses:" => "Le lien a été envoyé à ces adresses:",
"Friend's email" => "Adresse mail de votre ami",
"Separate multiple email addresses with a comma." => "Séparer les adresses mail par des virgules.</em>",
"Your name" => "Votre nom",
"Your email" => "Votre adresse email",
"I found an interesting page that I thought you would like." => "J'ai trouvé cette page qui pourrait t'intéresser.",
"Summary mode" => "Mode résumé",
"Show Page Differences" => "Montrer les différences de page",
"Delete this link" => "Supprimer ce lien",
"Failure" => "Échec",
"Reference" => "Référence",
"The pages are different" => "Les pages sont différentes",
"The pages are identical" => "Les pages sont identiques",
"Theme Control Center: categories" => "Contrôle des thèmes/catégories",
"ThemeControl" => "Contrôle des thèmes",
"ThemeControl tpl" => "gabarit du contrôle des thèmes",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "Pour apprendre plus sur les <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">thèmes</a>.",
"Theme is selected as follows" => "Le thème est choisi comme suit",
"If a theme is assigned to the individual object that theme is used." => "Si un thème est attribué à l'objet lui-même, ce thème est utilisé",
"If not then if a theme is assigned to the object's category that theme is used" => "Sinon, si un thème est attribué à la catégorie de l'objet, ce thème est utilisé",
"If not then a theme for the section is used" => "Sinon, le thème de la section est utilisé",
"If none of the above was selected the user theme is used" => "Si rien au-dessus n'est sélectionné, le thème de l'utilisateur est utilisé",
"Finally if the user didn't select a theme the default theme is used" => "Finalement, si l'utilisateur n'a pas sélectionné un thème, le thème par défaut est utilisé",
"Control by Objects" => "Contrôle des thèmes/objets",
"Control by Sections" => "Contrôle des thèmes/sections",
"Assign themes to categories" => "Attribuer un thème à une catégorie",
"Assigned categories" => "Catégories avec thème",
"theme" => "thème",
"Theme Control Center: Objects" => "Contrôle des thèmes/objets",
"ThemeControl Objects" => "Objets du contrôle des thèmes",
"theme control objects tpl" => "gabarit des objets du contrôle des thèmes",
"Control by Categories" => "Contrôle des thèmes/catégories",
"Assign themes to objects" => "Attribuer un thème à un objet",
"Assigned objects" => "Objets avec thème",
"Theme Control Center: sections" => "Contrôle des thèmes/sections",
"theme control sections tpl" => "gabarit des sections de contrôle de thème",
"Assign themes to sections" => "Attribuer un thème à une section",
"Assigned sections" => "Sections avec thème",
"Edit File:" => "Fichier modifié :",
"The following file was successfully uploaded" => "Ce fichier a été envoyé avec succès",
"You can download this file using" => "Vous pouvez télécharger ce fichier avec",
"You can link to the file from a Wiki page using" => "Vous pouvez inclure un lien vers le fichier dans une page Wiki en utilisant",
"You can display an image in a Wiki page using" => "Vous pouvez afficher l'image dans une page Wiki en utilisant",
"You can link to the file from an HTML page using" => "Vous pouvez inclure un lien vers le fichier dans une page HTML en utilisant",
"Upload big files (e.g. PodCast files) here:" => "Envoi de fichiers volumineux (e.g. PodCast files) ici :",
"You locked the file" => "Vous avez verrouillé le fichier",
"The file is locked by {\$fileInfo.lockedby}" => "Le fichier est verrouillé par {\$fileInfo.lockedby}",
"File Title" => "Titre du fichier",
"Batch upload" => "Envoi par lot",
"Unzip all zip files" => "Dézipper tous les fichiers zip",
"Author if not the file creator" => "Auteur si différent du créateur",
"You have to create a gallery first!" => "Il faut tout d'abord créer une galerie !",
"Image Gallery tpl" => "gabarit des galeries d'images",
"Upload successful!" => "Envoi réussi !",
"The following image was successfully uploaded" => "L'image suivante a été envoyée avec succès",
"Thumbnail" => "Vignette",
"Image ID thumb" => "Vignette de l'image",
"You can include the image in an Wiki page using" => "Vous pouvez insérer cette image dans une page Wiki en utilisant",
"or use filename" => "ou utiliser le nom du fichier",
"Now enter the image URL" => "Entrer maintenant l'adresse Web",
" or upload a local image from your disk" => " ou envoyer une image à partir de votre disque",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Vignette (optionnel, annule et remplace la génération automatique de vignettes)",
"Note: Maximum image size is limited to" => "Remarque : la taille maximum de l'image est limitée à",
"User assigned modules" => "Modules utilisateur",
"User Assigned Modules" => "Modules utilisateur assignés",
"User Assigned Modules tpl" => "gabarit des modules utilisateur assignés",
"Assign module" => "Attribuer un module",
"Column" => "Colonne",
"User Bookmarks tpl" => "gabarit des signets utilisateur",
"Current folder" => "Répertoire courant",
"Folders" => "Répertoires",
"Folder in" => "Aller dans le répertoire",
"Remove Folder" => "Supprimer le répertoire",
"Refresh Cache" => "Réactualiser l'antémémoire",
"Admin folders and bookmarks" => "Administrer les répertoires et les signets",
"User Contacts Preferences" => "Préférences sur mes contacts",
"Edit User Contacts Preferences" => "Modifier les préférences contacts utilisateur",
"Manage Fields" => "Gérer les champs",
"Default view" => "Vue par défaut",
"Send me a message" => "Envoyez-moi un message",
"Gender" => "Sexe",
"Homepage" => "Page d'accueil",
"Users HomePage" => "Page d'accueil des utilisateurs",
"Personal Wiki Page" => "Page Wiki personnelle",
"Create page" => "Créer une page",
"This user is your friend" => "Cet utilisateur est votre ami",
"Request friendship from this user" => "Proposer de devenir ami avec cet utilisateur",
"Forum comments" => "Commentaires de forum",
"Toggle options" => "Afficher/cacher les sous menus",
"Toggle" => "Afficher/cacher",
"UserPreferences tpl" => "gabarit des préférences utilisateur",
"Personal Information" => "Informations personnelles",
"Use Google Map locator" => "Utiliser le localisateur de carte google",
"Your personal Wiki Page" => "Page Wiki personnelle",
"Your personal tracker information" => "Votre formulaire d'informations personnelles",
"View extra information" => "Voir les informations supplémentaires",
"Is email public? (uses scrambling to prevent spam)" => "Brouiller l'adresse électronique pour éviter le spam",
"Unavailable - please set your e-mail below" => "Indisponible - donnez votre adresse électronique ci-dessous SVP",
"My level" => "Mon niveau",
"Account Information" => "Informations sur le compte",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Laisser les champs \"Nouveau mot de passe\" et \"Confirmer le nouveau mot de passe\" vides pour garder le mot de passe courant",
"Email address" => "Adresse électronique",
"Confirm new password" => "Confirmer le nouveau mot de passe",
"Current password (required)" => "Mot de passe courant (obligatoire)",
"Change administrative info" => "Changer les informations sur le compte",
"User Tasks tpl" => "Gabarit des tâches utilisateurs",
"New task" => "Nouvelle tâche",
"Task list" => "Liste des tâches",
"Admin mode off" => "Mode admin off",
"Admin mode on" => "Mode admin on",
"Task help" => "Aide (Tâches)",
"Empty Trash" => "Vider la corbeille",
"Received task" => "Tâches reçues",
"You received this task, please read and execute it" => "Vous avez reçu cette tâche. SVP, lisez la et faites la",
"Send task" => "Envoyer une tâche",
"You send this task to a other user" => "Vous envoyez cette tâche à un autre utilisateur",
"Shared task" => "Tâche partagée",
"This task is public to a special group" => "Cette tâche est commune pour un groupe défini",
"Accepted by Task User and Creator" => "Accepté par l'utilisateur et le créateur de la tâche",
"Accepted User and Creator" => "Accepté par l'utilisateur et le créateur",
"Task is accepted by user and creator" => "Tâche acceptée par l'utilisateur et créateur",
"Not Accepted by One User" => "Non accepté par un utilisateur",
"Not Accepted User" => "Non accepté par utilisateur",
"Task is rejected by one user" => "Tâche refusée par un utilisateur",
"Waiting for Me" => "En attente de mon acceptation",
"Task is not accepted by you, read the task and accept or reject it" => "Vous n'avez pas accepté cette tâche pour l'instant, lisez son contenu et acceptez-la ou refusez-la",
"Waiting for Other User" => "En attente d'autres utilisateurs",
"Task is not accepted/rejected by other user" => "Cette tâche est en attente de refus/acceptation par d'autres utilisateurs",
"Admin Mode" => "Mode administration",
"Edit task" => "Modifier une tâche",
"Red" => "Rouge",
"NOT accept" => "NON accepté",
"Remove from Trash" => "Retirer de la corbeille",
"Move into Trash" => "Mettre dans la corbeille",
"Task saved" => "Tâche sauvegardée",
"Edit Task" => "Modifier une tâche",
"View Task" => "Afficher une tâche",
"Open a new task" => "Ouvrir une nouvelle tâche",
"Task user" => "Utilisateur de la tâche",
"Only the creator can delete this task" => "Seul son créateur peut effacer cette tâche",
"Use start date and time" => "Utiliser date et temps de départ",
"Use end date and time" => "Utiliser date et temps de fin",
"Open / In Process" => "Ouvert / en cours",
"Waiting / Not Started" => "En attente / non démarrée",
"Percentage completed" => "Pourcentage accompli",
"Waiting" => "En attente",
"Shared for Group" => "Partagé par le groupe",
"Accepted by User" => "Accepté par l'utilisateur",
"No / Rejected" => "Non / refusé",
"Accepted by Creator" => "Accepté par le créateur",
"This message will be send to users if you are makeing changes of assigned tasks" => "Ce message va être envoyé aux utilisateurs si vous faites des changements aux tâches attribuées",
"Send message with changes" => "Envoyer un message avec les changements",
"Modified by" => "Modifié par",
"Marked as deleted" => "Marqué comme détruit",
"Inform task user by email" => "Informer l'utilisateur de la tâche par email",
"You can only view this task" => "Vous ne pouvez voir que cette tâche",
"%m/%d/%Y [%H:%M]" => "%d/%m/%Y [%H:%M]",
"No tasks entered" => "Aucune tâche entrée",
"Select One" => "Choisir parmi",
"Undo Trash" => "Retirer de la corbeille",
"Show:" => "Montrer :",
"Received" => "Reçu",
"Submitted" => "Soumis",
"Shared" => "Partagé",
"All Shared Tasks" => "Toutes les tâches partagées",
"completed (100%)" => "fini (100%)",
"Public for group" => "Publique pour le groupe",
"User Watches tpl" => "Gabarit de notification de changement utilisateur",
"Add Watch" => "Ajouter une notification",
"A user submits a blog post" => "Nouvel article de blogue",
"A user posts a forum thread" => "Nouveau message dans fil discussion",
"A user posts a forum topic" => "Nouveau sujet forum",
"A user edited a wiki page" => "Page wiki modifiée",
"Add watch" => "Ajouter une notification",
"Used space:" => "Volume utilisé :",
"up to" => "sur",
"no limit for admin" => "aucune limite pour l'administrateur",
"May need to refresh twice to see changes" => "Vous devrez peut-être réactualiser 2 fois pour voir les modifications",
"Add top level bookmarks to menu" => "Ajouter les signets du niveau supérieur au menu utilisateur",
"replace window" => "remplacer la fenêtre (w)",
"User_versions_for" => "Versions pour",
"Insert Row" => "Ajouter une ligne",
"Insert Column" => "Ajouter une colonne",
"Remove Row" => "Supprimer une ligne",
"Remove Column" => "Supprimer une colonne",
"Merge Cells" => "Fusionner des cellules",
"Restore Cells" => "Restaurer les cellules",
"Copy Calculation" => "Copier la formule",
"Format Cell" => "Formater une cellule",
"Before" => "Devant",
"After" => "Après",
"expires:" => "expire :",
"No articles." => "Pas d'articles.",
"Banner stats" => "Statistiques de la bannière",
"Create new banner" => "Créer une nouvelle bannière",
"Banner Information" => "Information sur la bannière",
"Click ratio" => "Proportion de clics",
"Weekdays" => "Jours de semaines",
"mon" => "lun",
"tue" => "mar",
"wed" => "mer",
"thu" => "jeu",
"fri" => "ven",
"sat" => "sam",
"sun" => "dim",
"Banner raw data" => "Données brutes de la bannière",
"This is a cached version of the page." => "Cette version de la page est dans l'antémémoire.",
"Click here to view the Google cache of the page instead." => "Cliquer ici pour voir à la place le cache Google de la page.",
"Edit Items" => "Modifier un item",
"List Charts" => "Liste des palmarès",
"Last Chart" => "Dernier palmarès",
"Previous Chart" => "Palmarès précédent",
"Chart created" => "Palmarès créé",
"Next Chart" => "Palmarès suivant",
"Pre" => "Pré",
"Permanency" => "Stabilité",
"Avg" => "Moy.",
"Next chart will be generated on" => "Le prochain palmarès sera généré le",
"View or vote items not listed in the chart" => "Afficher ou voter pour des items non listés dans le palmarès",
"Select something to vote on" => "Sélectionner pour pouvoir voter",
"Item information" => "Information sur l'item",
"Best Position" => "Meilleure position",
"Vote this item" => "Voter pour cet item",
"Highest" => "Maxi",
"View FAQ Tpl" => "Gabarit de l'affichage des FAQs",
"Admin Menus tpl" => "Gabarit de l'administration des menus",
"There are no questions in this FAQ." => "Il n'y a pas de questions dans cette galerie.",
"Answers" => "Réponses",
"A" => "R",
"Add Suggestion" => "Ajouter une suggestion",
"Forum List" => "Liste des forums",
"Edit Forum" => "Modifier ce forum",
"Manage Message Queue" => "Gèrer la file d'attente de messages",
"Manage Reported Messages" => "Gérer les messages dénoncés",
"Monitor Topics of this Forum" => "Surveiller les fils de discussions de ce forum",
"Stop Monitoring Topics of this Forum" => "Arrêter de surveiller les fils de discussion de ce forum",
"Monitor Topics and Threads of this Forum" => "Surveiller les fils de discussions et les articles de ce forum",
"Stop Monitoring Topics and Threads of this Forum" => "Arrêter de surveiller les fils de discussions et les articles de ce forum",
"You have {\$unread} unread private messages" => "Vous avez {\$unread} messages privés non lus",
"Your message has been queued for approval, the message will be posted after a moderator approves it." => "Votre message a été mis en attente de validation. Il sera affiché après validation par le modérateur.",
"You have to enter a title and text" => "Vous devez saisir un titre et du texte",
"Another post with the same title and content already exists." => "une autre publication avec les mêmes titre et contenu existe déjà.",
"Please change your title or content then click Post." => "Veuillez changer le titre ou le contenu avant de publier à nouveau.",
"Summary" => "Résumé",
"Watch for replies" => "Surveiller les réponses",
"Send me an e-mail when someone replies to my topic" => "M'envoyer un email lorsqu'une modification est faite à mon sujet",
"Don't send me any e-mails" => "Ne pas m'envoyer de mails",
"Editing posts" => "Edition des articles",
"Moderator Actions" => "Actions du modérateur",
"Move Selected Topics" => "Déplacer les sujets sélectionnés",
"Unlock Selected Topics" => "Déverrouiller les sujets sélectionnés",
"Lock Selected Topics" => "Verrouiller les sujets sélectionnés",
"Delete Selected Topics" => "Effacer les sujets sélectionnés",
"Merge" => "Fusionner",
"Merge Selected Topics" => "Fusionner les sujets sélectionnés",
"Reported Messages:" => "Messages émis :",
"Queued Messages:" => "Messages en attente :",
"Merge into topic" => "Fusionner dans le sujet",
"Emot" => "émot",
"Announce" => "Annonce",
"Hot" => "Populaire",
"Sticky" => "Captivant",
"Unarchive" => "Par archivé",
"No topics yet" => "Aucun sujet pour l'instant",
"posts in this forum" => "articles dans ce forum",
"Show posts" => "Afficher les articles",
"Last hour" => "De la dernière heure",
"Last 24 hours" => "Des dernières 24h",
"Last 48 hours" => "Des dernières 48h",
"Show archived posts" => "Afficher les messages archivés",
"Jump to forum" => "Aller dans le forum",
"Archived" => "Archivé",
" unread private messages" => " messages privés non lus",
"The post has been reported and will be reviewed by a moderator." => "La publication a été signalé à un modérateur et va être revue.",
"prev topic" => "sujet préc.",
"next topic" => "sujet suivant",
"Print this page only" => "Imprimer cette page seulement",
"Print all pages" => "imprimer toutes les pages",
"IRC log" => "log IRC",
"Show All" => "Afficher tout",
"Stop Monitor" => "Arrêter la surveillance",
"Insert New Item" => "Insérer une nouvelle fiche",
"Edit Fields" => "Modifier les champs",
"Tracker Items for" => "liste des fiches de",
"View inserted item" => "Voir la fiche insérée",
"Tracker Item:" => "Fiche du formulaire :",
"Edit/Delete" => "Modifier/Supprimer",
"View Item" => "Voir la fiche",
"Filter Tracker Items" => "Filtrer les fiches du formulaire",
"Add a Comment" => "Ajouter un commentaire",
"Items list" => "Liste de fiches",
"Remove Image" => "Supprimer l'image",
"Special Operations" => "Opération spéciales",
"fields marked with a * are mandatory" => "les champs marqués par une * sont obligatoires",
"Edit mail account" => "Modifier le compte mail",
"Add new mail account" => "Ajouter un nouveau compte email géré par ce Webmail",
"User accounts" => "Comptes utilisateur",
"View All" => "Afficher tout",
"Clip" => "clip",
"Back To Mailbox" => "retourner à la boîte à lettre",
"Full Headers" => "en-têtes complets",
"Normal Headers" => "en-têtes normaux",
"Reply To All" => "répondre à tous",
"Forward" => "transférer",
"Select from address book" => "sélectionner du carnet d'adresses",
"Use HTML mail" => "Utiliser HTML pour le mail",
"The following addresses are not in your address book" => "Les adresses suivantes ne sont pas dans votre carnet d'adresses",
"Add Contacts" => "Ajouter des contacts",
"Attachment 1" => "Fichier joint 1",
"Attachment 2" => "Fichier joint 2",
"Attachment 3" => "Fichier joint 3",
"Address book" => "Carnet d'adresses",
"Word Limit Exceeded" => "Nombre maximum de mots atteint",
"Word Count:" => "Nombre de mots :",
"Number of voices" => "nombre de voies",
"You have ever subscribed" => "Vous êtes déjà inscrit",
"You have not yet subscribed" => "Vous n'êtes pas inscrit",
"friends" => "amis",
"Unsubscribe" => "Se désabonner",
"Google Maps is not enabled." => "Google Maps n'est pas activée.",
"Use this thread to discuss the page:" => "Utilisez ce fil de discussion pour discuter sur la page:",
"Missing or incorrect trackerId parameter for the plugin." => "Paramètre incorrect ou manquant pour le plugin.",
"Subscribe to a group" => "S'inscrire dans un groupe",
"Show Filters" => "Afficher les filtres",
"Toggle display" => "Afficher/cacher l'affichage",
"Start:" => "Début :",
"Close:" => "Fermer :",
"as Creator &amp; Last Editor" => "comme créateur &amp; dernier éditeur",
"Business style" => "Style affaire",
"Collaborative style" => "Style collaboratif",
"no (disabled)" => "non (désactivé)",
"Save the page as a partial translation." => "Enregistrer la page comme une traduction partielle.",
"Partial Translation" => "Traduction partielle",
"Save the page as a completed translation." => "Enregistrer la page comme une traduction complète.",
"Save the page, but do not send notifications and do not count it as new content to be translated." => "Enregistrer la page sans envoi de notification par courrier. Ne pas enregistrer le contenu comme à être traduit",
"Minor Edit" => "Modif. mineure",
"Save the page as a draft." => "Enregistrer la page comme brouillon.",
"Save Draft" => "Enregistrer brouillon",
"If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Si vous souhaitez que les autres utilisateurs puissent vous répondre, vous devez vérifier que vous avez sélectionné <a href='tiki-user_preferences.php'>Autoriser des messages d'autres utilisateurs</a>",
"Permission denied you cannot view the Tiki calendar" => "Droit d'accès refusé : vous ne pouvez pas voir le calendrier Tiki",
"Help on Configuration Sections" => "Aide sur les différentes sections de configuration",
"%s enabled" => "Fonctionnalité activée : %s",
"%s disabled" => "Fonctionnalité désactivée : %s",
"Enable/disable Tiki features here, but configure them elsewhere" => "Activez/désactivez les fonctionnalités Tiki ici, mais configurez dans leur page d'administration associée",
"General preferences and settings" => "Préférences et configuration générales",
"User registration, login and authentication" => "Inscription utilisateur, connexion et authentification",
"Wiki settings" => "Configuration Wiki",
"Wiki Attachments" => "Fichiers joints Wiki",
"Article/CMS settings" => "Configuration des articles/CMS",
"Poll comments settings" => "Configuration des commentaires de sondages",
"Configuration options for all blogs on your site" => "Options de configuration pour tous les blogues de votre site",
"Forums settings" => "Configuration des forums",
"FAQ comments settings" => "Configuration des commentaires de FAQ",
"Trackers settings" => "Configuration des formulaires",
"RSS settings" => "Configuration RSS",
"Directory settings" => "Configuration du répertoire des liens",
"Maps configuration" => "Configuration des cartes",
"Meta Tags settings" => "Configuration des Méta balises",
"Search settings" => "Configuration de la recherche",
"Score settings" => "Configurations des scores",
"Community settings" => "Configuration de la communauté",
"Calendar settings" => "Configuration des calendriers",
"Intertiki settings" => "Configuration Intertiki",
"Freetags settings" => "Configuration de la folksonomie(freetags)",
"Help on \$admintitle Config" => "Aide sur la configuration de : \$admintitle",
"Must specify actionId" => "actionId doit être spécifié",
"Users Contributions: Addition" => "Contributions utilisateur: Ajouts",
"%s Contributions: Addition" => "%s Contributions: Ajouts",
"Users Contributions: Suppression" => "Contributions utilisateur: Suppressions",
"%s Contributions: Suppression" => "%s Contributions: Suppressions",
"Total Contributions Addition per Day" => "Total des contributions Ajouts par jour",
"Total Contributions Addition per Week" => "Total des contributions Ajouts par semaine",
"Total Contributions Suppression per Day" => "Total des contributions Suppressions par jour",
"Total Contributions Suppression per Week" => "Total des contributions Suppressions par semaine",
"Total Contributions: Addition" => "Total des contributions: Ajouts",
"Total Contributions: Suppression" => "Total des contributions: Suppressions",
"Groups Contributions: Addition" => "Contributions des groupes: Ajouts",
"Groups Contributions: Suppression" => "Contributions des groupes: Suppressions",
"white" => "blanc",
"gray" => "gris",
"silver" => "argenté",
"ivory" => "ivoire",
"whitesmoke" => "blanc fumée",
"darkgrey" => "gris fonçé",
"Click here to delete the category:" => "Cliquez ici pour supprimer la catégorie :",
"You can not create a category with a name already existing at this level" => "Vous ne pouvez pas créer une catégorie avec un nom existant déjà à ce niveau",
"Category can`t be parent of itself" => "Une catégorie ne peut pas être parente d'elle-même",
"No chart indicated" => "Aucun palmarès indiqué",
"Upload failed" => "Échec de l'envoi",
"You have to provide a hotword and a URL" => "Vous devez fournir un mot/lien automatique ou une adresse Web",
"moved %d images, %d errors occured." => "%d images déplacées, %d erreurs trouvées.",
"a timeout occured. Hit the reload button to move the rest" => "un timeout est arrivé. Pressez le bouton recherger pour déplacer le reste",
"Detected, Version:" => "Trouvé. Version :",
"Not detected." => "Pas trouvé.",
"You cannot have a blank password" => "Vous ne pouvez pas avoir un mot de passe vide",
"Your admin password has been changed" => "Votre mot de passe administrateur a été changé",
"All Fields except gdaltindex must be filled" => "Tous les champs sauf gdaltindex doivent être remplis",
"No valid gdaltindex executable" => "Aucun exécutable gdaltindex valide",
"You cannot mix old and new trackers" => "Vous ne pouvez pas mélanger les anciens et les nouveaux formulaires",
"Tag already exists" => "Le marqueur existe déjà",
"Tag not found" => "Aucun marqueur trouvé",
"Repository name can't be an empty" => "Un nom de répertoire ne peut pas être vide",
"Requested action is not supported on repository" => "L'action demandée n'est pas supportée sur le répertoire",
"No repository" => "Aucun répertoire indiqué",
"Search is mandatory field" => "Le champ Recherche est obligatoire",
"File not found " => "Fichier non trouvé",
"Requested action in not supported on repository" => "L'action demandée n'est pas supportée dans ce répertoire",
"Non-existent link" => "Lien inexistant",
"Mail-in account %s incorrect" => "Compte mail-in %s incorrect",
"Mail-in account %s saved" => "Compte mail-in %s sauvegardé",
"Frequency should be a positive integer!" => "La fréquence doit être un entier positif!",
"Mail-in accounts set to be checked every %s minutes" => "Les comptes mail-in sont synchronisés toutes les %s minutes",
"Automatic Mail-in accounts checking disabled" => "Les comptes mail-in ne sont pas synchronisés automatiquement",
"No menu indicated" => "Aucun menu indiqué",
"Cannot create or update module: You need to specify a name to the module" => "Impossible de créer ou de mettre à jour le module : vous devez spécifier le nom du module",
"Cannot create or update module: You cannot leave the data field empty" => "Impossible de créer ou de mettre à jour le module : vous ne pouvez pas laisser le champ de données vide",
"No newsletter indicated" => "Aucune newsletter indiquée",
"Error opening uploaded file" => "Erreur lors de l'ouverture du fichier envoyé",
"Invalid email" => "Adresse électronique invalide",
"You need to provide a username or an email" => "Vous devez donner un nom d'utilisateur ou une adresse électronique",
"No poll indicated" => "Aucun sondage indiqué",
"Insert" => "Insérer",
"Icon" => "Icône",
"unsafe" => "dangereux",
"register_globals should be off by default. See the php manual for details." => "register_globals doit être off par défaut. Voir le manuel php pour les détails.",
"safe" => "sans danger",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid doit être off par défaut. Voir le manuel php pour les détails.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir est probablement dans votre répertoire Tikiwiki. C'est un risque car quelqu'un peut envoyer un fichier dans ce répertoire puis y accéder par le Web",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "ne peut pas vérifier que upload_tmp_dir est accessible par le web. Vous devez contrôler la configuration de votre serveur Web",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "mettre l'option xbithack est dangereux. Selon la façon dont votre serveur Web gère les fichiers et votre configuration Tikiwiki, il est possible d'attaquer en envoyant des scripts dans les galeries de fichiers et de les exécuter",
"risky" => "risqué",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen peut être utilisé pour envoyer des données ou scripts sur le serveur. Si vous n'utilisez pas les blogues, vous pouvez le désactiver.",
"The Path to store files in the filegallery should be outside the tiki root directory" => "Le chemin de sauvegarde des fichiers des galeries de fichiers doit être hors du répertoire Tikiwiki",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "Le chemin de sauvegarde des fichiers des galeries d'images doit être hors du répertoire Tikiwiki",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "La fonctionnalité \"Modifier les gabarits\" est activée. Ne laisser personne de peu fiable utiliser cette fonctionnalité. Il est facile d'injecter du code php.",
"installed" => "installé",
"The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "Le plugin \"Snarf\" est installé. Il peut être utilisé par les éditeurs Wiki pour inclure des pages du réseau local et via le remplacement regexp créer n'importe quel page html.",
"The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "Le plugin \"Regex\" est installé. Il peut être utilisé par les éditeurs Wiki pour créer n'importe quel html avec le remplacement regex",
"The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "Le plugin Wiki \"Lsdir\" est installé. Il peut révéler aux éditeurs Wiki le contenu de tout répertoire.",
"The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "Le plugin Wiki \"Bloglist\" est installé. Il peut révéler aux éditeurs Wiki des publications privées de blogue.",
"Path disclosure" => "Faille Path disclosure",
"Path disclosure through error message" => "Faille Path disclosure au travers d'un message d'erreur",
"SQL injection" => "Injection SQL",
"SQL injection by authenticated user" => "Injection SQL par un utilisateur authentifié",
"SQL injection by authenticated user with special privileges" => "Injection SQL par un utilisateur authentifié avec des privilèges spéciaux",
"SQL injection without authentication" => "Injection SQL sans authentification",
"PHP command injection" => "Injection de commande PHP",
"PHP command injection by authenticated user" => "Injection de commande PHP par un utilisateur authentifié",
"PHP command injection by authenticated user with special privileges" => "Injection de commande PHPpar un utilisateur authentifié avec des privilèges spéciaux",
"PHP command injection without authentication" => "Injection de commande PHP sans authentification",
"File upload" => "Envoi de fichier",
"File is not readable. Unable to check." => "Fichier sans droit de lecture. Impossible de vérifier.",
"This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "Ceci n'est pas un fichier Tikiwiki. Contrôlez si ce fichier a été envoyé par un tiers et si il est dangereux.",
"This is a modified File. Cannot check version. Check if it is dangerous." => "C'est un fichier modifié. Impossible de vérifier la version. Vérifiez si c'est dangereux",
"This file is from another Tikiwiki version: " => "Ce fichier est d'une autre version de Tikiwiki",
"You have to provide a word" => "Vous devez indiquer un mot",
"Permission denied you cannot view this page" => "Droit d'accès refusé : vous ne pouvez afficher cette page",
"Permission denied you cannot edit this page" => "Droit d'accès refusé : vous ne pouvez pas modifier cette page",
"You must specify a page name, it will be created if it doesn't exist." => "Vous devez donner un nom de page, la page sera créée si elle n'existe pas.",
"page not added (Exists)" => "page non ajoutée (Existe)",
"No survey indicated" => "Aucune enquête indiquée",
"You don't have permission to use this feature" => "Vous n'avez pas le droit d'utiliser cette fonctionnalité",
"No Errors detected" => "Aucune erreur détectée",
"No tracker indicated" => "Aucun formulaire indiqué",
"Remove group: " => "Supprimer le groupe : ",
"Remove permission: %s on %s" => "Retirer la permission: %s suron %s",
"Group already exists" => "Ce groupe existe déjà",
"User doesn't exist" => "Cet utilisateur n'existe pas",
"No records were found. Check the file please!" => "Pas d'entrée trouvée. Vérifier le fichier SVP!",
"User login is required" => "Nom utilisateur obligatoire",
"Password is required" => "Mot de passe obligatoire",
"Email is required" => "Adresse électronique obligatoire",
"User is duplicated" => "L'utilisateur est dupliqué",
"Created account %s <%s>" => "Compte créé %s <%s>",
"Assigned %s in group %s" => "Mettre %s dans le groupe %s",
"User %s already exists" => "L'utilisateur %s existe déjà",
"User login contains invalid characters" => "Le nom utilisateur contient des caractères invalides",
"New %s created with %s %s." => "Un nouveau %s a été créé avec le %s %s.",
"Impossible to create new %s with %s %s." => "Impossible de créer un nouveau %s avec %s %s.",
"%s %s successfully deleted." => "%s %s détruit avec succès.",
"%s %s removed from %s %s." => "%s %s supprimé de %s %s.",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> détruit avec succès.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> mis dans le groupe %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> supprimé du groupe %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "le groupe <b>%s</b> est affecté comme groupe par défaut pour l'utilisateur <b>%s</b>.",
"%s modified successfully." => "%s modifié avec succès.",
"password" => "mot de passe",
"%s modification failed." => "la modification de %s modification a échoué.",
"%s changed from %s to %s" => "%s changé de %s en %s",
"Impossible to change %s from %s to %s" => "Impossible de changer %s de %s à %s",
"Login contains invalid characters" => "Le nom utilisateur contient des caractères invalides",
"approved by " => "approuvé par ",
"rss feed disabled" => "alimentation rss désactivée",
"Permission denied you cannot view this section" => "Droit d'accès refusé : vous ne pouvez pas afficher cette section",
"Tiki RSS feed for articles" => "Canal de syndication RSS Tiki pour les articles",
"Last articles." => "Derniers articles.",
"Unassign perm %s from group %s" => "Désattribuerle droit %s au groupe %s",
"Unknown group" => "Groupe inconnu",
"Group doesn't exist" => "Ce groupe n'existe pas",
"You have to indicate a group" => "Vous devez indiquer un groupe",
"This group is invalid" => "Ce groupe est invalide",
"Permission denied you cannot view backlinks for this page" => "Droit d'accès refusé : vous ne pouvez pas afficher les pages pointant cette page",
"The page cannot be found" => "Cette page n'a pu être trouvée",
"Image Galleries Admin Panel" => "Panneau d'administration des galeries d'images",
"Could not read image %s." => "Ne peut pas lire l'image %s.",
"Image %s upload failed." => "Echec de l'envoi de l'image %s.",
"Image %s uploaded successfully." => "Image %s envoyée avec succès.",
"Image %s removed from Batch directory." => "Image %s supprimée du répertoire de téléchargement par lot.",
"Impossible to remove image %s from Batch directory." => "Impossible de supprimer l'image %s du répertoire Batch.",
"Permission denied you cannot use the batch directory loading" => "Droit d'accès refusé: vous ne pouvez pas utiliser le répertoire de téléchargement par lot",
"Incorrect directory chosen for batch upload of images." => "Répertoire invalide choisi pour l'envoi des images par lot.",
"Please setup that dir on " => "SVP, positionner ce répertoire sur ",
"Please contact the website administrator." => "SVP, contacter l'administrateur du site.",
"Invalid directory name" => "Nom de répertoire invalide",
"File Galleries Admin Panel" => "Panneau d'administration des galeries de fichiers",
"Could not read file %s." => "Impossible de lire le fichier %s.",
"Could not write to file %s." => "Impossible d'écrire le fichier %s.",
"File %s upload failed." => "L'envoi du fichier %s a échoué.",
"Upload was successful" => "Envoi réussi",
"File %s removed from Batch directory." => "Fichier %s détruit du répertoire de téléchargement par lot.",
"Impossible to remove file %s from Batch directory." => "Impossible de détruire le fichier %s du répertoire de téléchargement par lot.",
"Incorrect directory chosen for batch upload of files." => "Répertoire invalide choisi pour le téléchargement par lot de fichiers.",
"Permission denied you cannot post" => "Droit d'accès refusé : vous ne pouvez pas publier d'articles",
"Permission denied you cannot edit this post" => "Droit d'accès refusé : vous ne pouvez modifier cet article",
"You can't post in any blog maybe you have to create a blog first" => "Vous ne pouvez publier d'articles dans aucun blogue : peut-être devez-vous en créer un",
"Top visited blogs" => "Blogues les plus visités",
"Last posts" => "Derniers articles de blogue",
"Top active blogs" => "Blogues les plus actifs",
"Tiki RSS feed for blog: " => "Canal de syndication RSS Tiki pour le blogue : ",
"No blogId specified" => "Aucun Id de blogue spécifié",
"Tiki RSS feed for weblogs" => "Canal de syndication RSS Tiki pour les blogues",
"Last posts to weblogs." => "Derniers articles des blogues.",
"Nothing tagged yet" => "Aucun tag pour le moment",
"You must clear your browser cache." => "Il faut vider le cache de votre navigateur.",
"Permission denied you cannot access this gallery" => "Droit d'accès refusé : vous ne pouvez pas accéder à cette galerie",
"No gallery indicated" => "Aucune galerie indiquée",
"Permission denied you can not view this section" => "Droit d'accès refusé : vous ne pouvez pas afficher cette section",
"Permission denied you cannot remove images from this gallery" => "Droit d'accès refusé : vous ne pouvez pas supprimer d'images de cette galerie",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Droit d'accès refusé : vous ne pouvez pas reconstruire les vignettes dans cette galerie",
"Permission denied you cannot rotate images in this gallery" => "Droit d'accès refusé : vous ne pouvez pas pivoter les images dans cette galerie",
"No image indicated" => "Aucune image indiquée",
"Permission denied you cannot move images from this gallery" => "Droit d'accès refusé : vous ne pouvez pas déplacer d'images de cette galerie",
"Permission denied you cannot view the calendar" => "Droit d'accès refusé : vous ne pouvez pas voir le calendrier",
"event without name" => "évènement sans nom",
"Permission denied you can not view this page" => "Droit d'accès refusé. Vous ne pouvez pas voir cette page.",
"Access Denied" => "Accès refusé",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "1",
"%m/%d" => "%d/%m",
"%H:%M %Z" => "%Hh%M",
"Tiki RSS feed for calendars" => "Canaux de syndication RSS Tiki pour les calendriers",
"Upcoming events." => "Évènements à venir.",
"End:" => "Fin :",
"No category indicated" => "Aucune catégorie indiquée",
"Permission denied; you cannot assign permissions for this category" => "Droit d'accès refusé : vous n'avez pas les droits d'attribuer cette catégorie",
"Invalid username or activation code. Maybe this code has already been used." => "Nom utilisateur ou code d'activation invalide. Peut être ce code est déjà utilisé.",
"You can not use the same password again" => "Vous ne pouvez pas réutiliser le même mot de passe à nouveau",
"Top authors" => "Auteurs les plus actifs",
"Problem. Try to log in again to receive new confirmation instructions." => "Problème. Essayez de vour connecter encore pour recevoir les instructions de confirmation.",
"ERROR: you must include a subject or a message at least" => "ERREUR : vous devez inclure au moins un sujet ou un message",
"You need to change chmod 'whelp' manually to 777" => "Vous devez faire manuellement un chmod 777 sur 'whelp'",
"This feature has been disabled" => "Cette fonctionnalité a été désactivée",
"Tiki RSS feed for directory sites" => "Canal de syndication RSS Tiki pour les sites des répertoires",
"Last sites." => "Derniers sites.",
"Must enter a name to add a site. " => "Vous devez donner un nom pour ajouter un site. ",
"Must enter a url to add a site. " => "Vous devez entrer une adresse Web pour ajouter un site. ",
"URL already added to the directory. Duplicate site? " => "Adresse Web déjà présente dans le répertoire. Enregistrer un doublon ? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "L'adresse Web ne peut pas être accédée : mauvaise adresse Web ou site déconnecté. L'adresse Web ne peut pas être ajoutée au répertoire. ",
"Must select a category. " => "Vous devez choisir une catégorie. ",
"Must enter a name to add a site" => "Vous devez donner un nom pour ajouter un site",
"Must enter a url to add a site" => "Vous devez entrer une adresse Web pour ajouter un site",
"URL already added to the directory. Duplicate site?" => "Adresse Web déjà présente dans le répertoire. Enregistrer un doublon ?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "L'URL ne peut pas être accédé (mauvaise URL ou site offline) : l'URL ne peut pas être ajoutée au répertoire",
"Must select a category" => "Vous devez choisir une catégorie",
"No site indicated" => "Aucun site indiqué",
"No parent specified" => "aucun parent spécifié",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Derniers sites du répertoire \".\$rc[\"name\"].\" .",
"You can not download files" => "Vous ne pouvez pas télécharger de fichiers",
"Error : The file %s doesn't exist." => "Erreur : Le fichier %s n'existe pas.",
"Invalid email:" => "Adresse électronique invalide :",
"Article not found" => "Article introuvable",
"Permission denied you cannot edit this article" => "Droit d'accès refusé : vous ne pouvez modifier cet article",
"The language can't be changed as its set of translations has already this language" => "La langue ne peut pas être changée parce qu'il y a déjà cette langue dans le jeu de traductions",
"You do not have permissions to edit banners" => "Droit d'accès refusé : vous ne pouvez modifier les bannières",
"Banner not found" => "Page d'ouverture introuvable",
"You do not have permission to edit this banner" => "Droit d'accès refusé : vous ne pouvez modifier cette bannière",
"Permission denied you cannot create or edit blogs" => "Droit d'accès refusé : vous ne pouvez créer/modifier de blogues",
"Permission denied you cannot edit this blog" => "Droit d'accès refusé : vous ne pouvez modifier ce blogue",
"You do not have permission to write the style sheet" => "Vous n'avez pas la permission d'écrire la feuille de style",
"Invalid request to edit an image" => "Demande de modification d'image invalide",
"Permission denied you cannot edit images" => "Droit d'accès refusé : vous ne pouvez modifier les images",
"Permission denied you can edit images but not in this gallery" => "Droit d'accès refusé : vous pouvez modifier des images mais pas dans cette galerie",
"Failed to edit the image" => "Échec de la modification de l'image",
"Permission denied to use this feature" => "Droit d'accès refusé : vous ne pouvez pas utiliser cette fonctionnalité",
"Shortname must be 2 Characters" => "Un diminutif doit avoir 2 caractères",
"You must provide a longname" => "Vous devez donner un nom long",
"Language created" => "Langue créée",
"No content id indicated" => "Aucun ID de contenu indiqué",
"No question indicated" => "Aucune question indiquée",
"No quiz indicated" => "Aucun QCM indiqué",
"No structure indicated" => "Aucune structure indiquée",
"Invalid structure_id or page_ref_id" => "Structure_id ou page_ref_id invalide",
"Permission denied you cannot send submissions" => "Droit d'accès refusé : vous ne pouvez publier d'articles",
"Permission denied you cannot edit submissions" => "Droit d'accès refusé : vous ne pouvez modifier les articles publiés",
"You have to create a topic first" => "Vous devez créer un sujet d'abord",
"You do not have permission to do that" => "Vous n'avez pas les droits d'accès pour faire cela",
"You do not have permission to write the template:" => "Droit d'accès refusé : vous n'avez pas droit d'écrire le gabarit",
"You do not have permission to read the template" => "Droit d'accès refusé : vous ne pouvez lire le gabarit",
"No topic id specified" => "Aucun id de sujet spécifié",
"Invalid topic id specified" => "Id de sujet invalide",
"Translation in progress." => "Traduction en cours.",
"No object indicated" => "Aucun objet indiqué",
"No type indicated" => "Aucun type indiqué",
"Not enable for this type of object" => "Non permis pour ce type d'objet",
"Override lock and carry on with edit" => "Outrepasser le verrou et continuer en mode édition",
"Page is currently being edited" => "La page est en cours d'édition",
"page imported" => "page importée",
"created from import" => "créé de l'importation",
"This page is being edited by " => "Cette page est en cours de modification par ",
"Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Veuillez consulter cet utilisateur avant d'éditer la page,\n\t\t\tsinon les modifications seront sauvegardées en deux versions distinctes de l'historique et\n\t\t\tvous devrez fusionner plus tard les différences manuellement. ",
"Can't import remote HTML page" => "On ne peut pas importer une page HTML distante",
"Can't parse remote HTML page" => "On ne peut pas analyser une page HTML distante",
"The SandBox is disabled" => "Le bac à sable est désactivé",
"Cannot edit page because it is locked" => "Cette page ne peut être modifiée : elle est verrouillée",
"Page already exists. Go back and choose a different name." => "La page existe déjà. Revenez en arriêre et choisissez un nom différent.",
"No questions group indicated" => "Aucun groupe de questions indiqué",
"Remove archive: " => "Supprimer l'archive : ",
"Remove file gallery: " => "Supprimer la galerie de fichiers : ",
"Permission denied you cannot edit this file" => "Droit d'accès refusé : vous ne pouvez pas modifier ce fichier",
"Permission denied you cannot remove files from this gallery" => "Droit d'accès refusé : vous ne pouvez supprimer de fichiers de cette galerie",
"Top visited file galleries" => "Galeries de fichiers les plus visitées",
"Most downloaded files" => "Fichiers les plus téléchargés",
"Last files" => "Derniers fichiers",
"Tiki RSS feed for file galleries" => "Canal de syndication RSS Tiki pour les galeries de fichiers",
"Last files uploaded to the file galleries." => "Derniers fichiers envoyés dans les galeries de fichiers.",
"No galleryId specified" => "Aucun galleryId spécifié",
"Tiki RSS feed for the file gallery: " => "Canal de syndication RSS Tiki pour la galerie de fichiers : ",
"Form error - no import method selected for some reason." => "Erreur de formulaire - aucune méthode d'import n'a été sélectionnée.",
"Form error - no server-side filename entered for selected import method." => "Erreur de formulaire - aucun fichier situé sur le serveur n'a été saisi pour la méthode d'import sélectionnée.",
"No forum indicated" => "Aucun forum indiqué",
"Forum posts" => "Articles de forums",
"No forumId specified" => "Aucun ID de forum indiqué",
"Tiki RSS feed for forum: " => "Canal de syndication RSS Tiki pour le forum : ",
"Tiki RSS feed for forums" => "Canal de syndication RSS Tiki pour les forums",
"Last topics in forums." => "Derniers sujets des forums.",
"Accepted friendship request from %s" => "Demande d'amitié acceptée de %s",
"Refused friendship request from %s" => "Demande d'amitié refusée de %s",
"Broke friendship with %s" => "Casser l'amitié avec %s",
"I have broken our friendship!" => "J'ai cassé notre amitié!",
"You must be logged in to use this feature" => "Vous devez vous inscrire pour utiliser cette fonctionnalité",
"Friendship request sent to %s" => "Demande d'amitié envoyé à %s",
"You're already friend of %s" => "Vous êtes déjà l'ami de %s",
"I have accepted your friendship request!" => "J'ai accepté votre demande d'amitié",
"I have refused your friendship request." => "J'ai refusé votre demande d'amitié.",
"No process indicated" => "Aucun processus indiqué",
"Role name cannot be empty" => "Le nom de rôle ne peut pas être vide",
"Activity name cannot be empty" => "Le nom de l'activité ne peut pas être vide",
"Activity name already exists" => "Le nom de l'activité existe déjà",
"indicates if the process is active. Invalid processes cant be active" => "indique si le processus est actif. Les processus invalides ne peuvent pas être actifs",
"No instance indicated" => "Aucune instance indiquée",
"No activity indicated" => "Aucune activité indiquée",
"The process name already exists" => "Le nom de processus existe déjà",
"Process already exists" => "Le processus existe déjà",
"Invalid source path" => "Chemin vers la source invalide",
"A start activity requires a name for the instance" => "Une activité initiale a besoin d'un nom d'instance",
"You cant execute this activity" => "Vous ne pouvez pas exécuter cette activité",
"You couldn't abort a instance" => "Vous ne pouvez pas interrompre une instance",
"You couldn't exception a instance" => "Vous ne pouvez pas appliquer une exception sur une instance",
"No user indicated" => "Aucun utilisateur indiqué",
"No title indicated" => "Aucun titre indiqué",
"No comment indicated" => "Aucun commentaire indiqué",
"No date indicated" => "Aucune date indiquée",
"No item indicated" => "Aucune fiche indiquée",
"first uploaded image" => "première image envoyée",
"last uploaded image" => "dernière image envoyée",
"first image" => "première image",
"last image" => "dernière image",
"random image" => "image choisie au hasard",
"Permission denied you cannot create galleries and so you cant edit them" => "Droit d'accès refusé : vous ne pouvez ni créer ni modifier de galeries",
"Permission denied you cannot edit this gallery" => "Droit d'accès refusé : vous ne pouvez modifier cette galerie",
"Permission denied you cannot remove this gallery" => "Droit d'accès refusé : vous ne pouvez supprimer cette galerie",
"Permission denied you cannot make the map of this gallery" => "Droit d'accès refusé : vous ne pouvez pas la carte de cette galerie",
"Top images" => "Images les plus populaires",
"Last images" => "Dernières images",
"Back to preferences" => "Revenir aux préférences",
"Back to item" => "Retour à l'élément",
"No valid renderer found. GD or PDFLib required." => "Aucun moteur de rendu trouvé. GD ou PDFLib nécessaire.",
"No sheet specified." => "Aucun feuillet spécifié.",
"You must select a renderer." => "Vous devez choisir un moteur de rendu",
"Invalid Series for current graphic." => "Séries invalides pour le graphique courant.",
"Tiki RSS feed for image galleries" => "Canal de syndication RSS Tiki pour les galeries d'image",
"Last images uploaded to the image galleries." => "Dernières images envoyées dans les galeries d'images.",
"Tiki RSS feed for the image gallery: " => "Canal de syndication RSS Tiki pour la galerie d'images : ",
"Only the administrator can upload language files." => "Seul l'administrateur peu tgélécharger des fichiers de langues.",
"overwriting old page" => "écrasement de la vieille page",
"updated from structured text import" => "modifié d'un import de Texte Structuré",
"page created" => "page crée",
"created from structured text import" => "créé d'un import de Texte Structuré",
"No name indicated for wiki page" => "Aucun nom indiqué pour la page Wiki",
"No repository given" => "Aucun répertoire indiqué",
"Error writing in the databse: \$query" => "Erreur à l'écriture dans la base de données : \$query",
"Permission denied you cannot view pages like this page" => "Droit d'accès refusé : vous ne pouvez pas afficher les pages similaires à celle-ci",
"Permission denied you cannot remove articles" => "Droit d'accès refusé : vous ne pouvez supprimer d'articles",
"Permission denied you cannot remove banners" => "Droit d'accès refusé : vous ne pouvez supprimer de bannière",
"Permission denied you cannot remove this blog" => "Droit d'accès refusé : vous ne pouvez supprimer ce blogue",
"Non-existent gallery" => "Galerie inexistante",
"The file is already locked by %s" => "Le fichier est déjà verrouillé par %s",
"Permission denied you can upload files but not to this file gallery" => "Droit d'accès refusé : vous pouvez envoyer des fichiers mais pas dans cette galerie",
"Warning: Empty file:" => "Attention : fichier vide :",
"Please re-upload your file" => "SVP, réenvoyer votre fichier",
"Could not upload the file" => "Ne peut pas envoyer le fichier",
"Invalid filename (using filters for filenames)" => "Nom de fichier invalide (le nom ne répond pas aux filtres)",
"Could not find the file requested" => "Fichier demandé non trouvé",
"Permission denied you can edit this file" => "Droit d'accès refusé : vous ne pouvez pas modifier ce fichier",
"Cannot read file:" => "Ne peut pas lire le fichier :",
"Cannot read the file:" => "Ne peut pas lire le fichier :",
"Upload was not successful. Duplicate file content" => "L'envoi n'a pas réussi. Un fichier de même contenu existe déjà",
"File update was successful" => "Succès de la mise à jour du fichier",
"Permission denied you can't upload files so you can't edit them" => "Droit d'accès refusé : vous ne pouvez pas envoyer de fichier et ainsi vous ne pouvez pas le modifier",
"This gallery does not exist" => "Cette galerie n'existe pas",
"The game file must have .swf or .dcr extension" => "Le jeu doit avoir une extension .swf ou .dcr",
"The thumbnail name must be" => "Le nom de la vignette doit être",
"Please supply both files" => "SVP, fournissez les 2 fichiers",
"You cannot admin blogs" => "Vous ne pouvez pas administrer les blogues",
"Permission denied you cannot remove submissions" => "Droit d'accès refusé : vous ne pouvez supprimer d'articles publiés",
"Permission denied you cannot approve submissions" => "Droit d'accès refusé : vous ne pouvez approuver les soumissions",
"Permission denied you cannot remove pages" => "Droit d'accès refusé : vous ne pouvez pas détruire de pages",
"Delete those pages:" => "Détruire ces pages :",
"You have to enable cookies to be able to login to this site" => "Vous devez authoriser les cookies si vous voulez vous connecter sur ce site",
"Unable to contact remote server." => "Incapable de contacter le serveur distant.",
"XMLRPC Error: " => "Erreur XMLRPC: ",
"Unable to create login" => "Incapable de créer un utilisateur",
"More than %d unsuccessful login attempts have been made." => "Plus de %d connexions non réussies ont été faites.",
"An email has been sent to you with the instructions to follow." => "Un courrier électronique vous a été envoyé avec les instructions à suivre.",
"Invalid password" => "Mot de passe invalide",
"Account disabled" => "Compte désactivé",
"You must use the right case for your user name" => "Vous devez respecter majuscules et minuscules pour votre nom utilisateur",
"You are not yet validated" => "Vous n'êtes pas encore validé",
"Your default nickname is already in use. A new one has to be selected." => "Votre pseudonyme est déjà utilisé. Veuillez en choisir un autre.",
"unknown action" => "action inconnue",
"Authentication method is not OpenID" => "La méthode d'authentification n'est pas OpenID",
"Account validated successfully." => "Compte validé avec succès.",
"Tiki mail-in auto-reply" => "Réponse automatique du mail-in Tiki",
"Sorry, you can't use this feature." => "Désolé, vous ne pouvez pas utiliser cette fonctionnalité.",
"invalid mapfile name" => "nom de fichier-carte invalide",
"Please create a directory named '.\$prefs['map_path'].' to hold your map files." => "SVP, créez un répertoire '.\$prefs['map_path'].' comme repositaire des fichiers cartes.",
"You do not have permissions to view the maps" => "Droit d'accès refusé : vous ne pouvez pas voir les cartes",
"Maps feature is not correctly setup : Maps path is missing." => "La fonctionnalité Cartes n'est pas correctement configurée: Le chemin d'accès Cartes est incorrect",
"mapfile name incorrect" => "nom de fichier-carte incorrect",
"This mapfile already exists" => "Le fichier-carte existe déjà",
"You do not have permission to write to the mapfile" => "Droit d'accès refusé : vous ne pouvez pas écrire le fichier-carte",
"You do not have permission to delete the mapfile" => "Droit d'accès refusé : vous ne pouvez effacer le fichier-carte",
"I could not make a copy" => "Copie impossible",
"You do not have permission to read the mapfile" => "Droit d'accès refusé : vous ne pouvez lire le fichier-carte",
"You dont have permission to do that" => "Vous n'avez pas les droits pour faire cela",
"Tiki RSS feed for maps" => "Canal de syndication RSS Tiki pour les cartes",
"List of maps available." => "Liste des cartes disponibles.",
"You do not have permissions to view the layers" => "Droit d'accès refusé : vous ne pouvez pas voir les layers",
"You do not have permissions to delete a file" => "Droit d'accès refusé : vous ne pouvez effacer le fichier",
"File not found" => "Fichier non trouvé",
"You do not have permissions to create a directory" => "Droit d'accès refusé : vous ne pouvez créer le répertoire",
"The Directory is not empty" => "Le répertoire est vide",
"You do not have permissions to delete a directory" => "Droit d'accès refusé : vous ne pouvez effacer le répertoire",
"You do not have permissions to create an index file" => "Droit d'accès refusé : vous ne pouvez créer un fichier index",
"Invalid file name" => "Nom de fichier invalide",
"Invalid files to index" => "Fichiers à indexer invalide",
"I do not know where is gdaltindex. Set correctly the Map feature" => "gdaltindex invalide. Positionnez le correctement dans l'administration des cartes",
"I could not create the index file" => "Le fichier d'index ne peut être créé",
"Must be logged to use this feature" => "Vous devez être connecté pour utiliser cette fonctionnalité",
"Welcome at Hawiki" => "Bienvenu sur Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Ce site Tikiwiki peut être accéder par de nombreux équipements mobiles, entre autres Téléphone WAP, PDA, i-mode...",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Vous pouvez parcourir ce site de votre mobile en suivant le lien :",
"About" => "Au sujet",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "Vous devez exécuter setup.sh :<br />./setup.sh \$APACHEUSER all<br />Les utilisateurs classiques de Apache sont www-data, apache ou nobody",
"Your PHP installation does not have zlib enabled." => "Votre installation PHP n'a pas l'option zlib activée.",
"You must log in to use this feature" => "Vous devez vous inscrire pour utiliser cette fonctionnalité",
"You do not have permission to view other users data" => "Droit d'accès refusé : vous ne pouvez afficher les données des autres utilisateurs",
"You must be logged in to subscribe to newsletters" => "Vous devez vous connecter pour vous inscrire à une newsletter",
"No server indicated" => "Aucun serveur indiqué",
"Cannot connect to" => "Impossible de se connecter à",
"Missing information to read news (server,port,username,password,group) required" => "Informations manquantes pour lire les news (serveur, port, nom utilisateur, mot de passe, groupe) exigées",
"Cannot get messages" => "Impossible de récupérer les messages",
"No note indicated" => "Aucune note indiquée",
"merged note:" => "note de fusion :",
"File is too big" => "Fichier trop gros",
"created from notepad" => "crée du bloc-note",
"Page already exists" => "La page existe déjà",
"Not enough information to display this page" => "Information insuffisante pour afficher cette page",
"Permission denied you cannot assign permissions for this object" => "Droit d'accès refusé : vous ne pouvez pas attribuer des droits d'accès à cet objet",
"Permission denied you cannot browse this page history" => "Droit d'accès refusé : vous ne pouvez pas afficher l'historique de cette page",
"Permission denied you cannot view the source of this page" => "Droit d'accès refusé : vous ne pouvez pas voir le source de cette page",
"No article indicated" => "Aucun article indiqué",
"Article is not published yet" => "Cet article n'a pas encore été publié",
"No post indicated" => "Aucun article indiqué",
"Blog not found" => "Blogue introuvable",
"No pages indicated" => "Aucune page indiquée",
"Pageviews" => "Affichage de page",
"You don't have permission to edit quizzes." => "Vous n'avez pas la permission de modifier les QCMs",
"No result indicated" => "Aucun résultat indiqué",
"Registered" => "Inscrit",
"You must choose a group" => "Vous devez choisir un groupe",
"The passwords don't match" => "Les mots de passe ne correspondent pas",
"Username cannot contain uppercase letters" => "Le nom d'utilisateur ne peut contenir de majuscules",
"Username must be at least" => "Le nom d'utilisateur doit avoir au moins",
"Username cannot contain more than" => "Le nom d'utilisateur ne peut pas contenir plus de",
"characters" => "caractères",
"Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "SVP, saisissez un valide %s. Pas d'espace, pas plud de %d caractères et contenant %s",
"This is not a valid mail adress" => "Ce n'est pas une adresse électronique valide",
"mail adress" => "adresse électronique",
"empty" => "vide",
"Invalid or unknown username" => "Nom utilisateur invalide ou inconnu",
"Unable to send mail. User has not configured email" => "Impossible d'envoyer l'email. L'utilisateur n'a pas configuré son adresse électronique",
"Invalid or unknown email" => "Adresse électronique incorrecte ou inconnue",
"The mail can't be sent. Contact the administrator" => "Le courriel ne peut pas être envoyé. Contactez l'administrateur",
"A password and your IP address reminder email has been sent " => "Un rappel de votre mot de passe et de votre adresse IP a été envoyé",
"An email with a link to reset your password has been sent " => "Un email comportant un lien qui permet de réinitialiser votre mot de passe a été envoyé ",
"to the registered email address for" => "à l'adresse électronique inscrite pour",
"last version" => "dernière version",
"Permission denied you cannot remove versions from this page" => "Droit d'accès refusé : vous ne pouvez pas supprimer de versions de cette page",
"Permission denied you cannot rename this page" => "Vous n'avez pas le droit de renommer cette page",
"Cannot rename page because the new name begins with reserved prefix" => "Vous ne pouvez pas renommer la page avec un nom qui commence par un préfixe réservé",
"Cannot rename page maybe new page already exists" => "Ne peut pas renommer la page, peut-être que la page existe déjà",
"changed '%s' from '%s' to '%s'" => "Modifié : '%s' de '%s' en '%s'",
"Non-existent version" => "Version inexistante",
"Permission denied you cannot rollback this page" => "Droit d'accès refusé : vous ne pouvez pas revenir à cette page",
"Error Message" => "Message d'erreur",
"Tiki RSS Feed Error Message: \$errmsg" => "Message d'erreur du canal de syndication Tiki RSS : \$errmsg",
"Post recommendation at" => "Un bon article sur",
"No newsletters available." => "Aucune lettre d'informations n'est disponible.",
" successfully sent" => " envoyé avec succès",
" not sent" => " pas envoyé",
"Error: " => "Erreur :",
"Notice: this variable may not be empty:" => "Cette variable ne peut pas être vide :",
"Notice: invalid variable value:" => "Remarque : value de variable invalide :",
"Permission denied you cannot remove this sheet" => "Droit d'accès refusé : vous ne pouvez pas supprimer ce feuillet",
"You do not have permission to edit messages \$owner" => "Vous n'avez pas ls droits de modifer les messages \$owner",
"Page must be defined inside a structure to use this feature" => "La page doit être définie à l'intérieur d'une structure pour utiliser cette fonctionnalité",
"You cannot take this quiz twice" => "Vous ne pouvez remplir ce QCM deux fois",
"Quiz time limit exceeded quiz cannot be computed" => "Limite de temps dépassée : le QCM ne peut pas être traité",
"You cannot take this survey twice" => "Vous ne pouvez pas répondre à cette enquête 2 fois",
"Please create a category first" => "SVP, créer une catégorie d'abord",
"Tracker item:" => "Fiche du formulaire :",
"No trackerId specified" => "Pas d'identifiant de formulaire spécifié",
"Tiki RSS feed for individual trackers: " => "Canaux de syndication RSS Tiki pour les formulaires individuels: ",
"No permission to upload zipped file packages" => "Aucun droit pour envoyer des paquetages de fichiers zippés",
"Error processing zipped image package" => "Erreur lors du traitement de paquetage image zippé",
"No permission to upload zipped image packages" => "Aucun droit pour envoyer des paquetages d'images zippées",
"The uploaded file ist not recognized as a image" => "Le fichier envoyé n'est pas une image",
"Permission denied you cannot upload images" => "Droit d'accès refusé : vous ne pouvez envoyer d'images",
"Permission denied you can upload images but not to this gallery" => "Droit d'accès refusé : vous pouvez envoyer des images, mais pas dans cette galerie",
"Cannot get image from URL" => "Impossible d'obtenir d'image de cette adresse Web",
"That is not an image (or you have php < 4.0.5)" => "Ceci n'est pas une image (ou votre version php < 4.0.5)",
"Usage" => "Utilisation",
"No url indicated" => "Aucune adresse Web indiquée",
"Unknown user" => "Utilisateur inconnu",
"You are not logged in and no user indicated" => "Vous n'êtes pas connecté et aucun utilisateur n'est indiqué",
"The user has chosen to make his information private" => "L'utilisateur a choisi de garder ses informations privées",
"Invalid password.  Your current password is required to change administrative information" => "Mot de passe invalide. Votre mot de passe courant est nécessaire pour modifier les informations de votre compte",
"Email is set to %s" => "L'adresse électronique est changée en %s",
"The passwords did not match" => "Les mots de passe ne correspondent pas",
"no" => "non",
"was moved into trash" => "a été mis à la corbeille",
"trashed by" => "mis à la corbeille par",
"open / in process" => "ouvert / en cours",
"Rights by creator" => "Droits par créateur",
"END" => "FIN",
"Percentage" => "Pourcentage",
"Task accepted by creator" => "Tâche acceptée par le créateur",
"Task accepted by task user" => "Tâche acceptée par l'utilisateur de la tâche",
"Task NOT accepted by creator" => "Tâche NON acceptée par le créateur",
"Task NOT accepted by task user" => "Tâche NON acceptée par l'utilisateur de la tâche",
"Sorry this task does not exist or you have no rights to view this task" => "Désolé, cette tâche n'existe pas ou vous n'avez pas les droits",
"Task entries:" => "Description de la tâche :",
"Changes:" => "Modifications :",
"Info message" => "Message d'info",
"NEW Task" => "NOUVELLE tâche",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Désolé, vous ne pouvez envoyer une tâche à un autre utilisateur, ou l'utilisateur n'a pas les droits pour recevoir des tâches",
"Changes on Task" => "Modification de la tâche",
"You received a new task" => "Vous avez reçu une nouvelle tâche",
"The priority is" => "La priorité est",
"very low" => "très bas",
"low" => "bas",
"high" => "haut",
"very high" => "très haut",
"You've to start your work at least on" => "Vous devez commencer le travail au moins le",
"You've to finish your work on" => "Vous devez finir le travail pour le",
"Login and click the link below" => "Connectez-vous et cliquez sur le lien ci-dessous",
"Please read the task and work on it!" => "SVP, lisez la tâche et travaillez dessus!",
"Sorry, there was an error while trying to write data into the database" => "Désolé pour ce problème existant dans la base de données",
"Cannot upload this file not enough quota" => "Envoi du fichier impossible, quota insuffisant",
"Non-existent user" => "Utilisateur inexistant",
"No banner indicated" => "Aucune bannière indiquée",
"No blog indicated" => "Aucun blogue indiqué",
"Permission denied you cannot remove the post" => "Droit d'accès refusé : vous ne pouvez supprimer cet article",
"No cache information available" => "Aucune information sur l'antémémoire disponible",
"No faq indicated" => "Aucune FAQ indiquée",
"You are not permitted to remove someone else\\'s post!" => "Vous n'avez pas les droits d'effacer les publications de quelqu'un d'autre!",
"Wrong password. Cannot post comment" => "Mot de passe incorrect. Vous ne pouvez pas publier un commentaire",
"Please wait 2 minutes between posts" => "SVP respectez un délai de 2 minutes entre chaque publication",
"No thread indicated" => "Aucun fil de discussion indiqué",
"Incorrect thread" => "Fil de discussion incorrect",
"A SheetId is required." => "Le SheetId est exigé.",
"That tracker don't use extras." => "Ce formulaire n'utilise pas de supplément pour les pièces attachées.",
"No subject" => "Aucun sujet",
"Top pages" => "Pages les plus populaires",
"Last pages" => "Dernières pages",
"Tiki RSS feed for the wiki pages" => "Canal de syndication RSS Tiki pour les pages Wiki",
"Last modifications to the Wiki." => "Dernières pages Wiki modifiées.",
"The page is empty" => "La page est vide",
"###end###"=>"###end###");
?>
