/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Balancer;
import br.arca.morcego.Config;
import br.arca.morcego.Feeder;
import br.arca.morcego.Graph;
import br.arca.morcego.GraphDataRetriever;
import br.arca.morcego.Node;
import br.arca.morcego.Renderer;
import br.arca.morcego.Spinner;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Enumeration;

public class Morcego
extends Applet
implements MouseListener,
MouseMotionListener {
    private boolean isStandalone = false;
    private boolean focussed = false;
    private Cursor handCursor = new Cursor(12);
    private int clickX;
    private int clickY;
    private int previousX;
    private int previousY;
    private int rotateSpeedX;
    private int rotateSpeedY;
    private BufferedImage bi;
    private Graphics2D bg;
    private Graph graph;
    private Feeder feeder;
    private Balancer balancer;
    private Renderer renderer;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;

    public void init() {
        this.initConfig();
        this.setSize((Integer)Config.getValue("windowWidth"), (Integer)Config.getValue("windowHeight"));
        this.resize((Integer)Config.getValue("windowWidth"), (Integer)Config.getValue("windowHeight"));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void initConfig() {
        Config.init();
        Enumeration vars = Config.listConfigVars();
        while (vars.hasMoreElements()) {
            String varName = (String)vars.nextElement();
            String value = this.getParameter(varName);
            if (value == null) continue;
            Class<?> type = Config.getValue(varName).getClass();
            try {
                if (type.equals(class$java$lang$Integer == null ? Morcego.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    Config.setValue(varName, Integer.valueOf(value));
                    continue;
                }
                if (type.equals(class$java$lang$Float == null ? Morcego.class$("java.lang.Float") : class$java$lang$Float)) {
                    Config.setValue(varName, Float.valueOf(value));
                    continue;
                }
                if (type.equals(class$java$lang$String == null ? Morcego.class$("java.lang.String") : class$java$lang$String)) {
                    Config.setValue(varName, value);
                    continue;
                }
                if (!type.equals(class$java$awt$Color == null ? Morcego.class$("java.awt.Color") : class$java$awt$Color)) continue;
                Config.setValue(varName, Color.decode(value));
            }
            catch (Exception e) {}
        }
    }

    public void start() {
        this.bi = new BufferedImage((Integer)Config.getValue("windowWidth"), (Integer)Config.getValue("windowHeight"), 1);
        this.bg = (Graphics2D)this.bi.getGraphics();
        this.bg.setClip((Integer)Config.getValue("viewStartX"), (Integer)Config.getValue("viewStartY"), (Integer)Config.getValue("viewWidth"), (Integer)Config.getValue("viewHeight"));
        GraphDataRetriever retriever = new GraphDataRetriever((String)Config.getValue("serverUrl"));
        Graph firstGraph = null;
        try {
            firstGraph = retriever.retrieveData((String)Config.getValue("startNode"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.graph = new Graph();
        Node centerNode = firstGraph.nodeFromName((String)Config.getValue("startNode"));
        this.graph.add(centerNode);
        this.graph.navigateTo(centerNode);
        this.feeder = new Feeder(this.graph, retriever);
        this.renderer = new Renderer(this);
        this.balancer = new Balancer(this.graph, this.renderer);
        Spinner spinner = new Spinner(this.graph, this.renderer);
        Thread feedingThread = new Thread(this.feeder);
        Thread balanceThread = new Thread(this.balancer);
        Thread renderingThread = new Thread(this.renderer);
        Thread spinningThread = new Thread(spinner);
        balanceThread.start();
        feedingThread.start();
        renderingThread.start();
        spinningThread.start();
        this.feeder.feed(firstGraph);
    }

    public void stop() {
    }

    public void destroy() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent e) {
        this.graph.setRotating(false);
        if (this.graph.contains(e.getX(), e.getY())) {
            if (!this.graph.getFocus().centered()) {
                this.graph.navigateTo(this.graph.getFocus());
                this.balancer.awake();
                Feeder feeder = this.feeder;
                synchronized (feeder) {
                    this.feeder.notify();
                }
            } else {
                URL url = this.graph.getFocus().getActionUrl();
                if (url != null) {
                    this.getAppletContext().showDocument(url, (String)Config.getValue("controlWindowName"));
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.graph.setRotating(false);
        if (this.graph.contains(x, y)) {
            this.balancer.awake();
            this.balancer.lockBalance();
            this.setCursor(this.handCursor);
            this.graph.getFocus().fixPosition();
            this.focussed = true;
            this.clickX = x;
            this.clickY = y;
        }
        this.previousX = x;
        this.previousY = y;
        e.consume();
    }

    public void mouseMoved(MouseEvent e) {
        int y;
        int x = e.getX();
        if (this.graph.contains(x, y = e.getY())) {
            this.setCursor(this.handCursor);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.previousX = x;
        this.previousY = y;
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.focussed) {
            this.focussed = false;
            this.graph.getFocus().releasePosition();
            this.balancer.awake();
            this.balancer.unlockBalance();
        } else if (Math.abs(this.rotateSpeedX) + Math.abs(this.rotateSpeedY) > 4) {
            this.graph.setRotating(true);
            this.graph.rotate(this.rotateSpeedX / 5, this.rotateSpeedY / 5);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (!this.focussed) {
            this.rotateSpeedX = x - this.previousX;
            this.rotateSpeedY = y - this.previousY;
            this.graph.rotate(this.rotateSpeedX, this.rotateSpeedY);
            Renderer renderer = this.renderer;
            synchronized (renderer) {
                this.renderer.notify();
            }
            this.previousX = x;
            this.previousY = y;
        } else {
            int dx = x - this.previousX;
            int dy = y - this.previousY;
            this.previousX = x;
            this.previousY = y;
            this.graph.getFocus().moveBy(-2.0f * (float)dx, -2.0f * (float)dy, 0.0f);
            Renderer renderer = this.renderer;
            synchronized (renderer) {
                this.renderer.notify();
            }
        }
        e.consume();
    }

    public void paint(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setClip((Integer)Config.getValue("viewStartX"), (Integer)Config.getValue("viewStartY"), (Integer)Config.getValue("viewWidth"), (Integer)Config.getValue("viewHeight"));
        g.setBackground((Color)Config.getValue("backgroundColor"));
        try {
            RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHints(qualityHints);
            if (this.bg != null) {
                this.bg.setRenderingHints(qualityHints);
            }
        }
        catch (NullPointerException ne) {
            System.out.println("ne1");
        }
        if (this.bi != null) {
            this.bg.setColor((Color)Config.getValue("backgroundColor"));
            this.bg.fillRect(0, 0, this.getSize().width, this.getSize().height);
            this.graph.paint(this.bg);
            g.drawImage((Image)this.bi, 0, 0, this);
        }
    }

    public void update(Graphics g) {
        if (this.bi == null) {
            g.clearRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.paint(g);
    }

    public String getAppletInfo() {
        return "Morcego rulez!";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public static void main(String[] args) {
        Morcego applet = new Morcego();
        applet.isStandalone = true;
        Frame frame = new Frame();
        frame.setTitle("Morcego");
        frame.add(applet);
        applet.init();
        applet.start();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        ((Component)frame).setVisible(true);
    }

    public Graph getGraph() {
        return this.graph;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

