/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.jgraph.pad.InternalPopupMenu;
import org.jgraph.pad.JTextAreaOutputStream;
import org.jgraph.pad.MyDocumentListener;
import org.jgraph.pad.resources.Translator;

public class GPLogConsole
extends JFrame {
    private PrintStream stdout = null;
    private PrintStream stderr = null;
    private String frameTitle = "";
    CardLayout cardLayout = new CardLayout();
    JTextArea stderrText = new JTextArea();
    JScrollPane stdoutScrollPane = new JScrollPane();
    JTextArea stdoutText = new JTextArea();
    JScrollPane stderrScrollPane = new JScrollPane();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    Image myIcon = null;
    boolean makeVisibleOnError = false;
    InternalPopupMenu popup = new InternalPopupMenu();

    public GPLogConsole(String string, Image image, boolean bl) {
        this.frameTitle = string;
        this.myIcon = image;
        this.makeVisibleOnError = bl;
        if (this.frameTitle == null || this.frameTitle.equals("")) {
            this.frameTitle = "Test drive";
        }
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
    }

    private void jbInit() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GPLogConsole.this.this_windowClosing(windowEvent);
            }
        });
        this.setTitle(this.frameTitle);
        this.getContentPane().setLayout(this.cardLayout);
        if (this.myIcon != null) {
            this.setIconImage(this.myIcon);
        }
        this.redirect();
        this.stderrText.setForeground(Color.red);
        this.stderrText.setBackground(Color.lightGray);
        this.stderrText.setEditable(false);
        this.stderrText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GPLogConsole.this.stderrText_mouseClicked(mouseEvent);
            }
        });
        this.stdoutText.setForeground(Color.black);
        this.stdoutText.setEditable(false);
        this.stdoutText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GPLogConsole.this.stdoutText_mouseClicked(mouseEvent);
            }
        });
        this.jTabbedPane1.setTabPlacement(3);
        this.jTabbedPane1.setMinimumSize(new Dimension(400, 400));
        this.jTabbedPane1.setPreferredSize(new Dimension(400, 400));
        this.getContentPane().add((Component)this.jTabbedPane1, "jTabbedPane1");
        this.jTabbedPane1.add((Component)this.stdoutScrollPane, Translator.getString("StandardOut"));
        this.jTabbedPane1.add((Component)this.stderrScrollPane, Translator.getString("StandardError"));
        this.stderrScrollPane.getViewport().add((Component)this.stderrText, null);
        this.stdoutScrollPane.getViewport().add((Component)this.stdoutText, null);
        this.stdoutText.getDocument().addDocumentListener(new MyDocumentListener(this, this.jTabbedPane1, this.stdoutScrollPane));
        this.stderrText.getDocument().addDocumentListener(new MyDocumentListener(this, this.jTabbedPane1, this.stderrScrollPane));
        this.pack();
    }

    private void redirect() {
        this.stdout = System.out;
        this.stderr = System.err;
        try {
            System.setOut(new JTextAreaOutputStream(this.stdoutText, this.stdout, true));
            System.setErr(new JTextAreaOutputStream(this.stderrText, this.stderr, true));
        }
        catch (Exception exception) {
            System.err.println("Error while re-directing the output. Ignoring...");
        }
    }

    void this_windowDispose(WindowEvent windowEvent) {
        this.dispose();
    }

    void this_windowClosing(WindowEvent windowEvent) {
        this.this_windowDispose(windowEvent);
        System.exit(0);
    }

    void stdoutText_mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            this.popup.setTextArea(this.stdoutText);
            this.popup.show(this.stdoutText, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void stderrText_mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            this.popup.setTextArea(this.stderrText);
            this.popup.show(this.stderrText, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

