'''OpenGL extension NV.vertex_program2

Overview (from the spec)
	
	This extension further enhances the concept of vertex programmability
	introduced by the NV_vertex_program extension, and extended by
	NV_vertex_program1_1.  These extensions create a separate vertex program
	mode where the configurable vertex transformation operations in unextended
	OpenGL are replaced by a user-defined program.
	
	This extension introduces the VP2 execution environment, which extends the
	VP1 execution environment introduced in NV_vertex_program.  The VP2
	environment provides several language features not present in previous
	vertex programming execution environments:
	
	  * Branch instructions allow a program to jump to another instruction
	    specified in the program.
	
	  * Branching support allows for up to four levels of subroutine
	    calls/returns.
	
	  * A four-component condition code register allows an application to
	    compute a component-wise write mask at run time and apply that mask to
	    register writes.  
	
	  * Conditional branches are supported, where the condition code register
	    is used to determine if a branch should be taken.
	
	  * Programmable user clipping is supported support (via the CLP0-CLP5
	    clip distance registers).  Primitives are clipped to the area where
	    the interpolated clip distances are greater than or equal to zero.
	
	  * Instructions can perform a component-wise absolute value operation on
	    any operand load.
	
	The VP2 execution environment provides a number of new instructions, and
	extends the semantics of several instructions already defined in
	NV_vertex_program.
	
	  * ARR:  Operates like ARL, except that float-to-int conversion is done
	    by rounding.  Equivalent results could be achieved (less efficiently)
	    in NV_vertex program using an ADD/ARL sequence and a program parameter
	    holding the value 0.5.
	
	  * BRA, CAL, RET:  Branch, subroutine call, and subroutine return
	    instructions.
	
	  * COS, SIN:  Adds support for high-precision sine and cosine
	    computations.
	
	  * FLR, FRC:  Adds support for computing the floor and fractional portion
	    of floating-point vector components.  Equivalent results could be
	    achieved (less efficiently) in NV_vertex_program using the EXP
	    instruction to compute the fractional portion of one component at a
	    time.
	
	  * EX2, LG2:  Adds support for high-precision exponentiation and
	    logarithm computations.
	
	  * ARA:  Adds pairs of components of an address register; useful for
	    looping and other operations.
	
	  * SEQ, SFL, SGT, SLE, SNE, STR:  Add six new "set on" instructions,
	    similar to the SLT and SGE instructions defined in NV_vertex_program.
	    Equivalent results could be achieved (less efficiently) in
	    NV_vertex_program with multiple SLT, SGE, and arithmetic instructions.
	
	  * SSG:  Adds a new "set sign" operation, which produces a vector holding
	    negative one for negative components, zero for components with a value
	    of zero, and positive one for positive components.  Equivalent results
	    could be achieved (less efficiently) in NV_vertex_program with
	    multiple SLT, SGE, and arithmetic instructions.
	
	  * The ARL instruction is extended to operate on four components instead
	    of a single component.
	
	  * All instructions that produce integer or floating-point result vectors
	    have variants that update the condition code register based on the
	    result vector.
	
	This extension also raises some of the resource limitations in the
	NV_vertex_program extension.
	
	  * 256 program parameter registers (versus 96 in NV_vertex_program).
	
	  * 16 temporary registers (versus 12 in NV_vertex_program).
	
	  * Two four-component integer address registers (versus one
	    single-component register in NV_vertex_program).
	
	  * 256 total vertex program instructions (versus 128 in
	    NV_vertex_program).
	
	  * Including loops, programs can execute up to 64K instructions.
	

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/NV/vertex_program2.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_NV_vertex_program2'



def glInitVertexProgram2NV():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
