/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class BMPImageReader
extends ImageReader {
    private BMPInfoHeader infoHeader = null;
    private BMPFileHeader fileHeader = null;
    private BMPDecoder decoder = null;

    private final void validateIndex(int n) throws IndexOutOfBoundsException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Invalid image index.");
        }
    }

    public void setInput(Object object) {
        super.setInput(object);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
    }

    public void setInput(Object object, boolean bl) {
        super.setInput(object, bl);
        if (!(object instanceof ImageInputStream)) {
            throw new IllegalArgumentException("Input not an ImageInputStream.");
        }
    }

    private final void checkStream() throws IOException {
        if (!(this.input instanceof ImageInputStream)) {
            throw new IllegalStateException("Input not an ImageInputStream.");
        }
        if (this.input == null) {
            throw new IllegalStateException("No input stream.");
        }
    }

    private final void readHeaders() throws IOException, IIOException {
        if (this.fileHeader != null) {
            return;
        }
        this.checkStream();
        this.fileHeader = new BMPFileHeader((ImageInputStream)this.input);
        this.infoHeader = new BMPInfoHeader((ImageInputStream)this.input);
        this.decoder = BMPDecoder.getDecoder(this.fileHeader, this.infoHeader);
    }

    public int getWidth(int n) throws IOException {
        this.validateIndex(n);
        this.readHeaders();
        return this.infoHeader.getWidth();
    }

    public int getHeight(int n) throws IOException {
        this.validateIndex(n);
        this.readHeaders();
        return this.infoHeader.getHeight();
    }

    public Iterator getImageTypes(int n) {
        this.validateIndex(n);
        return null;
    }

    public int getNumImages(boolean bl) {
        return 1;
    }

    public IIOMetadata getImageMetadata(int n) {
        this.validateIndex(n);
        return null;
    }

    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException, IIOException {
        this.validateIndex(n);
        this.readHeaders();
        return this.decoder.decode((ImageInputStream)this.input);
    }

    protected BMPImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }
}

