/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.javax.crypto.assembly.Assembly;
import gnu.javax.crypto.assembly.Cascade;
import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.Stage;
import gnu.javax.crypto.assembly.Transformer;
import gnu.javax.crypto.assembly.TransformerException;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.PadFactory;
import gnu.javax.crypto.sasl.ConfidentialityException;
import gnu.javax.crypto.sasl.srp.KDF;
import java.util.HashMap;
import javax.security.sasl.SaslException;

public final class CALG {
    private Assembly assembly;
    private Object modeNdx;
    private int blockSize;
    private int keySize;

    static final synchronized CALG getInstance(String string) {
        IBlockCipher iBlockCipher = CipherFactory.getInstance(string);
        int n = iBlockCipher.defaultBlockSize();
        int n2 = iBlockCipher.defaultKeySize();
        Cascade cascade = new Cascade();
        Object object = cascade.append(Stage.getInstance(ModeFactory.getInstance("ofb", iBlockCipher, n), Direction.FORWARD));
        IPad iPad = PadFactory.getInstance("pkcs7");
        Assembly assembly = new Assembly();
        assembly.addPreTransformer(Transformer.getCascadeTransformer(cascade));
        assembly.addPreTransformer(Transformer.getPaddingTransformer(iPad));
        return new CALG(n, n2, object, assembly);
    }

    public final void init(KDF kDF, byte[] byArray, Direction direction) throws SaslException {
        byte[] byArray2;
        if (byArray.length == this.blockSize) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[this.blockSize];
            if (byArray.length > this.blockSize) {
                System.arraycopy(byArray, 0, byArray2, 0, this.blockSize);
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            }
        }
        HashMap hashMap = new HashMap();
        byte[] byArray3 = kDF.derive(this.keySize);
        hashMap.put("gnu.crypto.cipher.key.material", byArray3);
        hashMap.put("gnu.crypto.mode.iv", byArray2);
        HashMap hashMap2 = new HashMap();
        hashMap2.put("gnu.crypto.assembly.assembly.direction", direction);
        hashMap2.put(this.modeNdx, hashMap);
        try {
            this.assembly.init(hashMap2);
        }
        catch (TransformerException transformerException) {
            throw new SaslException("getInstance()", transformerException);
        }
    }

    public final byte[] doFinal(byte[] byArray) throws ConfidentialityException {
        return this.doFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) throws ConfidentialityException {
        byte[] byArray2;
        try {
            byArray2 = this.assembly.lastUpdate(byArray, n, n2);
        }
        catch (TransformerException transformerException) {
            throw new ConfidentialityException("doFinal()", transformerException);
        }
        return byArray2;
    }

    private CALG(int n, int n2, Object object, Assembly assembly) {
        this.blockSize = n;
        this.keySize = n2;
        this.modeNdx = object;
        this.assembly = assembly;
    }
}

