;; Quail package `chinese-ctlau' -*- coding:iso-2022-7bit; -*-
;;   Generated by the command `miscdic-convert'
;;   Date: Sun Jul  5 15:46:09 2009
;;   Source dictionary file: CTLau.html
;;   Copyright notice of the source file
;;------------------------------------------------------
;; "CTLau.html" is available at:
;;
;;   http://umunhum.stanford.edu/~lee/chicomp/CTLau.html
;;
;; It contains the following copyright notice:
;;
;; # Copyright (C) 1988-2001  Fung Fung Lee (lee@umunhum.stanford.edu)
;; # 
;; # This program is free software; you can redistribute it and/or
;; # modify it under the terms of the GNU General Public License
;; # as published by the Free Software Foundation; either version 2
;; # of the License, or any later version.
;; # 
;; # This program is distributed in the hope that it will be useful,
;; # but WITHOUT ANY WARRANTY; without even the implied warranty of
;; # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; # GNU General Public License for more details.
;; # 
;; # You should have received a copy of the GNU General Public License
;; # along with this program; if not, write to the Free Software Foundation,
;; # Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;------------------------------------------------------

;;; Code:

(require 'quail)
(quail-define-package "chinese-ctlau" "Chinese-CNS" "$AAuTA(B" t
"$A::WVJdHk!KAuN}OiJ=TARt!K(B

 $AAuN}OiJ=TASoW"Rt7=08(B
 Sidney Lau's Cantonese transcription scheme as described in his book
 \"Elementary Cantonese\", The Government Printer, Hong Kong, 1972.
 This file was prepared by Fung Fung Lee ($A@n7c7e(B).
 Originally converted from CTCPS3.tit
 Last modified: June 2, 1993.

 Some infrequent GB characters are accessed by typing \\, followed by
 the Cantonese romanization of the respective radical ($A2?JW(B)."
  '(("" . quail-delete-last-char)
   ("." . quail-next-translation)
   (">" . quail-next-translation)
   ("," . quail-prev-translation)
   ("<" . quail-prev-translation))
  nil nil nil nil)

(quail-define-rules
("a" "$A0"0!Q;Q=Q>QFQG_9k2o9(B")
("aai" "$A0#0$`I0%0&0/`H(B")
("aan" "$AjL03(B")
("aang" "$As?(B")
("aap" "$AQ<(B")
("aat" "$AQ9Q:(B")
("aau" "$A^V(B")
("ak" "$ANU6s6rv;(B")
("am" "$A05ZOwv(B")
("ang" "$A]:(B")
("au" "$AE7E8E9E;E=(B")
("ba" "$A0Q0M0E0H0I0J0L0P0S0T0U0V]bnYtN(B")
("baai" "$AEH0Z0\0]0^_B(B")
("baak" "$A0W0Y2.0[2/FH27(B")
("baan" "$A0l0`0_0d0e0f0gZf[`c]t2(B")
("baang" "$A1A1D(B")
("baat" "$A0K0F(B")
("baau" "$A0|0z0{1%1+1,v5(B")
("bai" "$A1R1U1M1N1P1V1W1](B")
("bak" "$A11(B")
("bam" "$A1CER(B")
("ban" "$A1v1?1r1s1u1w1<F7YwYOfIikkwo<oY(B")
("bang" "$A1@`T(B")
("bat" "$A2;1O1J0N0O_Yevn_(B")
("be" "$AF!(B")
("bei" "$A1;1/181H1Gn/F"1.10191K1Q1S1T1[1\CXCZE~X0YB`N1He~(B")
("beng" "$A1z1}2!(B")
("bik" "$A1F1L1ZtE(B")
("bin" "$AXR1b1c1d1_1a1e1f1g1h1^cjq9(B")
("bing" "$A2"1x1y1{1|1~1E(B")
("bit" "$A1p1n1o1q1Xni(B")
("biu" "$A1m1j1kf;opoZ(B")
("bo" "$A281#2?2<1(292=1)0}262>2@1$1&FRFXlRp1(B")
("boh" "$A2#2$2%2(FB[6`#(B")
("bok" "$A252+2)2,2-2022241]1"8?(B")
("bong" "$A0n0o0p0q0s0u0w(B")
("booi" "$A131-121415171:(B")
("boon" "$A0k1>0cEO0a0i0m1=EQEV(B")
("boot" "$A2'c#212&2*23XC(B")
("buk" "$A27FYnGFM(B")
("bung" "$A1B(B")
("cha" "$Aoo2i2n2f2g2h2k2m2oNNT{w~(B")
("chaai" "$A2B2H2q2rY-nN(B")
("chaak" "$A2b2_2a2pTtb|(B")
("chaam" "$A2N2O2Q2R2s2t2v2wI<wu(B")
("chaan" "$A2y2z2M2P2StS(B")
("chaang" "$A3E3H(B")
("chaap" "$A2e(B")
("chaat" "$A2l2AL!K"`'`j(B")
("chaau" "$A3-3.323334qi(B")
("chai" "$AF`FkF\F^FvYQ]B_b(B")
("cham" "$AQ03AGVG^G_Z__Dd1v`(B")
("chan" "$A3B3>3C3DGWUnUo_Sv3(B")
("chang" "$A2cTx(B")
("chap" "$A<)<-(B")
("chat" "$AF_FaFb(B")
("chau" "$AGo3i3j3k3l3m3o3q3r3s3t4UGtGvGBPaY1t\(B")
("che" "$A35GR366_I]P0P1(B")
("chek" "$A3_(B")
("cheng" "$AGk(B")
("cheuk" "$A4A4BIVIWW?W@WFY>ey(B")
("cheung" "$AG=Oj403$3!Oi2}2~3&3)3*3+G9G:G>G@Ohc^f=(B")
("chi" "$A3U3X4J4L4NKFJ<2^4K3YJA3a3]3c4C4D4E4F4G4H4I4M3V3W3Z3[3\3^FjJ8JQVD_j`4`M_Zekf&ltr?tYuX(B")
("chik" "$AF]3`3b`R_3k7(B")
("chim" "$AG)G1G5YTe_o7(B")
("chin" "$AG'G.OK=&G0G32x2{2|<_G'G(G*Zd(B")
("ching" "$A3N3FGi3LGk3J3M3Q3S5IG`GeGgGhU|r_(B")
("chip" "$Af*(B")
("chit" "$AGP37393:FcIhU^(B")
("chiu" "$A3/3,31=8GDGFGMGNLvP$UQnH(B")
("cho" "$A2]2Y2Z2[2\4V4W4kThTjTkTo`Pa^ick}t=(B")
("choh" "$Ao14l3u3z3{3~4!4h4j4m[;(B")
("choi" "$A2G2J2E2F2C2D2I2K2LH|TTH{(B")
("chong" "$A42442X2V2T2U2W4/433'3(Xw(B")
("chue" "$A4&3w3x3y4"JoJpVyV|Xyui(B")
("chuen" "$A4e4f4+H+4'4(4)4-4.4Z4\4gH)H*H,K(K)MD\uk0nKn}oi(B")
("chuet" "$A4iW>6^W:WB`(`\_M(B")
("chui" "$AH!45KeKf3}3|4647484]4^4_4`4dGwH"H$Pl_}(B")
("chuk" "$A4Y4#4$JxKYPnPsX!v:(B")
("chun" "$A4:4;4@GXQ-Q.Q2(B")
("chung" "$AVX3d4S3e3f3h4O4P4Q4R4TKIVTZ#o%(B")
("chut" "$A3vwmwq(B")
("da" "$A4r(B")
("daai" "$A4s4x4u4w4t(B")
("daam" "$A`"5"5#5(5*5-YYqu(B")
("daan" "$A5+5%5$5&5'5)5,5.5/50ncw0(B")
("daap" "$A4pL$4n4qm3(B")
("daat" "$A4oL"`*sNw2(B")
("dai" "$A5]5ZA%5W4~5M5V5[5\X5tF(B")
("dak" "$A5B5CLXo=(B")
("dang" "$A5H5E5F5G5J5K`bj-ok(B")
("dat" "$AM9M;(B")
("dau" "$A69676665686:6;>@nWr=q<(B")
("de" "$A5y`G(B")
("dei" "$A5X(B")
("dek" "$A5Q(B")
("deng" "$A6"6$p[(B")
("deuh" "$A6d(B")
("deuk" "$AWAWD(B")
("dik" "$A5D5N5O5P5R5S5U`Voa(B")
("dim" "$A5c5`5j(B")
("din" "$A5g5d5b5e5f5i5l5m5n5_a[ndq2(B")
("ding" "$A6&6(6)6!6#6%6'M]Xjqttz(B")
("dip" "$A5z5{5}5~`)k:(B")
("dit" "$A5x5|VHis(B")
("diu" "$A5u5q5t5w5o5p5r5s5v6*nvn{uu(B")
("do" "$A565@5=6H6<6B6C6D6E6F6I6J57595:5<5>5?5A`=k.(B")
("doh" "$A6`6b6c6d6e6g6h6i_a(B")
("doi" "$A4z4}4|a7wl(B")
("dok" "$Anlub(B")
("dong" "$A5451525355nu(B")
("duen" "$A6L6M6N6O6K6P(B")
("duet" "$A6a(B")
("dui" "$A6T6Q6R6S(B")
("duk" "$A6@6=6>6?6Ak9sFwr(B")
("dun" "$A6X6Y6U6V6[6](B")
("dung" "$A6/6+6.416,6-6061626364_Kk1(B")
("fa" "$A;(;/(B")
("faai" "$A?l?i?j?~_`(B")
("faan" "$A7:7174hs7672787*0j7+7,7-7.7/7073757779^,(B")
("faat" "$A7"7(7)(B")
("fai" "$A;S;U7Q7M7N7O7P;TjMoP(B")
("fan" "$A7]7V7\7`7R7S7T7U7W7X7Y7Z7[7^7_;g;h;iQ,Q5YG^9ww(B")
("fat" "$A7p:v7w7z8%7#7$7%7&7'_|eu(B")
("fau" "$A7q2:8!8"87FJs>(B")
("fe" "$A7H(B")
("fei" "$A7I7Gkh7F7J7K7LdGezl3rctdv-(B")
("foh" "$A?F;u;p;o?NnXrr(B")
("fok" "$A;t>p(B")
("fong" "$A7B?v7=7E7;7<7>7?7@7A7C7D;D;E;N;O;P;Qa]hJkAnUt3(B")
("foo" "$A7r:tfZ888;8(7{8*7t817s7u7v7}8&8'8)8+8-8.8/808385868:8<8=8>8@:u;";#?`?b?c?]XZ\=\^_;fbw<(B")
("fooi" "$A;Z;e;R;V;^?|?}Z6`-`9(B")
("foon" "$A;6?m?n(B")
("foot" "$A@+(B")
("fuk" "$A847~8#7x7y7|8$8289Ykp%rp(B")
("fung" "$A7g7l7a7b7c7d7e7f7h7i7j7k7m7n7oY:_t(B")
("ga" "$A<\<Y<[<S<^8A8B<N<O<R<V<Z<]oXtB(B")
("gaai" "$A=b=i=W=g=V<Q=d=f=j=k=l=T=UYI^N`.(B")
("gaak" "$A8o8q8l8tX*`CkuoSw@(B")
("gaam" "$A<u<`<x^OvN(B")
("gaan" "$A<i<d<r<h<k<m<o<o<p<q='ZIo5(B")
("gaang" "$A8{(B")
("gaap" "$A<W<P<T<U<XkNnr(B")
("gaau" "$A=L=O=;8c=:=<=A=B=F=H=J=QY.p(rTuS(B")
("gai" "$A<F<L<&<;YJ(B")
("gam" "$A=p=q8P8J8L8R<j=u={`d(B")
("gan" "$A=|=t8z8y=m=n=o=v=w=y]@_gt^(B")
("gang" "$A9#8|8}8~9]9">,_l(B")
("gap" "$A8k8r<1(B")
("gat" "$A8m<*=[Y%(B")
("gau" "$A>?>I>E9;969798>A>B>C>D>G>H>L>N?Yw|(B")
("gei" "$A<8<G;z;y<H<M<<;~<!<"<%<'<:<?<D<I<KX^_4h=g\wd(B")
("geng" "$A>5>1(B")
("geuk" "$A=E(B")
("geung" "$A=)=*=.G<t](B")
("gik" "$A<,<$<+;wX=ijj*(B")
("gim" "$A=#<l<f<s(B")
("gin" "$A=!<{<~=(<a<g<|=]kl(B")
("ging" "$A>6>9>#>->)>3>0>">$>%>*>/>4>7>:XYYSqf(B")
("gip" "$A=Y(B")
("git" "$A=a=`=\hn(B")
("giu" "$A=>=P=?=C=Ik8(B")
("go" "$A8_8e8f8]8^8`8a8b8dR$X:Z>(B")
("goh" "$A8h8v8g(B")
("goi" "$A8C8D(B")
("gok" "$A>u8w8i8s=Gge(B")
("gon" "$A8I8K8M8N8O8QG,(B")
("gong" "$A=-8[8T8U8V8W8X8Y8Z8\=2=5?8qp(B")
("goo" "$A9E9A9L9I9B9J9<9=9>9@9C9D9F9K9Mn\p3o@(B")
("goon" "$A9\9Z9[9Y9`9a9W9]9^NSYD]8pY(B")
("got" "$A8n8p:V(B")
("guen" "$A>h>i>j>k>l>m>nH/Q+d8(B")
("gui" "$A>_>]>d>Y>e>S>X>^>a>b>fYFe}l+q@(B")
("guk" "$A>V>U9H>O`7o8(B")
("gung" "$A9&9$9+929'8S9%9(9)9*9,9-9.9091r<(B")
("gwa" "$A9O9R9P9QXT_I(B")
("gwaai" "$A9T9U9V(B")
("gwaan" "$A9X9_(B")
("gwaang" "$A9d(B")
("gwaat" "$A9N@((B")
("gwai" "$A9q<>9e9g9h9i9j9k9l9m9n9p9r9s<B?y@!XPXQX[p'(B")
("gwan" "$A>}>|>y9v9w>{?$Yrs^(B")
("gwang" "$A:d(B")
("gwat" "$A9G>r?_w;(B")
("gwing" "$A><(B")
("gwoh" "$A9}9{8j9|?C?Eo>(B")
("gwok" "$A9y9z@*(B")
("gwong" "$A9c9b(B")
("ha" "$AODOB9~O:O<O>OCeZh&n~(B")
("haai" "$AP3:!:"?+P,P5P7P8eb(B")
("haak" "$A?MOE(B")
("haam" "$AONOL:-:/:0OZ(B")
("haan" "$AO^OPf5(B")
("haang" "$A:;?SPP(B")
("haap" "$AF~O?OA`>_H(B")
("haau" "$AP'GCP#?<:p=M?=?>GIOxP"f/(B")
("hai" "$AO5Yb^Ilyw{(B")
("hak" "$A?L:U:Z?&?Kk4(B")
("ham" "$A:6:,:(:):3?0?1?2?3G6O]r%(B")
("han" "$A:\:[:]:^?Q?R(B")
("hang" "$APRPP:_:`:b:c?O?PPSo,(B")
("hap" "$AO@:O:PG]G"O;qkr"(B")
("hat" "$A:KFrO9O=[@(B")
("hau" "$A?Z:s:s:r:m:n:o:qeKtWvW(B")
("hei" "$AFxFp_qO#O2F{:YF[FqFwFzNuN{N~O]O)O7YRfRjXldl{tK(B")
("hek" "$A3T(B")
("heuh" "$AQ%(B")
("heung" "$AOrOlOmOcINOgbC(B")
("him" "$AOUG+G7(B")
("hin" "$AG#OWOTG2G4PyOFOFO\Q\llr9OK(B")
("hing" "$APKGaGbGdGlPV\0s@(B")
("hip" "$AG8GSP-P.P2(B")
("hit" "$AP*(B")
("hiu" "$A===DGAGOOyO~_Xfg(B")
("ho" "$A:E:F:C:>:?:@:A:D`F`cj;p)r+wR(B")
("hoh" "$A:N:I?I:S:G:J:X?@`@t4(B")
("hoi" "$A:&?*:#:$:%:'?-X\`Knxo4r$(B")
("hok" "$AQ':W?G(B")
("hon" "$A:.::?4:9?/:*:+:1:2:4:5:7:8Y)e+q|w}(B")
("hong" "$A?5:=PP:<?o?p?t?6?7?TG;OnOo_Qq~(B")
("hot" "$A?J:H(B")
("huen" "$APzH&H.H0Q$]f(B")
("huet" "$AQ*(B")
("hui" "$APiPmH%PjPfZ<hrlcq4(B")
("huk" "$A?a?^(B")
("hung" "$APZ:lP[?U?V:e:f:g:h:i9/?W?XPWPXPYP\PoYE(B")
("ja" "$A2jT[T|U%U&U'U(U)^j_8_8rF(B")
("jaai" "$AU+U.U/(B")
("jaak" "$ATpU,5TTqTsV@U*U-ZX_ut7(B")
("jaam" "$AU>T]U6U8U:U?tX(B")
("jaan" "$AT^U5U;U@WkW+W,(B")
("jaang" "$AUuUvUxUy(B")
("jaap" "$AO0TS</O.U"U#_Fl*(B")
("jaat" "$ATzT}T~_n(B")
("jaau" "$AUR30VbVhUVW%W&(B")
("jai" "$AVF<C<7<@<A<JVMWPv+38(B")
("jak" "$ATr2`XF(B")
("jam" "$AUm=~TuUeUkZZp2(B")
("jan" "$AUrUfUqUdUpUs[Z`Ajb(B")
("jang" "$ATv2dI.TwTxTy`aa?o#o-s](B")
("jap" "$AV-V4(B")
("jat" "$A<2<5V6VJVO(B")
("jau" "$AV^>FVg>MV[V]W_>>PdV\V_VcVdVeVfW`WaW^YV_z`1f{kP(B")
("je" "$AUbU_=h=cP;U`UaUZ`5i?pQ(B")
("jek" "$AV;<9VK_s(B")
("jeng" "$A>.>;V#Ze(B")
("jeuk" "$AWCWEH8>t=@H5lz(B")
("jeung" "$AUEOs=+=/UF3$=,=0=1=3=4OpOqUAUBUCUDUGUHUIUJUKULUMUNUOXvbjoOs/(B")
("ji" "$AWSWTWOWVV*VGV>V.WKWMWJVNV9V;V=VAKBKCKEKGKHV%V&V'V(V)V+V,V7V8V:V<V?VBVCVIVLWHWIWLWNWQZQY9\Ff"lklmlsoEqhqjtRv7(B")
("jik" "$A<(V0V/V1<.<4;}<#<E=eNyO&O+O/V2V3V5WUq6vjU]MP(B")
("jim" "$A<b=%IDUhU0U2U3U4U<Z^(B")
("jin" "$AU9=&<c<e<t<v<y<z<}=$DhDkL:U1U7U=j'te(B")
("jing" "$AagU}>2V$U~U{>&>'>+>8UjUlUtUwUzV!V"lun[(B")
("jip" "$A=S`?_](B")
("jit" "$A=ZU[=X=]=^UcU\U](B")
("jiu" "$A=6=7=9=KUPUSUTUUUYXdZ/YU`]3/(B")
("jo" "$ATgWiTlWvWfTbTcTeTfTiTmTnWb_plq(B")
("joh" "$AWxVzWhWsWtWyY^_r(B")
("joi" "$ATZTYTUTVTWTXWRg^(B")
("jok" "$AWwTdWrWu(B")
("jong" "$AW42XT_T`TaW.W/W0W1W2W3j0(B")
("jue" "$AVwW!W"VxVnVmVjViVkVlVoVsVtV{V}W]W$Y*\of-nywf(B")
("juen" "$A4+W(W*6WT\WjWpWqW)_yr'(B")
("juet" "$A>x6^W:`(`\(B")
("jui" "$AWnWmPr>W>Q>R>Z>[GyPpWgWlWoW5W6W7W8W9v4vBSl(B")
("juk" "$AWcWePxKW4%4XV`VaVpVqVrVuVvV~W#W=WG`Uf(omo_t6sC(B")
("jun" "$A=x>!W<=r=z=}>~?]?"?#?%UiiWoTq8(B")
("jung" "$AVPVVVZW]WZW\VUKLKOKPVQVRVSVWVYWWWXWYW[YLoqt)t1tU(B")
("jut" "$AWd(B")
("ka" "$A?(?'X{_G(B")
("kaai" "$A?,(B")
("kaat" "$A_R(B")
("kaau" "$A??nm(B")
("kai" "$AFu;|FtF}O*(B")
("kam" "$At@=sGYG\G]`_f!(B")
("kan" "$AGZG[(B")
("kap" "$A<0N|8x<3<6sE(B")
("kat" "$A?H(B")
("kau" "$A?[tC99Gs959:>J>K?\GrY4_5fEp/r0OP(B")
("ke" "$AFoH3GQY$(B")
("kei" "$AFeFdFZFmFlFs;{<=FfFgFiFna*gwlwq}whw"(B")
("kek" "$A>g(B")
("keuk" "$AH4`e(B")
("keung" "$AG?ojtG(B")
("kim" "$AG-G/(B")
("kin" "$Ar/(B")
("king" "$AGc>(GfGjGmwt(B")
("kit" "$Ar!>o=R=_P+f]tIwo(B")
("kiu" "$A=NGEGGGHGKGLO-(B")
("koh" "$An](B")
("koi" "$A8E8G8F8H?.?DX$n'(B")
("kok" "$AH7:B:TH6[V(B")
("kong" "$A?9@)?q?s?:?;XxnV?u(B")
("koo" "$A9?(B")
("kooi" "$A9t;b;f;_?k@#kZqy(B")
("koot" "$A@(;mqx(B")
("kuen" "$AH(;?H'H-(B")
("kuet" "$A>w>v>qH1H2XJXcZ\`Yf^oc(B")
("kui" "$AGx>P>T>\>`>cG{G}G~X~aia+lnvD(B")
("kuk" "$AGz(B")
("kung" "$AGnq7(B")
("kwa" "$A?d9S?e?f?g?hY((B")
("kwaang" "$A?r(B")
("kwai" "$A9f9o?w?x?z?{@"P/X8aMeS(B")
("kwan" "$A@'9u>=>z@$@%@&H9H:o?PRPWPk(B")
("kwik" "$AO6k=(B")
("kwong" "$A?s?u(B")
("la" "$AsA@.@2X](B")
("laai" "$A@-@5(B")
("laam" "$A@6<w="@7@:@?@@@B@Dq\(B")
("laan" "$A@<@8@9@;@=@>@A@Cog(B")
("laang" "$A@d(B")
("laap" "$A@0@,@/(B")
("laat" "$A@1eepx(B")
("lai" "$A@}@v@g@h@q@s@w@xY3fjtOws(B")
("lak" "$A@U@_Xl`O(B")
("lam" "$AA]AUAVAXAYA\_x(B")
("lap" "$AA"0<A#sR(B")
("lat" "$AK&(B")
("lau" "$AB)B%AtAwAoApAqArAsAuAvAxB&B'B(B*YM`6froNoVqowC(B")
("le" "$A_V(B")
("lei" "$A@n@{@mA'@~@e@f@i@j@k@l@o@p@r@tBDA]A(Y5`,f2o.(B")
("lek" "$A_7(B")
("leng" "$Av&vl(B")
("leuk" "$ABTBS(B")
("leung" "$AA:A=A?A)A8A9A;A<A>AAABR)(B")
("lik" "$AA&@zA$_?(B")
("lim" "$AA-A.A1A2A3ig(B")
("lin" "$AA,A/A6A7A+A0A4Dl(B")
("ling" "$AAbAlAmAiAc@b@cA`AaAdAeAfAgAhAjAkAn_Jqv(B")
("lip" "$AAT^[(B")
("lit" "$AAPAQARY}(B")
("liu" "$AAHAKACADAEAFAGAIALAMANAO`ZnI(B")
("lo" "$AB7B6B,@O@L@M@N@P@Q@TB+B-B.B/B0B1B2B3B8B:B?_k``a@iVnnoepXplo)qlt5vT(B")
("loh" "$AB^?)B\B]B_B`BaBcAJY@o](B")
("loi" "$A@4@3abqg(B")
("lok" "$A@VBd8u:Q@R@SBeBfBgK8@V(B")
("long" "$A@E@F@G@H@I@J@KA@`%rk(B")
("luen" "$AA*BMBNBOBPBRA5f.(B")
("luet" "$AAS(B")
("lui" "$ABB@o@`@[@a@Z@W@X@Y@\@]@^B@BABCBEBFBGBKBbYz`&leQ+(B")
("luk" "$AB<B9AyB=B4B5B;B>BHBL(B")
("lun" "$ABXBQBUBVBWBYBZB[AWAZA[A_j%wk(B")
("lung" "$AkJAzA{A|A}A~B!B"B#B$E*gg(B")
("lut" "$A@uBI@uBJm2(B")
("m" "$A_m(B")
("ma" "$ABiBhBmBkBjBlBnBoBp(B")
("maai" "$ABtBqBrBu(B")
("maan" "$AMrB}MmBxByB{B|B~C]w)(B")
("maang" "$AC$CLCMCOrlt;(B")
("maau" "$AD5C(C)C,C-C.C2(B")
("mai" "$ACPCQCTCUCW_d(B")
("mak" "$ABsBvD+D,D0]k_i(B")
("man" "$ANDNECqNJCrCtCuCvC%NCNFNGNIXXc}v)(B")
("mang" "$ACHCK(B")
("mat" "$ANoC[C\M`NpX?ZW(B")
("mau" "$AD3C3C}D1D2D6C/Y0(B")
("me" "$A_c(B")
("mei" "$AC@N4N2C<C>CBCDCRCSN"N6^1aRetf8pLoQt:tMv2wcwg(B")
("mi" "$A_d(B")
("mik" "$ACYci(B")
("min" "$ACfCbC`CaCcCdCeC^C_(B")
("ming" "$AC{CwC|CsCxCyCzZ$\xu$(B")
("mit" "$ACoCpsz(B")
("miu" "$ACnChCgCiCjCkClCmC*_wechCm5q:(B")
("mo" "$ANdN^D8NqD!D#D4D7D9D:D<D=C+C0C1NWN\N_NcNhNjNlNm_h_<e|pD(B")
("moh" "$AC4C4C~D"D%D&D'fVqrwb(B")
("mok" "$AD*0~D$D.D/D;C](B")
("mong" "$AC#M|MvC"C&C'MxM{M}Xh(B")
("mooi" "$AC6C5C7C9C9C:C=C?CACCwH(B")
("moon" "$ABzCGCEBwCFnMr)ug(B")
("moot" "$AD)C;D(D-\Tib(B")
("muk" "$AD>D?D@DADBXo\Ycenb(B")
("mung" "$ACICJCNcBk|t?SS(B")
("na" "$ADCDGDDDHE2oU(B")
("naai" "$ADJDKDL(B")
("naam" "$ADODP`+a0kn(B")
("naan" "$ADQ(B")
("naap" "$ADEDFDIZ+(B")
("naau" "$ADSDVDW_Nns(B")
("nai" "$AD`(B")
("nam" "$AZE(B")
("nang" "$AD\(B")
("nau" "$AE$E%E&P`f$fUqqt[(B")
("ne" "$ADX(B")
("nei" "$ADcDa6|6}D]DeDzCVl;lrnj(B")
("neung" "$ADo(B")
("ng" "$ANeNsN`NaNbNfNgNiNnNrXu`ErZwy(B")
("nga" "$AM_Q?Q@QAQCQEQHXsXt(B")
("ngaai" "$A0,QBQDXW^_(B")
("ngaak" "$A6n(B")
("ngaam" "$A0)QR(B")
("ngaan" "$AQcQUQ[(B")
("ngaang" "$AS2(B")
("ngaau" "$AO}R'X3kH(B")
("ngai" "$AN#0+D^D_N!N1N:RORURcRh_=t/t`(B")
("ngak" "$A_@(B")
("ngam" "$AbVpF(B")
("ngan" "$AHMRxv8(B")
("ngat" "$AFyRYX#Xn(B")
("ngau" "$AE#9394E:E<qn(B")
("ngit" "$ADv(B")
("ngo" "$A0A0=0>0?qz(B")
("ngoh" "$ANRNT6j6k6l6m6o6p6vE6o0(B")
("ngoi" "$A4tMb0-:R(B")
("ngok" "$A6uT@ZLoIr&@V(B")
("ngon" "$A06(B")
("ngong" "$A0:(B")
("ngung" "$ANM(B")
("ni" "$ADX(B")
("nik" "$A@yDdDg(B")
("nim" "$ADnDi(B")
("nin" "$ADj(B")
("ning" "$AD{D|D~E]E"Xz_Lqw(B")
("nip" "$ADmDsDtDwDxDyr((B")
("niu" "$ADqDrtA(B")
("no" "$AE,DTDUE+E-es(B")
("noh" "$AE3E4YP_v(B")
("noi" "$ADNDZDMDYhM(B")
("nok" "$AE5o;(B")
("nong" "$ADRH?`l(B")
("nuen" "$AD[E/(B")
("nui" "$AE.nO(B")
("nuk" "$At,(B")
("nung" "$AE'E(E)Y/_f(B")
("o" "$A?A?B`8`^f9ippb(B")
("oi" "$A0.0'0(0*fHoMv0(B")
("ok" "$A6qX,[Qc5(B")
("on" "$A020800010407o'(B")
("ong" "$A090;(B")
("ou" "$A0D0@0B0CNk(B")
("pa" "$AEB0G0RE?E@EChK(B")
("paai" "$AEEEFEIY=(B")
("paak" "$A0XFGFIE>EAEDgj(B")
("paan" "$A0bEJEN(B")
("paang" "$AEl0tEkEmEoEpErEt`X(B")
("paau" "$AEZEY1*EWEXE\E](B")
("pai" "$AEz(B")
("pan" "$A1tEgF5F6(B")
("pang" "$AF>Es(B")
("pat" "$AF%qb(B")
("pei" "$AF)F$1IExE{E}F#F&F(E^X'Xrf>hAnk(B")
("pek" "$AE|(B")
("pik" "$A1YEyF'q1(B")
("pin" "$A1i1`F*F+F,F-ry(B")
("ping" "$AF4F=EjF;3REiF8F9F:F<F?F@FAY7f0f3fi(B")
("pit" "$AF2F3X/k-(B")
("piu" "$AF11lF.F/F0Xb`QfNih(B")
("po" "$AFWFU1'8,FLFNFOFQFTFVE[Yid_oh(B")
("poh" "$AFFFEFDXOn^p+uK(B")
("pok" "$AFKFS`[od(B")
("pong" "$AET0r0v0x0yESEUdhs&(B")
("pooi" "$A16EdE`EaEbEcEeEfEwFPEGE_oBv,(B")
("poon" "$AELEKEP0hEhEM(B")
("poot" "$AFCn`(B")
("puk" "$AFM(B")
("pung" "$AEnEqEuEv(B")
("sa" "$AHwI/I0I3I4K#X&Xm`DtDvh(B")
("saai" "$AI9acgtsB(B")
("saam" "$AH}H}I@nL(B")
("saan" "$AI=I"4[I]I:I>IGU$d}cEf)t.uG(B")
("saang" "$AJ!Iz(B")
("saap" "$A;xTQTRv.(B")
("saat" "$AHvHxI1I2I7o](B")
("saau" "$AGJIRISITIZt9(B")
("sai" "$AO8NwJFJ@JDJEJII8NxPvO,O4tQ(B")
("sak" "$AH{`g(B")
("sam" "$APDIuIrIs3;3@InItIxJ2I-a/(B")
("san" "$AIqPBIm3?Ij3<3=IiIkIlIoIpIvIwP=P?PA(B")
("sang" "$AIzI{I|(B")
("sap" "$AJ.J*J0I,(B")
("sat" "$AJ'J5J-JRI*O%(B")
("sau" "$APbPeJV3p3nJUP^JWJXJ[J\JYJZJ]J^J~KQKRKTP_Pc[E],`2awoKt<(B")
("se" "$AP4IgIdP)IaIbI6I^I_P6P:Y\wj(B")
("sei" "$AKDK@(B")
("sek" "$AJ/K6N}(B")
("seng" "$APHIy(B")
("seuk" "$AOwne(B")
("seung" "$AK+K*O`IOILOk3#3"3%ILIKIMIPIQOaObOdOeOfadfOfWidlX(B")
("si" "$AKAJBJGJPJ1J9J>J+J7K<J?J&JSJ(J)J,J:J;JHJKJLJOJTK9K:K;K=K>K?VEXKZV_1_PnfoHty3Wm'(B")
("sik" "$AI+O'NvJ=O"JNJMJJJ3J4J6JCNtNzN}O$O(O1ixp*o$rat*s,(B")
("sim" "$AIA2uI;IBf?iilx(B")
("sin" "$AOHO_I?ICIEIFIHIIO3OIOJOYO[Q"Y~Y;k/tLs5v1(B")
("sing" "$A3GIyJ$PJPTI}3P3I3K3OJ%J"I~J#PGPIPQPUX)nqPHV;(B")
("sip" "$AIcIeIf(B")
("sit" "$AGTI`P(P9P<Q&oF(B")
("siu" "$AP!P&P%OzIYUWO{IUIXI[I\OtOuOvO|UXso(B")
("so" "$AKUKXJ}I&I'I(I)KSKVK\K]K_`<vUPkVBVF(B")
("soh" "$AKyJ_JaJhI5KrKsKtKvKx_o`Bf6tH(B")
("soi" "$AHyHz(B")
("sok" "$AKwK7`;`J(B")
("song" "$AI#I$I%K,r*(B")
("sue" "$AJiJbJdJsJ`JcJfJmJnJrJwJyJzJ|K]X-(B")
("suen" "$AKcKaW-Ko4,KbKpK1P{P}Q!h/(B")
("suet" "$AK5Q)(B")
("sui" "$APkK.K0KdPh494a4b4cHpJ{KgKhKiKjKkKlKmKnK%K'K-K/PuPw]Medegqc(B")
("suk" "$AJeK`JtJgJjJkJlJqKuKZK[K^YmY?[S^#(B")
("sun" "$APEQ84<4=4>4?KqK2K3K4Q/Q1Q3Q4Q6Q7W;\wa_(B")
("sung" "$AKI3gKJKKKMKNdAaTq5V;(B")
("sut" "$APtJuJvK$Pgs0(B")
("ta" "$AK{K|K}nh(B")
("taai" "$AL+L,4v4{L)L+L-_>nQ(B")
("taam" "$AL8L0L5L6L7L=q{(B")
("taan" "$AL>L/L1L2L3L4L9L;L<L?f'l~(B")
("taap" "$AKzK~L#L.e](B")
("tai" "$ALeLaLbm{5L5Y5^L]L`LcLdLfLgLiLjLkZPf7(B")
("tan" "$AML(B")
("tang" "$ALZLYkx(B")
("tau" "$AM7M5M6M8(B")
("tek" "$AL_(B")
("teng" "$AL|M'(B")
("tik" "$AL^LhYCl}o+(B")
("tim" "$A5kLmLpLqLriem,wQ(B")
("tin" "$ALl5a5hLnLoLs(B")
("ting" "$AM"M#L}L~M$M%M&QQfCnzrQv*(B")
("tip" "$ALyL{(B")
("tit" "$ALz(B")
("tiu" "$ALu5wLtLwLxY,lvo"q;tPv6(B")
("to" "$ALU_{LMM@M>MBMALWM<MC6G585;LNLOLPLQLRLSLTLVM=M?]1_6h:lbnJ(B")
("toh" "$A6fMOMRMSMTMUMVMWMYY"c{(B")
("toi" "$AL%L(4y5]L&L'(B")
("tok" "$AMPMXuE(B")
("tong" "$ALALFL@LBLCLDLELGLHLILJLKLLYNlYqmtJs+u1(B")
("tuen" "$AME6ZMMMN(B")
("tuet" "$AMQ(B")
("tui" "$AMHMFMGMIMJMK(B")
("tuk" "$AM:(B")
("tun" "$A6\(B")
("tung" "$AM(M,M4M3L[L\M)M*M+M-M.M/M0M1M2Y]YWYZ`LkXt>(B")
("uk" "$AN]dW(B")
("wa" "$AM[;);-;*;0FhM\M]M^n|(B")
("waai" "$A;5;3;4Ma(B")
("waak" "$A;r;-;s;.(B")
("waan" "$AMe;9;7;<;B;CMdMgMlviMfG'(B")
("waang" "$A:a(B")
("waat" "$A;+;,MZ(B")
("wai" "$A;YN*REN=N;N'N(N,;`;d;1;[;\;]M~N$N%N&N)N+N-N.N/N0N3N5N7N8N9N<N>N?N@YK`0(B")
("wan" "$ATFTKTONBTH;j;k;lNANHR|TETGTITJTLTMTNZ;\?ifk5(B")
("wang" "$A:j:k(B")
("wat" "$AG|>s(B")
("wik" "$ASr(B")
("wing" "$AS@HSHYS1S=S>aIr#(B")
("woh" "$A:M9x:L;vNONPNQYAf4q=(B")
("wok" "$A;qXeol(B")
("wong" "$AaeMy;F;G;H;I;J;K;L;MMtMuMwMz(B")
("woo" "$ANZN[:~:|:z:w:x:y:{:};];$;%;&;'NXNYSsY|b)d0lhlo(B")
("wooi" "$A;X;a;c;2;W(B")
("woon" "$AMf;;;:;8;=;>;@;AMcMkMnMsT+T.X(X`(B")
("woot" "$A;n(B")
("ya" "$AR2(B")
("yai" "$AR7W'(B")
("yam" "$ARtHNR{GUA^HIHQRqRuRwRy`3l'q?v/(B")
("yan" "$AP@HK6wHLR}S!RrPFHJHPHRPCRpRsRvRzR~TPS]UgX7Xp_Ek3nwr>(B")
("yap" "$AHkF|R>RX]0(B")
("yat" "$AR;HUR<R]RgX}Y+oW(B")
("yau" "$AGpGqSPSISHSVGuH`HaP]SDSESFSGSJSKSLSMSNSOSQSRSSSTSUSWY'_O_]i`k;nprGvOwnwx(B")
("ye" "$AR9HGR,R.R/R0R1Y<(B")
("yeuk" "$AT>ZJT<T;HuE0E1HtR)T?Y_(B")
("yeung" "$AQlQyQkHAQsDpH@HBHCQjQmQnQoQpQqQrQtQuQvQwQxQza`l|m&w1(B")
("yi" "$AR=RP6{6y6~RTRFRb6xReRWRlRiRIRKRjbyRQ6zDbR?R@RARBRCRDRGRHRJRLRMRNRSR^XfY&\2`f_W_^dtg2ill=noonwp(B")
("yik" "$ARZRVRmDfR4R8R:R[R\R_R`RdRfRkRnRo^D^HfdrfRW(B")
("yim" "$AQOQWH=H>OSQaQfQiQKQMQNQVQYQZQ^X_Y2(B")
("yin" "$AOROVQTQ`H;QPQLH<OMOOOQQbQdQeQgQhQIQJQSQ]Q_YpZ]dNe{fLkYs[wz(B")
("ying" "$AS"S0PNPMHOD}HTS&PLPOS#S$S%S'S(S)S*S+S,S-S.S/S3XMYx`Se-pP(B")
("yip" "$AR6R5R3Du(B")
("yit" "$AHHR-ZKt+(B")
("yiu" "$AHFQ|R*R+HEQ{Q}Q~R!R"R#R%R&R(X2_:afahf,(B")
("yoh" "$AS4`!(B")
("yue" "$ASkSZSjSoSZHgShH#HcHdHeHfHiHjS`SaSbScSdSeSfSgSiSlSmSnSpSuSvSwSxSySzS~T"T#T$T%T&SXSYS[S\S]S^S_X.XqZM`if%pvo(r,q>qAt't(sDv'v9(B")
("yuen" "$AT'T6T1MjT-T*QX4*HmHnG&MhMiMoMpMqP|P~OXQ#T(T)T,T/T0T2T3T4T5T7T8T9T:\>k<ngp0(B")
("yuet" "$ATBQ(TAT=RRTCTD_\nFna(B")
("yui" "$AHoHqP>Ra(B")
("yuk" "$ASqS}HbHhHlNVPqStS{S|T!X9ewgojEnZ(B")
("yun" "$AHrHs(B")
("yung" "$AS?S9o^SCSBHZH]HVHWHXH[H\H^H_NKNLS5S6S7S8S:S;S<SAY8`/g_iEp.(B")
("\\a" "$A#,!##?!"#:#;!.!/!0!1!4!5#(#)!:!;!>!?#-#_(B $A#1#2#3#4#5#6#7#8#9#0#!#@##!g#%!D#&#*)&#+#=)$(B")
("\\beng" "$Ap\p]p^@zp`papcpdpepfpgphpipjpmpnpopppqprpsptpupwpypzp{p|p}p~q!q"q#q$q%q&q'q(q)q*q+q,q-q.q/q0q3(B")
("\\booi" "$AjZj[j\j]j^j_j`jajcjdjejfjg(B")
("\\che" "$Aiminioiqiritiuiviwiyizi{i|i~j!j"j#j$j&(B")
("\\chi" "$Aorosot(B")
("\\chung" "$Ar1r2r3r4r5r6r7r8r:r;r@rArBrCrDrErHrIrJrKrLrMrNrOrPrRrSrUrVrWrXrYr[r\r]r^r`rbrdrergrhrirjrmrnrorqrsrtrurvrwrxrzr{r|r}r~s]s"s#s$s%s's(s)s*s-s.s1s2s3s4s6s7s8s9s:s;s<s=(B")
("\\faat" "$AwTwUwVwWwXwYwZw[w\w]w^w_(B")
("\\foh" "$Al>l?l@lAlBlClDlElFlGlHlIlJlKlLlMlNlOlPlQlSlTlUlVlWlZl[l\l]l^l_l`(B")
("\\fong" "$Al7l8l9l:l<(B")
("\\fung" "$Al)l,l-l.(B")
("\\gaak" "$Aw3w4w5w6w7w8w9(B")
("\\gam" "$AnRnSnTn_nto`obofo&o*o/o2o3o6o:oAoCoDoGoJoLoRo[o\vFvGvHvIvJvKvLvM(B")
("\\gan" "$A`x`y`z`{`|`}`~a]a"a#a$a%a&(B")
("\\gau" "$Aalamanaoapaqarasatauavaxayaza{a|a}a~b!b"b#b$b%b&b'b(b*b+b,b-b.b/b0b1b2b3b4b5(B")
("\\gin" "$Ajhjijjjkjljmjnjo(B")
("\\gok" "$Auzu{u|u}u~v!v"v#(B")
("\\gwa" "$Ap,p-(B")
("\\gwai" "$AwIwJwKwLwMwN(B")
("\\gwoh" "$Aj(j)j+j,j.j/(B")
("\\hau" "$A_~`$`:`W`h`k_C_T_U_[__(B")
("\\him" "$Al#l$l%l&l((B")
("\\jau" "$At-t0t8tqtrtstttut{t|t}t~u]u"u#u%u&u'u(u)u*u+u,u-u.u/u0u2u3u4u5u6u7u8(B")
("\\juk" "$Au`uaucudueufuhujukulumunuoupuqurusu;u<u=u>u?u@uAuBuCuDuFuHuIuJuLuMuNuOuPuQuRuTuUuVuWuYuZu[u\u]u^u_(B")
("\\jukfa" "$As`sasbscsdsesfsgshsisjskslsmsnspsqsrssstsusvswsxsys{s|s}s~t!t"t#t$t%t&sGsHsIsJsKsLsMsOsPsQsSsTsUsVsWsXsYsZs\s_(B")
("\\kwat" "$Aw`wiw:w=w>w?wAwBwDwEwFwG(B")
("\\lai" "$Alp(B")
("\\ma" "$Af`fafcfefffhfkflfmfnfofpfqfsftfufvfwfx(B")
("\\mo" "$Ak#k$k%k&k'k(k)k*k+k,(B")
("\\moon" "$AcFcGcHcIcJcKcLcMcNcOcPcQcRcScTcUcVcWcXcYc[(B")
("\\muk" "$Ah;h<h>h?h@hBhDhEhFhGhHhIhLhNhOhPhQhRhShThUhVhWhXhYhZh[h\h]h^h_h`hahbhchdhehfhghhhihjhkhlhmhohphqhthuhvhwhxhyhzh{h|h}h~iai]i"i#i$i%i&i'i(i)i*i+i,i-i.i/i0i1i2i3i4i5i6i7(B")
("\\nga" "$Aj1j2j3j4j5j6(B")
("\\ngaan" "$Amlmmmnmompmqmrmsmtmumvmwmxmymzm|m}m~n!n"n#n$n%n&n(n)n*n+n,n-n7n8n9n:n;n<n=n>n?n@(B")
("\\ngau" "$Ajpjqjrjsjtjujvjwjxjyjzj{(B")
("\\niu" "$Ap4p5p6p7p8p9p:p;p<p=p>p?p@pApBpCpEpGpHpIpJpKpMpNpOpRpSpTpUpVpW(B")
("\\nooi" "$Af#f+_8f:f<f@fAfBfDfFfGfJfKfMfPfQfSfT(B")
("\\pao" "$Auvuwuxuy(B")
("\\saan" "$Aa(a)a,a-a.a1a2a3a4a5a6a8a9a:a;a<a=a>aAaBaCaDaEaFaGaHaJaKaLaNaOaPaQaSaUaVaWaXaYaZ(B")
("\\sam" "$Ababbbcbdbebfbgbhbibkblbmbnbobpbqbrbsbtbubvbwbxbzb{b}b~c]c"c#c$c%c&c'c(c)c*c+c,c-c.c/c0c1c2c3c4c6c7c8c9c:c;c<c=c>c?c@cA(B")
("\\sam" "$Am]m"m#m$m%m'm(m)m*m+m-m.m/m0(B")
("\\sau" "$A^Q^R^S^T^U^W^X^Y^Z^\^]^^^`^a^b^c^d^e^f^g^h^i^k^l^m^n^o^p^q^r^s^t^u^v^w^x^y^z^{^|^}^~_"_#_$_%_&_'_(_)_*_+_,_-j|j}j~k]k"(B")
("\\sek" "$Am6m7m8m9m:m;m<m=m>m?m@mAmBmCmDmEmFmGmHmImJmKmLmMmNmOmPmQmRmSmTmUmVmWmXmYmZm[m\m]m^m_m`mambmcmdmemfmg(B")
("\\si" "$Afzf|f}f~g]g"g#g$g%g&g'g(g)g*g+g,g-g.g/g0g1g3g4g5g6g7g8g9g:g;g<g=g>g?g@gAgBgCgDgEgFgGgHgIgJgKgLgMgNgOgPgQgRgSgTgU=*gWgXgYgZ(B")
("\\sik" "$AwOwPwSb<b=b>b?b@bAbBbCbDS`bFbGbHbIbJbKbLbMbN(B")
("\\teng" "$Ae`eaeBeCeDeEeFeGeHeIeJeLeMeNeOePeQeReTeUeVeWeXeYe[e\e^(B")
("\\tin" "$An.n0n1n2n3n4n5n6(B")
("\\to" "$A[a[b[c[d[e[f[g[h[i[j[k[l[m[n[o[p[q[r[s[t[u[v[w[x[y[z[{[|[}[~\!\"\#\$\%\&\'\(\)\*\+\,\-\.\/\1[P[R[T[U[W[X[Y[[[\[][^[_(B")
("\\wai" "$A`n`o`p`q`r`s`t`u`v`w(B")
("\\woh" "$Ap$p&ouovowoxoyozo{o|o}o~p!p"p#(B")
("\\wong" "$Ag`gagbgcgdgfghgigkglgmgngpgqgrgsgugvgxgygzg{g|g}g~h!h"h#h$h%h'h(h)h*h+h,h-h.h/h0h1h2h3h4h5h6h7(B")
("\\woo" "$Alflgli(B")
("\\yan" "$AXkX|Y`YaY#Y6YHYXY[Y](B")
("\\yat" "$Aj8j9j:j<j=j>j?j@jAjBjCjDjFjGjHjIjJjKjNjOjPjQjRjSjTjUjVjWjY(B")
("\\yi" "$AqCqDqEqFqGqHqIqJqKqLqMqNqOqPqQqRqSqTqUqVqWqXqYqZq[q]q^q_q`qa(B")
("\\yider" "$AZcZgZhZiZjZkZlZmZnZoZpZqZrZsZtZuZvZwZxZyZzZ{Z|Z}Z~[]["[#[$[%[&['[([)[*[+[,[-[.[/[0[1[2[3[4[5[7[8[9[:(B")
("\\yin" "$AZ&Z'Z(Z)Z*Z,Z-Z.Z0Z1Z2Z3Z4Z5Z7Z8Z9Z:Z=Z?Z@ZAZBZCZDZFZGZHZNZRZSZTZUZYZ[(B")
("\\yoo" "$AvPvQvRvSvVvXvYvZv[v\v]v^v_vavbvcvdvevfvgvkvmvnvovpvqvrvsvtvuvvvwvxvyvzv{v|v}v~w]w#w$w%w&w'w(w*w+w,w-w.w/(B")
("\\yuk" "$Al"k`kakbkckdDrkfkgkikjkkkmkokpkqkrksktkvkykzk{k~l!k>k?k@kBkCkDkEkFkGkIkKkLkMkOkQkRkSkTkUkVkWk[k\k]k^k_(B")
)
