/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jde.debugger.CommandEvent;
import jde.debugger.CommandListener;
import jde.debugger.Debugger;
import jde.debugger.Etc;
import jde.debugger.EventSetEvent;
import jde.debugger.EventSetListener;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.gui.LVTreeNode;

class LocalVariableDisplay
extends JPanel
implements Protocol {
    private final JTree m_tree;
    private final JLabel m_message;
    private final DefaultMutableTreeNode m_root = new DefaultMutableTreeNode();
    private final Color m_defaultLabelColor;
    private final Debugger m_debugger;
    private final Collection m_interestingCommands;

    public LocalVariableDisplay(Debugger debugger) {
        super(new BorderLayout());
        this.m_tree = this.createJTree(this.m_root);
        this.m_tree.setRootVisible(false);
        this.m_debugger = debugger;
        this.m_interestingCommands = new HashSet();
        this.m_interestingCommands.add("stack_frame");
        JScrollPane scroll = new JScrollPane(this.m_tree, 20, 30);
        scroll.setColumnHeaderView(new JLabel("Local Variables", 0));
        this.add((Component)scroll, "Center");
        this.m_message = new JLabel();
        this.m_defaultLabelColor = this.m_message.getForeground();
        this.add((Component)this.m_message, "South");
        debugger.addEventSetListener(new EventSetListener(){

            public void eventSetReceived(EventSetEvent evt) {
            }

            public void debuggerSuspended(EventSetEvent evt) {
                LocalVariableDisplay.this.updateVariables(evt);
            }

            public void debuggerResumed(EventSetEvent evt) {
            }
        });
        debugger.addCommandListener(new CommandListener(){

            public void commandReceived(CommandEvent evt) {
                LocalVariableDisplay.this.updateVariables(evt);
            }
        });
        JDE.debug(64, "LocalVariableDisplay registered EventSetListener.");
    }

    private void updateVariables(EventSetEvent evt) {
        JDE.debug(64, "updateVariables()");
        try {
            this.p_message("");
            ThreadReference tRef = evt.getThreadReference();
            if (null == tRef) {
                throw new JDEException("No thread with event");
            }
            this.updateVariables(tRef, 0);
        }
        catch (JDEException exc) {
            this.p_error(exc.getMessage());
        }
    }

    private void updateVariables(CommandEvent evt) {
        JDE.debug(64, "updateVariables(" + evt.getCmdName() + ")");
        try {
            this.p_message("");
            if (!this.m_interestingCommands.contains(evt.getCmdName())) {
                return;
            }
            if (evt.getArgs().size() != 2) {
                throw new JDEException("Incorrect number of arguments: " + evt);
            }
            Long uniqueID = Etc.safeGetLong(evt.getArgs().get(0), "thread ID");
            int frameIndex = Etc.safeGetint(evt.getArgs().get(1), "frame index");
            ObjectReference oRef = this.m_debugger.getStore().get(uniqueID);
            if (oRef == null) {
                throw new JDEException("No such thread exists");
            }
            if (!(oRef instanceof ThreadReference)) {
                throw new JDEException("Object is not a thread");
            }
            ThreadReference tRef = (ThreadReference)oRef;
            this.updateVariables(tRef, frameIndex);
        }
        catch (JDEException exc) {
            this.p_error(exc.getMessage());
        }
    }

    private void updateVariables(ThreadReference tRef, int frameIndex) throws JDEException {
        if (!tRef.isSuspended()) {
            throw new JDEException("Thread " + tRef + " not suspended");
        }
        StackFrame frame = null;
        try {
            frame = tRef.frame(frameIndex);
        }
        catch (IncompatibleThreadStateException ex) {
            throw new JDEException("Thread is not suspended");
        }
        catch (IndexOutOfBoundsException ex) {
            throw new JDEException("Invalid stack frame");
        }
        catch (ObjectCollectedException ex) {
            throw new JDEException("The frame has already been garbage collected");
        }
        if (frame == null) {
            throw new JDEException("Error ascertaining frame");
        }
        try {
            final ObjectReference thisRef = frame.thisObject();
            final List<LocalVariable> visibleVariables = frame.visibleVariables();
            final Map<LocalVariable, Value> localVariableValues = frame.getValues(visibleVariables);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LocalVariableDisplay.this.updateVariablesOnSwingThread(thisRef, visibleVariables, localVariableValues);
                }
            });
        }
        catch (AbsentInformationException ex) {
            throw new JDEException("Local variable information not available: compile with -g");
        }
        catch (NativeMethodException ex) {
            throw new JDEException("Can't access local variables in native methods");
        }
        catch (InvalidStackFrameException ex) {
            throw new JDEException("Stack frame no longer valid");
        }
        catch (InconsistentDebugInfoException ex) {
            throw new JDEException("Inconsistent debug information: " + ex.getMessage());
        }
    }

    private void updateVariablesOnSwingThread(ObjectReference thisRef, List visibleVariables, Map localVariableValues) {
        try {
            boolean reload = false;
            DefaultTreeModel model = (DefaultTreeModel)this.m_tree.getModel();
            HashSet<Integer> updated = new HashSet<Integer>();
            int previousSize = this.m_root.getChildCount();
            reload = previousSize == 0;
            try {
                try {
                    if (null != thisRef) {
                        LVTreeNode thisNode = this.getThisNode();
                        String thisType = thisRef.referenceType().name();
                        if (null == thisNode || !thisNode.getTypeName().equals(thisType)) {
                            MutableTreeNode node = LVTreeNode.makeTreeNode("this", thisType, thisRef, model);
                            JDE.debug(64, "made this: isLeaf=" + node.isLeaf() + ", childCount=" + node.getChildCount() + "\n\tnode=" + node);
                            model.insertNodeInto(node, this.m_root, 0);
                            ++previousSize;
                        } else {
                            thisNode.setValue(thisRef);
                        }
                        updated.add(new Integer(0));
                    }
                    Iterator iter = localVariableValues.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        LocalVariable localVariable = (LocalVariable)entry.getKey();
                        Value value = (Value)entry.getValue();
                        LVTreeNode node = this.getVariableNode(localVariable);
                        if (null == node) {
                            MutableTreeNode newNode = LVTreeNode.makeTreeNode(localVariable, value, model);
                            model.insertNodeInto(newNode, this.m_root, this.m_root.getChildCount());
                            continue;
                        }
                        node.setValue(value);
                        updated.add(new Integer(this.m_root.getIndex(node)));
                    }
                    JDE.debug(64, "added values to tree, updated=" + updated);
                    int index = previousSize - 1;
                    while (index >= 0) {
                        if (!updated.contains(new Integer(index))) {
                            MutableTreeNode mutNode = (MutableTreeNode)this.m_root.getChildAt(index);
                            model.removeNodeFromParent(mutNode);
                        }
                        --index;
                    }
                }
                catch (InvalidStackFrameException ex) {
                    throw new JDEException("Stack frame no longer valid");
                }
                catch (InconsistentDebugInfoException ex) {
                    throw new JDEException("Inconsistent debug information: " + ex.getMessage());
                }
                Object var15_18 = null;
                if (reload) {
                    model.reload();
                }
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (reload) {
                    model.reload();
                }
                throw throwable;
            }
        }
        catch (JDEException exc) {
            this.p_error(exc.getMessage());
        }
    }

    private void p_error(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LocalVariableDisplay.this.m_message.setText(msg);
                LocalVariableDisplay.this.m_message.setForeground(Color.red);
            }
        });
    }

    private void p_message(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LocalVariableDisplay.this.m_message.setText(msg);
                LocalVariableDisplay.this.m_message.setForeground(LocalVariableDisplay.this.m_defaultLabelColor);
            }
        });
    }

    private LVTreeNode getThisNode() {
        if (this.m_root.getChildCount() == 0) {
            return null;
        }
        TreeNode node = this.m_root.getChildAt(0);
        if (!(node instanceof LVTreeNode)) {
            return null;
        }
        LVTreeNode thisNode = (LVTreeNode)node;
        if (thisNode.getName() != "this") {
            return null;
        }
        return thisNode;
    }

    private LVTreeNode getVariableNode(LocalVariable local) {
        int index = 0;
        while (index < this.m_root.getChildCount()) {
            LVTreeNode varNode;
            TreeNode node = this.m_root.getChildAt(index);
            if (node instanceof LVTreeNode && (varNode = (LVTreeNode)node).getName().equals(local.name())) {
                return varNode;
            }
            ++index;
        }
        return null;
    }

    private JTree createJTree(DefaultMutableTreeNode root) {
        JTree tree = new JTree(root){

            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof LVTreeNode) {
                    LVTreeNode node = (LVTreeNode)value;
                    return node.getName() + " (" + node.getTypeName() + ") " + node.getValue();
                }
                return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            }
        };
        tree.setLargeModel(true);
        return tree;
    }

    private static void dumpTree(TreeNode node) {
        JDE.debug(64, "tree dump");
        LocalVariableDisplay.dumpTree(node, "");
    }

    private static void dumpTree(TreeNode node, String prefix) {
        if (node instanceof LVTreeNode) {
            LVTreeNode lvt = (LVTreeNode)node;
            JDE.debug(64, prefix + lvt.getName());
        } else {
            JDE.debug(64, prefix + node.toString());
        }
        prefix = prefix + ".";
        int index = 0;
        while (node.getAllowsChildren() && index < node.getChildCount()) {
            LocalVariableDisplay.dumpTree(node.getChildAt(index), prefix);
            ++index;
        }
    }
}

