/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: Vertex.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef VERTEX_H
#define VERTEX_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <vector>
#include <cmath>
#include <string>
#include <map>
#include "Vector3.h"
#include "Color.h"

namespace Animorph {

class Vertex
{
protected:
  std::vector <int> shared_faces_vector;

public:
  /// vertex coordinate
  Vector3f co;	  

  /// vertex normal
  Vector3f no;  
  
  // vertex color
  //Color color;  

  Vertex () : co(), no() {co.zero (); no.zero ();}

  /// construct Vertex with coordinates
  /*!
   * \param x the x component to the vertex coordinate
   * \param y the y component to the vertex coordinate
   * \param z the z component to the vertex coordinate
   */
  Vertex (float x, float y, float z)
  : co(x,y,z), no()
  {
    no.zero ();
  }

  /*!
   * \param shared_face add the index number to which face this Vertex belongs
   */
  void addSharedFace (int shared_face);

  /*!
   * \return get a vector with all faces this Vertex belongs to
   */
  std::vector <int> &getSharedFaces ();
};

}

#endif	// VERTEX_H
