/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: ObjExporter.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef OBJEXPORTER_H
#define OBJEXPORTER_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <iostream>
#include <fstream>
#include "Mesh.h"
#include "Matrix.h"
#include "util.h"

using std::ostringstream;
using std::string;

namespace Animorph {

class ObjExporter
{
protected:
  Mesh &mesh;
  Matrix tm;

  void createOBJStream (ostringstream &out_stream, const string& basename, bool usemtl = true);
  void createMTLStream (ostringstream &out_stream, const string& basename);

public:
  /*!
   * \param _mesh construct ObjExporter from a Mesh object
   */
  ObjExporter (Animorph::Mesh &_mesh) : mesh (_mesh)
  {
    tm.identity ();
  }

  /*!
   * \param tm the Matrix which transformates the Mesh before exporting
   */
  void setTransformationMatrix (Matrix &tm) {this->tm = tm;}

  /// export the Mesh in OBJ file and MTL file with same name, but ending .mtl
  /*!
   * \param filename the file to save
   * \return true if file is saved
   * \return false if file couldn't be saved   
  */
  bool exportFile (const string& filename);
};

}

#endif	// OBJEXPORTER_H
