/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: Face.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef FACE_H
#define FACE_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <vector>
#include <list>
#include <assert.h>
#include "Vector3.h"
#include "Vector2.h"
#include "Vertex.h"
#include "Color.h"

namespace Animorph {

class Face
{
private:
  int vertices[4];
  int size;
  int material_index;

public:
  /// the normal vector of this face
  Vector3f no;

  /// construct a quad
  Face (int v0, int v1, int v2, int v3);

  /// construct a triangle
  Face (int v0, int v1, int v2);
  
  /*!
   * \return index of the material in MaterialVector
   */
  int getMaterialIndex () const {return material_index;}

  /*!
   * \param material_index index of the material in MaterialVector
   */
  void setMaterialIndex (int material_index) {this->material_index = material_index;}

  /*!
   * \return a vector with all vertex numbers for this face
   */
  size_t getSize() const {return size;}

  size_t getVertexAtIndex(int inIndex) const 
    {   assert(inIndex<size);
        return vertices[inIndex];}


};

}

#endif	// FACE_H
