<?php
	/**
	 * Rules Module
	 */
	class RulesListModule extends ListModule
	{	
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function RulesListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getRulesProperties();
		
			// Default Columns
			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "name", true, 0, _("Rule name"), _("Sort on rule name"));
			$this->addColumn($this->tablecolumns, "enabled", true, 1, _("Rule enabled"), _("Sort on rule enabled"));

			parent::ListModule($id, $data, array());

			$this->sort = array();
			$this->sort[$this->properties["rule_name"]] = TABLE_SORT_ASCEND;
		}
		
		/**
		 * Executes all the actions in the $data variable.
		 * @return boolean true on success of false on fialure.
		 */
		function execute()
		{
			$result = false;
			
			foreach($this->data as $action)
			{
				switch($action["attributes"]["type"]) {
				case 'list':
					$store = $this->getActionStore($action);
				
					$rules = $this->ruleList($store, $action);
					
					if($rules) {
						$result = true;

						$rules["attributes"] = array("type" => "list");
						
						$storeProps = mapi_msgstore_getprops($store, array(PR_IPM_WASTEBASKET_ENTRYID));
						$wastebasket_entryid = $storeProps[PR_IPM_WASTEBASKET_ENTRYID];
						$rules["wastebasket_entryid"] = array("attributes"=>array("type"=>"binary"), "_content"=>bin2hex($wastebasket_entryid));

						array_push($this->responseData["action"], $rules);
						$GLOBALS["bus"]->addData($this->responseData);
					};
					break;
				case 'setRules':
					$store = $this->getActionStore($action);

					if (isset($action["rules"])){
						$this->setRules($store, $action["rules"]);
					}
					break;
				}
			}
			
			return $result;
		}
		
		function ruleList($store, $action)
		{
			$rules = $GLOBALS["operations"]->getRules($store, $this->properties);
			
			$data["item"] = $rules;
			
			$data["column"] = array(
								array("id" => "rule_id", "visible" => false, "name" => _("Id"),      "title" => _("Sort on Id"),      "order" => 0 ),
								array("id" => "rule_state", "visible" => true, "title" => _("Sort on Enabled"), "order" => 0, "type" => "checkbox|ST_ENABLED", "length" => 22 ),
								array("id" => "rule_name", "visible" => true, "name" => _("Name"),    "title" => _("Sort on Name"),    "order" => 0, "length" => 400 ),
							  );
			
			return $data;
		}
		
		function setRules($store, $rules)
		{
			$result = $GLOBALS["operations"]->updateRules($store, $rules, $this->properties);
		}
	}
?>
