<?php
	/**
	 * Print List Module
	 * @author Saket Patel <s.patel@zarafa.com>
	 */
	
	class PrintListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function PrintListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getAppointmentProperties();
			
			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "icon_index", true, 0, _("Icon Index"), _("Sort on Icon Index"));
			$this->addColumn($this->tablecolumns, "subject", true, 1, _("Subject"), _("Sort on Subject"), PERCENTAGE);
			$this->addColumn($this->tablecolumns, "start", true, 2, _("Startdate"), _("Sort on Startdate"));
			$this->addColumn($this->tablecolumns, "end", true, 3, _("Enddate"), _("Sort on Enddate"));
			$this->addColumn($this->tablecolumns, "recurring", true, 4, _("Recurring"), _("Sort on Recurring"));
			$this->addColumn($this->tablecolumns, "busystatus", true, 5, _("Busy Status"), _("Sort on Busy Status")); 
			$this->addColumn($this->tablecolumns, "categories", false, 4, _("Categories"), _("Sort On Categories"));

			parent::ListModule($id, $data);

			$this->sort = array();
			$this->sort[$this->properties["startdate"]] = TABLE_SORT_ASCEND;
			
			$this->start = 0;
		}

		/**
		 * Function which retrieves a list of calendar items in a calendar folder
		 * @param object $store MAPI Message Store Object
		 * @param string $entryid entryid of the folder
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure
		 * this function is called from execute function on class.listmodule.php	 		 
		 */
		function messageList($store, $entryid, $action)
		{
			$result = false;
			
			if($store && $entryid) {
				$type = false;
				
				if(isset($action["restriction"])) {
					if(isset($action["restriction"]["startdate"])) {
						$this->startdate = (int) $action["restriction"]["startdate"];
					}
					
					if(isset($action["restriction"]["duedate"])) {
						$this->enddate = (int) $action["restriction"]["duedate"];
					}
				}
				
				if($this->startdate && $this->enddate) {
					$data = array();
					$data["attributes"] = array("type" => "list");
					$data["column"] = $this->tablecolumns;
					$data["item"] = $this->getCalendarItems($store, $entryid, $this->startdate, $this->enddate);
	
					array_push($this->responseData["action"], $data);
					$GLOBALS["bus"]->addData($this->responseData);
				}
			}
			
			return $result;
		}
			
		/**
		 * Function to return all Calendar items in a given timeframe. This
		 * function also takes recurring items into account.
		 * @param object $store message store
		 * @param object $calendar folder
		 * @param date $start startdate of the interval
		 * @param date $end enddate of the interval
		 */
		function getCalendarItems($store, $entryid, $start, $end)
		{
			$items = Array();
		
			$restriction = 
						// OR
						// (item[end] >= start && item[start] <= end) ||
						Array(RES_OR,
								 Array(
									   Array(RES_AND,
											 Array(
												   Array(RES_PROPERTY,
														 Array(RELOP => RELOP_GE,
															   ULPROPTAG => $this->properties["duedate"],
															   VALUE => $start
															   )
														 ),
												   Array(RES_PROPERTY,
														 Array(RELOP => RELOP_LE,
															   ULPROPTAG => $this->properties["startdate"],
															   VALUE => $end
															   )
														 )
												   )
											 ),
									   // OR
									   Array(RES_OR,
											 Array(
												   // OR
												   // (EXIST(recurrence_enddate_property) && item[isRecurring] == true && (item[end] < item[start] || item[end] >= start))
												   Array(RES_AND,
														 Array(
															   Array(RES_EXIST,
																	 Array(ULPROPTAG => $this->properties["enddate_recurring"],
																		   )
																	 ),
															   Array(RES_PROPERTY,
																	 Array(RELOP => RELOP_EQ,
																		   ULPROPTAG => $this->properties["recurring"],
																		   VALUE => true
																		   )
																	 ),
															   Array(RES_OR,
															   		// This is a hack. If we can see that the enddate_recurring is BEFORE the startdate, 
															   		// then the enddate_recurring is bogus and we should ignore it!
															   		Array(
																		Array(RES_COMPAREPROPS,
																			Array(RELOP => RELOP_LT,
																				ULPROPTAG1 => $this->properties["enddate_recurring"],
																				ULPROPTAG2 => $this->properties["startdate"]
																			)
																		),
																	
																		
																	   Array(RES_PROPERTY,
																			 Array(RELOP => RELOP_GE,
																				   ULPROPTAG => $this->properties["enddate_recurring"],
																				   VALUE => $start
																				   )
																			 )
																		)
																	)
															   )
														 ),
												   // OR
												   // (!EXIST(recurrence_enddate_property) && item[isRecurring] == true && item[start] <= end)

												   Array(RES_AND,
														 Array(
															   Array(RES_NOT,
																	 Array(
																		   Array(RES_EXIST,
																				 Array(ULPROPTAG => $this->properties["enddate_recurring"]
																					   )
																				 )
																		   )
																	 ),
															   Array(RES_PROPERTY,
																	 Array(RELOP => RELOP_LE,
																		   ULPROPTAG => $this->properties["startdate"],
																		   VALUE => $end
																		   )
																	 ),
															   Array(RES_PROPERTY,
																	 Array(RELOP => RELOP_EQ,
																		   ULPROPTAG => $this->properties["recurring"],
																		   VALUE => true
																		   )
																	 )
															   )
														 )
												   )
											 ) // EXISTS OR
									   )
								 );		// global OR

			$folder = mapi_msgstore_openentry($store, $entryid);
			$table = mapi_folder_getcontentstable($folder);
			$calendaritems = mapi_table_queryallrows($table, $this->properties, $restriction);
			$storeProviderGuid = mapi_getprops($store, array(PR_MDB_PROVIDER));
			
			foreach($calendaritems as $calendaritem)
			{
				$item = null;
				if (isset($calendaritem[$this->properties["recurring"]]) && $calendaritem[$this->properties["recurring"]]) {
					$recurrence = new Recurrence($store, $calendaritem);
					$recuritems = $recurrence->getItems($start, $end);
					
					foreach($recuritems as $recuritem)
					{
						$item = Conversion::mapMAPI2XML($this->properties, $recuritem);
						if(isset($recuritem["exception"])) {
							$item["exception"] = true;
						}

						if(isset($recuritem["basedate"])) {
							$item["basedate"] = array();
							$item["basedate"]["attributes"] = array();
							$item["basedate"]["attributes"]["unixtime"] = $recuritem["basedate"];
							$item["basedate"]["_content"] = strftime("%a %d-%m-%Y %H:%M", $recuritem["basedate"]);
						}
						$item = $this->disablePrivateItem($storeProviderGuid[PR_MDB_PROVIDER], $item);
						array_push($items, $item);
					}
				} else {
					$item = Conversion::mapMAPI2XML($this->properties, $calendaritem);
					$item = $this->disablePrivateItem($storeProviderGuid[PR_MDB_PROVIDER], $item);
					array_push($items,$item);
				}

			} 
			usort($items, array("PrintListModule", "compareCalendarItems"));

			return $items;
		}

		/**
		* Function to remove some properties when the item is private
		* returns the item;
		*/
		function disablePrivateItem($storeProviderGuid, $item)
		{
			// if this is a private item and not in our own store we need to censor it ;)
			if (isset($item["sensitivity"]) && $item["sensitivity"] != SENSITIVITY_NONE){
				if ($storeProviderGuid==ZARAFA_STORE_DELEGATE_GUID){		
					$item["subject"] = _("Private Appointment");
					$item["location"] = "";
					$item["reminder"] = 0;
					$item["disabled_item"] = 1;
				}
			}
			return $item;
		}
		
		/**
		 * Function will sort items for the month view
		 * small startdate->attributes->unixtime on top	 
		 */		 		
		function compareCalendarItems($a, $b)
		{
			$start_a = $a["startdate"]["attributes"]["unixtime"];
			$start_b = $b["startdate"]["attributes"]["unixtime"];
		
		   if ($start_a == $start_b) {
		       return 0;
		   }
		   return ($start_a < $start_b) ? -1 : 1;
		}
	}
?>
