<?php
	/**
	 * Contact ItemModule
	 * Module which openes, creates, saves and deletes an item. It 
	 * extends the Module class.
	 * @author Johnny Biemans <j.biemans@connectux.com>
	 */
	class ContactItemModule extends ItemModule
	{

		var $plaintext;

		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function ContactItemModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getContactProperties();
			
			$this->plaintext = true;

			parent::ItemModule($id, $data);
		}
		
		/**
		 * Function which saves an item. It sets the right properties for a contact
		 * item (address book properties).		 
		 * @param object $store MAPI Message Store Object
		 * @param string $parententryid parent entryid of the message
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */		 		
		function save($store, $parententryid, $action)
		{
			$result = false;
			
			if(!$store && !$parententryid) {
				if(isset($action["props"]["message_class"])) {
					$store = $GLOBALS["mapisession"]->getDefaultMessageStore();
					$parententryid = $this->getDefaultFolderEntryID($store, $action["props"]["message_class"]);
				}
			}

            $action["props"]["subject"] = $action["props"]["fileas"];

			if($store && $parententryid) {
				if(isset($action["props"]) && isset($action["email_addresses"]) && isset($action["email_addresses"]["email_address"])) {
					foreach($action["email_addresses"]["email_address"] as $email_address)
					{

						// if emailaddress of name is "0" then it will be ignored (non-issue)
						if(isset($email_address["id"]) && !empty($email_address["name"]) && !empty($email_address["address"])) {
							$action["props"]["email_address_entryid_" . $email_address["id"]] = bin2hex(mapi_createoneoff($email_address["name"], "SMTP", $email_address["address"]));
							
							if(!isset($action["props"]["address_book_mv"]) || !is_array($action["props"]["address_book_mv"])) {
								$action["props"]["address_book_mv"] = array();
							}
							

							if(!isset($action["props"]["address_book_long"])) {
								$action["props"]["address_book_long"] =  0;
							}
							
							switch((int)$email_address["id"]){
								case 1:
									$action["props"]["address_book_long"] += 1;
									array_push($action["props"]["address_book_mv"], 0);
									break;
								case 2:
									$action["props"]["address_book_long"] += 2;
									array_push($action["props"]["address_book_mv"], 1);
									break;
								case 3:
									$action["props"]["address_book_long"] += 4;
									array_push($action["props"]["address_book_mv"], 2);
									break;
							}				
							sort($action["props"]["address_book_mv"]);

							$action["props"]["email_address_type_".(int)$email_address["id"]] = "SMTP";
							$action["props"]["email_address_display_name_email_".(int)$email_address["id"]] = $email_address["address"];
						}
					}
	
					if(isset($action["props"]["entryid"]) && !empty($action["props"]["entryid"])) {
						$props = array();
						
						for($i = 1; $i < 4; $i++)
						{
							if(!isset($action["props"]["email_address_entryid_" . $i])) {
								array_push($props, $this->properties["email_address_entryid_" . $i]);
								array_push($props, $this->properties["email_address_" . $i]);
								array_push($props, $this->properties["email_address_display_name_" . $i]);
								array_push($props, $this->properties["email_address_display_name_email_" . $i]);
								array_push($props, $this->properties["email_address_type_" . $i]);
							}
						}
						
						// Check if the birthday and anniversary properties are empty. If so delete them.
						if($action['props']['birthday'] == ""){
							array_push($props, $this->properties['birthday']);
						}
						if($action['props']['wedding_anniversary'] == ""){
							array_push($props, $this->properties['wedding_anniversary']);
						}
						$GLOBALS["operations"]->deleteProps($store, hex2bin($action["props"]["entryid"]), $props);
					}

					// HACK: Parse displayname to first/middle/surname since we do not support those yet in the webaccess
					if(isset($action['props']['display_name'])){
						$displayNameParts = explode(" ", $action['props']['display_name']);
						if (!isset($action['props']['given_name']) || array_search($action['props']['given_name'], $displayNameParts) === false ||
							!isset($action['props']['surname'])  || array_search($action['props']['surname'], $displayNameParts) === false) {

							// remove the salutation and suffix if they are in the displayname 
							if (isset($action['props']['title']) && array_search($action['props']['title'], $displayNameParts) !== false) 
								array_shift($displayNameParts);
							if (isset($action['props']['generation'])     && array_search($action['props']['generation'], $displayNameParts) > 1)
								array_pop($displayNameParts);

							$action['props']['given_name'] = array_shift($displayNameParts);
							if (count($displayNameParts) > 0) $action['props']['surname'] = array_pop($displayNameParts);
							if (count($displayNameParts) > 0) $action['props']['middle_name'] = implode(" ", $displayNameParts);
						}
					}
						
					$messageProps = array();
					$result = $GLOBALS["operations"]->saveMessage($store, $parententryid, Conversion::mapXML2MAPI($this->properties, $action["props"]), array(), $action["dialog_attachments"], $messageProps);
	
					if($result) {
						$GLOBALS["bus"]->notify(bin2hex($parententryid), TABLE_SAVE, $messageProps);
					}
				}
			}
			
			return $result;
		}
	}
?>
