stickynotelistmodule.prototype = new ListModule;
stickynotelistmodule.prototype.constructor = stickynotelistmodule;
stickynotelistmodule.superclass = ListModule.prototype;

function stickynotelistmodule(id, element, title, data)
{
	if(arguments.length > 0) {
		this.init(id, element, title, data);
	}
}

stickynotelistmodule.prototype.init = function(id, element, title, data)
{
	this.entryid = data["entryid"];
	this.defaultview = webclient.settings.get("folders/entryid_"+this.entryid+"/selected_view", "icon");
	
	stickynotelistmodule.superclass.init.call(this, id, element, title, data);
	this.initializeView();

	this.menuItems.push(webclient.menu.createMenuItem("seperator", ""));
	this.menuItems.push(webclient.menu.createMenuItem("stickynote_icon", _("Icon"), _("Icon View"), eventStickynotelistSwitchView));
	this.menuItems.push(webclient.menu.createMenuItem("stickynote_list", _("List"), _("List View"), eventStickynotelistSwitchView));
	webclient.menu.buildTopMenu(this.id, "stickynote", this.menuItems, eventListNewMessage);

	var items = new Array();
	items.push(webclient.menu.createMenuItem("open", _("Open"), false, eventListContextMenuOpenMessage));
	items.push(webclient.menu.createMenuItem("print", _("Print"), false, eventListContextMenuPrintMessage));
	items.push(webclient.menu.createMenuItem("seperator", ""));
	items.push(webclient.menu.createMenuItem("categories", _("Categories"), false, eventListContextMenuCategoriesMessage));
	items.push(webclient.menu.createMenuItem("seperator", ""));
	items.push(webclient.menu.createMenuItem("delete", _("Delete"), false, eventListContextMenuDeleteMessage));
	this.contextmenu = items;
}

stickynotelistmodule.prototype.initializeView = function(view)
{
	if (view){
		webclient.settings.set("folders/entryid_"+this.entryid+"/selected_view", view);
	}
	this.setTitle(this.title, NBSP, true);
	this.contentElement = dhtml.addElement(this.element, "div");
	
	this.viewController.initView(this.id, (view?view:this.defaultview), this.contentElement, this.events, false);
}

function eventStickynotelistSwitchView(moduleObject, element, event)
{
	var newView = element.id.split("_")[1];
	moduleObject.destructor(moduleObject);
	moduleObject.initializeView(newView);
	moduleObject.list();
	moduleObject.resize();
}
