<?php
	include("client/loader.php");

	if (function_exists("initWindow")){
		initWindow();
	}

	header("Content-type: text/html; charset=utf-8");
?><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<head>
		<title><?=getDialogTitle()?></title>
		<!--[if IE]>
		<script type="text/javascript">
			window.BROWSER_IE=true;
			try { document.execCommand("BackgroundImageCache", false, true); } catch(err) {}
		</script>
		<![endif]-->
<?php
		includeFiles("css", array(
								"client/layout/css/style.css",
								"client/layout/css/icons.css",
								"client/layout/css/dialog.css"
							)
		);
?>
		<script type="text/javascript" src="index.php?load=translations.js&lang=<?=$GLOBALS["language"]->getSelected()?>"></script>
		<!--[if IE]>
		<link rel="stylesheet" type="text/css" href="client/layout/css/style.ie.css">
		<![endif]-->
<?php
	includeFiles("js", array(
							"client/core/constants.js",
							"client/core/utils.js",
							"client/views/view.js",
							"client/views/table.view.js",
							"client/widgets/widget.js",
							"client/widgets/menu.js",
							"client/layout/js/dialog.js",
							"client/modules/module.js",
							"client/modules/dialogmodule.js"
						)
	);

	includeJavaScriptFilesFromDir("core", array("constants.js", "utils.js"));

	if (function_exists('getModuleName')){
		includeFiles("js", array(
								"client/modules/listmodule.js", 
								"client/modules/itemmodule.js"
							)
		);
	}
	
	if (function_exists('getIncludes')){
		$css = array();
		$js = array();
		foreach(getIncludes() as $file){
			if (substr($file,-3) == "css"){
				$css[] = $file;
			}else if (substr($file,-2) == "js"){
				$js[] = $file;
			}
		}
		if (count($css)>0){
			includeFiles("css", $css);
		}
		if (count($js)>0){
			includeFiles("js", $js);
		}
	}

	include("client/layout/themes.php");
?>		
		<script type="text/javascript">
			var CLIENT_TIMEOUT = <?=CLIENT_TIMEOUT?>;
			var DIALOG_URL = "<?=DIALOG_URL?>";
			var DND_FILEUPLOAD_URL = <?=(defined('DND_FILEUPLOAD_URL')&&DND_FILEUPLOAD_URL)?'"'.DND_FILEUPLOAD_URL.'"':'false'?>;
			var parentwindow;
			var parentWebclient;
			var webclient;
			var dhtml;
			var module;
			var dialoghelper;
			
			window.onload = function()
			{

				parentwindow = window.opener;
				if(!parentwindow) {
					if(window.dialogArguments) {
						// IE modal dialog
						
						parentwindow = window.dialogArguments.parentWindow;
						window.opener = parentwindow;
						
						// In IE, the callback parameters are passed via 'dialogArguments' instead of directly
						// in the window object
						if(window.dialogArguments.resultCallBack)
							window.resultCallBack = window.dialogArguments.resultCallBack;
						if(window.dialogArguments.callBackData)
							window.callBackData = window.dialogArguments.callBackData;
						if(window.dialogArguments.windowData)
							window.windowData = window.dialogArguments.windowData;
					}
				}
				
				if(parentwindow && parentwindow.webclient) {
					parentWebclient = parentwindow.webclient;
					if(parentwindow.parentWebclient) {
						parentWebclient = parentwindow.parentWebclient;
					}
					
					dhtml = new DHTML();

					// disable context menu
					dhtml.addEvent(-1, document.body, "mouseup", checkMenuState);
					dhtml.addEvent(-1, document.body, "contextmenu", eventBodyMouseDown);

					webclient = new WebClient();
					webclient.inputmanager = new InputManager();
					webclient.setUserInfo(parentWebclient.username, parentWebclient.fullname, parentWebclient.userEntryid);
					webclient.init(parentWebclient.base_url, (window.name)?window.name:"dialog",  Array("suggestEmailAddressModule.js"));

<?php
	$buttons = false;
	if(function_exists('getMenuButtons')) { 
		$buttons = getMenuButtons();
		if(is_array($buttons)) {
?>
					var menuItems = new Array();
<?php
			foreach($buttons as $button){
				if (isset($button['id'])){
					if(strstr($button['id'],"seperator")) {
						echo '					menuItems.push(webclient.menu.createMenuItem("'.$button['id'].'", ""));'."\n";
					} else if (isset($button['title']) && isset($button['name']) && isset($button['callback'])){
						$button["shortcut"] = isset($button['shortcut'])?'"'.$button['shortcut'].'"':"false";
						echo '					menuItems.push(webclient.menu.createMenuItem("'.$button['id'].'", "'.$button['name'].'", "'.$button['title'].'", '.$button['callback'].', '.$button['shortcut'].'));'."\n";
					}
				}
			}
?>
					webclient.menu.buildMenu(-1,menuItems);
<?php
		} // if is_array
	} // if function_exists
?>
					dialoghelper = new dialogmodule();
					var dialoghelperID = webclient.addModule(dialoghelper);
					dialoghelper.init(dialoghelperID);
<?php if(function_exists('getModuleName')) { ?>
					module = new <?=getModuleName()?>();
					var moduleID = webclient.addModule(module);
<?php } // if function_exists ?>

<?=(function_exists("getJavaScript_onload")?getJavaScript_onload():"")?>

				}
			}
			
			window.onresize = function()
			{
<?php
	
	if(function_exists("getJavaScript_onresize")) {
		echo getJavaScript_onresize();
	} else {
		if(function_exists('getModuleName')) { 
			echo "\t\t\t\tresizeBody();\n";
		}
	}
?>
			}
<?php

	if (function_exists("getJavaScript_other")){
		echo getJavaScript_other();
	}
?>
		</script>
	</head>
	<body	class="dialog"
			scroll="no">

		<div class="title">
			<div id="windowtitle" class="zarafa_title"><?=getDialogTitle()?></div>
			<div class="zarafa_background"></div>
		</div>
<?php if (is_array($buttons)) { ?>
		<div id="menubar">
			<div id="menubar_left"></div>
			<div id="menubar_right"></div>
			<div id="zarafa_loader"></div>
		</div>
<?php } else { // if is_array?>
		<div class="subtitle">
			<div class="subtitle_zarafa_background"></div>
			<span id="subtitle" class="zarafa_title">&nbsp;</span>
		</div>
<?php } // else?>

		<div id="dialog_content">
<?=getBody()?>
		</div>
		<input id="dialog_attachments" type="hidden" value="<?=md5(uniqid(rand(),true))?>">
	</body>
</html>
