<?php

function calendar_settings_title(){
	return _("Calendar");
}

function calendar_settings_order(){
	return 3;
}

function calendar_settings_html(){ ?>
	<fieldset>
		<legend><?=_("Calendar View")?></legend>

		<table class="options"> 
			<tr>
				<th><label for="calendar_workdaystart"><?=_("Start of workday")?></label></th>
				<td>
					<select id="calendar_workdaystart" onchange="calendar_checkworkhours(this)">
					<? for($i=0;$i<24*60;$i+=30) { ?>
						<option value="<?=$i?>"><?=sprintf("%d:%02d",floor($i/60),$i%60);?></option>
					<?  } ?>
					</select>
				</td>
			</tr>

			<tr>
				<th><label for="calendar_workdayend"><?=_("End of workday")?></label></th>
				<td>
					<select id="calendar_workdayend" onchange="calendar_checkworkhours(this)">
					<? for($i=0;$i<24*60;$i+=30) { ?>
						<option value="<?=$i?>"><?=sprintf("%d:%02d",floor($i/60),$i%60);?></option>
					<?  } ?>
					</select>
				</td>
			</tr>

			<tr>
				<th><label for="calendar_size"><?=_("Vertical size")?></label></th>
				<td>
					<select id="calendar_size">
						<option value="1"><?=_("Small")?></option>
						<option value="2"><?=_("Medium")?></option>
						<option value="3"><?=_("Large")?></option>
					</select>
				</td>
			</tr>
		</table>
	</fieldset>

	<fieldset>
		<legend><?=_("Multi User Calendar View")?></legend>

		<table class="options"> 
			<tr>
				<th><label for="calendar_mucalendar_zoomlevel"><?=_("Number of days displayed")?></label></th>
				<td>
					<select id="calendar_mucalendar_zoomlevel">
						<option value="2">2</option>
						<option value="3">3</option>
						<option value="4">4</option>
						<option value="5">5</option>
						<option value="6">6</option>
						<option value="7">7</option>
						<option value="10">10</option>
						<option value="14">14</option>
					</select>
				</td>
			</tr>

			<tr>
				<th><label for="calendar_mucalendar_numofdaysloaded"><?=_("Number of days loaded")?></label></th>
				<td>
					<select id="calendar_mucalendar_numofdaysloaded">
						<option value="2">2</option>
						<option value="3">3</option>
						<option value="4">4</option>
						<option value="5">5</option>
						<option value="6">6</option>
						<option value="7">7</option>
						<option value="10">10</option>
						<option value="14">14</option>
					</select>
				</td>
			</tr>
		</table>				
	</fieldset>
<?php } ?>
