/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef TRACE_H
#define TRACE_H

#define TRACE_ENTRY 1
#define TRACE_RETURN 2
#define TRACE_WARNING 3
#define TRACE_INFO 4

void TraceMapi(int time, char *func, char *format, ...);
void TraceMapiLib(int time, char *func, char *format, ...);
void TraceNotify(int time, char *func, char *format, ...);
void TraceSoap(int time, char *func, char *format, ...);
void TraceInternals(int time, char *action, char *func, char *format, ...);
void TraceStream(int time, char *func, char *format, ...);
void TraceECMapi(int time, char *func, char *format, ...);
void TraceExt(int time, char *func, char *format, ...);

#ifdef DEBUG
#define TRACE_MAPI		TraceMapi
#define TRACE_MAPILIB	TraceMapiLib
#define TRACE_ECMAPI	TraceECMapi
#define TRACE_NOTIFY	TraceNotify
#define TRACE_INTERNAL	TraceInternals
#define TRACE_SOAP		TraceSoap
#define TRACE_STREAM	TraceStream
#define TRACE_EXT		TraceExt
#else
#  define TRACE_MAPI(...)
#  define TRACE_MAPILIB(...)
#  define TRACE_ECMAPI(...)
#  define TRACE_NOTIFY(...)
#  define TRACE_INTERNAL(...)
#  define TRACE_SOAP(...)
#  define TRACE_STREAM(...)
#  define TRACE_EXT(...)
#endif

#endif // TRACE_H
